/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import com.hyphenate.helpdesk.httpclient.HttpClientException;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.httpclient.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class WriteToOutputStreamHandler
extends HttpResponseHandler {
    private final OutputStream out;

    public WriteToOutputStreamHandler(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        this.out = out;
    }

    @Override
    public void onResponse(HttpResponse response, long contentLength) throws Exception {
        try {
            int bytesRead;
            InputStream in = response.getPayload();
            byte[] buf = new byte[1024];
            while ((bytesRead = in.read(buf)) != -1) {
                this.out.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new HttpClientException("Cannot write Http response to output stream", e);
        }
        finally {
            IOUtils.close(this.out);
        }
    }
}

