/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.helpdesk.model.Content;
import com.hyphenate.helpdesk.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ArticlesInfo
extends Content {
    private static final String TAG = "ArticlesInfo";
    public static final String PARENT_NAME = "msgtype";
    public static final String ITEM_NAME = "articles";

    public ArticlesInfo() {
    }

    public ArticlesInfo(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    public List<ArticleItem> getArticles() {
        Collection<JSONObject> objArray = this.getObjectArray(ITEM_NAME);
        if (objArray == null) {
            return null;
        }
        ArrayList<ArticleItem> items = new ArrayList<ArticleItem>();
        for (JSONObject obj : objArray) {
            ArticleItem item = this.createArticleItem(obj);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public ArticleItem createArticleItem(JSONObject obj) {
        ArticleItem item = null;
        try {
            item = new ArticleItem(obj.getString("date"), obj.getString("description"), obj.getString("picurl"), obj.getString("title"), obj.getString("url"));
            item.setContent(obj);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }
        return item;
    }

    public static class ArticleItem {
        private String date;
        private String description;
        private String picurl;
        private String title;
        private String url;
        private JSONObject jsonObj;

        public ArticleItem(String date, String description, String picurl, String title, String url) {
            this.date = date;
            this.description = description;
            this.picurl = picurl;
            this.title = title;
            this.url = url;
        }

        public void setContent(JSONObject jsonObj) {
            this.jsonObj = jsonObj;
        }

        public String getDate() {
            return this.date;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPicurl() {
            if (TextUtils.isEmpty((CharSequence)this.picurl)) {
                return "";
            }
            if (this.picurl.startsWith("http")) {
                return this.picurl;
            }
            return ChatClient.getInstance().getKefuServerAddress() + this.picurl;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                return "";
            }
            if (this.url.startsWith("http")) {
                return this.url;
            }
            return ChatClient.getInstance().getKefuServerAddress() + this.url;
        }
    }
}

