/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.Message;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.model.AgentInfo;
import com.hyphenate.helpdesk.model.ArticlesInfo;
import com.hyphenate.helpdesk.model.ContentFactory;
import com.hyphenate.helpdesk.model.ControlMessage;
import com.hyphenate.helpdesk.model.EvaluationInfo;
import com.hyphenate.helpdesk.model.FormInfo;
import com.hyphenate.helpdesk.model.OrderInfo;
import com.hyphenate.helpdesk.model.RobotMenuInfo;
import com.hyphenate.helpdesk.model.ToCustomServiceInfo;
import com.hyphenate.helpdesk.model.TransferIndication;
import com.hyphenate.helpdesk.model.VisitorTrack;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageHelper {
    private static final String TAG = "MessageHelper";
    private static final boolean DEBUG = false;
    public static final String TAG_ROOT = "ext";
    public static final String TAG_MSGTYPE = "msgtype";
    public static final String TAG_WEICHAT = "weichat";
    static final String MESSAGE_ATTR_IS_BIG_EXPRESSION = "em_is_big_expression";
    static final String TRANSFER_INDICATION_ACTION = "transfer";

    public static ExtMsgType getMessageExtType(Message message) {
        if (MessageHelper.getEvalRequest(message) != null) {
            return ExtMsgType.EvaluationMsg;
        }
        if (MessageHelper.getOrderInfo(message) != null) {
            return ExtMsgType.OrderMsg;
        }
        if (MessageHelper.getVisitorTrack(message) != null) {
            return ExtMsgType.TrackMsg;
        }
        if (MessageHelper.isFormMessage(message)) {
            return ExtMsgType.FormMsg;
        }
        if (MessageHelper.getRobotMenu(message) != null) {
            return ExtMsgType.RobotMenuMsg;
        }
        if (MessageHelper.isArticlesMessage(message)) {
            return ExtMsgType.ArticlesMsg;
        }
        if (message.getBooleanAttribute(MESSAGE_ATTR_IS_BIG_EXPRESSION, false)) {
            return ExtMsgType.BigExpressionMsg;
        }
        if (!TextUtils.isEmpty((CharSequence)MessageHelper.getCustomEmojiMessage(message))) {
            return ExtMsgType.CustomEmojiMsg;
        }
        if (MessageHelper.getToCustomServiceInfo(message) != null) {
            return ExtMsgType.ToCustomServiceMsg;
        }
        return ExtMsgType.GeneralMsg;
    }

    public static JSONObject getContainerObject(Message message, String tag) {
        JSONObject obj = null;
        try {
            if (message != null) {
                obj = message.getJSONObjectAttribute(tag);
            }
        }
        catch (HyphenateException hyphenateException) {
            // empty catch block
        }
        return obj;
    }

    public static EvaluationInfo getEvalRequest(Message message) {
        JSONObject content;
        String ctrlType;
        EvaluationInfo info = null;
        JSONObject jsonObject = MessageHelper.getContainerObject(message, TAG_WEICHAT);
        if (jsonObject != null && (ctrlType = MessageHelper.getString(jsonObject, "ctrlType")) != null && ctrlType.equals("inviteEnquiry") && (content = MessageHelper.getJSONObject(jsonObject, "ctrlArgs")) != null) {
            info = ContentFactory.createEvaluationInfo(content);
        }
        return info;
    }

    public static RobotMenuInfo getRobotMenu(Message message) {
        RobotMenuInfo menuInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "choice", false);
        if (content != null) {
            menuInfo = ContentFactory.createRobotMenuInfo(content);
        }
        if (menuInfo != null && (menuInfo.has("items") || menuInfo.has("list"))) {
            return menuInfo;
        }
        return null;
    }

    public static TransferIndication getTransferIndication(Message message) {
        JSONObject content;
        TransferIndication indication = null;
        if (MessageHelper.hasAction(message, TRANSFER_INDICATION_ACTION) && (content = MessageHelper.extractObject(message, TAG_WEICHAT, null, true)) != null && (indication = ContentFactory.createTransferIndication(content)).isNull()) {
            indication = null;
        }
        return indication;
    }

    public static AgentInfo getAgentInfo(Message message) {
        AgentInfo agentInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_WEICHAT, "agent", false);
        if (content != null) {
            agentInfo = ContentFactory.createAgentInfo(content);
        }
        return agentInfo;
    }

    public static ControlMessage getTransferToAgent(Message message) {
        return null;
    }

    public static OrderInfo getOrderInfo(Message message) {
        OrderInfo orderInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "order", false);
        if (content != null) {
            orderInfo = ContentFactory.createOrderInfo(content);
        }
        if (orderInfo != null && orderInfo.getPrice() == null && orderInfo.getDesc() == null) {
            orderInfo = null;
        }
        return orderInfo;
    }

    public static VisitorTrack getVisitorTrack(Message message) {
        VisitorTrack visitorTrack = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "track", false);
        if (content != null) {
            visitorTrack = ContentFactory.createVisitorTrack(content);
        }
        if (visitorTrack != null && visitorTrack.getDesc() == null && visitorTrack.getPrice() == null) {
            visitorTrack = null;
        }
        return visitorTrack;
    }

    private static boolean hasAction(Message msg, String action) {
        EMCmdMessageBody body;
        return msg.getType() == Message.Type.CMD && (body = (EMCmdMessageBody)msg.body()).action().equals(action);
    }

    private static JSONObject extractObject(Message message, String parentName, String name, boolean isComposite) {
        JSONObject content = null;
        JSONObject container = MessageHelper.getContainerObject(message, parentName);
        if (!isComposite) {
            if (container != null) {
                if (container.isNull(name)) {
                    return null;
                }
                try {
                    content = container.getJSONObject(name);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return content;
        }
        return container;
    }

    private static String extractString(Message message, String parentName, String name) {
        String content = null;
        JSONObject container = MessageHelper.getContainerObject(message, parentName);
        if (container != null) {
            try {
                content = container.getString(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return content;
    }

    public static ToCustomServiceInfo getToCustomServiceInfo(Message message) {
        JSONObject content;
        String ctrlType;
        ToCustomServiceInfo info = null;
        JSONObject jsonObject = MessageHelper.getContainerObject(message, TAG_WEICHAT);
        if (jsonObject != null && (ctrlType = MessageHelper.getString(jsonObject, "ctrlType")) != null && ctrlType.equals("TransferToKfHint") && (content = MessageHelper.getJSONObject(jsonObject, "ctrlArgs")) != null) {
            info = ContentFactory.createToCustomeServiceInfo(content);
        }
        return info;
    }

    public static ArticlesInfo getArticlesMessage(Message message) {
        ArticlesInfo articlesInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, null, true);
        if (content != null) {
            articlesInfo = ContentFactory.createArticlesInfo(content);
        }
        return articlesInfo;
    }

    public static boolean isArticlesMessage(Message message) {
        try {
            JSONArray articles;
            JSONObject msgtype = message.getJSONObjectAttribute(TAG_MSGTYPE);
            if (msgtype != null && (articles = msgtype.getJSONArray("articles")) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getCustomEmojiMessage(Message message) {
        try {
            JSONObject customEmoji;
            JSONObject msgtype = message.getJSONObjectAttribute(TAG_MSGTYPE);
            if (msgtype != null && (customEmoji = msgtype.getJSONObject("customMagicEmoji")) != null && customEmoji.has("url")) {
                return customEmoji.getString("url");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static FormInfo getFormMessage(Message message) {
        FormInfo formInfo = null;
        JSONObject content = MessageHelper.extractObject(message, TAG_MSGTYPE, "html", false);
        if (content != null) {
            formInfo = ContentFactory.createFormInfo(content);
        }
        return formInfo;
    }

    public static boolean isFormMessage(Message message) {
        if (message.getStringAttribute("type", null) != null) {
            try {
                String type = message.getStringAttribute("type");
                if (type.equals("html/form")) {
                    return true;
                }
            }
            catch (HyphenateException hyphenateException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isNotificationMessage(Message message) {
        try {
            JSONObject weichatJson = message.getJSONObjectAttribute(TAG_WEICHAT);
            if (weichatJson != null && weichatJson.has("notification")) {
                return weichatJson.getBoolean("notification");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTicketStatusChangedMessage(Message message) {
        try {
            String eventName;
            JSONObject eventJson;
            JSONObject weichatJson = message.getJSONObjectAttribute(TAG_WEICHAT);
            if (weichatJson != null && weichatJson.has("event") && (eventJson = weichatJson.getJSONObject("event")) != null && eventJson.has("eventName") && !TextUtils.isEmpty((CharSequence)(eventName = eventJson.getString("eventName"))) && (eventName.equals("TicketStatusChangedEvent") || eventName.equals("CommentCreatedEvent"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static JSONObject getJSONObject(JSONObject jsonObject, String name) {
        if (jsonObject.has(name) && !jsonObject.isNull(name)) {
            try {
                return jsonObject.getJSONObject(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getString(JSONObject jsonObj, String name) {
        if (jsonObj.has(name) && !jsonObj.isNull(name)) {
            try {
                return jsonObj.getString(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void sendEvalMessage(Message message, String detail, EvaluationInfo.Degree degree, List<EvaluationInfo.TagInfo> selectedTags, final Callback callback) {
        EvaluationInfo evaluationInfo = MessageHelper.getEvalRequest(message);
        ControlMessage content = ContentFactory.createEvaluationResponse(evaluationInfo, detail, degree.getLevel(), degree.getId(), selectedTags);
        final Message messageToSend = Message.createTxtSendMessage("", message.from());
        messageToSend.addContent(content);
        ChatClient.getInstance().chatManager().sendMessage(messageToSend, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    public static void sendEvalMessage(String msgId, String summary, String detail, final Callback callback) {
        Message message = ChatClient.getInstance().chatManager().getMessage(msgId);
        EvaluationInfo evaluationInfo = MessageHelper.getEvalRequest(message);
        int level = 5;
        try {
            level = Integer.parseInt(summary);
        }
        catch (NumberFormatException e) {
            try {
                level = (int)Float.parseFloat(summary);
            }
            catch (NumberFormatException err) {
                err.printStackTrace();
            }
        }
        ControlMessage content = ContentFactory.createEvaluationResponse(evaluationInfo, detail, level, -1, null);
        final Message messageToSend = Message.createTxtSendMessage("", message.from());
        messageToSend.addContent(content);
        ChatClient.getInstance().chatManager().sendMessage(messageToSend, new Callback(){

            @Override
            public void onSuccess() {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().chatManager().getConversation(messageToSend.to()).removeMessage(messageToSend.messageId());
                if (callback != null) {
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
            }
        });
    }

    public static enum ExtMsgType {
        EvaluationMsg,
        OrderMsg,
        TrackMsg,
        FormMsg,
        RobotMenuMsg,
        ArticlesMsg,
        ToCustomServiceMsg,
        BigExpressionMsg,
        CustomEmojiMsg,
        GeneralMsg;

    }
}

