/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Intent;
import android.hardware.Camera;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Pair;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMCallOptions;
import com.hyphenate.chat.EMCallSession;
import com.hyphenate.chat.EMCallStateChangeListener;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVideoCallHelper;
import com.hyphenate.chat.adapter.EMACallManager;
import com.hyphenate.chat.adapter.EMACallManagerListener;
import com.hyphenate.chat.adapter.EMACallRtcImpl;
import com.hyphenate.chat.adapter.EMACallRtcListenerDelegate;
import com.hyphenate.chat.adapter.EMACallSession;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.EMNoActiveCallException;
import com.hyphenate.exceptions.EMServiceNotReadyException;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.media.EMCallSurfaceView;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.VideoViewRenderer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class EMCallManager {
    static final String TAG = "EMCallManager";
    EMACallManager emaObject;
    EMClient mClient;
    List<EMCallStateChangeListener> callListeners = Collections.synchronizedList(new ArrayList());
    EMACallListenerDelegate delegate = new EMACallListenerDelegate();
    EMCallSession currentSession;
    EMVideoCallHelper callHelper = new EMVideoCallHelper();
    EMCameraDataProcessor processor;
    EMCameraDataProcessorDelegate mProcessorDelegate = new EMCameraDataProcessorDelegate();
    CallStateUnion callState = new CallStateUnion();
    EMCallOptions callOptions;
    boolean isConnectedFromRinging = false;
    RtcConnection mRtcConnection;
    RtcConnection.Listener mRtcListener;
    boolean isVideoCall = true;
    EMCallPushProvider mPushProvider;
    final EMCallPushProvider defaultProvider = new EMCallPushProvider(){

        void updateMessageText(EMMessage eMMessage, String string) {
            EMConversation eMConversation = EMClient.getInstance().chatManager().getConversation(eMMessage.getTo());
            if (eMConversation != null) {
                eMConversation.removeMessage(eMMessage.getMsgId());
            }
        }

        @Override
        public void onRemoteOffline(final String string) {
            EMLog.d(EMCallManager.TAG, "onRemoteOffline, to:" + string);
            final EMMessage eMMessage = EMMessage.createTxtSendMessage("You have an incoming call", string);
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("em_push_title", (Object)"You have an incoming call");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            eMMessage.setAttribute("em_apns_ext", jSONObject);
            eMMessage.setAttribute("is_voice_call", !EMCallManager.this.isVideoCall);
            eMMessage.setMessageStatusCallback(new EMCallBack(){

                @Override
                public void onSuccess() {
                    EMLog.d(EMCallManager.TAG, "onRemoteOffline success");
                    this.updateMessageText(eMMessage, string);
                }

                @Override
                public void onError(int n, String string2) {
                    EMLog.d(EMCallManager.TAG, "onRemoteOffline Error");
                    this.updateMessageText(eMMessage, string);
                }

                @Override
                public void onProgress(int n, String string2) {
                }
            });
            EMClient.getInstance().chatManager().sendMessage(eMMessage);
        }
    };
    public static final String IncomingCallAction = ".action.incomingcall";
    HandlerThread stateChangeHandlerThread = new HandlerThread("CallStateHandlerThread");
    Handler stateChangeHandler;

    public String getIncomingCallBroadcastAction() {
        return EMClient.getInstance().getContext().getPackageName() + IncomingCallAction;
    }

    protected EMCallManager(EMClient eMClient, EMACallManager eMACallManager) {
        this.stateChangeHandlerThread.start();
        this.stateChangeHandler = new Handler(this.stateChangeHandlerThread.getLooper()){

            public void handleMessage(Message message) {
                Pair pair = (Pair)message.obj;
                EMCallStateChangeListener.CallState callState = (EMCallStateChangeListener.CallState)((Object)pair.first);
                EMCallStateChangeListener.CallError callError = (EMCallStateChangeListener.CallError)((Object)pair.second);
                EMLog.d(EMCallManager.TAG, "stateChangeHandler handleMessage BEGIN ---- state:" + (Object)((Object)callState));
                EMCallManager.this.notifyCallStateChanged(callState, callError);
                EMLog.d(EMCallManager.TAG, "stateChangeHandler handleMessage  END  ----");
            }
        };
        this.mClient = eMClient;
        this.emaObject = eMACallManager;
        this.emaObject.addListener(this.delegate);
        try {
            EMediaManager.initGlobal(EMClient.getInstance().getContext());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCameraDataProcessor(EMCameraDataProcessor eMCameraDataProcessor) {
        this.processor = eMCameraDataProcessor;
    }

    public void setPushProvider(EMCallPushProvider eMCallPushProvider) {
        this.mPushProvider = eMCallPushProvider;
    }

    public EMCallStateChangeListener.CallState getCallState() {
        return this.callState.getState();
    }

    public EMVideoCallHelper getVideoCallHelper() {
        return this.callHelper;
    }

    public void makeVideoCall(String string) throws EMServiceNotReadyException {
        this.makeVideoCall(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeVideoCall(String string, String string2) throws EMServiceNotReadyException {
        EMLog.d(TAG, "makeVideoCall");
        this.isVideoCall = true;
        if (!EMClient.getInstance().isConnected()) {
            EMLog.d(TAG, "exception isConnected:false");
            throw new EMServiceNotReadyException("exception isConnected:false");
        }
        if (!NetUtils.hasDataConnection(EMClient.getInstance().getContext())) {
            EMLog.d(TAG, "Has no network connection");
            throw new EMServiceNotReadyException(2, "Has no network connection");
        }
        if (!this.callState.isIdle() && !this.callState.isDisconnected()) {
            EMLog.d(TAG, "exception callState:" + this.callState);
            throw new EMServiceNotReadyException("exception callState:" + this.callState.getState().toString());
        }
        EMAError eMAError = new EMAError();
        EMACallSession eMACallSession = this.emaObject.makeCall(string, EMACallSession.Type.VIDEO, string2, eMAError);
        EMCallManager eMCallManager = this;
        synchronized (eMCallManager) {
            if (eMAError.errCode() != 0) {
                EMLog.d(TAG, "errorCode:" + eMAError.errCode());
                this.currentSession = null;
                this.changeState(EMCallStateChangeListener.CallState.DISCONNECTED, this.getCallError(eMAError));
                throw new EMServiceNotReadyException(eMAError.errCode(), eMAError.errMsg());
            }
            this.currentSession = new EMCallSession(eMACallSession);
            this.changeState(EMCallStateChangeListener.CallState.CONNECTING);
        }
    }

    public void makeVoiceCall(String string) throws EMServiceNotReadyException {
        this.makeVoiceCall(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeVoiceCall(String string, String string2) throws EMServiceNotReadyException {
        EMLog.d(TAG, "makeVoiceCall");
        this.isVideoCall = false;
        if (!EMClient.getInstance().isConnected()) {
            EMLog.d(TAG, "exception isConnected:false");
            throw new EMServiceNotReadyException("exception isConnected:false");
        }
        if (!NetUtils.hasDataConnection(EMClient.getInstance().getContext())) {
            EMLog.d(TAG, "Has no network connection");
            throw new EMServiceNotReadyException(2, "Has no network connection");
        }
        if (!this.callState.isIdle() && !this.callState.isDisconnected()) {
            EMLog.d(TAG, "exception callState:" + this.callState);
            throw new EMServiceNotReadyException("exception callState:" + this.callState.getState().toString());
        }
        EMAError eMAError = new EMAError();
        EMACallSession eMACallSession = this.emaObject.makeCall(string, EMACallSession.Type.VOICE, string2, eMAError);
        EMCallManager eMCallManager = this;
        synchronized (eMCallManager) {
            if (eMAError.errCode() != 0) {
                EMLog.d(TAG, "errorCode:" + eMAError.errCode());
                this.currentSession = null;
                this.changeState(EMCallStateChangeListener.CallState.DISCONNECTED, this.getCallError(eMAError));
                throw new EMServiceNotReadyException(eMAError.errCode(), eMAError.errMsg());
            }
            this.currentSession = new EMCallSession(eMACallSession);
            this.changeState(EMCallStateChangeListener.CallState.CONNECTING);
        }
    }

    private EMCallStateChangeListener.CallError getCallError(EMAError eMAError) {
        EMCallStateChangeListener.CallError callError = EMCallStateChangeListener.CallError.ERROR_TRANSPORT;
        switch (eMAError.errCode()) {
            case 800: {
                callError = EMCallStateChangeListener.CallError.ERROR_NONE;
                break;
            }
            case 801: {
                callError = EMCallStateChangeListener.CallError.ERROR_BUSY;
                break;
            }
            case 802: {
                callError = EMCallStateChangeListener.CallError.ERROR_UNAVAILABLE;
                break;
            }
            case 803: {
                callError = EMCallStateChangeListener.CallError.ERROR_TRANSPORT;
                break;
            }
        }
        return callError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        List<EMCallStateChangeListener> list = this.callListeners;
        synchronized (list) {
            if (!this.callListeners.contains(eMCallStateChangeListener)) {
                this.callListeners.add(eMCallStateChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallStateChangeListener(EMCallStateChangeListener eMCallStateChangeListener) {
        List<EMCallStateChangeListener> list = this.callListeners;
        synchronized (list) {
            if (this.callListeners.contains(eMCallStateChangeListener)) {
                this.callListeners.remove(eMCallStateChangeListener);
            }
        }
    }

    static RtcConnection createRtcConnection(String string) {
        RtcConnection rtcConnection = new RtcConnection(string);
        EMCallOptions eMCallOptions = EMClient.getInstance().callManager().getCallOptions();
        if (eMCallOptions.isUserSetAutoResizing) {
            RtcConnection.enableFixedVideoResolution(eMCallOptions.userSetAutoResizing);
        }
        if (eMCallOptions.isUserSetMaxFrameRate) {
            rtcConnection.setMaxVideoFrameRate(eMCallOptions.userSetMaxFrameRate);
        }
        if (eMCallOptions.isEnableExternalVideoData) {
            rtcConnection.setEnableExternalVideoData(eMCallOptions.isEnableExternalVideoData);
        }
        if (eMCallOptions.rotateAngel >= 0) {
            rtcConnection.setRotation(eMCallOptions.rotateAngel);
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("maxAKbps", eMCallOptions.maxAudioBitrate);
            long l = eMCallOptions.getVideoResolutionWidth();
            long l2 = eMCallOptions.getVideoResolutionHeight();
            if (l != -1L && l2 != -1L) {
                jSONObject.put("width", l);
                jSONObject.put("heigth", l2);
            }
            rtcConnection.setConfigure(jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rtcConnection;
    }

    public synchronized void setSurfaceView(EMCallSurfaceView eMCallSurfaceView, EMCallSurfaceView eMCallSurfaceView2) {
        if (this.mRtcConnection == null) {
            this.mRtcConnection = EMCallManager.createRtcConnection("rtc");
        }
        VideoViewRenderer videoViewRenderer = null;
        VideoViewRenderer videoViewRenderer2 = null;
        if (eMCallSurfaceView != null) {
            videoViewRenderer = eMCallSurfaceView.getRenderer();
        }
        if (eMCallSurfaceView2 != null) {
            videoViewRenderer2 = eMCallSurfaceView2.getRenderer();
        }
        this.mRtcConnection.setViews(videoViewRenderer, videoViewRenderer2);
        this.mRtcConnection.setRtcCameraDataProcessor(this.mProcessorDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void answerCall() throws EMNoActiveCallException {
        Object object = this;
        synchronized (object) {
            if (this.currentSession == null) {
                throw new EMNoActiveCallException("no incoming active call");
            }
        }
        if (!this.callState.isRinging()) {
            throw new EMNoActiveCallException("Current callstate is not ringing callState:" + (Object)((Object)this.callState.getState()));
        }
        object = new EMAError();
        this.emaObject.answerCall(this.currentSession.getCallId(), (EMAError)object);
        EMCallManager eMCallManager = this;
        synchronized (eMCallManager) {
            this.changeState(EMCallStateChangeListener.CallState.ANSWERING);
            if (((EMAError)object).errCode() != 0) {
                EMLog.d(TAG, "errorCode:" + ((EMAError)object).errCode());
                this.endCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectCall() throws EMNoActiveCallException {
        final EMCallSession eMCallSession = this.currentSession;
        if (eMCallSession == null) {
            EMLog.e(TAG, "no incoming active call");
            throw new EMNoActiveCallException("no incoming active call");
        }
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMCallManager.this.emaObject.endCall(eMCallSession.getCallId(), EMCallManager.this.callState.isRinging() ? EMACallSession.EndReason.REJECT : EMACallSession.EndReason.HANGUP);
            }
        });
        EMCallManager eMCallManager = this;
        synchronized (eMCallManager) {
            this.mRtcConnection = null;
            this.mRtcListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCall() throws EMNoActiveCallException {
        String string = "";
        Object object = this;
        synchronized (object) {
            if (this.currentSession == null) {
                EMLog.e(TAG, "no incoming active call");
                throw new EMNoActiveCallException("no incoming active call");
            }
            string = this.currentSession.getCallId();
        }
        object = string;
        EMClient.getInstance().execute(new Runnable((String)object){
            final /* synthetic */ String val$callId;
            {
                this.val$callId = string;
            }

            @Override
            public void run() {
                EMCallManager.this.emaObject.endCall(this.val$callId, EMACallSession.EndReason.HANGUP);
            }
        });
        EMCallManager eMCallManager = this;
        synchronized (eMCallManager) {
            this.mRtcConnection = null;
            this.mRtcListener = null;
        }
    }

    public boolean isDirectCall() {
        EMACallRtcListenerDelegate eMACallRtcListenerDelegate;
        RtcConnection.RtcStatistics rtcStatistics;
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate && (rtcStatistics = (eMACallRtcListenerDelegate = (EMACallRtcListenerDelegate)listener).getStatistics()) != null && rtcStatistics.connectionType != null) {
            return rtcStatistics.connectionType.equals("direct");
        }
        return true;
    }

    public void pauseVoiceTransfer() throws HyphenateException {
        EMCallSession eMCallSession;
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.setMute(true);
        }
        if ((eMCallSession = this.currentSession) != null) {
            EMAError eMAError = new EMAError();
            this.emaObject.updateCall(eMCallSession.getCallId(), EMACallSession.StreamControlType.PAUSE_VOICE, eMAError);
            this.handleError(eMAError);
        }
    }

    public void resumeVoiceTransfer() throws HyphenateException {
        EMCallSession eMCallSession;
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.setMute(false);
        }
        if ((eMCallSession = this.currentSession) != null) {
            EMAError eMAError = new EMAError();
            this.emaObject.updateCall(eMCallSession.getCallId(), EMACallSession.StreamControlType.RESUME_VOICE, eMAError);
            this.handleError(eMAError);
        }
    }

    public void pauseVideoTransfer() throws HyphenateException {
        EMCallSession eMCallSession;
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.stopCapture();
        }
        if ((eMCallSession = this.currentSession) != null) {
            EMAError eMAError = new EMAError();
            this.emaObject.updateCall(eMCallSession.getCallId(), EMACallSession.StreamControlType.PAUSE_VIDEO, eMAError);
            this.handleError(eMAError);
        }
    }

    public void resumeVideoTransfer() throws HyphenateException {
        EMCallSession eMCallSession;
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.startCapture();
        }
        if ((eMCallSession = this.currentSession) != null) {
            EMAError eMAError = new EMAError();
            this.emaObject.updateCall(eMCallSession.getCallId(), EMACallSession.StreamControlType.RESUME_VIDEO, eMAError);
            this.handleError(eMAError);
        }
    }

    public void setCameraFacing(int n) throws HyphenateException {
        if (n != 0 && n != 1) {
            throw new HyphenateException(817, "Invalid camera index");
        }
        RtcConnection.setCameraFacing(n);
    }

    public synchronized void switchCamera() {
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.switchCamera();
        }
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            EMLog.e(TAG, "error code:" + eMAError.errCode() + " errorMsg:" + eMAError.errMsg());
            throw new HyphenateException(eMAError);
        }
    }

    public int getCameraFacing() {
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            return rtcConnection.getCameraFacing();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCallStateChanged(EMCallStateChangeListener.CallState callState, EMCallStateChangeListener.CallError callError) {
        List<EMCallStateChangeListener> list = this.callListeners;
        synchronized (list) {
            for (EMCallStateChangeListener eMCallStateChangeListener : this.callListeners) {
                eMCallStateChangeListener.onCallStateChanged(callState, callError);
            }
        }
    }

    void changeState(EMCallStateChangeListener.CallState callState) {
        this.changeState(callState, EMCallStateChangeListener.CallError.ERROR_NONE);
    }

    protected void changeState(EMCallStateChangeListener.CallState callState, EMCallStateChangeListener.CallError callError) {
        if (CallStateUnion.isMainState(callState) && this.callState.getState().equals((Object)callState)) {
            return;
        }
        EMLog.d(TAG, "changeState:" + (Object)((Object)callState));
        this.callState.changeState(callState);
        this.stateChangeHandler.sendMessage(this.stateChangeHandler.obtainMessage(0, (Object)new Pair((Object)callState, (Object)callError)));
    }

    void clearStateMessages() {
        this.stateChangeHandler.removeMessages(0);
    }

    void onLogout() {
        this.stateChangeHandler.removeMessages(0);
    }

    void printStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public EMCallOptions getCallOptions() {
        if (this.callOptions == null) {
            this.callOptions = new EMCallOptions(this.emaObject);
        }
        return this.callOptions;
    }

    public EMCallSession getCurrentCallSession() {
        return this.currentSession;
    }

    public void inputExternalVideoData(byte[] byArray, int n, int n2, int n3) {
        RtcConnection rtcConnection = this.mRtcConnection;
        if (rtcConnection != null) {
            rtcConnection.inputExternalVideoData(byArray, n, n2, n3);
        }
    }

    static {
        EMediaManager.setLoggerDelegate(new XClientBridger.Logcallbackfunc(){

            @Override
            public void onLog(int n, String string) {
                EMLog.d("EMCallManager$RTC", string);
            }
        });
    }

    class EMACallListenerDelegate
    extends EMACallManagerListener {
        EMACallListenerDelegate() {
        }

        @Override
        public void onSendPushMessage(String string, String string2) {
            EMCallPushProvider eMCallPushProvider = EMCallManager.this.mPushProvider;
            if (eMCallPushProvider == null) {
                EMCallManager.this.defaultProvider.onRemoteOffline(string2);
            } else {
                eMCallPushProvider.onRemoteOffline(string2);
            }
        }

        @Override
        public void onRecvCallFeatureUnsupported(EMACallSession eMACallSession, EMAError eMAError) {
            EMLog.d(EMCallManager.TAG, "onRecvCallFeatureUnsupported, callId:" + eMACallSession.getCallId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecvCallIncoming(EMACallSession eMACallSession) {
            EMLog.d(EMCallManager.TAG, "onRecvSessionRemoteInitiate");
            EMCallManager eMCallManager = EMCallManager.this;
            synchronized (eMCallManager) {
                EMCallManager.this.currentSession = new EMCallSession(eMACallSession);
                EMCallManager.this.changeState(EMCallStateChangeListener.CallState.RINGING);
            }
            eMCallManager = new Intent(EMCallManager.this.getIncomingCallBroadcastAction());
            eMCallManager.putExtra("type", EMCallManager.this.currentSession.getType() == EMCallSession.Type.VIDEO ? "video" : "voice");
            eMCallManager.putExtra("from", EMCallManager.this.currentSession.getRemoteName());
            eMCallManager.putExtra("to", EMClient.getInstance().getCurrentUser());
            EMClient.getInstance().getContext().sendBroadcast((Intent)eMCallManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecvCallConnected(EMACallSession eMACallSession) {
            EMLog.d(EMCallManager.TAG, "onRecvSessionConnected");
            EMCallManager eMCallManager = EMCallManager.this;
            synchronized (eMCallManager) {
                if (EMCallManager.this.currentSession == null) {
                    EMCallManager.this.currentSession = new EMCallSession(eMACallSession);
                }
                EMCallManager.this.changeState(EMCallStateChangeListener.CallState.CONNECTED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecvCallAccepted(EMACallSession eMACallSession) {
            EMLog.d(EMCallManager.TAG, "onReceiveCallAccepted");
            EMCallManager eMCallManager = EMCallManager.this;
            synchronized (eMCallManager) {
                if (EMCallManager.this.currentSession == null) {
                    EMCallManager.this.currentSession = new EMCallSession(eMACallSession);
                }
                EMLog.d(EMCallManager.TAG, "onReceiveCallAccepted");
                EMCallManager.this.changeState(EMCallStateChangeListener.CallState.ACCEPTED);
            }
        }

        EMCallStateChangeListener.CallError endReasonToCallError(EMCallSession.EndReason endReason, EMAError eMAError) {
            EMCallStateChangeListener.CallError callError = EMCallStateChangeListener.CallError.ERROR_NONE;
            switch (endReason) {
                case HANGUP: {
                    callError = EMCallStateChangeListener.CallError.ERROR_NONE;
                    break;
                }
                case NORESPONSE: {
                    callError = EMCallStateChangeListener.CallError.ERROR_NORESPONSE;
                    break;
                }
                case REJECT: {
                    callError = EMCallStateChangeListener.CallError.REJECTED;
                    break;
                }
                case BUSY: {
                    callError = EMCallStateChangeListener.CallError.ERROR_BUSY;
                    break;
                }
                case FAIL: {
                    callError = EMCallStateChangeListener.CallError.ERROR_TRANSPORT;
                    if (eMAError.errCode() == 0) break;
                    if (eMAError.errCode() == 802) {
                        callError = EMCallStateChangeListener.CallError.ERROR_UNAVAILABLE;
                        break;
                    }
                    if (eMAError.errCode() == 801) {
                        callError = EMCallStateChangeListener.CallError.ERROR_UNAVAILABLE;
                        break;
                    }
                    if (eMAError.errCode() != 803) break;
                    callError = EMCallStateChangeListener.CallError.ERROR_TRANSPORT;
                    break;
                }
                case OFFLINE: {
                    callError = EMCallStateChangeListener.CallError.ERROR_UNAVAILABLE;
                    break;
                }
            }
            return callError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecvCallEnded(EMACallSession eMACallSession, int n, EMAError eMAError) {
            EMLog.d(EMCallManager.TAG, "onReceiveCallTerminated, reasonOrdinal: " + n);
            EMCallManager eMCallManager = EMCallManager.this;
            synchronized (eMCallManager) {
                if (EMCallManager.this.currentSession != null) {
                    EMCallManager.this.currentSession = null;
                }
                EMCallManager.this.changeState(EMCallStateChangeListener.CallState.DISCONNECTED, this.endReasonToCallError(EMCallSession.getEndReason(n), eMAError));
                EMCallManager.this.mRtcConnection = null;
                EMCallManager.this.mRtcListener = null;
            }
        }

        @Override
        public void onRecvCallNetworkStatusChanged(EMACallSession eMACallSession, int n) {
            EMLog.d(EMCallManager.TAG, "onRecvCallNetworkStatusChanged, callId: " + eMACallSession.getCallId() + " toStatus:" + n);
            EMCallStateChangeListener.CallState callState = EMCallStateChangeListener.CallState.DISCONNECTED;
            if (n == EMACallSession.NetworkStatus.CONNECTED.ordinal()) {
                callState = EMCallStateChangeListener.CallState.NETWORK_NORMAL;
            } else if (n == EMACallSession.NetworkStatus.UNSTABLE.ordinal()) {
                callState = EMCallStateChangeListener.CallState.NETWORK_UNSTABLE;
            } else if (n == EMACallSession.NetworkStatus.DISCONNECTED.ordinal()) {
                callState = EMCallStateChangeListener.CallState.NETWORK_DISCONNECTED;
            } else {
                try {
                    throw new HyphenateException("onRecvCallNetworkStatusChanged invalid toStatus:" + n);
                }
                catch (HyphenateException hyphenateException) {
                    hyphenateException.printStackTrace();
                }
            }
            if (EMCallManager.this.callState.getState() == callState) {
                EMLog.d(EMCallManager.TAG, "onRecvCallNetworkStatusChanged toStatus equals to current callState");
                return;
            }
            EMCallManager.this.changeState(callState);
        }

        @Override
        public void onRecvCallStateChanged(EMACallSession eMACallSession, int n) {
            EMLog.d(EMCallManager.TAG, "onRecvCallStateChanged, callId: " + eMACallSession.getCallId() + " StreamControlType:" + n);
            EMCallStateChangeListener.CallState callState = EMCallStateChangeListener.CallState.DISCONNECTED;
            if (n == EMACallSession.StreamControlType.PAUSE_VIDEO.ordinal()) {
                callState = EMCallStateChangeListener.CallState.VIDEO_PAUSE;
            } else if (n == EMACallSession.StreamControlType.PAUSE_VOICE.ordinal()) {
                callState = EMCallStateChangeListener.CallState.VOICE_PAUSE;
            } else if (n == EMACallSession.StreamControlType.RESUME_VIDEO.ordinal()) {
                callState = EMCallStateChangeListener.CallState.VIDEO_RESUME;
            } else if (n == EMACallSession.StreamControlType.RESUME_VOICE.ordinal()) {
                callState = EMCallStateChangeListener.CallState.VOICE_RESUME;
            } else {
                try {
                    throw new HyphenateException("onRecvCallStateChanged invalid streamControlType:" + n);
                }
                catch (HyphenateException hyphenateException) {
                    hyphenateException.printStackTrace();
                }
            }
            if (EMCallManager.this.callState.getState() == callState) {
                EMLog.d(EMCallManager.TAG, "onRecvCallStateChanged toStatus equals to current callState");
                return;
            }
            EMCallManager.this.changeState(callState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewRtcConnection(String string, String string2, RtcConnection.Listener listener, EMACallRtcImpl eMACallRtcImpl) {
            EMLog.d(EMCallManager.TAG, "onNewRtcConnection, remoteName: " + string2);
            if (eMACallRtcImpl == null || listener == null) {
                return;
            }
            EMCallManager eMCallManager = EMCallManager.this;
            synchronized (eMCallManager) {
                if (EMCallManager.this.mRtcConnection == null) {
                    EMCallManager.this.mRtcConnection = EMCallManager.createRtcConnection("rtc:" + string2);
                    EMCallManager.this.mRtcConnection.setRtcCameraDataProcessor(EMCallManager.this.mProcessorDelegate);
                }
                EMCallManager.this.mRtcListener = listener;
                EMCallManager.this.mRtcConnection.setListener(listener);
                eMACallRtcImpl.setRtcConnection(EMCallManager.this, EMCallManager.this.mRtcConnection);
            }
        }
    }

    public static interface EMCallPushProvider {
        public void onRemoteOffline(String var1);
    }

    class EMCameraDataProcessorDelegate
    implements RtcConnection.RtcCameraDataProcessor {
        EMCameraDataProcessorDelegate() {
        }

        @Override
        public void onProcessData(byte[] byArray, Camera camera, int n, int n2, int n3) {
            EMCameraDataProcessor eMCameraDataProcessor = EMCallManager.this.processor;
            if (eMCameraDataProcessor != null) {
                eMCameraDataProcessor.onProcessData(byArray, camera, n, n2, n3);
            }
        }

        @Override
        public void setResolution(int n, int n2) {
        }
    }

    public static interface EMCameraDataProcessor {
        public void onProcessData(byte[] var1, Camera var2, int var3, int var4, int var5);
    }

    static class CallStateUnion {
        short BIT0 = 1;
        short BIT1 = (short)2;
        short BIT2 = (short)4;
        short BIT3 = (short)8;
        short BIT4 = (short)16;
        short BIT5 = (short)32;
        short BIT6 = (short)64;
        short BIT7 = (short)128;
        BitSet callState = new BitSet();
        boolean ringingToConnected = false;

        CallStateUnion() {
        }

        void reset() {
            this.callState.clear();
            this.ringingToConnected = false;
        }

        void changeState(EMCallStateChangeListener.CallState callState) {
            switch (callState) {
                case IDLE: 
                case RINGING: 
                case ANSWERING: 
                case CONNECTING: 
                case CONNECTED: 
                case ACCEPTED: 
                case DISCONNECTED: {
                    if (this.isRinging() && callState == EMCallStateChangeListener.CallState.CONNECTED) {
                        this.ringingToConnected = true;
                    }
                    this.callState.clear(0, 3);
                    int n = callState.ordinal();
                    if ((n & this.BIT0) > 0) {
                        this.callState.set(0);
                    } else {
                        this.callState.clear(0);
                    }
                    if ((n & this.BIT1) > 0) {
                        this.callState.set(1);
                    } else {
                        this.callState.clear(1);
                    }
                    if ((n & this.BIT2) > 0) {
                        this.callState.set(2);
                    } else {
                        this.callState.clear(2);
                    }
                    if ((n & this.BIT3) > 0) {
                        this.callState.set(3);
                    } else {
                        this.callState.clear(3);
                    }
                    if (callState != EMCallStateChangeListener.CallState.DISCONNECTED) break;
                    this.reset();
                    break;
                }
                case VOICE_PAUSE: {
                    this.callState.set(4);
                    break;
                }
                case VOICE_RESUME: {
                    this.callState.clear(4);
                    break;
                }
                case VIDEO_PAUSE: {
                    this.callState.set(5);
                    break;
                }
                case VIDEO_RESUME: {
                    this.callState.clear(5);
                    break;
                }
                case NETWORK_NORMAL: {
                    this.callState.clear(6, 7);
                    break;
                }
                case NETWORK_UNSTABLE: {
                    this.callState.set(6);
                    this.callState.clear(7);
                    break;
                }
                case NETWORK_DISCONNECTED: {
                    this.callState.clear(6);
                    this.callState.set(7);
                    break;
                }
            }
        }

        EMCallStateChangeListener.CallState getState() {
            int n = 0;
            if (this.callState.get(0)) {
                n |= this.BIT0;
            }
            if (this.callState.get(1)) {
                n |= this.BIT1;
            }
            if (this.callState.get(2)) {
                n |= this.BIT2;
            }
            if (this.callState.get(3)) {
                n |= this.BIT3;
            }
            return EMCallStateChangeListener.CallState.values()[n];
        }

        static boolean isMainState(EMCallStateChangeListener.CallState callState) {
            return callState.ordinal() <= EMCallStateChangeListener.CallState.DISCONNECTED.ordinal();
        }

        boolean isIdle() {
            return !this.callState.get(0) && !this.callState.get(1) && !this.callState.get(2) && !this.callState.get(3);
        }

        boolean isRinging_() {
            return this.callState.get(0) && !this.callState.get(1) && !this.callState.get(2) && !this.callState.get(3);
        }

        boolean isRinging() {
            return this.isRinging_() || this.isConnected() && this.ringingToConnected;
        }

        boolean isAnswering() {
            return !this.callState.get(0) && this.callState.get(1) && !this.callState.get(2) && !this.callState.get(3);
        }

        boolean isConnecting() {
            return this.callState.get(0) && this.callState.get(1) && !this.callState.get(2) && !this.callState.get(3);
        }

        boolean isConnected() {
            return !this.callState.get(0) && !this.callState.get(1) && this.callState.get(2) && !this.callState.get(3);
        }

        boolean isAccepted() {
            return this.callState.get(0) && !this.callState.get(1) && this.callState.get(2) && !this.callState.get(3);
        }

        boolean isDisconnected() {
            return !this.callState.get(0) && this.callState.get(1) && this.callState.get(2) && !this.callState.get(3);
        }

        boolean isVoicePause() {
            return this.callState.get(4);
        }

        boolean isVideoPause() {
            return this.callState.get(5);
        }
    }
}

