/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.adapter.EMACallSession;

public class EMCallSession
extends EMBase<EMACallSession> {
    EMCallSession() {
    }

    EMCallSession(EMACallSession eMACallSession) {
        this.emaObject = eMACallSession;
    }

    public String getCallId() {
        return ((EMACallSession)this.emaObject).getCallId();
    }

    static EndReason getEndReason(int n) {
        if (n == EndReason.HANGUP.ordinal()) {
            return EndReason.HANGUP;
        }
        if (n == EndReason.NORESPONSE.ordinal()) {
            return EndReason.NORESPONSE;
        }
        if (n == EndReason.REJECT.ordinal()) {
            return EndReason.REJECT;
        }
        if (n == EndReason.BUSY.ordinal()) {
            return EndReason.BUSY;
        }
        if (n == EndReason.FAIL.ordinal()) {
            return EndReason.FAIL;
        }
        return EndReason.OFFLINE;
    }

    static SessionInfoType getSessionInfoType(int n) {
        SessionInfoType sessionInfoType = SessionInfoType.RESUME_VOICE;
        switch (n) {
            case 0: {
                sessionInfoType = SessionInfoType.PAUSE_VOICE;
                break;
            }
            case 1: {
                sessionInfoType = SessionInfoType.RESUME_VOICE;
                break;
            }
            case 2: {
                sessionInfoType = SessionInfoType.PAUSE_VIDEO;
                break;
            }
            case 3: {
                sessionInfoType = SessionInfoType.RESUME_VIDEO;
                break;
            }
        }
        return sessionInfoType;
    }

    public Type getType() {
        EMACallSession.Type type = ((EMACallSession)this.emaObject).getType();
        switch (type) {
            case VOICE: {
                return Type.VOICE;
            }
        }
        return Type.VIDEO;
    }

    public ConnectType getConnectType() {
        EMACallSession.ConnectType connectType = ((EMACallSession)this.emaObject).getConnectType();
        switch (connectType) {
            case DIRECT: {
                return ConnectType.DIRECT;
            }
            case RELAY: {
                return ConnectType.RELAY;
            }
        }
        return ConnectType.NONE;
    }

    String password() {
        return "12345678";
    }

    public String getRemoteName() {
        return ((EMACallSession)this.emaObject).getRemoteName();
    }

    public String getExt() {
        return ((EMACallSession)this.emaObject).getExt();
    }

    public String getLocalName() {
        return ((EMACallSession)this.emaObject).getLocalName();
    }

    static enum SessionInfoType {
        PAUSE_VOICE,
        RESUME_VOICE,
        PAUSE_VIDEO,
        RESUME_VIDEO;

    }

    public static enum EndReason {
        HANGUP,
        NORESPONSE,
        REJECT,
        BUSY,
        FAIL,
        OFFLINE;

    }

    public static enum Status {
        DISCONNECTED,
        RINGING,
        CONNECTING,
        CONNECTED,
        ACCEPTED;

    }

    public static enum ConnectType {
        NONE,
        DIRECT,
        RELAY;

    }

    public static enum Type {
        VOICE,
        VIDEO;

    }
}

