/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ImageUtils {
    public static final int SCALE_IMAGE_WIDTH = 640;
    public static final int SCALE_IMAGE_HEIGHT = 960;

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        return ImageUtils.getRoundedCornerBitmap(bitmap, 6.0f);
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float f) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        int n = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    public static Bitmap getVideoThumbnail(String string, int n, int n2, int n3) {
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)string, (int)n3);
        EMLog.d("getVideoThumbnail", "video thumb width:" + bitmap.getWidth());
        EMLog.d("getVideoThumbnail", "video thumb height:" + bitmap.getHeight());
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)n, (int)n2, (int)2);
        return bitmap;
    }

    public static String saveVideoThumb(File file, int n, int n2, int n3) {
        Bitmap bitmap = ImageUtils.getVideoThumbnail(file.getAbsolutePath(), n, n2, n3);
        File file2 = new File(PathUtil.getInstance().getVideoPath(), "th" + file.getName());
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        try {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file2.getAbsolutePath();
    }

    public static Bitmap decodeScaleImage(String string, int n, int n2) {
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(string);
        int n3 = ImageUtils.calculateInSampleSize(options, n, n2);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n3);
        options.inSampleSize = n3;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        int n4 = ImageUtils.readPictureDegree(string);
        Bitmap bitmap2 = null;
        if (bitmap != null && n4 != 0) {
            bitmap2 = ImageUtils.rotateImageView(n4, bitmap);
            bitmap.recycle();
            bitmap = null;
            return bitmap2;
        }
        return bitmap;
    }

    public static Bitmap decodeScaleImage(Context context, int n, int n2, int n3) {
        int n4;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)n, (BitmapFactory.Options)options);
        options.inSampleSize = n4 = ImageUtils.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6;
            int n7 = Math.round((float)n3 / (float)n2);
            n5 = n7 > (n6 = Math.round((float)n4 / (float)n)) ? n7 : n6;
        }
        return n5;
    }

    public static String getThumbnailImage(String string, int n) {
        Bitmap bitmap = ImageUtils.decodeScaleImage(string, n, n);
        try {
            File file = File.createTempFile("image", ".jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
            }
            fileOutputStream.close();
            EMLog.d("img", "generate thumbnail image at:" + file.getAbsolutePath() + " size:" + file.length());
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getScaledImage(Context context, String string) {
        File file = new File(string);
        if (!file.exists()) {
            return string;
        }
        long l = file.length();
        EMLog.d("img", "original img size:" + l);
        if (l <= 102400L) {
            EMLog.d("img", "use original small image");
            return string;
        }
        Bitmap bitmap = ImageUtils.decodeScaleImage(string, 640, 960);
        try {
            File file2 = File.createTempFile("image", ".jpg", context.getFilesDir());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
            }
            fileOutputStream.close();
            EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
            return file2.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getScaledImage(Context context, String string, int n) {
        File file = new File(string);
        if (file.exists()) {
            long l = file.length();
            EMLog.d("img", "original img size:" + l);
            if (l > 102400L) {
                Bitmap bitmap = ImageUtils.decodeScaleImage(string, 640, 960);
                try {
                    File file2 = new File(context.getExternalCacheDir(), "eaemobTemp" + n + ".jpg");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    if (bitmap != null) {
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
                    }
                    fileOutputStream.close();
                    EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
                    return file2.getAbsolutePath();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string;
    }

    public static Bitmap mergeImages(int n, int n2, List<Bitmap> list) {
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-3355444);
        EMLog.d("img", "merge images to size:" + n + "*" + n2 + " with images:" + list.size());
        int n3 = list.size() <= 4 ? 2 : 3;
        int n4 = 0;
        int n5 = (n - 4) / n3;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                Bitmap bitmap2 = list.get(n4);
                Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n5, (int)n5, (boolean)true);
                Bitmap bitmap4 = ImageUtils.getRoundedCornerBitmap(bitmap3, 2.0f);
                bitmap3.recycle();
                canvas.drawBitmap(bitmap4, (float)(j * n5 + (j + 2)), (float)(i * n5 + (i + 2)), null);
                bitmap4.recycle();
                if (++n4 != list.size()) continue;
                return bitmap;
            }
        }
        return bitmap;
    }

    public static int readPictureDegree(String string) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static Bitmap rotateImageView(int n, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public static BitmapFactory.Options getBitmapOptions(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        return options;
    }
}

