/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.call.AudioSource;
import com.superrtc.call.AudioTrack;
import com.superrtc.call.EglBase;
import com.superrtc.call.Logging;
import com.superrtc.call.MediaConstraints;
import com.superrtc.call.MediaStream;
import com.superrtc.call.PeerConnection;
import com.superrtc.call.VideoCapturer;
import com.superrtc.call.VideoSource;
import com.superrtc.call.VideoTrack;
import java.util.List;

public class PeerConnectionFactory {
    private static final String TAG = "PeerConnectionFactory";
    private final long nativeFactory;
    private static Thread workerThread;
    private static Thread signalingThread;
    private EglBase localEglbase;
    private EglBase remoteEglbase;

    public static native boolean initializeAndroidGlobals(Object var0, boolean var1, boolean var2, boolean var3);

    public static native void initializeFieldTrials(String var0);

    public static native void setconfigframerate(int var0);

    public static native void initializeInternalTracer();

    public static native void shutdownInternalTracer();

    public static native boolean startInternalTracingCapture(String var0);

    public static native void stopInternalTracingCapture();

    @Deprecated
    public PeerConnectionFactory() {
        this(null);
    }

    public PeerConnectionFactory(Options options) {
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(options);
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints constraints, PeerConnection.Observer observer) {
        long nativeObserver = PeerConnectionFactory.nativeCreateObserver(observer);
        if (nativeObserver == 0L) {
            return null;
        }
        long nativePeerConnection = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rtcConfig, constraints, nativeObserver);
        if (nativePeerConnection == 0L) {
            return null;
        }
        return new PeerConnection(nativePeerConnection, nativeObserver);
    }

    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, MediaConstraints constraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        return this.createPeerConnection(rtcConfig, constraints, observer);
    }

    public MediaStream createLocalMediaStream(String label) {
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, label));
    }

    public VideoSource createVideoSource(VideoCapturer capturer, MediaConstraints constraints) {
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, capturer, constraints));
    }

    public VideoTrack createVideoTrack(String id, VideoSource source) {
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, id, source.nativeSource));
    }

    public AudioSource createAudioSource(MediaConstraints constraints) {
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, constraints));
    }

    public AudioTrack createAudioTrack(String id, AudioSource source) {
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, id, source.nativeSource));
    }

    public boolean startAecDump(int file_descriptor, int filesize_limit_bytes) {
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, file_descriptor, filesize_limit_bytes);
    }

    public void stopAecDump() {
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    public boolean startRtcEventLog(int file_descriptor) {
        return PeerConnectionFactory.nativeStartRtcEventLog(this.nativeFactory, file_descriptor);
    }

    public void StopRtcEventLog() {
        PeerConnectionFactory.nativeStopRtcEventLog(this.nativeFactory);
    }

    @Deprecated
    public void setOptions(Options options) {
        this.nativeSetOptions(this.nativeFactory, options);
    }

    public void setVideoHwAccelerationOptions(EglBase.Context localEglContext, EglBase.Context remoteEglContext) {
        if (this.localEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.remoteEglbase.release();
        }
        this.localEglbase = EglBase.create(localEglContext);
        this.remoteEglbase = EglBase.create(remoteEglContext);
        PeerConnectionFactory.nativeSetVideoHwAccelerationOptions(this.nativeFactory, this.localEglbase.getEglBaseContext(), this.remoteEglbase.getEglBaseContext());
    }

    public void SetVideoenableHwOptions(boolean disaleHWEncoder, boolean disableHWDecoder) {
        PeerConnectionFactory.nativeSetVideoenableHwOptions(this.nativeFactory, disaleHWEncoder, disableHWDecoder);
    }

    public void dispose() {
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        signalingThread = null;
        workerThread = null;
        if (this.localEglbase != null) {
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            this.remoteEglbase.release();
        }
    }

    public void threadsCallbacks() {
        PeerConnectionFactory.nativeThreadsCallbacks(this.nativeFactory);
    }

    private static void printStackTrace(Thread thread, String threadName) {
        StackTraceElement[] stackTraces;
        if (thread != null && (stackTraces = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, threadName + " stacks trace:");
            for (StackTraceElement stackTrace : stackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    private static native long nativeCreatePeerConnectionFactory(Options var0);

    private static native long nativeCreateObserver(PeerConnection.Observer var0);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, VideoCapturer var2, MediaConstraints var3);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    private static native boolean nativeStartRtcEventLog(long var0, int var2);

    private static native void nativeStopRtcEventLog(long var0);

    @Deprecated
    public native void nativeSetOptions(long var1, Options var3);

    private static native void nativeSetVideoHwAccelerationOptions(long var0, Object var2, Object var3);

    private static native void nativeThreadsCallbacks(long var0);

    private static native void nativeFreeFactory(long var0);

    private static native void nativeSetVideoenableHwOptions(long var0, boolean var2, boolean var3);

    public boolean startRecordPlayout() {
        return PeerConnectionFactory.nativeStartRecordPlayout(this.nativeFactory);
    }

    private static native boolean nativeStartRecordPlayout(long var0);

    public String stopRecordPlayout() {
        return PeerConnectionFactory.nativeStopRecordPlayout(this.nativeFactory);
    }

    private static native String nativeStopRecordPlayout(long var0);

    static {
        System.loadLibrary("hyphenate_av");
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;
    }
}

