/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.superrtc.call.EglBase;
import com.superrtc.call.EglBase10;
import com.superrtc.call.EglBase14;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.GlTextureFrameBuffer;
import com.superrtc.call.GlUtil;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.VideoRenderer;
import com.superrtc.call.VideoRendererGui;
import com.superrtc.sdk.VideoView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public class VideoRendererGui2
implements GLSurfaceView.Renderer {
    private Runnable eglContextReady = null;
    private static final String TAG = "VideoRendererGui2";
    private VideoView surface;
    private EglBase.Context eglContext = null;
    private boolean onSurfaceCreatedCalled;
    private int screenWidth;
    private int screenHeight;
    private final ArrayList<YuvImageRenderer> yuvImageRenderers;
    private Thread renderFrameThread;
    private Thread drawThread;
    private boolean renderEnabled = true;

    @SuppressLint(value={"NewApi"})
    public VideoRendererGui2(VideoView surface, Runnable eglContextReady) {
        this.surface = surface;
        this.eglContextReady = eglContextReady;
        surface.setPreserveEGLContextOnPause(true);
        surface.setEGLContextClientVersion(2);
        surface.setRenderer(this);
        surface.setRenderMode(0);
        this.yuvImageRenderers = new ArrayList();
    }

    public void setReadyCallback(Runnable eglContextReady) {
        this.eglContextReady = eglContextReady;
    }

    public int getframesReceived() {
        int framenum;
        block0: {
            framenum = 0;
            Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
            if (!iterator.hasNext()) break block0;
            YuvImageRenderer yuvImageRenderer = iterator.next();
            framenum = yuvImageRenderer.framesReceived;
        }
        return framenum;
    }

    public synchronized EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        VideoRendererGui2 instance = this;
        if (instance == null) {
            return;
        }
        Logging.d(TAG, "VideoRendererGui.dispose");
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : instance.yuvImageRenderers) {
                yuvImageRenderer.release();
            }
            instance.yuvImageRenderers.clear();
        }
        this.renderFrameThread = null;
        this.drawThread = null;
        instance.surface = null;
        this.eglContext = null;
        this.eglContextReady = null;
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeblack(boolean enable) {
        VideoRendererGui2 instance = this;
        if (instance == null) {
            return;
        }
        Logging.e(TAG, "VideoRendererGui makeblack " + enable);
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : instance.yuvImageRenderers) {
                yuvImageRenderer.makeblack(enable);
            }
        }
        if (enable) {
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            GLES20.glClear((int)16384);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glFinish();
        }
    }

    public VideoRenderer createGui(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) throws Exception {
        YuvImageRenderer javaGuiRenderer = this.create(x, y, width, height, scalingType, mirror);
        return new VideoRenderer(javaGuiRenderer);
    }

    public VideoRenderer.Callbacks createGuiRenderer(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        return this.create(x, y, width, height, scalingType, mirror);
    }

    public synchronized YuvImageRenderer create(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        return this.create(x, y, width, height, scalingType, mirror, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized YuvImageRenderer create(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror, RendererCommon.GlDrawer drawer) {
        if (x < 0 || x > 100 || y < 0 || y > 100 || width < 0 || width > 100 || height < 0 || height > 100 || x + width > 100 || y + height > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        final VideoRendererGui2 instance = this;
        if (instance == null) {
            throw new RuntimeException("Attempt to create yuv renderer before setting GLSurfaceView");
        }
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(instance.surface, instance.yuvImageRenderers.size(), x, y, width, height, scalingType, mirror, drawer);
        if (instance.onSurfaceCreatedCalled) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            if (instance.surface != null) {
                instance.surface.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(instance.screenWidth, instance.screenHeight);
                        countDownLatch.countDown();
                    }
                });
            } else {
                countDownLatch.countDown();
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            instance.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    public int getScreenWidth() {
        int videoWidth;
        block0: {
            videoWidth = 0;
            Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
            if (!iterator.hasNext()) break block0;
            YuvImageRenderer yuvImageRenderer = iterator.next();
            videoWidth = yuvImageRenderer.getVideoWidth();
        }
        return videoWidth;
    }

    public int getScreenHeight() {
        int videoHeight;
        block0: {
            videoHeight = 0;
            Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
            if (!iterator.hasNext()) break block0;
            YuvImageRenderer yuvImageRenderer = iterator.next();
            videoHeight = yuvImageRenderer.getVideoHeight();
        }
        return videoHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized YuvImageRenderer createRenderer(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror, RendererCommon.GlDrawer drawer) {
        if (x < 0 || x > 100 || y < 0 || y > 100 || width < 0 || width > 100 || height < 0 || height > 100 || x + width > 100 || y + height > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        final VideoRendererGui2 inst = this;
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(inst.surface, inst.yuvImageRenderers.size(), x, y, width, height, scalingType, mirror, drawer);
        ArrayList<YuvImageRenderer> arrayList = inst.yuvImageRenderers;
        synchronized (arrayList) {
            if (inst.onSurfaceCreatedCalled) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                inst.surface.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(inst.screenWidth, inst.screenHeight);
                        countDownLatch.countDown();
                    }
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            inst.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(VideoRenderer.Callbacks renderer, int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
        Logging.d(TAG, "VideoRendererGui.update");
        VideoRendererGui2 instance = this;
        if (instance == null) {
            throw new RuntimeException("Attempt to update yuv renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.setPosition(x, y, width, height, scalingType, mirror);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRendererEvents(VideoRenderer.Callbacks renderer, RendererCommon.RendererEvents rendererEvents) {
        Logging.d(TAG, "VideoRendererGui.setRendererEvents");
        VideoRendererGui2 instance = this;
        if (instance == null) {
            throw new RuntimeException("Attempt to set renderer events before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.rendererEvents = rendererEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(VideoRenderer.Callbacks renderer) {
        Logging.d(TAG, "VideoRendererGui.remove");
        VideoRendererGui2 instance = this;
        if (instance == null) {
            throw new RuntimeException("Attempt to remove renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            int index = instance.yuvImageRenderers.indexOf(renderer);
            if (index == -1) {
                Logging.w(TAG, "Couldn't remove renderer (not present in current list)");
            } else {
                instance.yuvImageRenderers.remove(index).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(VideoRenderer.Callbacks renderer) {
        Logging.d(TAG, "VideoRendererGui.reset");
        VideoRendererGui2 instance = this;
        if (instance == null) {
            throw new RuntimeException("Attempt to reset renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = instance.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : instance.yuvImageRenderers) {
                if (yuvImageRenderer != renderer) continue;
                yuvImageRenderer.reset();
            }
        }
    }

    private static void printStackTrace(Thread thread, String threadName) {
        StackTraceElement[] stackTraces;
        if (thread != null && (stackTraces = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, threadName + " stacks trace:");
            for (StackTraceElement stackTrace : stackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    public synchronized void printStackTraces() {
        VideoRendererGui2.printStackTrace(this.renderFrameThread, "Render frame thread");
        VideoRendererGui2.printStackTrace(this.drawThread, "Draw thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceCreated");
        Class<VideoRendererGui2> clazz = VideoRendererGui.class;
        synchronized (VideoRendererGui.class) {
            this.eglContext = EglBase14.isEGL14Supported() ? new EglBase14.Context(EGL14.eglGetCurrentContext()) : new EglBase10.Context(((EGL10)EGLContext.getEGL()).eglGetCurrentContext());
            Logging.d(TAG, "VideoRendererGui EGL Context: " + this.eglContext);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            clazz = this.yuvImageRenderers;
            synchronized (clazz) {
                for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                    yuvImageRenderer.createTextures();
                }
                this.onSurfaceCreatedCalled = true;
            }
            GlUtil.checkNoGLES2Error("onSurfaceCreated done");
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            clazz = VideoRendererGui2.class;
            synchronized (VideoRendererGui2.class) {
                if (this.eglContextReady != null) {
                    this.eglContextReady.run();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 unused, int width, int height) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceChanged: " + width + " x " + height + "  ");
        this.screenWidth = width;
        this.screenHeight = height;
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.setScreenSize(this.screenWidth, this.screenHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 unused) {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            if (!this.onSurfaceCreatedCalled) {
                return;
            }
        }
        if (this.drawThread == null) {
            this.drawThread = Thread.currentThread();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        GLES20.glClear((int)16384);
        arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            if (!this.renderEnabled) {
                return;
            }
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.draw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderEnable(boolean enabled) {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            this.renderEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRenderEnable() {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            return this.renderEnabled;
        }
    }

    private static class YuvImageRenderer
    implements VideoRenderer.Callbacks {
        private VideoView surface;
        private int id;
        private int[] yuvTextures = new int[]{0, 0, 0};
        private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
        private final RendererCommon.GlDrawer drawer;
        private GlTextureFrameBuffer textureCopy;
        private VideoRenderer.I420Frame pendingFrame;
        private final Object pendingFrameLock = new Object();
        private RendererType rendererType;
        private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
        RendererCommon.ScalingType newscalingtype;
        private boolean mirror;
        private RendererCommon.RendererEvents rendererEvents;
        boolean seenFrame;
        private int framesReceived;
        private int framesDropped;
        private int framesRendered;
        private long startTimeNs = -1L;
        private long drawTimeNs;
        private long copyTimeNs;
        private final Rect layoutInPercentage;
        private final Rect displayLayout = new Rect();
        private float[] layoutMatrix;
        private boolean updateLayoutProperties;
        private final Object updateLayoutLock = new Object();
        private float[] rotatedSamplingMatrix;
        private int screenWidth;
        private int screenHeight;
        private int videoWidth;
        private int videoHeight;
        private boolean ismakeblack = false;
        private int rotationDegree;

        private YuvImageRenderer(VideoView surface, int id, int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror, RendererCommon.GlDrawer drawer) {
            Logging.d(VideoRendererGui2.TAG, "YuvImageRenderer.Create id: " + id);
            this.surface = surface;
            this.id = id;
            this.scalingType = surface != null ? (surface.getScaleMode() == VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit ? RendererCommon.ScalingType.SCALE_ASPECT_FIT : RendererCommon.ScalingType.SCALE_ASPECT_FILL) : scalingType;
            this.mirror = mirror;
            this.drawer = drawer;
            this.layoutInPercentage = new Rect(x, y, Math.min(100, x + width), Math.min(100, y + height));
            this.updateLayoutProperties = false;
            this.rotationDegree = 0;
        }

        public synchronized void reset() {
            this.seenFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void release() {
            this.surface = null;
            this.drawer.release();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (this.pendingFrame != null) {
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
                this.rendererEvents = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void makeblack(boolean enable) {
            Object object = this.pendingFrameLock;
            synchronized (object) {
                this.ismakeblack = enable;
            }
        }

        private void createTextures() {
            Logging.d(VideoRendererGui2.TAG, "  YuvImageRenderer.createTextures " + this.id + " on GL thread:" + Thread.currentThread().getId());
            for (int i = 0; i < 3; ++i) {
                this.yuvTextures[i] = GlUtil.generateTexture(3553);
            }
            this.textureCopy = new GlTextureFrameBuffer(6407);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLayoutMatrix() {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                RendererCommon.ScalingType scalingType = this.newscalingtype = this.surface.getScaleMode() == VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit ? RendererCommon.ScalingType.SCALE_ASPECT_FIT : RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                if (this.newscalingtype != this.scalingType) {
                    this.updateLayoutProperties = true;
                    this.scalingType = this.newscalingtype;
                }
                if (!this.updateLayoutProperties) {
                    return;
                }
                this.displayLayout.set((this.screenWidth * this.layoutInPercentage.left + 99) / 100, (this.screenHeight * this.layoutInPercentage.top + 99) / 100, this.screenWidth * this.layoutInPercentage.right / 100, this.screenHeight * this.layoutInPercentage.bottom / 100);
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". AdjustTextureCoords. Allowed display size: " + this.displayLayout.width() + " x " + this.displayLayout.height() + ". Video: " + this.videoWidth + " x " + this.videoHeight + ". Rotation: " + this.rotationDegree + ". Mirror: " + this.mirror);
                float videoAspectRatio = this.rotationDegree % 180 == 0 ? (float)this.videoWidth / (float)this.videoHeight : (float)this.videoHeight / (float)this.videoWidth;
                Point displaySize = RendererCommon.getDisplaySize(this.scalingType, videoAspectRatio, this.displayLayout.width(), this.displayLayout.height());
                this.displayLayout.inset((this.displayLayout.width() - displaySize.x) / 2, (this.displayLayout.height() - displaySize.y) / 2);
                Logging.d(VideoRendererGui2.TAG, "  Adjusted display size: " + this.displayLayout.width() + " x " + this.displayLayout.height());
                this.layoutMatrix = RendererCommon.getLayoutMatrix(this.mirror, videoAspectRatio, (float)this.displayLayout.width() / (float)this.displayLayout.height());
                this.updateLayoutProperties = false;
                Logging.d(VideoRendererGui2.TAG, "  AdjustTextureCoords done");
            }
        }

        public int getVideoWidth() {
            return this.videoWidth;
        }

        public int getVideoHeight() {
            return this.videoHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw() {
            boolean isNewFrame;
            if (!this.seenFrame) {
                return;
            }
            if (this.ismakeblack) {
                return;
            }
            long now = System.nanoTime();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                boolean bl = isNewFrame = this.pendingFrame != null;
                if (isNewFrame && this.startTimeNs == -1L) {
                    this.startTimeNs = now;
                }
                if (isNewFrame) {
                    this.rotatedSamplingMatrix = RendererCommon.rotateTextureMatrix(this.pendingFrame.samplingMatrix, this.pendingFrame.rotationDegree);
                    if (this.pendingFrame.yuvFrame) {
                        this.rendererType = RendererType.RENDERER_YUV;
                        this.yuvUploader.uploadYuvData(this.yuvTextures, this.pendingFrame.width, this.pendingFrame.height, this.pendingFrame.yuvStrides, this.pendingFrame.yuvPlanes);
                    } else {
                        this.rendererType = RendererType.RENDERER_TEXTURE;
                        this.textureCopy.setSize(this.pendingFrame.rotatedWidth(), this.pendingFrame.rotatedHeight());
                        GLES20.glBindFramebuffer((int)36160, (int)this.textureCopy.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        this.drawer.drawOes(this.pendingFrame.textureId, this.rotatedSamplingMatrix, 0, 0, this.textureCopy.getWidth(), this.textureCopy.getHeight());
                        this.rotatedSamplingMatrix = RendererCommon.identityMatrix();
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glFinish();
                    }
                    this.copyTimeNs += System.nanoTime() - now;
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
            this.updateLayoutMatrix();
            float[] texMatrix = RendererCommon.multiplyMatrices(this.rotatedSamplingMatrix, this.layoutMatrix);
            int viewportY = this.screenHeight - this.displayLayout.bottom;
            if (this.rendererType == RendererType.RENDERER_YUV) {
                this.drawer.drawYuv(this.yuvTextures, texMatrix, this.displayLayout.left, viewportY, this.displayLayout.width(), this.displayLayout.height());
            } else {
                this.drawer.drawRgb(this.textureCopy.getTextureId(), texMatrix, this.displayLayout.left, viewportY, this.displayLayout.width(), this.displayLayout.height());
            }
            if (isNewFrame) {
                ++this.framesRendered;
                if (this.framesRendered == 1) {
                    Logging.e(VideoRendererGui2.TAG, "first frame rendered: " + this.framesRendered);
                }
                this.drawTimeNs += System.nanoTime() - now;
                if (this.framesRendered % 300 == 0) {
                    this.logStatistics();
                }
            }
        }

        private void logStatistics() {
            long timeSinceFirstFrameNs = System.nanoTime() - this.startTimeNs;
            Logging.e(VideoRendererGui2.TAG, "ID: " + this.id + ". Type: " + (Object)((Object)this.rendererType) + ". Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                Logging.d(VideoRendererGui2.TAG, "Duration: " + (int)((double)timeSinceFirstFrameNs / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)timeSinceFirstFrameNs);
                Logging.d(VideoRendererGui2.TAG, "Draw time: " + (int)(this.drawTimeNs / (long)(1000 * this.framesRendered)) + " us. Copy time: " + (int)(this.copyTimeNs / (long)(1000 * this.framesReceived)) + " us");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScreenSize(int screenWidth, int screenHeight) {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (screenWidth == this.screenWidth && screenHeight == this.screenHeight) {
                    return;
                }
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setScreenSize: " + screenWidth + " x " + screenHeight);
                this.screenWidth = screenWidth;
                this.screenHeight = screenHeight;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(int x, int y, int width, int height, RendererCommon.ScalingType scalingType, boolean mirror) {
            Rect layoutInPercentage = new Rect(x, y, Math.min(100, x + width), Math.min(100, y + height));
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (layoutInPercentage.equals((Object)this.layoutInPercentage) && scalingType == this.scalingType && mirror == this.mirror) {
                    return;
                }
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setPosition: (" + x + ", " + y + ") " + width + " x " + height + ". Scaling: " + (Object)((Object)scalingType) + ". Mirror: " + mirror);
                this.layoutInPercentage.set(layoutInPercentage);
                this.mirror = mirror;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSize(int videoWidth, int videoHeight, int rotation) {
            if (videoWidth == this.videoWidth && videoHeight == this.videoHeight && rotation == this.rotationDegree) {
                return;
            }
            if (this.rendererEvents != null) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". Reporting frame resolution changed to " + videoWidth + " x " + videoHeight);
                this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
            }
            Object object = this.updateLayoutLock;
            synchronized (object) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setSize: " + videoWidth + " x " + videoHeight + " rotation " + rotation);
                this.videoWidth = videoWidth;
                this.videoHeight = videoHeight;
                this.rotationDegree = rotation;
                this.updateLayoutProperties = true;
                Logging.d(VideoRendererGui2.TAG, "  YuvImageRenderer.setSize done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void renderFrame(VideoRenderer.I420Frame frame) {
            if (this.surface == null) {
                VideoRenderer.renderFrameDone(frame);
                return;
            }
            if (!this.seenFrame && this.rendererEvents != null) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". Reporting first rendered frame.");
                this.rendererEvents.onFirstFrameRendered();
            }
            ++this.framesReceived;
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (frame.yuvFrame && (frame.yuvStrides[0] < frame.width || frame.yuvStrides[1] < frame.width / 2 || frame.yuvStrides[2] < frame.width / 2)) {
                    Logging.e(VideoRendererGui2.TAG, "Incorrect strides " + frame.yuvStrides[0] + ", " + frame.yuvStrides[1] + ", " + frame.yuvStrides[2]);
                    VideoRenderer.renderFrameDone(frame);
                    return;
                }
                if (this.pendingFrame != null) {
                    ++this.framesDropped;
                    VideoRenderer.renderFrameDone(frame);
                    this.seenFrame = true;
                    return;
                }
                this.pendingFrame = frame;
            }
            this.setSize(frame.width, frame.height, frame.rotationDegree);
            this.seenFrame = true;
            this.surface.requestRender();
        }

        private static enum RendererType {
            RENDERER_YUV,
            RENDERER_TEXTURE;

        }
    }
}

