/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.opengl.EGLContext;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.superrtc.call.AudioSource;
import com.superrtc.call.AudioTrack;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.DataChannel;
import com.superrtc.call.EglBase;
import com.superrtc.call.IceCandidate;
import com.superrtc.call.Logging;
import com.superrtc.call.MediaCodecVideoEncoder;
import com.superrtc.call.MediaConstraints;
import com.superrtc.call.MediaStream;
import com.superrtc.call.MediaStreamTrack;
import com.superrtc.call.PeerConnection;
import com.superrtc.call.PeerConnectionFactory;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.SdpObserver;
import com.superrtc.call.SessionDescription;
import com.superrtc.call.StatsObserver;
import com.superrtc.call.StatsReport;
import com.superrtc.call.VideoCapturerAndroid;
import com.superrtc.call.VideoRenderer;
import com.superrtc.call.VideoRendererGui2;
import com.superrtc.call.VideoSource;
import com.superrtc.call.VideoTrack;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.sdk.ALog;
import com.superrtc.sdk.Bandwidth;
import com.superrtc.sdk.Packetslostrate;
import com.superrtc.sdk.RtcListener;
import com.superrtc.sdk.SDPSsrcChanger;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.util.AppRTCAudioManager;
import com.superrtc.util.BitmapUtil;
import com.superrtc.util.CpuMonitor;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import com.superrtc.voice.WebRtcAudioManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@SuppressLint(value={"DefaultLocale"})
public class RtcConnection {
    private static final String TAG = "RtcConn";
    private static final String RTC_VERSION = "2.0.1";
    private static Context sContext;
    private static LooperExecutor executor;
    private static PeerConnectionFactory factory;
    private boolean enableOpenCamera = false;
    private boolean autoAddVideo = true;
    private Listener listener;
    private boolean isStopCapture = false;
    public String name = "RTC0";
    public String streamId = "";
    public String pubStreamId = "";
    private Parameters peerConnectionParameters;
    private boolean localRendererAdded = false;
    private boolean remoteRendererAdded = false;
    private static Logging.Severity medialoglevel;
    private static boolean disableResize;
    private static int configfps;
    private static final int DEFAULT_CONFIG_FPS = 20;
    private static int configminkbps;
    private static int DEFAULT_CONFIG_MINKBPS;
    private static boolean useVideoCodecHw;
    private static boolean iscreateConnectionFactory;
    private EglBase.Context sharedeglContext = null;
    private String connectType = "disconn";
    private boolean isConnected = false;
    private Packetslostrate packetslostrate = new Packetslostrate();
    private Packetslostrate recvpacketslostrate = new Packetslostrate();
    private PeerConnection.IceConnectionState iceConnectionState;
    public static final String RtcKVCaptureVideoBoolean = "capVideo";
    public static final String RtcKVRecvVideoBoolean = "recvVideo";
    public static final String RtcKVCaptureAudioBoolean = "capAudio";
    public static final String RtcKVRecvAudioBoolean = "recvAudio";
    public static final String RtcCustomVideoSourceBoolean = "customVideoSrc";
    public static final String RtcKVRelayOnlyBoolean = "relayOnly";
    public static final String RtcKVVideoResolutionLevelLong = "vresL";
    public static final String RtcKVMaxVideoKbpsLong = "maxVKbps";
    public static final String RtcKVRelayVideoKbpsLong = "relayVKbps";
    public static final String RtcKVMaxAudioKbpsLong = "maxAKbps";
    public static final String RtcKVRelayAudioKbpsLong = "relayAKbps";
    public static final String RtcvideofpsLong = "videofps";
    public static final String RtcvideowidthLong = "width";
    public static final String RtcvideoheigthLong = "heigth";
    public static final String RtcKVPreferVCodecString = "prefVC";
    public static final String RtcKVPreferACodecString = "prefAC";
    public static final String RtcKVIceServersArray = "iceServers";
    public static final String RtcKVDisablePranswerBoolean = "disablePranswer";
    public static final String RtcKVLoopbackBoolean = "loopback";
    public static final String RtcKVAecDumpFileString = "aecdumpFile";
    public static final String RtcConstStringVP8 = "VP8";
    public static final String RtcConstStringVP9 = "VP9";
    public static final String RtcConstStringH264 = "H264";
    public static final String RtcConstStringOPUS = "OPUS";
    public static final String RtcConstStringG722 = "G722";
    public static final String RtcConstStringURL = "url";
    public static final String RtcConstStringUserName = "username";
    public static final String RtcConstStringCredential = "credential";
    public static final String RtcHDVideoEncoderBoolean = "hdencoder";
    public static final String RtcHDVideoDecoderBoolean = "hddecoder";
    private boolean isHangup = false;
    private String lusevcodectype = "VP8";
    private String luseacodectype = "OPUS";
    private String rusevcodectype = "VP8";
    private String ruseacodectype = "OPUS";
    private int framesReceived = 0;
    private boolean enableHWEncoder = false;
    private boolean enableHWDecoder = false;
    private static int cameraid;
    private static boolean enableLocalViewMirror;
    private RtcCameraDataProcessor processor;
    private boolean enableExternalVideoData;
    private RtcGlTextureProcessor glprocessor;
    private int configRotation = 0;
    private boolean isconfigRotation = false;
    private static String globalVideoCodec;
    public VideoViewRenderer localViewRender;
    public VideoViewRenderer remoteViewRender;
    VideoRendererGui2 localGui;
    VideoRendererGui2 remoteGui;
    RenderRect localRect;
    RenderRect remoteRect;
    private long localSeq = 0L;
    SDPSsrcChanger ssrcChanger = new SDPSsrcChanger("ARDAMS");
    private LinkedList<SessionDescription> pendingSdp = new LinkedList();
    private List<IceCandidate> pendingCandidates = new ArrayList<IceCandidate>();
    LocalSDPObserver localSDPObserver = new LocalSDPObserver();
    RemoteSDPObserver remoteSDPObserver = new RemoteSDPObserver();
    MediaStream remoteStream;
    boolean isPranswerState = false;
    private final CpuMonitor cpuMonitor = new CpuMonitor();
    public static int loglevel;
    private static MIRROR mirrorType;
    private static LogListener sLogListenerInternal;
    public static LogListener sLogListener;
    private static RtcListener rtcListener;
    private static final String STAT_KEY_CONNECTION = "connection";
    private Bandwidth remoteVideoBW = new Bandwidth();
    private Bandwidth remoteAudioBW = new Bandwidth();
    private Bandwidth localVideoBW = new Bandwidth();
    private Bandwidth localAudioBW = new Bandwidth();
    private RendererCommon.ScalingType localScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    private RendererCommon.ScalingType remoteScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    private boolean localEnableDTX = false;
    private boolean remoteEnableDTX = false;
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String FIELD_TRIAL_VP9 = "WebRTC-SupportVP9/Enabled/";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String MAX_VIDEO_WIDTH_CONSTRAINT = "maxWidth";
    private static final String MIN_VIDEO_WIDTH_CONSTRAINT = "minWidth";
    private static final String MAX_VIDEO_HEIGHT_CONSTRAINT = "maxHeight";
    private static final String MIN_VIDEO_HEIGHT_CONSTRAINT = "minHeight";
    private static final String MAX_VIDEO_FPS_CONSTRAINT = "maxFrameRate";
    private static final String MIN_VIDEO_FPS_CONSTRAINT = "minFrameRate";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1920;
    private static final int HD_VIDEO_HEIGHT = 1080;
    private static final int MAX_VIDEO_WIDTH = 1920;
    private static final int MAX_VIDEO_HEIGHT = 1920;
    private static final int MAX_VIDEO_FPS = 30;
    private static final String RTC_DEFAULT_VIDEO_CODEC = "VP8";
    private static final int RTC_DEFAULT_VIDEO_WIDTH = 640;
    private static final int RTC_DEFAULT_VIDEO_HEIGH = 480;
    private static final String RTC_DEFAULT_AUDIO_CODEC = "OPUS";
    private int videolastsendpackets = 0;
    private int videocursendpackets = 0;
    private int audiolastsendpackets = 0;
    private int audiocursendpackets = 0;
    private int videosendbytes = 0;
    private int videorecvbytes = 0;
    private int audiosendbytes = 0;
    private int audiorecvbytes = 0;
    private int videolastsendpacketsLost = 0;
    private int videocursendpacketsLost = 0;
    private int audiolastsendpacketsLost = 0;
    private int audiocursendpacketsLost = 0;
    private int videolastrecvpackets = 0;
    private int videocurrecvpackets = 0;
    private int audiolastrecvpackets = 0;
    private int audiocurrecvpackets = 0;
    private int videolastrecvpacketsLost = 0;
    private int videocurrecvpacketsLost = 0;
    private int audiolastrecvpacketsLost = 0;
    private int audiocurrecvpacketsLost = 0;
    private final PCObserver pcObserver = new PCObserver();
    private PeerConnection peerConnection;
    PeerConnectionFactory.Options options = null;
    private VideoSource videoSource;
    private AudioSource audioSource;
    private boolean videoCallEnabled = true;
    private boolean videoreceiveEnabled = true;
    private boolean disablePranswer = false;
    private boolean loopbackEnable = false;
    private String aecDumpFilename = null;
    private String videoCodec = globalVideoCodec;
    private int videoWidth = 0;
    private int videoHeigth = 0;
    private int videoFramerate = 15;
    private int videoMaxrate = 0;
    private int videoStartBitrate = 120;
    private int relayvideoMaxrate = 0;
    private boolean audioCallEnabled = true;
    private boolean audioreceiveEnabled = true;
    private String audioCodec;
    private int audioMaxrate = 24;
    private int relayaudioMaxrate = 24;
    private boolean enableRelay = false;
    private boolean preferIsac;
    private boolean preferH264 = true;
    private boolean videoSourceStopped;
    private Timer statsTimer;
    private VideoRenderer.Callbacks localRender;
    private VideoRenderer.Callbacks remoteRender;
    private VideoRenderer localvideorender;
    private VideoRenderer remotevideorender;
    private List<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
    private MediaConstraints pcConstraints;
    private MediaConstraints videoConstraints;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    private boolean isInitiator;
    private SessionDescription localSdp;
    private MediaStream mediaStream;
    private int numberOfCameras;
    private VideoCapturerAndroid videoCapturer;
    private boolean renderVideo;
    private VideoTrack localVideoTrack;
    private AudioTrack localAudioTrack;
    private VideoTrack remoteVideoTrack;
    private boolean enableaudio = true;
    private boolean enableaec = true;
    private boolean enableagc = true;
    private boolean enablens = true;
    private AppRTCAudioManager audioManager = null;
    ParcelFileDescriptor aecDumpFileDescriptor = null;
    public View view4Capture = null;
    private boolean isViewCaptureTimer = false;

    public static void setLocalVideoViewMirror(MIRROR mirror) {
        mirrorType = mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLogListener(LogListener listener) {
        Log.i((String)TAG, (String)"[rapi]++ registerLogListener");
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            Log.i((String)TAG, (String)"[rapi]-- registerLogListener");
            sLogListener = listener;
            sLogListener = listener != null ? listener : sLogListenerInternal;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void callbackLog(int level, String log) {
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            sLogListener.onLog(level, log);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static int getKbpsByVideoSize(int w, int h) {
        if (w == 320 && h == 240 || w == 240 && h == 320) {
            return 300;
        }
        if (w == 640 && h == 480 || w == 480 && h == 640) {
            return 800;
        }
        if (w == 1280 && h == 720 || w == 720 && h == 1280) {
            return 2500;
        }
        if (w == 1920 && h == 1080 || w == 1080 && h == 1920) {
            return 10000;
        }
        return 300;
    }

    public void interestAt(int x, int y, int focus, int exposure, boolean fromRemote) {
        if (!this.enableExternalVideoData) {
            this.handleFocus(x, y, focus, exposure);
        }
    }

    public void zoomWithFactor(Float factor) {
        if (!this.enableExternalVideoData) {
            this.handleZoom(factor);
        }
    }

    public void handleZoom(final Float isZoomIn) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip handleZoom because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleZoom(isZoomIn);
                }
            }
        });
    }

    public void handleFocus(final int x, final int y, final int focus, final int exposure) {
        if (this.localGui == null) {
            return;
        }
        final int viewWidth = this.localGui.getScreenWidth();
        final int viewHeight = this.localGui.getScreenHeight();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip handleFocus because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleFocusMetering(x, y, viewWidth, viewHeight, focus, exposure);
                }
            }
        });
    }

    public void handleManualFocus(final float x, final float y, final int viewWidth, final int viewHeight) {
        if (this.localGui == null) {
            return;
        }
        final int width = this.localGui.getScreenWidth();
        final int height = this.localGui.getScreenHeight();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip handleFocus because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleManualFocus((int)x, (int)y, width, height, viewWidth, viewHeight, RtcConnection.this.localScalingType);
                }
            }
        });
    }

    public void handleManualZoom(final boolean isZoomIn, final int zoomScale) {
        if (this.localGui == null) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip zoom because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleManualZoom(isZoomIn, zoomScale);
                }
            }
        });
    }

    public void handleFlashLight(final boolean isOpen) {
        if (this.localGui == null) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip flashlight because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.videoCapturer != null) {
                    RtcConnection.this.videoCapturer.handleFlashLight(isOpen);
                }
            }
        });
    }

    public void setRotation(int rotation) {
        this.isconfigRotation = true;
        this.configRotation = rotation;
        this.checkVideoCapturerConfigRotation();
    }

    public static void setAudioSampleRate(int samplerate) {
        if (samplerate > 0) {
            WebRtcAudioManager.setAudioSampleRate(samplerate);
        }
    }

    public void setEnableExternalVideoData(boolean enable) {
        this.enableExternalVideoData = enable;
    }

    public void setCallAudioSource(int source) {
        WebRtcAudioManager.setCallAudioSource(source);
    }

    public static void setRtcListener(RtcListener listener) {
        rtcListener = listener;
        WebRtcAudioManager.setRtcListener(listener);
    }

    public void setRtcCameraDataProcessor(RtcCameraDataProcessor processor) {
        this.processor = processor;
        this.checkVideoCapturerDataProcessor();
    }

    public void setRtcGlTextureProcessor(RtcGlTextureProcessor glprocessor) {
        this.glprocessor = glprocessor;
        this.checkGlTextureProcessor();
    }

    public static void enableFixedVideoResolution(boolean enable) {
        disableResize = enable;
    }

    public static void setMinVideoKbps(int kbps) {
        configminkbps = kbps > 0 ? kbps : DEFAULT_CONFIG_MINKBPS;
    }

    public static void setCameraFacing(int id) {
        if (cameraid != id) {
            cameraid = id;
            if (cameraid == 0) {
                enableLocalViewMirror = false;
            } else if (cameraid == 1) {
                enableLocalViewMirror = true;
            }
        }
    }

    public int getCameraFacing() {
        if (this.videoCapturer == null) {
            sLogListener.onLog(loglevel, this.name + "::: videoCapturer is null,Failed to getCameraFacing.");
            return -1;
        }
        return this.videoCapturer.getCurrentCameraId();
    }

    public static void setGlobalVideoCodec(String codec) {
        globalVideoCodec = codec;
    }

    public static void initGlobal(Context context) throws Exception {
        RtcConnection.initGlobal(context, false, null);
    }

    public static void initGlobal(Context context, LooperExecutor executor) throws Exception {
        RtcConnection.initGlobal(context, false, executor);
    }

    public static void setMediaLogLevel(Medialogmod level) {
        switch (level) {
            case M_SENSITIVE: {
                medialoglevel = Logging.Severity.LS_SENSITIVE;
                break;
            }
            case M_VERBOSE: {
                medialoglevel = Logging.Severity.LS_VERBOSE;
                break;
            }
            case M_INFO: {
                medialoglevel = Logging.Severity.LS_INFO;
                break;
            }
            case M_WARNING: {
                medialoglevel = Logging.Severity.LS_WARNING;
                break;
            }
            case M_ERROR: {
                medialoglevel = Logging.Severity.LS_ERROR;
            }
        }
    }

    public static void initGlobal(final Context context, final boolean useVideoCodecHw, LooperExecutor setexecutor) throws Exception {
        sLogListener.onLog(loglevel, "[rapi]++ initGlobal, useVideoCodecHw=" + useVideoCodecHw + "rtc sdk version " + RtcConnection.getVersion());
        sContext = context;
        if (setexecutor == null) {
            executor = new LooperExecutor();
            executor.requestStart();
        } else {
            executor = setexecutor;
        }
        RtcConnection.useVideoCodecHw = useVideoCodecHw;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "[rapi]-- initGlobal, useVideoCodecHw=" + useVideoCodecHw);
                PeerConnectionFactory.setconfigframerate(20);
                try {
                    RtcConnection.createConnectionFactoryInternal(context, null, useVideoCodecHw);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                Logging.enableTracing("logcat:", EnumSet.of(Logging.TraceLevel.TRACE_DEFAULT), medialoglevel);
            }
        });
    }

    public RtcConnection(final String name) {
        this.name = name;
        this.isHangup = false;
        sLogListener.onLog(loglevel, name + "::: [rapi]++ create RtcConnection");
        this.statsTimer = new Timer();
        this.setStatsEnable(true);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "create RtcConnection start -0- name: " + name);
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, name + "::: skip createConnectionFactory because of conn is already hangup!");
                    return;
                }
                sLogListener.onLog(loglevel, name + "::: [rapi]-- create RtcConnection");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReportString() throws JSONException {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ getReportString");
        JSONObject obj = new JSONObject();
        Class<RtcConnection> clazz = RtcConnection.class;
        synchronized (RtcConnection.class) {
            obj.put("conn", (Object)this.connectType);
            obj.put("lvcodec", (Object)this.lusevcodectype);
            obj.put("lacodec", (Object)this.luseacodectype);
            obj.put("rvcodec", (Object)this.rusevcodectype);
            obj.put("racodec", (Object)this.ruseacodectype);
            obj.put("sentVB", this.videosendbytes);
            obj.put("sentAB", this.audiosendbytes);
            obj.put("recvVB", this.videorecvbytes);
            obj.put("recvAB", this.audiorecvbytes);
            obj.put("sentVP", this.videolastsendpackets);
            obj.put("sentAP", this.audiolastsendpackets);
            obj.put("recvVP", this.videolastrecvpackets);
            obj.put("recvAP", this.audiolastrecvpackets);
            obj.put("os", (Object)"a");
            if (this.remoteGui != null) {
                this.framesReceived = this.remoteGui.getframesReceived();
            }
            obj.put("rvfrm", this.framesReceived);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            sLogListener.onLog(loglevel, this.name + "::: [rapi]-- getReportString");
            return obj.toString();
        }
    }

    private static void createConnectionFactoryInternal(Context context, EGLContext renderEGLContext, boolean videoCodecHwAcceleration) throws Exception {
        PeerConnectionFactory.initializeFieldTrials(null);
        if (!PeerConnectionFactory.initializeAndroidGlobals(context, true, true, videoCodecHwAcceleration)) {
            throw RtcConnection.newException("Failed to initializeAndroid");
        }
        factory = new PeerConnectionFactory();
    }

    private Parameters getDefaultParameters() {
        boolean videoEnabled = true;
        boolean noAudioProcessing = false;
        return new Parameters(videoEnabled, this.loopbackEnable, this.videoWidth, this.videoHeigth, this.videoFramerate, this.videoMaxrate, this.videoCodec, false, 0, this.audioCodec, noAudioProcessing, true);
    }

    public String getName() {
        return this.name;
    }

    public void setListener(final Listener listerner) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setListener");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setListener because of conn is already hangup!");
                    return;
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setListener");
                RtcConnection.this.listener = listerner;
            }
        });
    }

    public void clearIceServer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ clearIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- clearIceServer");
                RtcConnection.this.iceServers.clear();
            }
        });
    }

    public void addIceServer(final String uri, final String username, final String password) {
        sLogListener.onLog(loglevel, "[rapi]++ addIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- addIceServer");
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add ice server: " + uri);
                RtcConnection.this.iceServers.add(new PeerConnection.IceServer(uri, username, password));
            }
        });
    }

    public void makeblack(boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: makeblack :" + enable);
        if (this.remoteGui != null) {
            this.remoteGui.makeblack(enable);
        }
        if (this.localGui != null) {
            this.localGui.makeblack(enable);
        }
    }

    public void setViews(VideoViewRenderer localView_, VideoViewRenderer remoteView_) {
        String setviewtype = "";
        if (localView_ != null) {
            setviewtype = setviewtype + " localView_ ";
        }
        if (remoteView_ != null) {
            setviewtype = setviewtype + " remoteView_ ";
        }
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setViews" + setviewtype);
        this.stopRenderer(this.localViewRender, this.remoteViewRender);
        this.addRenderer(localView_, remoteView_);
        this.handleCoverShowLogic();
    }

    public void switchTorchOn(boolean on) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchTorchOn because of conn is already hangup!");
                    return;
                }
                if (!RtcConnection.this.enableOpenCamera || RtcConnection.this.videoCapturer == null) {
                    sLogListener.onLog(loglevel, "Failed to switchTorchOn. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchTorchOn");
                    return;
                }
            }
        });
    }

    private boolean isLocalViewReady() {
        return this.localViewRender != null && this.localViewRender.isViewReady();
    }

    private boolean isRemoteViewReady() {
        return this.remoteViewRender != null && this.remoteViewRender.isViewReady();
    }

    public void switchVideo(final boolean enabled) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchVideo because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnectionParameters != null) {
                    ((RtcConnection)RtcConnection.this).peerConnectionParameters.captureVideo = enabled;
                    RtcConnection.this.checkMediaTracksInternal();
                }
            }
        });
    }

    public void switchAudio(final boolean enabled) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchAudio because of conn is already hangup!");
                    return;
                }
                ((RtcConnection)RtcConnection.this).peerConnectionParameters.captureAudio = enabled;
                RtcConnection.this.checkMediaTracksInternal();
            }
        });
    }

    private static String appendStatString(String orgin, String add) {
        if (orgin == null || orgin.equals("")) {
            return add;
        }
        return orgin + "," + add;
    }

    private static void addState(Map<String, String> map, String key, String add) {
        map.put(key, RtcConnection.appendStatString(map.get(key), add));
    }

    private static String makeStatLine(Map<String, String> map, String key, String div) {
        if (map.get(key) != null) {
            return div + key + ": " + map.get(key) + "\r\n";
        }
        return "";
    }

    private static Map<String, String> convertStatMap(StatsReport.Value[] values) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (StatsReport.Value value : values) {
            m.put(value.name, value.value);
        }
        return m;
    }

    private void getStats() {
        if (this.peerConnection == null | this.isHangup) {
            return;
        }
        boolean success = this.peerConnection.getStats(new StatsObserver(){

            @Override
            public void onComplete(StatsReport[] reports) {
                HashMap<String, String> mapCommon = new HashMap<String, String>();
                HashMap<String, String> mapLocal = new HashMap<String, String>();
                HashMap<String, String> mapRemote = new HashMap<String, String>();
                HashMap<String, String> mapLocalstat = new HashMap<String, String>();
                HashMap<String, String> mapRemotestat = new HashMap<String, String>();
                RtcStatistics rtcStatistics = new RtcStatistics();
                for (StatsReport report : reports) {
                    Map m = RtcConnection.convertStatMap(report.values);
                    if (report.type.equals("googCandidatePair")) {
                        if (!((String)m.get("googActiveConnection")).equals("true")) continue;
                        String localType = (String)m.get("googLocalCandidateType");
                        String remoteType = (String)m.get("googRemoteCandidateType");
                        if (localType != null && localType.equals("relay") || remoteType != null && remoteType.equals("relay")) {
                            RtcConnection.addState(mapCommon, RtcConnection.STAT_KEY_CONNECTION, "relay");
                            RtcConnection.this.connectType = "relay";
                            rtcStatistics.connectionType = RtcConnection.this.connectType;
                            continue;
                        }
                        RtcConnection.addState(mapCommon, RtcConnection.STAT_KEY_CONNECTION, "direct");
                        RtcConnection.this.connectType = "direct";
                        rtcStatistics.connectionType = RtcConnection.this.connectType;
                        continue;
                    }
                    if (report.type.equals("ssrc")) {
                        String w;
                        String codec = (String)m.get("googCodecName");
                        if (m.get("googFrameWidthReceived") != null) {
                            RtcConnection.this.rusevcodectype = codec;
                            w = (String)m.get("googFrameWidthReceived");
                            String h = (String)m.get("googFrameHeightReceived");
                            mapRemote.put("vcodec", codec);
                            mapRemote.put("vsize", w + "x" + h);
                            mapRemote.put("vfps", (String)m.get("googFrameRateDecoded"));
                            mapRemote.put("vlost", (String)m.get("packetsLost"));
                            mapRemote.put("vbytes", (String)m.get("bytesReceived"));
                            RtcConnection.this.remoteVideoBW.update((String)m.get("bytesReceived"));
                            RtcConnection.this.videorecvbytes = Integer.parseInt((String)m.get("bytesReceived"));
                            RtcConnection.this.videocurrecvpackets = Integer.parseInt((String)m.get("packetsReceived"));
                            int recvpacket = RtcConnection.this.videocurrecvpackets - RtcConnection.this.videolastrecvpackets;
                            RtcConnection.this.videolastrecvpackets = RtcConnection.this.videocurrecvpackets;
                            RtcConnection.this.videocurrecvpacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            int recvpacketlost = RtcConnection.this.videocurrecvpacketsLost - RtcConnection.this.videolastrecvpacketsLost;
                            RtcConnection.this.videolastrecvpacketsLost = RtcConnection.this.videocurrecvpacketsLost;
                            RtcConnection.this.recvpacketslostrate.addvideopackslost(recvpacket, recvpacketlost);
                            rtcStatistics.remoteVideoPacketsLostrate = RtcConnection.this.recvpacketslostrate.getvideopackslostrate();
                            mapRemotestat.put("vsize", w + "x" + h);
                            mapRemotestat.put("vfps", (String)m.get("googFrameRateReceived"));
                            mapRemotestat.put("vlost", (String)m.get("packetsLost"));
                            rtcStatistics.remoteWidth = Integer.parseInt((String)m.get("googFrameWidthReceived"));
                            rtcStatistics.remoteHeight = Integer.parseInt((String)m.get("googFrameHeightReceived"));
                            rtcStatistics.remoteFps = Integer.parseInt((String)m.get("googFrameRateReceived"));
                            rtcStatistics.remoteVideoPacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            continue;
                        }
                        if (m.get("googFrameWidthSent") != null) {
                            w = (String)m.get("googFrameWidthSent");
                            String h = (String)m.get("googFrameHeightSent");
                            RtcConnection.this.lusevcodectype = codec;
                            mapLocal.put("vlcodec", codec);
                            mapLocal.put("vinsize", (String)m.get("googFrameWidthInput") + "x" + (String)m.get("googFrameHeightInput"));
                            mapLocal.put("vsize", w + "x" + h);
                            mapLocal.put("vfps", (String)m.get("googFrameRateInput") + "/" + (String)m.get("googFrameRateSent"));
                            mapLocal.put("vlost", (String)m.get("packetsLost"));
                            mapLocal.put("vrtt", (String)m.get("googRtt"));
                            mapLocal.put("vbytes", (String)m.get("bytesSent"));
                            RtcConnection.this.localVideoBW.update((String)m.get("bytesSent"));
                            RtcConnection.this.videosendbytes = Integer.parseInt((String)m.get("bytesSent"));
                            RtcConnection.this.videocursendpackets = Integer.parseInt((String)m.get("packetsSent"));
                            int sendpacket = RtcConnection.this.videocursendpackets - RtcConnection.this.videolastsendpackets;
                            RtcConnection.this.videolastsendpackets = RtcConnection.this.videocursendpackets;
                            RtcConnection.this.videocursendpacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            int sendpacketlost = RtcConnection.this.videocursendpacketsLost - RtcConnection.this.videolastsendpacketsLost;
                            RtcConnection.this.videolastsendpacketsLost = RtcConnection.this.videocursendpacketsLost;
                            RtcConnection.this.packetslostrate.addvideopackslost(sendpacket, sendpacketlost);
                            rtcStatistics.localVideoPacketsLostrate = RtcConnection.this.packetslostrate.getvideopackslostrate();
                            mapLocalstat.put("vsize", w + "x" + h);
                            mapLocalstat.put("vfps", (String)m.get("googFrameRateInput") + "/" + (String)m.get("googFrameRateSent"));
                            mapLocalstat.put("vlost", (String)m.get("packetsLost"));
                            mapLocalstat.put("vrtt", (String)m.get("googRtt"));
                            rtcStatistics.localCaptureWidth = Integer.parseInt((String)m.get("googFrameWidthInput"));
                            rtcStatistics.localCaptureHeight = Integer.parseInt((String)m.get("googFrameHeightInput"));
                            rtcStatistics.localEncodedWidth = Integer.parseInt((String)m.get("googFrameWidthSent"));
                            rtcStatistics.localEncodedHeight = Integer.parseInt((String)m.get("googFrameHeightSent"));
                            rtcStatistics.localCaptureFps = Integer.parseInt((String)m.get("googFrameRateInput"));
                            rtcStatistics.localEncodedFps = Integer.parseInt((String)m.get("googFrameRateSent"));
                            rtcStatistics.localVideoPacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            rtcStatistics.localVideoRtt = Integer.parseInt((String)m.get("googRtt"));
                            continue;
                        }
                        if (m.get("bytesReceived") != null) {
                            RtcConnection.this.ruseacodectype = codec;
                            mapRemote.put("acodec", codec);
                            mapRemote.put("alost", (String)m.get("packetsLost"));
                            mapRemote.put("abytes", (String)m.get("bytesReceived"));
                            RtcConnection.this.remoteAudioBW.update((String)m.get("bytesReceived"));
                            RtcConnection.this.audiorecvbytes = Integer.parseInt((String)m.get("bytesReceived"));
                            RtcConnection.this.audiocurrecvpackets = Integer.parseInt((String)m.get("packetsReceived"));
                            int recvpacket = RtcConnection.this.audiocurrecvpackets - RtcConnection.this.audiolastrecvpackets;
                            RtcConnection.this.audiolastrecvpackets = RtcConnection.this.audiocurrecvpackets;
                            RtcConnection.this.audiocurrecvpacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            int recvpacketlost = RtcConnection.this.audiocurrecvpacketsLost - RtcConnection.this.audiolastrecvpacketsLost;
                            RtcConnection.this.audiolastrecvpacketsLost = RtcConnection.this.audiocurrecvpacketsLost;
                            RtcConnection.this.recvpacketslostrate.addaudiopackslost(recvpacket, recvpacketlost);
                            rtcStatistics.remoteAudioPacketsLostrate = RtcConnection.this.recvpacketslostrate.getaudiopackslostrate();
                            mapRemotestat.put("alost", (String)m.get("packetsLost"));
                            mapRemotestat.put("artt", (String)m.get("googRtt"));
                            rtcStatistics.remoteAudioPacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                            continue;
                        }
                        if (m.get("bytesSent") == null) continue;
                        RtcConnection.this.luseacodectype = codec;
                        mapLocal.put("acodec", codec);
                        mapLocal.put("alost", (String)m.get("packetsLost"));
                        mapLocal.put("abytes", (String)m.get("bytesSent"));
                        RtcConnection.this.localAudioBW.update((String)m.get("bytesSent"));
                        mapLocalstat.put("alost", (String)m.get("packetsLost"));
                        mapLocalstat.put("abytes", (String)m.get("bytesSent"));
                        mapLocalstat.put("artt", (String)m.get("googRtt"));
                        RtcConnection.this.audiosendbytes = Integer.parseInt((String)m.get("bytesSent"));
                        RtcConnection.this.audiocursendpackets = Integer.parseInt((String)m.get("packetsSent"));
                        int sendpacket = RtcConnection.this.audiocursendpackets - RtcConnection.this.audiolastsendpackets;
                        RtcConnection.this.audiolastsendpackets = RtcConnection.this.audiocursendpackets;
                        RtcConnection.this.audiocursendpacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                        int sendpacketlost = RtcConnection.this.audiocursendpacketsLost - RtcConnection.this.audiolastsendpacketsLost;
                        RtcConnection.this.audiolastsendpacketsLost = RtcConnection.this.audiocursendpacketsLost;
                        RtcConnection.this.packetslostrate.addaudiopackslost(sendpacket, sendpacketlost);
                        rtcStatistics.localAudioPacketsLostrate = RtcConnection.this.packetslostrate.getaudiopackslostrate();
                        rtcStatistics.localAudioRtt = Integer.parseInt((String)m.get("googRtt"));
                        rtcStatistics.localAudioPacketsLost = Integer.parseInt((String)m.get("packetsLost"));
                        continue;
                    }
                    if (!report.type.equals("VideoBwe")) continue;
                    mapLocal.put("vbr", (String)m.get("googActualEncBitrate") + "/" + (String)m.get("googTargetEncBitrate"));
                    mapLocalstat.put("vbr", Integer.parseInt((String)m.get("googActualEncBitrate")) / 1000 + "/" + Integer.parseInt((String)m.get("googTargetEncBitrate")) / 1000);
                    rtcStatistics.localVideoActualBps = Integer.parseInt((String)m.get("googActualEncBitrate")) / 1000;
                    rtcStatistics.localVideoTargetBps = Integer.parseInt((String)m.get("googTargetEncBitrate")) / 1000;
                }
                if (mapCommon.get(RtcConnection.STAT_KEY_CONNECTION) == null) {
                    mapCommon.put(RtcConnection.STAT_KEY_CONNECTION, "disconnect");
                }
                String stat = "";
                String avstat = "";
                stat = stat + RtcConnection.makeStatLine(mapCommon, RtcConnection.STAT_KEY_CONNECTION, "");
                avstat = avstat + RtcConnection.makeStatLine(mapCommon, RtcConnection.STAT_KEY_CONNECTION, "");
                if (RtcConnection.this.cpuMonitor.sampleCpuUtilization()) {
                    stat = stat + "CPU%: " + RtcConnection.this.cpuMonitor.getCpuCurrent() + "/" + RtcConnection.this.cpuMonitor.getCpuAvg3() + "/" + RtcConnection.this.cpuMonitor.getCpuAvgAll();
                }
                if (mapLocal.size() > 0) {
                    mapLocal.put("vbps", String.valueOf(RtcConnection.this.localVideoBW.getBitrateString()));
                    mapLocal.put("abps", String.valueOf(RtcConnection.this.localAudioBW.getBitrateString()));
                    mapLocalstat.put("abps", String.valueOf(RtcConnection.this.localAudioBW.getBitrateString()));
                    rtcStatistics.localAudioBps = Integer.parseInt(RtcConnection.this.localAudioBW.getBitrateString());
                    stat = stat + "\r\n";
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vlcodec", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vinsize", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vsize", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vfps", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vrtt", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vlost", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vbytes", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vbps", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "vbr", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "acodec", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "alost", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "abytes", "");
                    stat = stat + RtcConnection.makeStatLine(mapLocal, "abps", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocal, "vlcodec", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "vsize", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "vfps", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "vrtt", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "vlost", "");
                    avstat = avstat + "vlostrate: " + rtcStatistics.localVideoPacketsLostrate + "\r\n";
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "vbr", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "alost", "");
                    avstat = avstat + "alostrate: " + rtcStatistics.localAudioPacketsLostrate + "\r\n";
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "artt", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapLocalstat, "abps", "");
                }
                if (mapRemote.size() > 0) {
                    mapRemote.put("vbps", String.valueOf(RtcConnection.this.remoteVideoBW.getBitrateString()));
                    mapRemote.put("abps", String.valueOf(RtcConnection.this.remoteAudioBW.getBitrateString()));
                    mapRemotestat.put("vbps", String.valueOf(RtcConnection.this.remoteVideoBW.getBitrateString()));
                    mapRemotestat.put("abps", String.valueOf(RtcConnection.this.remoteAudioBW.getBitrateString()));
                    rtcStatistics.remoteVideoBps = Integer.parseInt(RtcConnection.this.remoteVideoBW.getBitrateString());
                    rtcStatistics.remoteAudioBps = Integer.parseInt(RtcConnection.this.remoteAudioBW.getBitrateString());
                    stat = stat + "\r\n";
                    stat = stat + "remote:\r\n";
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vcodec", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vsize", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vfps", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vlost", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vbytes", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "vbps", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "acodec", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "alost", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "abytes", "");
                    stat = stat + RtcConnection.makeStatLine(mapRemote, "abps", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "vcodec", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "vsize", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "vfps", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "vlost", "");
                    avstat = avstat + "vlostrate: " + rtcStatistics.remoteVideoPacketsLostrate + "\r\n";
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "vbps", "");
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "alost", "");
                    avstat = avstat + "alostrate: " + rtcStatistics.remoteAudioPacketsLostrate + "\r\n";
                    avstat = avstat + RtcConnection.makeStatLine(mapRemotestat, "abps", "");
                }
                rtcStatistics.fullStatsString = avstat;
                if (!RtcConnection.this.isHangup) {
                    RtcConnection.this.listener.onStats(RtcConnection.this, rtcStatistics);
                }
            }
        }, null);
        if (!success) {
            sLogListener.onLog(loglevel, this.name + "::: getStats() returns false!");
        }
    }

    public void setStatsEnable(boolean enable) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                RtcConnection.this.getStats();
                            }
                        });
                    }
                }, 0L, 1000L);
            }
            catch (Exception e2) {
                sLogListener.onLog(loglevel, this.name + "::: Can not schedule statistics timer " + e2);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void stopRenderer(final VideoViewRenderer localView_, final VideoViewRenderer remoteView_) {
        if (!this.isConnected) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.makeblack(true);
                if (remoteView_ != null && RtcConnection.this.remoteViewRender == remoteView_ && RtcConnection.this.remoteVideoTrack != null && RtcConnection.this.remoteRendererAdded && RtcConnection.this.remotevideorender != null) {
                    RtcConnection.this.remoteRendererAdded = false;
                    RtcConnection.this.remoteVideoTrack.removeRenderer(RtcConnection.this.remotevideorender);
                    RtcConnection.this.remoteRect = null;
                    RtcConnection.this.remotevideorender = null;
                    if (RtcConnection.this.remoteGui != null) {
                        RtcConnection.this.remoteGui.remove(RtcConnection.this.remoteRender);
                        RtcConnection.this.remoteRender = null;
                        RtcConnection.this.remoteGui = null;
                    }
                    RtcConnection.this.remoteViewRender = null;
                }
                if (localView_ != null && RtcConnection.this.localViewRender == localView_ && RtcConnection.this.localVideoTrack != null && RtcConnection.this.localRendererAdded && RtcConnection.this.localvideorender != null) {
                    RtcConnection.this.localRendererAdded = false;
                    RtcConnection.this.localVideoTrack.removeRenderer(RtcConnection.this.localvideorender);
                    RtcConnection.this.localRect = null;
                    RtcConnection.this.localvideorender = null;
                    RtcConnection.this.localViewRender = null;
                    if (RtcConnection.this.localGui != null) {
                        RtcConnection.this.localGui.remove(RtcConnection.this.localRender);
                        RtcConnection.this.localRender = null;
                        RtcConnection.this.localGui = null;
                    }
                }
            }
        });
    }

    public void addRenderer(final VideoViewRenderer localView_, final VideoViewRenderer remoteView_) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "Add renderer start -0- name: " + RtcConnection.this.name);
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip addRenderer because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.remoteViewRender = remoteView_;
                RtcConnection.this.localViewRender = localView_;
                if (remoteView_ != null) {
                    RtcConnection.this.remoteGui = remoteView_.getGuiImpl();
                }
                if (localView_ != null) {
                    RtcConnection.this.localGui = localView_.getGuiImpl();
                }
                if (RtcConnection.this.remoteRect == null && RtcConnection.this.remoteViewRender != null) {
                    RtcConnection.this.remoteRect = new RenderRect(0, 0, 100, 100);
                }
                if (RtcConnection.this.localRect == null && RtcConnection.this.localViewRender != null) {
                    RtcConnection.this.localRect = localView_ != remoteView_ ? new RenderRect(0, 0, 100, 100) : new RenderRect(72, 72, 25, 25);
                }
                RtcConnection.this.checkAddRenddererInternal();
                RtcConnection.this.makeblack(false);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setViews");
            }
        });
    }

    public void setAspectMode(final AspectMode Localaspectmode, final AspectMode Remoteaspectmode) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setAspectMode Localaspectmode::" + (Object)((Object)Localaspectmode) + ",Remoteaspectmode::" + (Object)((Object)Remoteaspectmode));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (Localaspectmode == AspectMode.AspectFill) {
                    RtcConnection.this.localScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                } else if (Localaspectmode == AspectMode.AspectFit) {
                    RtcConnection.this.localScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                }
                if (Remoteaspectmode == AspectMode.AspectFill) {
                    RtcConnection.this.remoteScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                } else if (Remoteaspectmode == AspectMode.AspectFit) {
                    RtcConnection.this.remoteScalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
                }
                RtcConnection.this.updateVideoViewInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setAspectMode");
            }
        });
    }

    private void checkAddRenddererInternal() {
        sLogListener.onLog(loglevel, this.name + "::: checkAddRenddererInternal: => local=[" + this.localRender + ", " + this.localVideoTrack + "], remote=[" + this.remoteRender + ", " + this.remoteVideoTrack + "]");
        if (this.isRemoteViewReady()) {
            if (this.remoteRender == null) {
                sLogListener.onLog(loglevel, this.name + "::: create remote renderer");
                this.remoteRender = this.remoteGui.create(this.remoteRect.x, this.remoteRect.y, this.remoteRect.width, this.remoteRect.height, this.remoteScalingType, false);
            }
            if (this.remoteVideoTrack != null && !this.remoteRendererAdded && this.remoteRender != null) {
                this.remoteRendererAdded = true;
                sLogListener.onLog(loglevel, this.name + "::: add remote renderer");
                this.remotevideorender = new VideoRenderer(this.remoteRender);
                this.remoteVideoTrack.addRenderer(this.remotevideorender);
            }
        }
        if (this.isLocalViewReady()) {
            if (this.localRender == null) {
                boolean mirror = this.getVideoViewMirror();
                sLogListener.onLog(loglevel, this.name + "::: create local renderer. Mirror::" + mirror);
                this.localRender = this.localGui.create(this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.localScalingType, mirror);
            }
            if (this.localVideoTrack != null && !this.localRendererAdded && this.localRender != null) {
                this.localRendererAdded = true;
                sLogListener.onLog(loglevel, this.name + "::: add local renderer");
                this.localvideorender = new VideoRenderer(this.localRender);
                this.localVideoTrack.addRenderer(this.localvideorender);
            }
        }
    }

    private void updateVideoViewInternal() {
        if (this.remoteRender != null) {
            sLogListener.onLog(loglevel, this.name + "::: update remote renderer,remoteScalingType::" + (Object)((Object)this.remoteScalingType));
            if (this.remoteGui != null) {
                this.remoteGui.update(this.remoteRender, this.remoteRect.x, this.remoteRect.y, this.remoteRect.width, this.remoteRect.height, this.remoteScalingType, false);
            }
        }
        if (this.localRender != null && this.localGui != null) {
            boolean mirror = this.getVideoViewMirror();
            sLogListener.onLog(loglevel, this.name + "::: update local renderer,localScalingType::" + (Object)((Object)this.localScalingType));
            this.localGui.update(this.localRender, this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.localScalingType, mirror);
        }
    }

    public void updateVideoViewmirror() {
        boolean mirror = this.getVideoViewMirror();
        if (this.localRender != null && this.localGui != null) {
            sLogListener.onLog(loglevel, this.name + "::: update local renderer,localScalingType::" + (Object)((Object)this.localScalingType) + " mirror:" + mirror);
            this.localGui.update(this.localRender, this.localRect.x, this.localRect.y, this.localRect.width, this.localRect.height, this.localScalingType, mirror);
        }
    }

    private boolean getVideoViewMirror() {
        boolean mirror;
        switch (mirrorType) {
            case ON: {
                mirror = true;
                break;
            }
            case OFF: {
                mirror = false;
                break;
            }
            default: {
                mirror = enableLocalViewMirror;
            }
        }
        return mirror;
    }

    public void setIceServer(final String url, final String username, final String password) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setIceServer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject obj = new JSONObject();
                    obj.put(RtcConnection.RtcConstStringURL, (Object)url);
                    obj.put(RtcConnection.RtcConstStringUserName, (Object)username);
                    obj.put(RtcConnection.RtcConstStringCredential, (Object)password);
                    JSONArray array = new JSONArray();
                    array.put((Object)obj);
                    JSONObject root = new JSONObject();
                    root.put(RtcConnection.RtcKVIceServersArray, (Object)array);
                    RtcConnection.this.setConfigureInternal(root.toString());
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: excpetion:" + e2.getMessage());
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setIceServer");
            }
        });
    }

    public void setConfigure(final String configJson) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setConfigure");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "set Configure start -0- name: " + RtcConnection.this.name);
                RtcConnection.this.setConfigureInternal(configJson);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setConfigure");
            }
        });
    }

    private void handleCoverShowLogic() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "handleCoverShowLogic, isLocalViewReady: " + RtcConnection.this.isLocalViewReady() + " - hasCover: " + (RtcConnection.this.localViewRender == null ? null : Boolean.valueOf(RtcConnection.this.localViewRender.getWrapper().hasCover())));
                if (RtcConnection.this.isLocalViewReady() && RtcConnection.this.localViewRender.getWrapper().hasCover()) {
                    RtcConnection.this.localViewRender.getWrapper().showCover(true);
                    RtcConnection.this.localGui.reset(RtcConnection.this.localRender);
                    RtcConnection.this.localGui.setRendererEvents(RtcConnection.this.localRender, new RendererCommon.RendererEvents(){

                        @Override
                        public void onFirstFrameRendered() {
                            sLogListener.onLog(loglevel, "localView_ onFirstFrameRendered");
                            RtcConnection.this.localViewRender.getWrapper().showCover(false);
                        }

                        @Override
                        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                        }
                    });
                }
                sLogListener.onLog(loglevel, "handleCoverShowLogic, isRemoteViewReady: " + RtcConnection.this.isRemoteViewReady() + " - hasCover: " + (RtcConnection.this.remoteViewRender == null ? null : Boolean.valueOf(RtcConnection.this.remoteViewRender.getWrapper().hasCover())));
                if (RtcConnection.this.isRemoteViewReady() && RtcConnection.this.remoteViewRender.getWrapper().hasCover()) {
                    RtcConnection.this.remoteViewRender.getWrapper().showCover(true);
                    RtcConnection.this.remoteGui.reset(RtcConnection.this.remoteRender);
                    RtcConnection.this.remoteGui.setRendererEvents(RtcConnection.this.remoteRender, new RendererCommon.RendererEvents(){

                        @Override
                        public void onFirstFrameRendered() {
                            sLogListener.onLog(loglevel, "remoteView_ onFirstFrameRendered");
                            RtcConnection.this.remoteViewRender.getWrapper().showCover(false);
                        }

                        @Override
                        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                        }
                    });
                }
            }
        });
    }

    private void setConfigureInternal(String configJson) {
        try {
            JSONArray serverArray;
            Object ob;
            sLogListener.onLog(loglevel, this.name + "::: start setConfigure: config=" + configJson);
            JSONObject dataJson = new JSONObject(configJson);
            if (dataJson.has(RtcKVCaptureVideoBoolean)) {
                ob = dataJson.get(RtcKVCaptureVideoBoolean);
                if (Boolean.TRUE.equals(ob) || Integer.valueOf(1).equals(ob)) {
                    this.videoCallEnabled = true;
                } else {
                    this.autoAddVideo = false;
                    this.videoCallEnabled = false;
                }
            }
            if (dataJson.has(RtcKVRecvVideoBoolean)) {
                ob = dataJson.get(RtcKVRecvVideoBoolean);
                this.videoreceiveEnabled = Boolean.TRUE.equals(ob) || Integer.valueOf(1).equals(ob);
            }
            if (dataJson.has(RtcCustomVideoSourceBoolean)) {
                int customVideoSrc = dataJson.optInt(RtcCustomVideoSourceBoolean);
                this.enableExternalVideoData = customVideoSrc != 0;
                this.videoCallEnabled = true;
            }
            if (dataJson.has(RtcKVPreferVCodecString)) {
                this.videoCodec = dataJson.getString(RtcKVPreferVCodecString);
            }
            if (dataJson.has(RtcvideowidthLong)) {
                this.videoWidth = dataJson.getInt(RtcvideowidthLong);
                if (this.isConnected && dataJson.has(RtcvideoheigthLong)) {
                    this.videoHeigth = dataJson.getInt(RtcvideoheigthLong);
                    if (this.videoWidth != 0 && this.videoHeigth != 0) {
                        this.changeVideoResolution(this.videoWidth, this.videoHeigth);
                    }
                }
            }
            if (dataJson.has(RtcvideoheigthLong)) {
                this.videoHeigth = dataJson.getInt(RtcvideoheigthLong);
            }
            if (dataJson.has(RtcvideofpsLong)) {
                this.videoFramerate = dataJson.getInt(RtcvideofpsLong);
            }
            if (dataJson.has(RtcKVMaxVideoKbpsLong)) {
                this.videoMaxrate = dataJson.getInt(RtcKVMaxVideoKbpsLong);
                if (this.videoMaxrate < 0) {
                    this.videoMaxrate = 0;
                }
            }
            if (dataJson.has(RtcKVRelayVideoKbpsLong)) {
                this.relayvideoMaxrate = dataJson.getInt(RtcKVRelayVideoKbpsLong);
            }
            if (dataJson.has(RtcKVCaptureAudioBoolean)) {
                Object ob2 = dataJson.get(RtcKVCaptureAudioBoolean);
                this.audioCallEnabled = Boolean.TRUE.equals(ob2) || Integer.valueOf(1).equals(ob2);
            }
            if (dataJson.has(RtcKVRecvAudioBoolean)) {
                Object ob3 = dataJson.get(RtcKVRecvAudioBoolean);
                this.audioreceiveEnabled = Boolean.TRUE.equals(ob3) || Integer.valueOf(1).equals(ob3);
            }
            if (dataJson.has(RtcKVPreferACodecString)) {
                this.audioCodec = dataJson.getString(RtcKVPreferACodecString);
            }
            if (dataJson.has(RtcKVMaxAudioKbpsLong)) {
                this.audioMaxrate = dataJson.getInt(RtcKVMaxAudioKbpsLong);
            }
            if (dataJson.has(RtcKVRelayAudioKbpsLong)) {
                this.relayaudioMaxrate = dataJson.getInt(RtcKVRelayAudioKbpsLong);
            }
            if (dataJson.has(RtcKVDisablePranswerBoolean)) {
                Object ob4 = dataJson.get(RtcKVDisablePranswerBoolean);
                this.disablePranswer = Boolean.TRUE.equals(ob4) || Integer.valueOf(1).equals(ob4);
            }
            if (dataJson.has(RtcKVLoopbackBoolean)) {
                Object ob5 = dataJson.get(RtcKVLoopbackBoolean);
                this.loopbackEnable = Boolean.TRUE.equals(ob5) || Integer.valueOf(1).equals(ob5);
            }
            if (dataJson.has(RtcKVAecDumpFileString)) {
                this.aecDumpFilename = dataJson.getString(RtcKVAecDumpFileString);
            }
            if (dataJson.has(RtcKVRelayOnlyBoolean)) {
                Object ob6 = dataJson.get(RtcKVRelayOnlyBoolean);
                this.enableRelay = Boolean.TRUE.equals(ob6) || Integer.valueOf(1).equals(ob6);
            }
            if (dataJson.has(RtcHDVideoEncoderBoolean)) {
                Object ob7 = dataJson.get(RtcHDVideoEncoderBoolean);
                this.enableHWEncoder = Boolean.TRUE.equals(ob7) || Integer.valueOf(1).equals(ob7);
            }
            if (dataJson.has(RtcHDVideoDecoderBoolean)) {
                Object ob8 = dataJson.get(RtcHDVideoDecoderBoolean);
                this.enableHWDecoder = Boolean.TRUE.equals(ob8) || Integer.valueOf(1).equals(ob8);
            }
            if ((serverArray = dataJson.optJSONArray(RtcKVIceServersArray)) != null) {
                this.iceServers.clear();
                for (int i = 0; i < serverArray.length(); ++i) {
                    JSONObject obj = serverArray.getJSONObject(i);
                    this.iceServers.add(new PeerConnection.IceServer(obj.optString(RtcConstStringURL), obj.optString(RtcConstStringUserName), obj.optString(RtcConstStringCredential)));
                }
            }
            sLogListener.onLog(loglevel, this.name + "::: finish setConfigure");
        }
        catch (JSONException e2) {
            sLogListener.onLog(loglevel, this.name + "::: setConfigure failed");
            e2.printStackTrace();
        }
    }

    public void createOffer() {
        this.createOffer(null);
    }

    public void capturePicture(String filepath) {
    }

    public void startRecord(String dir) {
    }

    public String stopRecord() {
        return null;
    }

    public void createOffer(Parameters parameters) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ createOffer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip createOffer because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.createConnectionInternal(true);
                RtcConnection.this.peerConnection.createOffer(RtcConnection.this.localSDPObserver, RtcConnection.this.sdpMediaConstraints);
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- createOffer");
            }
        });
    }

    private void checkdisableResize(final boolean enable) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.setdisableResize(enable);
                }
            }
        });
    }

    public void changeVideoResolution(int width, int height) {
        if (!this.videoCallEnabled || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.videoCallEnabled + ". Error : "));
            return;
        }
        this.videoCapturer.onOutputFormatRequest(width, height, 15);
        this.videoCapturer.changeCaptureFormat(width, height, 15);
    }

    private boolean isNeedChangeVideoResolution(int width, int height) {
        if (!this.videoCallEnabled || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.videoCallEnabled + ". Error : "));
            return false;
        }
        CameraEnumerationAndroid.CaptureFormat currcapfam = this.videoCapturer.getCaptureFormat();
        return width > currcapfam.width || height > currcapfam.height;
    }

    public void SetVideoResolution(final int width, final int height, final boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetVideoResolution " + width + "*height enable:" + enable);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip SetVideoResolution because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.SetVideoResolution(width, height, enable);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetVideoResolution");
            }
        });
    }

    public void SetMaxSendBandwidth(final int maxkbps) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetMaxSendBandwidth::" + maxkbps);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip SetMaxSendBandwidth because of conn is already hangup!");
                    return;
                }
                if (RtcConnection.this.peerConnection != null) {
                    RtcConnection.this.peerConnection.SetMaxSendBandwidth(maxkbps * 1000);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetMaxSendBandwidth");
            }
        });
    }

    public void setMaxVideoFrameRate(final int fps) {
        configfps = fps;
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ SetMaxSendBandwidth fps:" + fps);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setMaxVideoFrameRate because of conn is already hangup!");
                    return;
                }
                if (fps > 0) {
                    PeerConnectionFactory.setconfigframerate(fps);
                } else {
                    PeerConnectionFactory.setconfigframerate(20);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- SetMaxSendBandwidth");
            }
        });
    }

    public void answer() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ answer");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ answer start -0-");
                if (!RtcConnection.this.isPranswerState && !RtcConnection.this.disablePranswer) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: accpet: NOT pranswer state");
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- answer");
                    return;
                }
                RtcConnection.this.isPranswerState = false;
                RtcConnection.this.checkMediaTracksInternal();
                RtcConnection.this.peerConnection.createAnswer(RtcConnection.this.localSDPObserver, RtcConnection.this.sdpMediaConstraints);
                if (RtcConnection.this.iceConnectionState != PeerConnection.IceConnectionState.CONNECTED || RtcConnection.this.connectType == "direct") {
                    // empty if block
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- answer");
            }
        });
    }

    private void createConnectionInternal(boolean initiator) {
        this.isInitiator = initiator;
        sLogListener.onLog(loglevel, this.name + "::: isInitiator => " + this.isInitiator);
        if (this.peerConnectionParameters == null) {
            this.peerConnectionParameters = this.getDefaultParameters();
            if (this.autoAddVideo) {
                this.peerConnectionParameters.captureVideo = this.autoAddVideo;
                this.peerConnectionParameters.receiveVideo = this.autoAddVideo;
            } else {
                this.peerConnectionParameters.captureVideo = this.videoCallEnabled;
                this.peerConnectionParameters.receiveVideo = this.videoreceiveEnabled;
            }
            this.peerConnectionParameters.captureAudio = this.audioCallEnabled;
            this.peerConnectionParameters.receiveAudio = this.audioreceiveEnabled;
            this.peerConnectionParameters.videoCallEnabled = this.videoCallEnabled;
            if (this.videoCodec == null) {
                this.videoCodec = "VP8";
                sLogListener.onLog(loglevel, this.name + "::: use default video codec " + this.videoCodec);
            }
            this.peerConnectionParameters.videoCodec = this.videoCodec;
            if (this.videoWidth == 0 || this.videoHeigth == 0) {
                this.videoWidth = 640;
                this.videoHeigth = 480;
                sLogListener.onLog(loglevel, this.name + "::: use default video size " + this.videoWidth + "x" + this.videoHeigth);
            }
            this.peerConnectionParameters.videoWidth = this.videoWidth;
            this.peerConnectionParameters.videoHeight = this.videoHeigth;
            if (this.videoMaxrate == 0) {
                this.videoMaxrate = RtcConnection.getKbpsByVideoSize(this.videoWidth, this.videoHeigth);
                sLogListener.onLog(loglevel, this.name + "::: use default maxVideoKbps " + this.videoMaxrate);
            }
            if (this.relayvideoMaxrate == 0) {
                this.relayvideoMaxrate = RtcConnection.getKbpsByVideoSize(this.videoWidth, this.videoHeigth);
            }
            this.peerConnectionParameters.videoFps = this.videoFramerate;
            if (this.audioCodec == null) {
                this.audioCodec = "OPUS";
                sLogListener.onLog(loglevel, this.name + "::: use default audio codec " + this.audioCodec);
            }
            this.peerConnectionParameters.audioCodec = this.audioCodec;
        }
        this.renderVideo = this.videoCallEnabled && this.peerConnectionParameters.renderLocal;
        this.renderVideo = true;
        this.createMediaConstraintsInternal();
        this.createPeerConnectionInternal();
    }

    private static SessionDescription content2Sdp(RtcContent sc) {
        if (sc.type.equalsIgnoreCase(RtcContent.TYPE_OFFER) || sc.type.equalsIgnoreCase(RtcContent.TYPE_ANSWER) || sc.type.equalsIgnoreCase(RtcContent.TYPE_PRANSWER)) {
            SessionDescription sdp = new SessionDescription(SessionDescription.Type.valueOf(sc.type.toUpperCase()), sc.sdp);
            return sdp;
        }
        return null;
    }

    private IceCandidate content2Candidatee(RtcContent sc) {
        if (sc.type.equalsIgnoreCase("candidate")) {
            IceCandidate candidate = new IceCandidate("audio", sc.mlineindex, sc.candidate);
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingSdp(SessionDescription sdp) {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            sLogListener.onLog(loglevel, this.name + "::: add pending sdp");
            this.pendingSdp.addLast(sdp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionDescription removePendingSdp() {
        LinkedList<SessionDescription> linkedList = this.pendingSdp;
        synchronized (linkedList) {
            if (this.pendingSdp.isEmpty()) {
                return null;
            }
            return this.pendingSdp.removeFirst();
        }
    }

    private void processPendingSdpInternal() {
        SessionDescription sdp;
        while ((sdp = this.removePendingSdp()) != null) {
            if (sdp.type == SessionDescription.Type.OFFER) {
                if (this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: got offer but isInitiator, drop it");
                    continue;
                }
                if (this.peerConnection == null) {
                    this.createConnectionInternal(false);
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.STABLE) {
                    if (this.peerConnection.getRemoteDescription() == null) {
                        this.isPranswerState = true;
                        this.setRemoteSdpInternal(sdp);
                        sLogListener.onLog(loglevel, this.name + "::: create PRANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
                        this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
                        continue;
                    }
                    this.isPranswerState = false;
                    this.setRemoteSdpInternal(sdp);
                    sLogListener.onLog(loglevel, this.name + "::: create ANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
                    this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: got offer at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            if (sdp.type == SessionDescription.Type.PRANSWER || sdp.type == SessionDescription.Type.ANSWER) {
                if (!this.isInitiator) {
                    sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sdp.type) + " but NOT isInitiator, drop it " + this.isInitiator);
                    continue;
                }
                if (this.peerConnection == null) {
                    sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sdp.type) + " but NOT pc null, drop it");
                    continue;
                }
                if (this.iceConnectionState != PeerConnection.IceConnectionState.CONNECTED || this.connectType == "direct") {
                    // empty if block
                }
                if (this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_LOCAL_OFFER || this.peerConnection.signalingState() == PeerConnection.SignalingState.HAVE_REMOTE_PRANSWER) {
                    this.setRemoteSdpInternal(sdp);
                    continue;
                }
                sLogListener.onLog(loglevel, this.name + "::: got " + (Object)((Object)sdp.type) + " at wrong state " + (Object)((Object)this.peerConnection.signalingState()));
                continue;
            }
            sLogListener.onLog(loglevel, this.name + "::: unknown sdp type " + (Object)((Object)sdp.type));
        }
    }

    public String setRemoteJson(String json) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: remote json: " + json);
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteJson");
        RtcContent sc = RtcContent.fromJson(json);
        SessionDescription sdp = RtcConnection.content2Sdp(sc);
        if (sdp != null) {
            this.addPendingSdp(sdp);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "setRemoteJson start -0- name: " + RtcConnection.this.name);
                    if (RtcConnection.this.isHangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip setRemoteJson because of conn is already hangup!");
                        return;
                    }
                    RtcConnection.this.processPendingSdpInternal();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote sdp");
                }
            });
            return sc.type;
        }
        final IceCandidate remoteCandidate = this.content2Candidatee(sc);
        if (remoteCandidate != null) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "setRemoteJson remote candidate start -0- name: " + RtcConnection.this.name);
                    if (RtcConnection.this.peerConnection != null) {
                        RtcConnection.this.peerConnection.addIceCandidate(remoteCandidate);
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote candidate");
                        return;
                    }
                    List list = RtcConnection.this.pendingCandidates;
                    synchronized (list) {
                        RtcConnection.this.pendingCandidates.add(remoteCandidate);
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteJson remote candidate");
                }
            });
            return sc.type;
        }
        throw new Exception("unknown type " + sc.type);
    }

    public String setRemoteCandidate(String json) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteCandidate");
        RtcContent sc = RtcContent.fromJson(json);
        final IceCandidate remoteCandidate = this.content2Candidatee(sc);
        if (remoteCandidate != null) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add remoteCandidate:: " + remoteCandidate.toString());
                        RtcConnection.this.peerConnection.addIceCandidate(remoteCandidate);
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteCandidate");
                        return;
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: add pending candidate");
                    List list = RtcConnection.this.pendingCandidates;
                    synchronized (list) {
                        RtcConnection.this.pendingCandidates.add(remoteCandidate);
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteCandidate");
                }
            });
            return sc.type;
        }
        throw new Exception("unknown type " + sc.type);
    }

    public String setRemoteSdp(String json) throws Exception {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setRemoteSdp");
        sLogListener.onLog(loglevel, this.name + "::: setRemoteSdp: " + json);
        RtcContent sc = RtcContent.fromJson(json);
        SessionDescription sdp = RtcConnection.content2Sdp(sc);
        if (sdp != null) {
            this.addPendingSdp(sdp);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RtcConnection.this.processPendingSdpInternal();
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setRemoteSdp");
                }
            });
            return sc.type;
        }
        throw new Exception("unknown type " + sc.type);
    }

    public String inverseSdpJson(String json) throws Exception {
        RtcContent sc = RtcContent.fromJson(json);
        if (sc.type.equalsIgnoreCase(RtcContent.TYPE_OFFER)) {
            SessionDescription sdp = new SessionDescription(SessionDescription.Type.valueOf(RtcContent.TYPE_ANSWER.toUpperCase()), sc.sdp);
            return RtcContent.SDP2Json(sdp, this.getLocalSeq(), "connectionId");
        }
        if (sc.type.equalsIgnoreCase(RtcContent.TYPE_ANSWER)) {
            SessionDescription sdp = new SessionDescription(SessionDescription.Type.valueOf(RtcContent.TYPE_OFFER.toUpperCase()), sc.sdp);
            return RtcContent.SDP2Json(sdp, this.getLocalSeq(), "connectionId");
        }
        return json;
    }

    private void printRemoteStream(String prefix) {
        if (this.remoteStream == null) {
            return;
        }
        if (this.remoteStream.videoTracks != null) {
            sLogListener.onLog(loglevel, this.name + "::: " + prefix + " remote stream video tracks = " + this.remoteStream.videoTracks.size());
            if (this.remoteStream.videoTracks.size() > 0) {
                sLogListener.onLog(loglevel, this.name + "::: " + prefix + " remote stream video track[0] state = " + (Object)((Object)this.remoteStream.videoTracks.get(0).state()));
            }
        } else {
            sLogListener.onLog(loglevel, this.name + "::: " + prefix + " remote stream video tracks is null");
        }
    }

    private void setRemoteSdpInternal(SessionDescription sdp) {
        if (this.peerConnection == null) {
            return;
        }
        String sdpDescription = this.filterRemoteSDP(sdp.description);
        SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
        sLogListener.onLog(loglevel, this.name + "::: Set remote SDP => " + (Object)((Object)sdpRemote.type));
        try {
            this.peerConnection.setRemoteDescription(this.remoteSDPObserver, sdpRemote);
            if (this.remoteStream != null) {
                this.printRemoteStream("p1");
                if (this.remoteVideoTrack != null && this.remoteVideoTrack.state() == MediaStreamTrack.State.ENDED) {
                    sLogListener.onLog(loglevel, this.name + "::: remote remote video track");
                    this.printRemoteStream("p2");
                }
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            sLogListener.onLog(loglevel, this.name + "::: Set remote SDP exception " + x.getMessage());
        }
    }

    private String filterRemoteSDP(String sdp) {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        for (String line : lines = sdp.split("\n")) {
            while (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)line)) continue;
            if (this.relayaudioMaxrate > 0 && line.contains("a=mid:audio")) {
                builder.append(line + "\r\n");
                builder.append(String.format("b=AS:%d\r\n", this.relayaudioMaxrate));
                line = null;
            } else if (this.relayvideoMaxrate > 0 && line.contains("a=mid:video")) {
                builder.append(line + "\r\n");
                builder.append(String.format("b=AS:%d\r\n", this.relayvideoMaxrate));
                line = null;
            } else if (this.videoStartBitrate > 0 && line.contains("a=rtpmap:")) {
                String[] origs = line.split(" ");
                if (origs.length > 1) {
                    String str1 = origs[1];
                    if (str1.contains("VP8") || str1.contains("VP9") || str1.contains("H264")) {
                        String str0 = origs[0];
                        String pType = str0.substring(9);
                        builder.append(line + "\r\n");
                        builder.append(String.format("a=fmtp:%s x-google-start-bitrate=%d\r\n", pType, this.videoStartBitrate));
                        line = null;
                    }
                    if (this.localEnableDTX && this.remoteEnableDTX && line.contains("CN/")) {
                        sLogListener.onLog(loglevel, this.name + ": ignore remote CN: " + line);
                        line = null;
                    }
                }
            } else if (this.videoStartBitrate > 0 && line.contains(VIDEO_CODEC_PARAM_START_BITRATE)) {
                sLogListener.onLog(loglevel, this.name + ": ignore remote start-bitrate: " + line);
                line = null;
            } else if (this.localEnableDTX && line.contains("usedtx=1")) {
                this.remoteEnableDTX = true;
                sLogListener.onLog(loglevel, this.name + ": found remote usedtx: " + line);
            }
            if (TextUtils.isEmpty((CharSequence)line)) continue;
            builder.append(line + "\r\n");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainCandidatesInteranl() {
        if (this.peerConnection != null) {
            List<IceCandidate> list = this.pendingCandidates;
            synchronized (list) {
                for (IceCandidate candidate : this.pendingCandidates) {
                    this.peerConnection.addIceCandidate(candidate);
                }
                this.pendingCandidates.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLocalSeq() {
        RtcConnection rtcConnection = this;
        synchronized (rtcConnection) {
            ++this.localSeq;
            return this.localSeq;
        }
    }

    private void reportError(final String errorMessage) {
        sLogListener.onLog(loglevel, this.name + "::: rtc reportError: " + errorMessage);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RtcConnection.this.isHangup) {
                    RtcConnection.this.listener.onError(RtcConnection.this, errorMessage);
                }
            }
        });
    }

    private static Exception newException(String errMsg) {
        ALog.i(TAG, errMsg);
        return new Exception(errMsg);
    }

    private static void slog(String msg) {
        ALog.i(TAG, msg);
    }

    private static void slogw(String msg) {
        ALog.i(TAG, msg);
    }

    private static void sloge(String msg) {
        ALog.i(TAG, msg);
    }

    private void log(String msg) {
        ALog.i(TAG, "<D><" + this.name + "> " + msg);
    }

    private void logw(String msg) {
        ALog.i(TAG, "<W><" + this.name + "> " + msg);
    }

    private void loge(String msg) {
        ALog.e(TAG, "<E><" + this.name + "> " + msg);
    }

    public void setenableaec(final boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableaec:" + enable);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenableaec");
                RtcConnection.this.enableaec = enable;
            }
        });
    }

    public void setenableagc(final boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenableagc:" + enable);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenableagc");
                RtcConnection.this.enableagc = enable;
            }
        });
    }

    public void setenablens(final boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setenablens:" + enable);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setenablens");
                RtcConnection.this.enablens = enable;
            }
        });
    }

    private void createMediaConstraintsInternal() {
        this.pcConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback) {
            sLogListener.onLog(loglevel, this.name + "::: loopback: set DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT false ");
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "false"));
        } else {
            this.pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
        }
        this.numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
        if (this.numberOfCameras == 0) {
            sLogListener.onLog(loglevel, this.name + "::: No camera on device. Switch to audio only call.");
            this.videoCallEnabled = false;
        }
        if (this.peerConnectionParameters.captureVideo) {
            int videoFps;
            this.videoConstraints = new MediaConstraints();
            int videoWidth = this.peerConnectionParameters.videoWidth;
            int videoHeight = this.peerConnectionParameters.videoHeight;
            if ((videoWidth == 0 || videoHeight == 0) && this.peerConnectionParameters.videoCodecHwAcceleration && MediaCodecVideoEncoder.isVp8HwSupported()) {
                videoWidth = 1920;
                videoHeight = 1080;
            }
            if (videoWidth > 0 && videoHeight > 0) {
                videoWidth = Math.min(videoWidth, 1920);
                videoHeight = Math.min(videoHeight, 1920);
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_WIDTH_CONSTRAINT, Integer.toString(videoWidth)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_WIDTH_CONSTRAINT, Integer.toString(1920)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_HEIGHT_CONSTRAINT, Integer.toString(videoHeight)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_HEIGHT_CONSTRAINT, Integer.toString(1920)));
            }
            if ((videoFps = this.peerConnectionParameters.videoFps) > 0) {
                videoFps = Math.min(videoFps, 30);
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MIN_VIDEO_FPS_CONSTRAINT, Integer.toString(videoFps)));
                this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair(MAX_VIDEO_FPS_CONSTRAINT, Integer.toString(videoFps)));
            }
        }
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        if (!this.enableaec) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AEC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
        }
        if (!this.enableagc) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio AGC");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
        }
        if (!this.enablens) {
            sLogListener.onLog(loglevel, this.name + "::: Disabling audio NS");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveAudio) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "false"));
            sLogListener.onLog(loglevel, this.name + "::: set OfferToReceiveAudio false");
        }
        if (this.peerConnectionParameters.loopback || this.peerConnectionParameters.receiveVideo || this.peerConnectionParameters.captureVideo) {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
            sLogListener.onLog(loglevel, this.name + "::: OfferToReceiveVideo true");
        } else {
            this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "false"));
        }
    }

    private void initAudio() {
        sLogListener.onLog(loglevel, this.name + "::: initAudio");
        if (this.audioManager == null) {
            this.audioManager = AppRTCAudioManager.create(sContext, new Runnable(){

                @Override
                public void run() {
                }
            });
            sLogListener.onLog(loglevel, this.name + "::: Initializing the audio manager...");
            this.audioManager.init();
        }
    }

    private void createPeerConnectionInternal() {
        if (factory == null) {
            sLogListener.onLog(loglevel, this.name + "::: Peerconnection factory is not created");
            return;
        }
        sLogListener.onLog(loglevel, this.name + "::: Create peer connection");
        sLogListener.onLog(loglevel, this.name + "::: PCConstraints: " + this.pcConstraints.toString());
        if (this.videoConstraints != null) {
            sLogListener.onLog(loglevel, this.name + "::: VideoConstraints: " + this.videoConstraints.toString());
        }
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        if (this.enableRelay) {
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        }
        this.peerConnection = factory.createPeerConnection(rtcConfig, this.pcConstraints, (PeerConnection.Observer)this.pcObserver);
        if (this.peerConnection != null) {
            if (disableResize) {
                this.peerConnection.setdisableResize(disableResize);
            }
            if (configfps != 0) {
                PeerConnectionFactory.setconfigframerate(configfps);
            }
            if (configminkbps <= 0) {
                configminkbps = DEFAULT_CONFIG_MINKBPS;
                this.peerConnection.setconfigminbitrate(configminkbps);
            } else {
                this.peerConnection.setconfigminbitrate(configminkbps);
            }
        }
        this.mediaStream = factory.createLocalMediaStream("ARDAMS");
        if (this.isInitiator) {
            this.checkMediaTracksInternal();
        }
        this.peerConnection.addStream(this.mediaStream);
        this.startAecDump();
    }

    private void checkRenegoInternal() {
    }

    private void checkRenegoInternal0() {
        if (this.peerConnection == null) {
            return;
        }
        if (this.peerConnection.signalingState() != PeerConnection.SignalingState.STABLE && this.peerConnection.signalingState() != PeerConnection.SignalingState.HAVE_LOCAL_PRANSWER && this.peerConnection.signalingState() != PeerConnection.SignalingState.HAVE_REMOTE_PRANSWER) {
            sLogListener.onLog(loglevel, this.name + "::: skip re-nego because of state " + (Object)((Object)this.peerConnection.signalingState()));
            return;
        }
        if (this.peerConnection.getLocalDescription() == null) {
            sLogListener.onLog(loglevel, this.name + "::: skip re-nego because of no local sdp ");
            return;
        }
        if (this.isInitiator) {
            sLogListener.onLog(loglevel, this.name + "::: re-create OFFER : sdpMediaConstraints=" + this.sdpMediaConstraints);
            this.peerConnection.createOffer(this.localSDPObserver, this.sdpMediaConstraints);
        } else {
            sLogListener.onLog(loglevel, this.name + "::: re-create ANSWER : sdpMediaConstraints=" + this.sdpMediaConstraints);
            this.peerConnection.createAnswer(this.localSDPObserver, this.sdpMediaConstraints);
        }
    }

    private void checkVideoCapturerConfigRotation() {
        if (this.videoCapturer != null && this.isconfigRotation) {
            this.videoCapturer.setRotation(this.configRotation);
        }
    }

    private void checkVideoCapturerDataProcessor() {
        if (this.processor != null) {
            if (this.videoCapturer != null) {
                this.videoCapturer.setCameraDataProcessor(new VideoCapturerAndroid.VideoCapturerDataProcessor(){

                    @Override
                    public void onProcessData(byte[] data, Camera camera, int width, int height, int rotation) {
                        RtcConnection.this.processor.onProcessData(data, camera, width, height, rotation);
                    }

                    @Override
                    public void setResolution(int width, int height) {
                        RtcConnection.this.processor.setResolution(width, height);
                    }
                });
            }
        } else if (this.videoCapturer != null) {
            this.videoCapturer.setCameraDataProcessor(null);
        }
    }

    private void checkGlTextureProcessor() {
        if (this.glprocessor != null) {
            if (this.videoCapturer != null) {
                this.videoCapturer.setGlTextureProcessor(new VideoCapturerAndroid.GlTextureProcessor(){

                    @Override
                    public void onDrawFrame(int texId, int texWidth, int texHeight, float[] transformMatrix, int rotation) {
                        RtcConnection.this.glprocessor.onDrawFrame(texId, texWidth, texHeight, transformMatrix, rotation);
                    }
                });
            }
        } else if (this.videoCapturer != null) {
            this.videoCapturer.setGlTextureProcessor(null);
        }
    }

    public void inputExternalVideoData(byte[] data, int width, int height, int rotation) {
        if (this.videoCapturer != null) {
            this.videoCapturer.inputExternalVideoData(data, width, height, rotation);
        }
    }

    public void inputExternalVideoData(Bitmap bmp, int rotation) {
        sLogListener.onLog(loglevel, this.name + ", " + bmp + ", videoCapturer " + this.videoCapturer);
        if (this.videoCapturer != null) {
            this.videoCapturer.inputExternalVideoData(bmp, rotation);
        }
    }

    private void checkMediaTracksInternal() {
        if (this.peerConnection == null) {
            return;
        }
        if (this.mediaStream == null) {
            return;
        }
        if (this.peerConnectionParameters.captureVideo && this.localVideoTrack == null) {
            boolean isbackfacing = false;
            String cameraDeviceName = CameraEnumerationAndroid.getDeviceName(0);
            isbackfacing = true;
            String frontCameraDeviceName = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
            if (this.numberOfCameras > 1 && frontCameraDeviceName != null) {
                cameraDeviceName = frontCameraDeviceName;
                isbackfacing = false;
            }
            if (cameraid >= 0 && cameraid < this.numberOfCameras) {
                cameraDeviceName = CameraEnumerationAndroid.getDeviceName(cameraid);
                if (cameraid == 0) {
                    isbackfacing = true;
                }
            }
            enableLocalViewMirror = !isbackfacing;
            this.updateVideoViewmirror();
            sLogListener.onLog(loglevel, this.name + "::: Opening camera: " + cameraDeviceName + " Mirror::" + this.getVideoViewMirror());
            boolean bl = this.enableOpenCamera = this.peerConnectionParameters.videoCallEnabled && !this.isStopCapture;
            if (this.glprocessor != null) {
                if (this.localGui != null) {
                    this.sharedeglContext = this.localGui.getEglBaseContext();
                }
                this.videoCapturer = VideoCapturerAndroid.create(cameraDeviceName, null, this.sharedeglContext);
            } else {
                this.videoCapturer = VideoCapturerAndroid.create(cameraDeviceName, null);
            }
            if (this.videoCapturer == null) {
                this.reportError("Failed to open camera");
            } else {
                this.checkVideoCapturerConfigRotation();
                this.videoCapturer.setEnableExternalVideoData(this.enableExternalVideoData);
                this.videoCapturer.setRtcListener(rtcListener);
                this.checkVideoCapturerDataProcessor();
                this.checkGlTextureProcessor();
                if (this.peerConnectionParameters.videoCallEnabled) {
                    if (this.isStopCapture) {
                        this.videoCapturer.setEnableCamera(false);
                        this.videoCapturer.setEnableCameragetsuppoted(false);
                    } else {
                        this.videoCapturer.setEnableCamera(true);
                        this.videoCapturer.setEnableCameragetsuppoted(false);
                    }
                } else if (this.autoAddVideo) {
                    this.videoCapturer.setEnableCamera(false);
                    this.videoCapturer.setEnableCameragetsuppoted(false);
                }
                this.videoSource = factory.createVideoSource(this.videoCapturer, this.videoConstraints);
                this.localVideoTrack = factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
                this.localVideoTrack.setEnabled(this.renderVideo);
                this.mediaStream.addTrack(this.localVideoTrack);
            }
            this.checkAddRenddererInternal();
            this.checkRenegoInternal();
        } else if (!this.peerConnectionParameters.captureVideo && this.localVideoTrack != null) {
            sLogListener.onLog(loglevel, this.name + "::: remove video track");
            if (this.localVideoTrack != null) {
                this.mediaStream.removeTrack(this.localVideoTrack);
                this.localVideoTrack.setEnabled(false);
                this.localVideoTrack.dispose();
                this.localVideoTrack = null;
                if (this.localRendererAdded) {
                    this.localRendererAdded = false;
                }
            }
            if (this.videoSource != null) {
                this.videoSource.stop();
                this.videoSource.dispose();
                this.videoSource = null;
            }
            this.checkRenegoInternal();
        }
        if (this.isRemoteViewReady() && this.remoteRender == null) {
            sLogListener.onLog(loglevel, this.name + "::: checking remote renderer");
            this.checkAddRenddererInternal();
        }
        if (this.peerConnectionParameters.captureAudio && this.localAudioTrack == null) {
            sLogListener.onLog(loglevel, this.name + "::: create capture audio");
            this.audioSource = factory.createAudioSource(this.audioConstraints);
            this.localAudioTrack = factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
            if (this.localAudioTrack != null) {
                if (!this.enableaudio) {
                    this.localAudioTrack.setEnabled(this.enableaudio);
                }
                this.mediaStream.addTrack(this.localAudioTrack);
            }
            this.checkRenegoInternal();
        } else if (!this.peerConnectionParameters.captureAudio && this.localAudioTrack != null) {
            sLogListener.onLog(loglevel, this.name + "::: remove audio track");
            if (this.localAudioTrack != null) {
                this.mediaStream.removeTrack(this.localAudioTrack);
                this.localAudioTrack = null;
            }
            this.checkRenegoInternal();
        } else {
            sLogListener.onLog(loglevel, this.name + "::: do nothing for audio");
        }
    }

    public void setMute(final boolean enable) {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ setMute ::" + enable);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.enableaudio = !enable;
                if (RtcConnection.this.localAudioTrack != null) {
                    RtcConnection.this.localAudioTrack.setEnabled(RtcConnection.this.enableaudio);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- setMute");
            }
        });
    }

    public void addlocalstream() {
        String cameraDeviceName = CameraEnumerationAndroid.getDeviceName(0);
        String frontCameraDeviceName = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
        if (this.numberOfCameras > 1 && frontCameraDeviceName != null) {
            cameraDeviceName = frontCameraDeviceName;
        }
        if (this.peerConnectionParameters.cameraIndex >= 0 && this.peerConnectionParameters.cameraIndex < this.numberOfCameras) {
            cameraDeviceName = CameraEnumerationAndroid.getDeviceName(this.peerConnectionParameters.cameraIndex);
        }
        sLogListener.onLog(loglevel, this.name + "::: Opening camera: " + cameraDeviceName);
    }

    public void TakePicture(String filepath) {
        this.peerConnection.TakePicture(filepath);
    }

    public void close() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ close");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnection.this.closeInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- close");
            }
        });
    }

    public void hangup() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ hangup");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: peer isHangup : " + RtcConnection.this.isHangup);
                    return;
                }
                RtcConnection.this.statsTimer.cancel();
                RtcConnection.this.isHangup = true;
                RtcConnection.this.isViewCaptureTimer = false;
                RtcConnection.this.view4Capture = null;
                RtcConnection.this.makeblack(true);
                RtcConnection.this.isConnected = false;
                if (RtcConnection.this.peerConnection != null) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: RTC hangup close peerConnection");
                    RtcConnection.this.peerConnection.dispose();
                    RtcConnection.this.peerConnection = null;
                }
                if (RtcConnection.this.videoSource != null) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: RTC hangup close videosource");
                    RtcConnection.this.videoSource.dispose();
                    RtcConnection.this.videoSource = null;
                    if (RtcConnection.this.localGui != null) {
                        RtcConnection.this.localGui.remove(RtcConnection.this.localRender);
                        RtcConnection.this.localRender = null;
                        RtcConnection.this.localGui = null;
                    }
                    RtcConnection.this.localViewRender = null;
                }
                if (RtcConnection.this.remoteGui != null) {
                    RtcConnection.this.remoteGui.remove(RtcConnection.this.remoteRender);
                    RtcConnection.this.remoteRender = null;
                    RtcConnection.this.remoteGui = null;
                    RtcConnection.this.remoteViewRender = null;
                }
                if (RtcConnection.this.audioSource != null) {
                    RtcConnection.this.audioSource.dispose();
                    RtcConnection.this.audioSource = null;
                }
                RtcConnection.this.options = null;
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onClosed");
                if (!RtcConnection.this.isHangup) {
                    RtcConnection.this.listener.onClosed(RtcConnection.this);
                }
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- hangup");
            }
        });
    }

    private void closeInternal() {
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection.");
        this.statsTimer.cancel();
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        this.log("Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection factory.");
        this.options = null;
        sLogListener.onLog(loglevel, this.name + "::: Closing peer connection done.");
        sLogListener.onLog(loglevel, this.name + ":::  onClosed");
        if (!this.isHangup) {
            this.listener.onClosed(this);
        }
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            sLogListener.onLog(loglevel, "::: No rtpmap for " + codec + " codec");
            return sdpDescription;
        }
        sLogListener.onLog(loglevel, "::: Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]);
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            sLogListener.onLog(loglevel, "::: Found " + codec + " " + lines[i]);
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            sLogListener.onLog(loglevel, "::: Update remote SDP line: " + lines[i]);
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            sLogListener.onLog(loglevel, "::: Add remote SDP line: " + bitrateSet);
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = -1;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        String mediaDescription = "m=video ";
        if (isAudio) {
            mediaDescription = "m=audio ";
        }
        for (int i = 0; i < lines.length && (mLineIndex == -1 || codecRtpMap == null); ++i) {
            if (lines[i].startsWith(mediaDescription)) {
                mLineIndex = i;
                continue;
            }
            Matcher codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
        }
        if (mLineIndex == -1) {
            sLogListener.onLog(loglevel, "::: No " + mediaDescription + " line, so can't prefer " + codec);
            return sdpDescription;
        }
        if (codecRtpMap == null) {
            sLogListener.onLog(loglevel, "::: No rtpmap for " + codec);
            return sdpDescription;
        }
        sLogListener.onLog(loglevel, "::: Found " + codec + " rtpmap " + codecRtpMap + ", prefer at " + lines[mLineIndex]);
        String[] origMLineParts = lines[mLineIndex].split(" ");
        if (origMLineParts.length > 3) {
            StringBuilder newMLine = new StringBuilder();
            int origPartIndex = 0;
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(codecRtpMap);
            while (origPartIndex < origMLineParts.length) {
                if (!origMLineParts[origPartIndex].equals(codecRtpMap)) {
                    newMLine.append(" ").append(origMLineParts[origPartIndex]);
                }
                ++origPartIndex;
            }
            lines[mLineIndex] = newMLine.toString();
            sLogListener.onLog(loglevel, "::: Change media description: " + lines[mLineIndex]);
        } else {
            sLogListener.onLog(loglevel, "::: Wrong SDP media description format: " + lines[mLineIndex]);
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (String line : lines) {
            newSdpDescription.append(line).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private void switchCameraInternal() {
        if (this.autoAddVideo) {
            if (!this.enableOpenCamera || this.numberOfCameras < 2 || this.videoCapturer == null) {
                sLogListener.onLog(loglevel, this.name + "::: Failed to switch camera. Video: " + this.enableOpenCamera + ". Number of cameras: " + this.numberOfCameras);
                return;
            }
        } else if (!this.videoCallEnabled || this.numberOfCameras < 2 || this.videoCapturer == null) {
            sLogListener.onLog(loglevel, this.name + "::: Failed to switch camera. Video: " + this.videoCallEnabled + ". Number of cameras: " + this.numberOfCameras);
            return;
        }
        sLogListener.onLog(loglevel, this.name + "::: Switch camera");
        this.videoCapturer.switchCamera(new VideoCapturerAndroid.CameraSwitchHandler(){

            @Override
            public void onCameraSwitchDone(boolean isFrontCamera) {
                if (isFrontCamera) {
                    enableLocalViewMirror = true;
                    RtcConnection.setCameraFacing(1);
                } else {
                    enableLocalViewMirror = false;
                    RtcConnection.setCameraFacing(0);
                }
                RtcConnection.this.updateVideoViewmirror();
            }

            @Override
            public void onCameraSwitchError(String errorDescription) {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: switchCamera Error::" + errorDescription);
            }
        });
    }

    public void switchCamera() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ switchCamera");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip switchCamera because of conn is already hangup!");
                    return;
                }
                RtcConnection.this.switchCameraInternal();
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- switchCamera");
            }
        });
    }

    private void checkoutenableCamera() {
        if (this.videoCapturer == null || this.enableOpenCamera || !this.autoAddVideo) {
            sLogListener.onLog(loglevel, this.name + "::: Failed to enableCamera. Video:" + this.enableOpenCamera + " autoAddVideo:" + this.autoAddVideo);
            return;
        }
        this.videoCapturer.enableCameraThread();
        this.enableOpenCamera = true;
    }

    public void startCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ startCapture");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                sLogListener.onLog(loglevel, "startCapture start -0- ");
                if (RtcConnection.this.videoCapturer == null || RtcConnection.this.enableOpenCamera) {
                    sLogListener.onLog(loglevel, "Failed to startCapture. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- startCapture");
                    return;
                }
                RtcConnection.this.checkoutenableCamera();
                RtcConnection.this.videoSource.restart();
                RtcConnection.this.enableOpenCamera = true;
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- startCapture");
            }
        });
    }

    public void stopCapture() {
        sLogListener.onLog(loglevel, this.name + "::: [rapi]++ stopCapture");
        this.isStopCapture = true;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RtcConnection.this.enableOpenCamera || RtcConnection.this.videoCapturer == null) {
                    sLogListener.onLog(loglevel, "Failed to stopCapture. OpenCamera:" + RtcConnection.this.enableOpenCamera);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- stopCapture");
                    return;
                }
                RtcConnection.this.videoSource.stop();
                RtcConnection.this.enableOpenCamera = false;
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- stopCapture");
            }
        });
    }

    private String preferCandidates(String sdpDescription) {
        StringBuilder newSdpDescription = new StringBuilder();
        String[] lines = sdpDescription.split("\r\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            newSdpDescription.append(line).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    @SuppressLint(value={"NewApi"})
    private void startAecDump() {
        try {
            if (this.aecDumpFilename == null) {
                return;
            }
            String aecFilePath = this.aecDumpFilename;
            sLogListener.onLog(loglevel, this.name + "::: start aec dump " + aecFilePath);
            this.aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(aecFilePath), (int)0x3C000000);
            sLogListener.onLog(loglevel, this.name + "::: aec dump fd " + this.aecDumpFileDescriptor.getFd());
            factory.startAecDump(this.aecDumpFileDescriptor.getFd(), -1);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void stopAecDump() {
        if (this.aecDumpFileDescriptor != null) {
            sLogListener.onLog(loglevel, this.name + "::: stop aec dump " + this.aecDumpFileDescriptor.toString());
            factory.stopAecDump();
            try {
                this.aecDumpFileDescriptor.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            this.aecDumpFileDescriptor = null;
        }
    }

    public void setCaptureFromView(final View view) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (RtcConnection.this.isHangup) {
                    return;
                }
                RtcConnection.this.view4Capture = view;
                RtcConnection.this.enableOpenCamera = false;
                if (RtcConnection.this.view4Capture != null) {
                    if (RtcConnection.this.isViewCaptureTimer) {
                        return;
                    }
                    RtcConnection.this.isViewCaptureTimer = true;
                    RtcConnection.this.fireNextImageInput();
                } else if (RtcConnection.this.isViewCaptureTimer) {
                    RtcConnection.this.isViewCaptureTimer = false;
                }
            }
        });
    }

    private void fireNextImageInput() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RtcConnection.this.isViewCaptureTimer || RtcConnection.this.view4Capture == null) {
                    return;
                }
                RtcConnection.this.captureViewPicture();
                RtcConnection.this.fireNextImageInput();
            }
        });
    }

    private void captureViewPicture() {
        sLogListener.onLog(loglevel, "capture share view display content");
        if (!this.isViewCaptureTimer || this.view4Capture == null) {
            return;
        }
        sLogListener.onLog(loglevel, "capture bitmap -0- " + System.currentTimeMillis());
        this.view4Capture.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.view4Capture.getDrawingCache());
        this.view4Capture.setDrawingCacheEnabled(false);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float s = 1.0f / BitmapUtil.getZoomScale(width, height, 800);
        matrix.postScale(s, s);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        sLogListener.onLog(loglevel, "capture bitmap -1- " + System.currentTimeMillis());
        this.inputExternalVideoData(bitmap, 0);
    }

    public void takeCameraPicture(RTCCallback callback) {
        if (!this.enableExternalVideoData) {
            this.videoCapturer.takeCameraPicture(callback);
        }
    }

    public static String getVersion() {
        return String.format("%s-%s", RTC_VERSION, PeerConnection.getVersion());
    }

    public static int setDocDirectory(String dirPath) {
        return PeerConnection.setDocDiretory(dirPath);
    }

    public static boolean startRecordPlayout() {
        if (factory == null) {
            return false;
        }
        return factory.startRecordPlayout();
    }

    public static String stopRecordPlayout() {
        if (factory == null) {
            return null;
        }
        return factory.stopRecordPlayout();
    }

    public static Map<String, Map<Integer, Integer>> getAudioVolumeOfRTCMap(Map<String, RtcConnectionExt> rtcMap) {
        HashMap<String, Map<Integer, Integer>> outMap = new HashMap<String, Map<Integer, Integer>>();
        for (String key : rtcMap.keySet()) {
            RtcConnectionExt rtc = rtcMap.get(key);
            Map<Integer, Integer> csrcs = rtc.getAudioVolume();
            if (csrcs == null) continue;
            outMap.put(key, csrcs);
        }
        return outMap;
    }

    public Map<Integer, Integer> getAudioVolume() {
        HashMap<Integer, Integer> csrcs = null;
        if (this.peerConnection == null) {
            return null;
        }
        long[][] audioLevel = this.peerConnection.getAudioLevel();
        if (audioLevel != null) {
            csrcs = new HashMap<Integer, Integer>();
            csrcs.put(-1, (int)audioLevel[1][0]);
            csrcs.put(-2, (int)audioLevel[1][1]);
            for (int i = 2; i < audioLevel[1].length; ++i) {
                csrcs.put((int)audioLevel[0][i], (int)audioLevel[1][i]);
                sLogListener.onLog(loglevel, "k:" + (int)audioLevel[0][i] + ",v:" + (int)audioLevel[1][i]);
            }
        }
        return csrcs;
    }

    static {
        medialoglevel = Logging.Severity.LS_WARNING;
        disableResize = false;
        configfps = 0;
        configminkbps = 80;
        DEFAULT_CONFIG_MINKBPS = 80;
        useVideoCodecHw = false;
        iscreateConnectionFactory = false;
        cameraid = -1;
        enableLocalViewMirror = true;
        loglevel = 6;
        mirrorType = MIRROR.AUTO;
        sLogListener = sLogListenerInternal = new LogListener(){

            @Override
            public void onLog(int level, String log) {
                Log.i((String)RtcConnection.TAG, (String)log);
            }
        };
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        @Override
        public void onCreateSuccess(SessionDescription origSdp) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: sdp: onCreateSuccess");
            String sdpDescription = origSdp.description;
            sdpDescription = RtcConnection.preferCodec(sdpDescription, RtcConnection.this.audioCodec, true);
            sdpDescription = RtcConnection.preferCodec(sdpDescription, RtcConnection.this.videoCodec, false);
            final SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            RtcConnection.this.localSdp = sdp;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.isHangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Set local SDP from " + (Object)((Object)sdp.type));
                        RtcConnection.this.peerConnection.setLocalDescription(RtcConnection.this.localSDPObserver, sdp);
                    }
                }
            });
        }

        @Override
        public void onSetSuccess() {
            RtcConnection.this.log("sdp: onSetSuccess");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    if (RtcConnection.this.isInitiator) {
                        if (RtcConnection.this.peerConnection.getRemoteDescription() == null) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                            if (!RtcConnection.this.isHangup) {
                                RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                            }
                        } else {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                            RtcConnection.this.drainCandidatesInteranl();
                        }
                    } else if (RtcConnection.this.peerConnection.getLocalDescription() != null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Local SDP set succesfully");
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                        if (!RtcConnection.this.isHangup) {
                            RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                        }
                        RtcConnection.this.drainCandidatesInteranl();
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Remote SDP set succesfully");
                    }
                }
            });
        }

        @Override
        public void onCreateFailure(String error) {
            RtcConnection.this.reportError("sdp: onCreateFailure: " + error);
        }

        @Override
        public void onSetFailure(String error) {
            RtcConnection.this.reportError("sdp: onSetFailure: " + error);
        }
    }

    private class RemoteSDPObserver
    implements SdpObserver {
        private RemoteSDPObserver() {
        }

        @Override
        public void onCreateSuccess(SessionDescription origSdp) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: create remote sdp success??");
        }

        @Override
        public void onSetSuccess() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: set remote sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "set remote sdp success start -0-");
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    RtcConnection.this.drainCandidatesInteranl();
                    RtcConnection.this.printRemoteStream("after remote sdp: ");
                }
            });
        }

        @Override
        public void onCreateFailure(String error) {
            RtcConnection.this.reportError("create local sdp failure: " + error);
        }

        @Override
        public void onSetFailure(String error) {
            RtcConnection.this.reportError("set local sdp failure: " + error);
        }
    }

    private class LocalSDPObserver
    implements SdpObserver {
        private LocalSDPObserver() {
        }

        @Override
        public void onCreateSuccess(final SessionDescription origSdp) {
            sLogListener.onLog(loglevel, "create local sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "create local sdp success start -0-");
                    if (RtcConnection.this.isHangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip set local because of null conn");
                        return;
                    }
                    String sdpDescription = origSdp.description;
                    sdpDescription = RtcConnection.preferCodec(sdpDescription, RtcConnection.this.audioCodec, true);
                    sdpDescription = RtcConnection.preferCodec(sdpDescription, RtcConnection.this.videoCodec, false);
                    sdpDescription = RtcConnection.this.preferCandidates(sdpDescription);
                    sdpDescription = RtcConnection.this.ssrcChanger.changeSSRC(sdpDescription);
                    SessionDescription.Type sdpType = origSdp.type;
                    if (RtcConnection.this.isPranswerState && !RtcConnection.this.disablePranswer) {
                        sdpDescription = sdpDescription.replaceAll("a=recvonly", "a=inactive");
                        sdpDescription = RtcConnection.this.ssrcChanger.processPranswer(sdpDescription);
                        sdpType = SessionDescription.Type.PRANSWER;
                    }
                    SessionDescription sdp = new SessionDescription(sdpType, sdpDescription);
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: Set local SDP " + (Object)((Object)sdp.type));
                    RtcConnection.this.localSdp = sdp;
                    RtcConnection.this.peerConnection.setLocalDescription(RtcConnection.this.localSDPObserver, sdp);
                }
            });
        }

        @Override
        public void onSetSuccess() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: set local sdp success");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "set local sdp success start -0-");
                    if (RtcConnection.this.isHangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip onSetSuccess because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi] onLocalSdp");
                    if (!RtcConnection.this.isHangup) {
                        RtcConnection.this.listener.onLocalSdp(RtcConnection.this, RtcContent.SDP2Json(RtcConnection.this.localSdp, RtcConnection.this.getLocalSeq(), "connectionId"));
                    }
                    RtcConnection.this.drainCandidatesInteranl();
                    RtcConnection.this.printRemoteStream("after local sdp: ");
                }
            });
        }

        @Override
        public void onCreateFailure(String error) {
            RtcConnection.this.reportError("create local sdp failure: " + error);
        }

        @Override
        public void onSetFailure(String error) {
            RtcConnection.this.reportError("set local sdp failure: " + error);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        @Override
        public void onIceCandidate(final IceCandidate candidate) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onlocalIceCandidate::" + candidate);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    RtcConnection.this.listener.onLocalCandidate(RtcConnection.this, RtcContent.candidate2Json(candidate, RtcConnection.this.getLocalSeq(), "connectionId"));
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]-- onlocalIceCandidate");
                }
            });
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState newState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onSignalingChange: " + (Object)((Object)newState));
        }

        @Override
        public void onIceConnectionChange(final PeerConnection.IceConnectionState newState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + ":::  ++ onIceConnectionChange: " + (Object)((Object)newState) + " (signalingState=" + (Object)((Object)RtcConnection.this.peerConnection.signalingState()) + ")");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "onIceConnectionChange: start -0- " + (Object)((Object)newState));
                    if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                        if (!RtcConnection.this.isConnected) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onConnectionsetup");
                            if (!RtcConnection.this.isHangup) {
                                RtcConnection.this.listener.onConnectionsetup(RtcConnection.this);
                            }
                            RtcConnection.this.isConnected = true;
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ connectType ::" + RtcConnection.this.connectType);
                        } else {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onConnected");
                            if (!RtcConnection.this.isHangup) {
                                RtcConnection.this.listener.onConnected(RtcConnection.this);
                            }
                        }
                        RtcConnection.this.updateVideoViewInternal();
                        RtcConnection.this.iceConnectionState = PeerConnection.IceConnectionState.CONNECTED;
                    } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onDisconnected");
                        if (!RtcConnection.this.isHangup) {
                            RtcConnection.this.listener.onDisconnected(RtcConnection.this);
                        }
                    } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                        RtcConnection.this.reportError("ICE connection failed.");
                    }
                    sLogListener.onLog(loglevel, RtcConnection.this.name + "::: -- onIceConnectionChange: ");
                }
            });
        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: IceGatheringState: " + (Object)((Object)newState));
            if (newState == PeerConnection.IceGatheringState.COMPLETE) {
                sLogListener.onLog(loglevel, RtcConnection.this.name + "::: [rapi]++ onCandidateCompleted");
                if (!RtcConnection.this.isHangup) {
                    RtcConnection.this.listener.onCandidateCompleted(RtcConnection.this);
                }
            }
        }

        @Override
        public void onIceConnectionReceivingChange(boolean receiving) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: IceConnectionReceiving changed to " + receiving);
        }

        @Override
        public void onAddStream(final MediaStream stream) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onAddStream");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    sLogListener.onLog(loglevel, "onAddStream start -0-");
                    if (RtcConnection.this.isHangup) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: skip onAddStream because of conn is already hangup!");
                        return;
                    }
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    if (stream.audioTracks.size() > 1 || stream.videoTracks.size() > 1) {
                        RtcConnection.this.reportError("Weird-looking stream: " + stream);
                        return;
                    }
                    if (stream.videoTracks.size() == 1) {
                        RtcConnection.this.remoteVideoTrack = stream.videoTracks.get(0);
                        RtcConnection.this.remoteVideoTrack.setEnabled(true);
                        RtcConnection.this.checkAddRenddererInternal();
                        if (RtcConnection.this.remoteVideoTrack != null) {
                            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onAddStream: remoteVideoTrack state " + (Object)((Object)RtcConnection.this.remoteVideoTrack.state()));
                        }
                    }
                    RtcConnection.this.remoteStream = stream;
                }
            });
        }

        @Override
        public void onRemoveStream(final MediaStream stream) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onRemoveStream");
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (RtcConnection.this.peerConnection == null) {
                        return;
                    }
                    RtcConnection.this.remoteVideoTrack = null;
                    stream.videoTracks.get(0).dispose();
                    if (stream == RtcConnection.this.remoteStream) {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: remove remote stream");
                        RtcConnection.this.remoteStream = null;
                    } else {
                        sLogListener.onLog(loglevel, RtcConnection.this.name + "::: warning: remove known stream");
                    }
                }
            });
        }

        @Override
        public void onDataChannel(DataChannel dc) {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onDataChannel");
            RtcConnection.this.reportError("AppRTC doesn't use data channels, but got: " + dc.label() + " anyway!");
        }

        @Override
        public void onRenegotiationNeeded() {
            sLogListener.onLog(loglevel, RtcConnection.this.name + "::: onRenegotiationNeeded");
        }
    }

    public static class PeerConnectionParameters {
        public boolean videoCallEnabled;
        public boolean loopback;
        public int videoWidth;
        public int videoHeight;
        public int videoFps;
        public int videoStartBitrate;
        public String videoCodec;
        public boolean videoCodecHwAcceleration;
        public int audioStartBitrate;
        public String audioCodec;
        public boolean noAudioProcessing;
        public boolean cpuOveruseDetection;

        public PeerConnectionParameters(boolean videoCallEnabled, boolean loopback, int videoWidth, int videoHeight, int videoFps, int videoStartBitrate, String videoCodec, boolean videoCodecHwAcceleration, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean cpuOveruseDetection) {
            this.videoCallEnabled = videoCallEnabled;
            this.loopback = loopback;
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            this.videoStartBitrate = videoStartBitrate;
            this.videoCodec = videoCodec;
            this.videoCodecHwAcceleration = videoCodecHwAcceleration;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.cpuOveruseDetection = cpuOveruseDetection;
        }

        public String toString() {
            return "[videoCallEnabled=" + this.videoCallEnabled + ", loopback=" + this.loopback + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", videoFps=" + this.videoFps + ", videoStartBitrate=" + this.videoStartBitrate + ", videoCodec=" + this.videoCodec + ", videoCodecHwAcceleration=" + this.videoCodecHwAcceleration + ", audioStartBitrate=" + this.audioStartBitrate + ", audioCodec=" + this.audioCodec + ", noAudioProcessing=" + this.noAudioProcessing + ", cpuOveruseDetection=" + this.cpuOveruseDetection + "]";
        }
    }

    public static class Parameters
    extends PeerConnectionParameters {
        public boolean renderLocal = true;
        public int cameraIndex = -1;
        public boolean receiveVideo = true;
        public boolean receiveAudio = true;
        public boolean captureVideo = true;
        public boolean captureAudio = true;

        public Parameters(boolean videoCallEnabled, boolean loopback, int videoWidth, int videoHeight, int videoFps, int videoStartBitrate, String videoCodec, boolean videoCodecHwAcceleration, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean cpuOveruseDetection) {
            super(videoCallEnabled, loopback, videoWidth, videoHeight, videoFps, videoStartBitrate, videoCodec, videoCodecHwAcceleration, audioStartBitrate, audioCodec, noAudioProcessing, cpuOveruseDetection);
        }

        public void enableVideo(boolean capture, boolean receive) {
            this.captureVideo = capture;
            this.receiveVideo = receive;
        }

        public void enableAudio(boolean capture, boolean receive) {
            this.captureAudio = capture;
            this.receiveAudio = receive;
        }
    }

    public class RtcStatistics {
        public String connectionType = "disconnect";
        public int localCaptureWidth = 0;
        public int localCaptureHeight = 0;
        public int localCaptureFps = 0;
        public int localEncodedWidth = 0;
        public int localEncodedHeight = 0;
        public int localEncodedFps = 0;
        public int localVideoActualBps = 0;
        public int localVideoTargetBps = 0;
        public int localVideoPacketsLost = 0;
        public int localVideoPacketsLostrate = 0;
        public int localVideoRtt = 0;
        public int localAudioPacketsLost = 0;
        public int localAudioPacketsLostrate = 0;
        public int localAudioBps = 0;
        public int localAudioRtt = 0;
        public int remoteWidth = 0;
        public int remoteHeight = 0;
        public int remoteFps = 0;
        public int remoteVideoPacketsLost = 0;
        public int remoteVideoPacketsLostrate = 0;
        public int remoteVideoBps = 0;
        public int remoteAudioPacketsLost = 0;
        public int remoteAudioPacketsLostrate = 0;
        public int remoteAudioBps = 0;
        public String fullStatsString = "fullStats";
    }

    public static class RenderRect {
        int x;
        int y;
        int width;
        int height;

        public RenderRect(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    public static interface Listener {
        public void onLocalSdp(RtcConnection var1, String var2);

        public void onLocalCandidate(RtcConnection var1, String var2);

        public void onConnected(RtcConnection var1);

        public void onConnectionsetup(RtcConnection var1);

        public void onDisconnected(RtcConnection var1);

        public void onCandidateCompleted(RtcConnection var1);

        public void onClosed(RtcConnection var1);

        public void onStats(RtcConnection var1, RtcStatistics var2);

        public void onError(RtcConnection var1, String var2);
    }

    private static class RtcContent {
        private static final String TYPE_OFFER = SessionDescription.Type.OFFER.name();
        private static final String TYPE_ANSWER = SessionDescription.Type.ANSWER.name();
        private static final String TYPE_PRANSWER = SessionDescription.Type.PRANSWER.name();
        private static final String TYPE_CANDIDATE = "candidate";
        String type;
        int mlineindex;
        String candidate;
        String sdp;
        long seq;

        private RtcContent() {
        }

        public boolean isSdp() {
            if (this.type == null) {
                return false;
            }
            return this.type.equalsIgnoreCase(TYPE_OFFER) || this.type.equalsIgnoreCase(TYPE_ANSWER) || this.type.equalsIgnoreCase(TYPE_PRANSWER);
        }

        public static RtcContent fromJson(String json) throws JSONException {
            RtcContent c2 = new RtcContent();
            JSONTokener jsonParser = new JSONTokener(json);
            JSONObject rootobj = (JSONObject)jsonParser.nextValue();
            c2.type = rootobj.optString("type");
            c2.mlineindex = rootobj.optInt("mlineindex", -1);
            c2.candidate = rootobj.optString(TYPE_CANDIDATE, null);
            c2.sdp = rootobj.optString("sdp", null);
            c2.seq = rootobj.optLong("seq", -1L);
            return c2;
        }

        protected static String candidate2Json(IceCandidate cand, long seq, String connectionId) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("type", (Object)TYPE_CANDIDATE);
                obj.put("mlineindex", cand.sdpMLineIndex);
                obj.put("mid", (Object)cand.sdpMid);
                obj.put(TYPE_CANDIDATE, (Object)cand.sdp);
                obj.put("connId", (Object)connectionId);
                obj.put("seq", seq);
                String json = obj.toString();
                return json;
            }
            catch (JSONException e2) {
                ALog.i(RtcConnection.TAG, "Exception: " + e2.getMessage());
                e2.printStackTrace();
                return null;
            }
        }

        protected static String SDP2Json(SessionDescription sdp, long seq, String connectionId) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("type", (Object)sdp.type.toString().toLowerCase());
                obj.put("sdp", (Object)sdp.description);
                obj.put("seq", seq);
                obj.put("connId", (Object)connectionId);
                String json = obj.toString();
                return json;
            }
            catch (JSONException e2) {
                ALog.i(RtcConnection.TAG, "Exception: " + e2.getMessage());
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static enum AspectMode {
        AspectFit,
        AspectFill;

    }

    public static interface RtcGlTextureProcessor {
        public void onDrawFrame(int var1, int var2, int var3, float[] var4, int var5);
    }

    public static interface RtcCameraDataProcessor {
        public void onProcessData(byte[] var1, Camera var2, int var3, int var4, int var5);

        public void setResolution(int var1, int var2);
    }

    public static interface LogListener {
        public void onLog(int var1, String var2);
    }

    public static enum LoggingSeverity {
        LS_SENSITIVE,
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    public static enum Medialogmod {
        M_SENSITIVE,
        M_VERBOSE,
        M_INFO,
        M_WARNING,
        M_ERROR;

    }

    public static enum MIRROR {
        AUTO,
        ON,
        OFF;

    }
}

