/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voice;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import com.superrtc.call.Logging;
import com.superrtc.voice.WebRtcAudioEffects;
import com.superrtc.voice.WebRtcAudioManager;
import com.superrtc.voice.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private final long nativeAudioRecord;
    private final Context context;
    private WebRtcAudioEffects effects = null;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;
    private static volatile boolean microphoneMute = false;
    private byte[] emptyBytes;

    WebRtcAudioRecord(Context context, long nativeAudioRecord) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = nativeAudioRecord;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInAGC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAGC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AGC is not supported on this platform");
            return false;
        }
        return this.effects.setAGC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    private int initRecording(int sampleRate, int channels) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        if (!WebRtcAudioUtils.hasPermission(this.context, "android.permission.RECORD_AUDIO")) {
            WebRtcAudioManager.openMicFail();
            Logging.e(TAG, "RECORD_AUDIO permission is missing");
            return -1;
        }
        if (this.audioRecord != null) {
            this.stopRecording();
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)16, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            Logging.e(TAG, "AudioRecord.getMinBufferSize failed: " + minBufferSize);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        try {
            int audioSource = WebRtcAudioManager.getCallAudioSource();
            if (audioSource < 0 || audioSource > 9) {
                audioSource = 7;
            }
            this.audioRecord = new AudioRecord(audioSource, sampleRate, 16, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e2) {
            WebRtcAudioManager.openMicFail();
            Logging.e(TAG, e2.getMessage());
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            WebRtcAudioManager.openMicFail();
            Logging.e(TAG, "Failed to create a new AudioRecord instance");
            return -1;
        }
        Logging.e(TAG, "open mic success");
        Logging.d(TAG, "AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        return framesPerBuffer;
    }

    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e2) {
            WebRtcAudioManager.openMicFail();
            Logging.e(TAG, "AudioRecord.startRecording exception: " + e2.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            WebRtcAudioManager.openMicFail();
            Logging.e(TAG, "AudioRecord.startRecording failed");
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        if (this.audioThread != null) {
            this.audioThread.joinThread();
            this.audioThread = null;
        }
        if (this.effects != null) {
            this.effects.release();
        }
        this.audioRecord.release();
        this.audioRecord = null;
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute API will be deprecated soon.");
        microphoneMute = mute;
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.read failed: " + bytesRead);
                if (bytesRead != -3) continue;
                this.keepAlive = false;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException e2) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + e2.getMessage());
            }
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

