/*
 * Decompiled with CFR 0.152.
 */
package internal.org.java_websocket;

import internal.org.java_websocket.WebSocket;
import internal.org.java_websocket.WebSocketListener;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.exceptions.InvalidDataException;
import internal.org.java_websocket.exceptions.InvalidHandshakeException;
import internal.org.java_websocket.framing.Framedata;
import internal.org.java_websocket.framing.PingFrame;
import internal.org.java_websocket.framing.PongFrame;
import internal.org.java_websocket.handshake.ClientHandshake;
import internal.org.java_websocket.handshake.HandshakeImpl1Server;
import internal.org.java_websocket.handshake.ServerHandshake;
import internal.org.java_websocket.handshake.ServerHandshakeBuilder;
import java.net.InetSocketAddress;

public abstract class WebSocketAdapter
implements WebSocketListener {
    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket conn, Framedata frame) {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public String getFlashPolicy(WebSocket conn) throws InvalidDataException {
        InetSocketAddress adr = conn.getLocalSocketAddress();
        if (null == adr) {
            throw new InvalidHandshakeException("socket not bound");
        }
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + adr.getPort() + "\" /></cross-domain-policy>\u0000";
    }
}

