/*
 * Decompiled with CFR 0.152.
 */
package internal.org.java_websocket;

import internal.org.java_websocket.WebSocket;
import internal.org.java_websocket.WebSocketListener;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.drafts.Draft_6455;
import internal.org.java_websocket.exceptions.IncompleteHandshakeException;
import internal.org.java_websocket.exceptions.InvalidDataException;
import internal.org.java_websocket.exceptions.InvalidHandshakeException;
import internal.org.java_websocket.exceptions.WebsocketNotConnectedException;
import internal.org.java_websocket.framing.CloseFrame;
import internal.org.java_websocket.framing.Framedata;
import internal.org.java_websocket.framing.PingFrame;
import internal.org.java_websocket.handshake.ClientHandshake;
import internal.org.java_websocket.handshake.ClientHandshakeBuilder;
import internal.org.java_websocket.handshake.Handshakedata;
import internal.org.java_websocket.handshake.ServerHandshake;
import internal.org.java_websocket.handshake.ServerHandshakeBuilder;
import internal.org.java_websocket.server.WebSocketServer;
import internal.org.java_websocket.util.Charsetfunctions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class WebSocketImpl
implements WebSocket {
    public static int RCVBUF = 16384;
    public static boolean DEBUG = false;
    public final BlockingQueue<ByteBuffer> outQueue;
    public final BlockingQueue<ByteBuffer> inQueue;
    private final WebSocketListener wsl;
    public SelectionKey key;
    public ByteChannel channel;
    public volatile WebSocketServer.WebSocketWorker workerThread;
    private volatile boolean flushandclosestate = false;
    private WebSocket.READYSTATE readystate = WebSocket.READYSTATE.NOT_YET_CONNECTED;
    private List<Draft> knownDrafts;
    private Draft draft = null;
    private WebSocket.Role role;
    private Framedata current_continuous_frame = null;
    private ByteBuffer tmpHandshakeBytes = ByteBuffer.allocate(0);
    private ClientHandshake handshakerequest = null;
    private String closemessage = null;
    private Integer closecode = null;
    private Boolean closedremotely = null;
    private String resourceDescriptor = null;
    private long lastPong = System.currentTimeMillis();
    private static final Object synchronizeWriteObject = new Object();

    public WebSocketImpl(WebSocketListener listener, List<Draft> drafts) {
        this(listener, (Draft)null);
        this.role = WebSocket.Role.SERVER;
        if (drafts == null || drafts.isEmpty()) {
            this.knownDrafts = new ArrayList<Draft>();
            this.knownDrafts.add(new Draft_6455());
        } else {
            this.knownDrafts = drafts;
        }
    }

    public WebSocketImpl(WebSocketListener listener, Draft draft) {
        if (listener == null || draft == null && this.role == WebSocket.Role.SERVER) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        this.outQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.inQueue = new LinkedBlockingQueue<ByteBuffer>();
        this.wsl = listener;
        this.role = WebSocket.Role.CLIENT;
        if (draft != null) {
            this.draft = draft.copyInstance();
        }
    }

    @Deprecated
    public WebSocketImpl(WebSocketListener listener, Draft draft, Socket socket) {
        this(listener, draft);
    }

    @Deprecated
    public WebSocketImpl(WebSocketListener listener, List<Draft> drafts, Socket socket) {
        this(listener, drafts);
    }

    public void decode(ByteBuffer socketBuffer) {
        assert (socketBuffer.hasRemaining());
        if (DEBUG) {
            System.out.println("process(" + socketBuffer.remaining() + "): {" + (socketBuffer.remaining() > 1000 ? "too big to display" : new String(socketBuffer.array(), socketBuffer.position(), socketBuffer.remaining())) + "}");
        }
        if (this.readystate != WebSocket.READYSTATE.NOT_YET_CONNECTED) {
            if (this.readystate == WebSocket.READYSTATE.OPEN) {
                this.decodeFrames(socketBuffer);
            }
        } else if (this.decodeHandshake(socketBuffer)) {
            assert (this.tmpHandshakeBytes.hasRemaining() != socketBuffer.hasRemaining() || !socketBuffer.hasRemaining());
            if (socketBuffer.hasRemaining()) {
                this.decodeFrames(socketBuffer);
            } else if (this.tmpHandshakeBytes.hasRemaining()) {
                this.decodeFrames(this.tmpHandshakeBytes);
            }
        }
        assert (this.isClosing() || this.isFlushAndClose() || !socketBuffer.hasRemaining());
    }

    private boolean decodeHandshake(ByteBuffer socketBufferNew) {
        block31: {
            ByteBuffer socketBuffer;
            if (this.tmpHandshakeBytes.capacity() == 0) {
                socketBuffer = socketBufferNew;
            } else {
                if (this.tmpHandshakeBytes.remaining() < socketBufferNew.remaining()) {
                    ByteBuffer buf = ByteBuffer.allocate(this.tmpHandshakeBytes.capacity() + socketBufferNew.remaining());
                    this.tmpHandshakeBytes.flip();
                    buf.put(this.tmpHandshakeBytes);
                    this.tmpHandshakeBytes = buf;
                }
                this.tmpHandshakeBytes.put(socketBufferNew);
                this.tmpHandshakeBytes.flip();
                socketBuffer = this.tmpHandshakeBytes;
            }
            socketBuffer.mark();
            try {
                Draft.HandshakeState isflashedgecase;
                if (this.draft == null && (isflashedgecase = this.isFlashEdgeCase(socketBuffer)) == Draft.HandshakeState.MATCHED) {
                    try {
                        this.write(Collections.singletonList(ByteBuffer.wrap(Charsetfunctions.utf8Bytes(this.wsl.getFlashPolicy(this)))));
                        this.close(-3, "");
                    }
                    catch (InvalidDataException e2) {
                        this.close(1006, "remote peer closed connection before flashpolicy could be transmitted", true);
                    }
                    return false;
                }
                try {
                    Draft.HandshakeState handshakestate;
                    if (this.role == WebSocket.Role.SERVER) {
                        if (this.draft == null) {
                            for (Draft d2 : this.knownDrafts) {
                                d2 = d2.copyInstance();
                                try {
                                    ServerHandshakeBuilder response;
                                    d2.setParseMode(this.role);
                                    socketBuffer.reset();
                                    Handshakedata tmphandshake = d2.translateHandshake(socketBuffer);
                                    if (!(tmphandshake instanceof ClientHandshake)) {
                                        this.flushAndClose(1002, "wrong http function", false);
                                        return false;
                                    }
                                    ClientHandshake handshake = (ClientHandshake)tmphandshake;
                                    handshakestate = d2.acceptHandshakeAsServer(handshake);
                                    if (handshakestate != Draft.HandshakeState.MATCHED) continue;
                                    this.resourceDescriptor = handshake.getResourceDescriptor();
                                    try {
                                        response = this.wsl.onWebsocketHandshakeReceivedAsServer(this, d2, handshake);
                                    }
                                    catch (InvalidDataException e3) {
                                        this.flushAndClose(e3.getCloseCode(), e3.getMessage(), false);
                                        return false;
                                    }
                                    catch (RuntimeException e4) {
                                        this.wsl.onWebsocketError(this, e4);
                                        this.flushAndClose(-1, e4.getMessage(), false);
                                        return false;
                                    }
                                    this.write(d2.createHandshake(d2.postProcessHandshakeResponseAsServer(handshake, response), this.role));
                                    this.draft = d2;
                                    this.open(handshake);
                                    return true;
                                }
                                catch (InvalidHandshakeException tmphandshake) {
                                }
                            }
                            if (this.draft == null) {
                                this.close(1002, "no draft matches");
                            }
                            return false;
                        }
                        Handshakedata tmphandshake = this.draft.translateHandshake(socketBuffer);
                        if (!(tmphandshake instanceof ClientHandshake)) {
                            this.flushAndClose(1002, "wrong http function", false);
                            return false;
                        }
                        ClientHandshake handshake = (ClientHandshake)tmphandshake;
                        handshakestate = this.draft.acceptHandshakeAsServer(handshake);
                        if (handshakestate == Draft.HandshakeState.MATCHED) {
                            this.open(handshake);
                            return true;
                        }
                        this.close(1002, "the handshake did finaly not match");
                        return false;
                    }
                    if (this.role != WebSocket.Role.CLIENT) break block31;
                    this.draft.setParseMode(this.role);
                    Handshakedata tmphandshake = this.draft.translateHandshake(socketBuffer);
                    if (!(tmphandshake instanceof ServerHandshake)) {
                        this.flushAndClose(1002, "wrong http function", false);
                        return false;
                    }
                    ServerHandshake handshake = (ServerHandshake)tmphandshake;
                    handshakestate = this.draft.acceptHandshakeAsClient(this.handshakerequest, handshake);
                    if (handshakestate == Draft.HandshakeState.MATCHED) {
                        try {
                            this.wsl.onWebsocketHandshakeReceivedAsClient(this, this.handshakerequest, handshake);
                        }
                        catch (InvalidDataException e5) {
                            this.flushAndClose(e5.getCloseCode(), e5.getMessage(), false);
                            return false;
                        }
                        catch (RuntimeException e6) {
                            this.wsl.onWebsocketError(this, e6);
                            this.flushAndClose(-1, e6.getMessage(), false);
                            return false;
                        }
                        this.open(handshake);
                        return true;
                    }
                    this.close(1002, "draft " + this.draft + " refuses handshake");
                }
                catch (InvalidHandshakeException e7) {
                    this.close(e7);
                }
            }
            catch (IncompleteHandshakeException e8) {
                if (this.tmpHandshakeBytes.capacity() == 0) {
                    socketBuffer.reset();
                    int newsize = e8.getPreferedSize();
                    if (newsize == 0) {
                        newsize = socketBuffer.capacity() + 16;
                    } else assert (e8.getPreferedSize() >= socketBuffer.remaining());
                    this.tmpHandshakeBytes = ByteBuffer.allocate(newsize);
                    this.tmpHandshakeBytes.put(socketBufferNew);
                }
                this.tmpHandshakeBytes.position(this.tmpHandshakeBytes.limit());
                this.tmpHandshakeBytes.limit(this.tmpHandshakeBytes.capacity());
            }
        }
        return false;
    }

    private void decodeFrames(ByteBuffer socketBuffer) {
        try {
            List<Framedata> frames = this.draft.translateFrame(socketBuffer);
            for (Framedata f : frames) {
                if (DEBUG) {
                    System.out.println("matched frame: " + f);
                }
                Framedata.Opcode curop = f.getOpcode();
                boolean fin = f.isFin();
                if (this.readystate == WebSocket.READYSTATE.CLOSING) {
                    return;
                }
                if (curop == Framedata.Opcode.CLOSING) {
                    int code = 1005;
                    String reason = "";
                    if (f instanceof CloseFrame) {
                        CloseFrame cf = (CloseFrame)f;
                        code = cf.getCloseCode();
                        reason = cf.getMessage();
                    }
                    if (this.readystate == WebSocket.READYSTATE.CLOSING) {
                        this.closeConnection(code, reason, true);
                        continue;
                    }
                    if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.TWOWAY) {
                        this.close(code, reason, true);
                        continue;
                    }
                    this.flushAndClose(code, reason, false);
                    continue;
                }
                if (curop == Framedata.Opcode.PING) {
                    this.wsl.onWebsocketPing(this, f);
                    continue;
                }
                if (curop == Framedata.Opcode.PONG) {
                    this.lastPong = System.currentTimeMillis();
                    this.wsl.onWebsocketPong(this, f);
                    continue;
                }
                if (!fin || curop == Framedata.Opcode.CONTINUOUS) {
                    if (curop != Framedata.Opcode.CONTINUOUS) {
                        if (this.current_continuous_frame != null) {
                            throw new InvalidDataException(1002, "Previous continuous frame sequence not completed.");
                        }
                        this.current_continuous_frame = f;
                    } else if (fin) {
                        if (this.current_continuous_frame == null) {
                            throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
                        }
                        if (this.current_continuous_frame.getOpcode() == Framedata.Opcode.TEXT) {
                            int off = Math.max(this.current_continuous_frame.getPayloadData().limit() - 64, 0);
                            this.current_continuous_frame.append(f);
                            if (!Charsetfunctions.isValidUTF8(this.current_continuous_frame.getPayloadData(), off)) {
                                throw new InvalidDataException(1007);
                            }
                        }
                        this.current_continuous_frame = null;
                    } else if (this.current_continuous_frame == null) {
                        throw new InvalidDataException(1002, "Continuous frame sequence was not started.");
                    }
                    if (curop == Framedata.Opcode.TEXT && !Charsetfunctions.isValidUTF8(f.getPayloadData())) {
                        throw new InvalidDataException(1007);
                    }
                    if (curop == Framedata.Opcode.CONTINUOUS && this.current_continuous_frame != null && this.current_continuous_frame.getOpcode() == Framedata.Opcode.TEXT) {
                        int off = Math.max(this.current_continuous_frame.getPayloadData().limit() - 64, 0);
                        this.current_continuous_frame.append(f);
                        if (!Charsetfunctions.isValidUTF8(this.current_continuous_frame.getPayloadData(), off)) {
                            throw new InvalidDataException(1007);
                        }
                    }
                    try {
                        this.wsl.onWebsocketMessageFragment(this, f);
                    }
                    catch (RuntimeException e2) {
                        this.wsl.onWebsocketError(this, e2);
                    }
                    continue;
                }
                if (this.current_continuous_frame != null) {
                    throw new InvalidDataException(1002, "Continuous frame sequence not completed.");
                }
                if (curop == Framedata.Opcode.TEXT) {
                    try {
                        this.wsl.onWebsocketMessage((WebSocket)this, Charsetfunctions.stringUtf8(f.getPayloadData()));
                    }
                    catch (RuntimeException e3) {
                        this.wsl.onWebsocketError(this, e3);
                    }
                    continue;
                }
                if (curop == Framedata.Opcode.BINARY) {
                    try {
                        this.wsl.onWebsocketMessage((WebSocket)this, f.getPayloadData());
                    }
                    catch (RuntimeException e4) {
                        this.wsl.onWebsocketError(this, e4);
                    }
                    continue;
                }
                throw new InvalidDataException(1002, "non control or continious frame expected");
            }
        }
        catch (InvalidDataException e1) {
            this.wsl.onWebsocketError(this, e1);
            this.close(e1);
            return;
        }
    }

    private void close(int code, String message, boolean remote) {
        if (this.readystate != WebSocket.READYSTATE.CLOSING && this.readystate != WebSocket.READYSTATE.CLOSED) {
            if (this.readystate == WebSocket.READYSTATE.OPEN) {
                if (code == 1006) {
                    assert (!remote);
                    this.readystate = WebSocket.READYSTATE.CLOSING;
                    this.flushAndClose(code, message, false);
                    return;
                }
                if (this.draft.getCloseHandshakeType() != Draft.CloseHandshakeType.NONE) {
                    try {
                        if (!remote) {
                            try {
                                this.wsl.onWebsocketCloseInitiated(this, code, message);
                            }
                            catch (RuntimeException e2) {
                                this.wsl.onWebsocketError(this, e2);
                            }
                        }
                        CloseFrame closeFrame = new CloseFrame();
                        closeFrame.setReason(message);
                        closeFrame.setCode(code);
                        closeFrame.isValid();
                        this.sendFrame(closeFrame);
                    }
                    catch (InvalidDataException e3) {
                        this.wsl.onWebsocketError(this, e3);
                        this.flushAndClose(1006, "generated frame is invalid", false);
                    }
                }
                this.flushAndClose(code, message, remote);
            } else if (code == -3) {
                assert (remote);
                this.flushAndClose(-3, message, true);
            } else {
                this.flushAndClose(-1, message, false);
            }
            if (code == 1002) {
                this.flushAndClose(code, message, remote);
            }
            this.readystate = WebSocket.READYSTATE.CLOSING;
            this.tmpHandshakeBytes = null;
            return;
        }
    }

    @Override
    public void close(int code, String message) {
        this.close(code, message, false);
    }

    protected synchronized void closeConnection(int code, String message, boolean remote) {
        if (this.readystate == WebSocket.READYSTATE.CLOSED) {
            return;
        }
        if (this.key != null) {
            this.key.cancel();
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e2) {
                this.wsl.onWebsocketError(this, e2);
            }
        }
        try {
            this.wsl.onWebsocketClose(this, code, message, remote);
        }
        catch (RuntimeException e3) {
            this.wsl.onWebsocketError(this, e3);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakerequest = null;
        this.readystate = WebSocket.READYSTATE.CLOSED;
        this.outQueue.clear();
    }

    protected void closeConnection(int code, boolean remote) {
        this.closeConnection(code, "", remote);
    }

    public void closeConnection() {
        if (this.closedremotely == null) {
            throw new IllegalStateException("this method must be used in conjuction with flushAndClose");
        }
        this.closeConnection(this.closecode, this.closemessage, this.closedremotely);
    }

    @Override
    public void closeConnection(int code, String message) {
        this.closeConnection(code, message, false);
    }

    protected synchronized void flushAndClose(int code, String message, boolean remote) {
        if (this.flushandclosestate) {
            return;
        }
        this.closecode = code;
        this.closemessage = message;
        this.closedremotely = remote;
        this.flushandclosestate = true;
        this.wsl.onWriteDemand(this);
        try {
            this.wsl.onWebsocketClosing(this, code, message, remote);
        }
        catch (RuntimeException e2) {
            this.wsl.onWebsocketError(this, e2);
        }
        if (this.draft != null) {
            this.draft.reset();
        }
        this.handshakerequest = null;
    }

    public void eot() {
        if (this.getReadyState() == WebSocket.READYSTATE.NOT_YET_CONNECTED) {
            this.closeConnection(-1, true);
        } else if (this.flushandclosestate) {
            this.closeConnection(this.closecode, this.closemessage, this.closedremotely);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.NONE) {
            this.closeConnection(1000, true);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.ONEWAY) {
            if (this.role == WebSocket.Role.SERVER) {
                this.closeConnection(1006, true);
            } else {
                this.closeConnection(1000, true);
            }
        } else {
            this.closeConnection(1006, true);
        }
    }

    @Override
    public void close(int code) {
        this.close(code, "", false);
    }

    public void close(InvalidDataException e2) {
        this.close(e2.getCloseCode(), e2.getMessage(), false);
    }

    @Override
    public void send(String text) throws WebsocketNotConnectedException {
        if (text == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        this.send(this.draft.createFrames(text, this.role == WebSocket.Role.CLIENT));
    }

    @Override
    public void send(ByteBuffer bytes) throws IllegalArgumentException, WebsocketNotConnectedException {
        if (bytes == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        this.send(this.draft.createFrames(bytes, this.role == WebSocket.Role.CLIENT));
    }

    @Override
    public void send(byte[] bytes) throws IllegalArgumentException, WebsocketNotConnectedException {
        this.send(ByteBuffer.wrap(bytes));
    }

    private void send(Collection<Framedata> frames) {
        if (!this.isOpen()) {
            throw new WebsocketNotConnectedException();
        }
        ArrayList<ByteBuffer> outgoingFrames = new ArrayList<ByteBuffer>();
        for (Framedata f : frames) {
            if (DEBUG) {
                System.out.println("send frame: " + f);
            }
            outgoingFrames.add(this.draft.createBinaryFrame(f));
        }
        this.write(outgoingFrames);
    }

    @Override
    public void sendFragmentedFrame(Framedata.Opcode op, ByteBuffer buffer, boolean fin) {
        this.send(this.draft.continuousFrame(op, buffer, fin));
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.send(Collections.singletonList(framedata));
    }

    @Override
    public void sendPing() throws NotYetConnectedException {
        this.sendFrame(new PingFrame());
    }

    @Override
    public boolean hasBufferedData() {
        return !this.outQueue.isEmpty();
    }

    private Draft.HandshakeState isFlashEdgeCase(ByteBuffer request) throws IncompleteHandshakeException {
        request.mark();
        if (request.limit() > Draft.FLASH_POLICY_REQUEST.length) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        if (request.limit() < Draft.FLASH_POLICY_REQUEST.length) {
            throw new IncompleteHandshakeException(Draft.FLASH_POLICY_REQUEST.length);
        }
        int flash_policy_index = 0;
        while (request.hasRemaining()) {
            if (Draft.FLASH_POLICY_REQUEST[flash_policy_index] != request.get()) {
                request.reset();
                return Draft.HandshakeState.NOT_MATCHED;
            }
            ++flash_policy_index;
        }
        return Draft.HandshakeState.MATCHED;
    }

    public void startHandshake(ClientHandshakeBuilder handshakedata) throws InvalidHandshakeException {
        assert (this.readystate != WebSocket.READYSTATE.CONNECTING) : "shall only be called once";
        this.handshakerequest = this.draft.postProcessHandshakeRequestAsClient(handshakedata);
        this.resourceDescriptor = handshakedata.getResourceDescriptor();
        assert (this.resourceDescriptor != null);
        try {
            this.wsl.onWebsocketHandshakeSentAsClient(this, this.handshakerequest);
        }
        catch (InvalidDataException e2) {
            throw new InvalidHandshakeException("Handshake data rejected by client.");
        }
        catch (RuntimeException e3) {
            this.wsl.onWebsocketError(this, e3);
            throw new InvalidHandshakeException("rejected because of" + e3);
        }
        this.write(this.draft.createHandshake(this.handshakerequest, this.role));
    }

    private void write(ByteBuffer buf) {
        if (DEBUG) {
            System.out.println("write(" + buf.remaining() + "): {" + (buf.remaining() > 1000 ? "too big to display" : new String(buf.array())) + "}");
        }
        this.outQueue.add(buf);
        this.wsl.onWriteDemand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<ByteBuffer> bufs) {
        Object object = synchronizeWriteObject;
        synchronized (object) {
            for (ByteBuffer b2 : bufs) {
                this.write(b2);
            }
        }
    }

    private void open(Handshakedata d2) {
        if (DEBUG) {
            System.out.println("open using draft: " + this.draft.getClass().getSimpleName());
        }
        this.readystate = WebSocket.READYSTATE.OPEN;
        try {
            this.wsl.onWebsocketOpen(this, d2);
        }
        catch (RuntimeException e2) {
            this.wsl.onWebsocketError(this, e2);
        }
    }

    @Override
    public boolean isConnecting() {
        assert (!this.flushandclosestate || this.readystate == WebSocket.READYSTATE.CONNECTING);
        return this.readystate == WebSocket.READYSTATE.CONNECTING;
    }

    @Override
    public boolean isOpen() {
        assert (this.readystate != WebSocket.READYSTATE.OPEN || !this.flushandclosestate);
        return this.readystate == WebSocket.READYSTATE.OPEN;
    }

    @Override
    public boolean isClosing() {
        return this.readystate == WebSocket.READYSTATE.CLOSING;
    }

    @Override
    public boolean isFlushAndClose() {
        return this.flushandclosestate;
    }

    @Override
    public boolean isClosed() {
        return this.readystate == WebSocket.READYSTATE.CLOSED;
    }

    @Override
    public WebSocket.READYSTATE getReadyState() {
        return this.readystate;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.wsl.getRemoteSocketAddress(this);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.wsl.getLocalSocketAddress(this);
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }

    @Override
    public void close() {
        this.close(1000);
    }

    @Override
    public String getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    long getLastPong() {
        return this.lastPong;
    }
}

