/*
 * Decompiled with CFR 0.152.
 */
package internal.org.java_websocket.server;

import internal.org.java_websocket.SSLSocketChannel2;
import internal.org.java_websocket.WebSocketAdapter;
import internal.org.java_websocket.WebSocketImpl;
import internal.org.java_websocket.WebSocketListener;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.server.WebSocketServer;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class DefaultSSLWebSocketServerFactory
implements WebSocketServer.WebSocketServerFactory {
    protected SSLContext sslcontext;
    protected ExecutorService exec;

    public DefaultSSLWebSocketServerFactory(SSLContext sslContext) {
        this(sslContext, Executors.newSingleThreadScheduledExecutor());
    }

    public DefaultSSLWebSocketServerFactory(SSLContext sslContext, ExecutorService exec) {
        if (sslContext == null || exec == null) {
            throw new IllegalArgumentException();
        }
        this.sslcontext = sslContext;
        this.exec = exec;
    }

    @Override
    public ByteChannel wrapChannel(SocketChannel channel, SelectionKey key) throws IOException {
        SSLEngine e2 = this.sslcontext.createSSLEngine();
        ArrayList<String> ciphers = new ArrayList<String>(Arrays.asList(e2.getEnabledCipherSuites()));
        ciphers.remove("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        e2.setEnabledCipherSuites(ciphers.toArray(new String[0]));
        e2.setUseClientMode(false);
        return new SSLSocketChannel2(channel, e2, this.exec, key);
    }

    @Override
    public WebSocketImpl createWebSocket(WebSocketAdapter a2, Draft d2) {
        return new WebSocketImpl((WebSocketListener)a2, d2);
    }

    @Override
    public WebSocketImpl createWebSocket(WebSocketAdapter a2, List<Draft> d2) {
        return new WebSocketImpl((WebSocketListener)a2, d2);
    }

    @Override
    public void close() {
        this.exec.shutdown();
    }
}

