package com.hyphenate.agora;

import android.graphics.Color;
import android.service.autofill.TextValueSanitizer;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import org.w3c.dom.Text;

public class AgoraStreamItem {
    // 容器按照顺序添加的，添加时的uid
    private int uid;
    //private SurfaceView surfaceView;
    private TextureView surfaceView;
    private View flatView;
    private FrameLayout mRemoteView;
    // 当关闭相机时使用
    private View mCameraView;

    // 替换后的真实uid
    private int mRealUid;

    private TextView mTextViewName;
    private TextView mIconTextView;
    private String mName;

    private View whiteboardDef;


    // voice
    private boolean mIsOpenVoice = true;
    // camera
    private boolean mIsOpenCamera = true;

    public void init() {
        mIsOpenVoice = true;
        mTextViewName = null;
        mIconTextView = null;
        mRemoteView = null;
        mCameraView = null;
    }


    private static final String sIconOpen = "\uecb1";
    private static final  String sIconClose = "\ue6eb";

    private static final String sIconOpenColor = "#3B84F7";
    private static final  String sIconCloseColor = "#ff4400";


    public int getRealUid() {
        return mRealUid;
    }

    public void setRealUid(int realUid) {
        mRealUid = realUid;
    }

    public void setIconTextView(TextView iconTextView) {
        mIconTextView = iconTextView;
    }

    public TextView getIconTextView() {
        return mIconTextView;
    }

    public void setOpenVoice(boolean openVoice) {
        mIsOpenVoice = openVoice;
        updateVoiceIcon();
    }

    public void setCameraView(View cameraView) {
        mCameraView = cameraView;
    }

    public View getCameraView() {
        return mCameraView;
    }

    public void setOpenCamera(boolean isOpenCamera) {
        mIsOpenCamera = isOpenCamera;
        updateCameraView();
    }

    public boolean isOpenCamera() {
        return mIsOpenCamera;
    }

    public boolean isOpenVoice() {
        return mIsOpenVoice;
    }

    public void setTextViewName(TextView textViewName) {
        mTextViewName = textViewName;
    }

    public TextView getTextViewName() {
        return mTextViewName;
    }

    public void setName(String name) {
        mName = name;
    }

    public AgoraStreamItem() {
    }

    public void updateName(){
        updateCameraView();
        if (mTextViewName != null){
            mTextViewName.setText(mName);
        }

        if (mIconTextView != null){
            if (mIsOpenVoice){
                mIconTextView.setText(sIconOpen);
                mIconTextView.setTextColor(Color.parseColor(sIconOpenColor));
            }else {
                mIconTextView.setText(sIconClose);
                mIconTextView.setTextColor(Color.parseColor(sIconCloseColor));
            }

            // mIconTextView.setVisibility(flatView != null ? View.GONE : View.VISIBLE);
            showAndHidden(mIconTextView, mRealUid != Integer.MAX_VALUE);
        }

        showAndHidden(mIconTextView, !(mRealUid == Integer.MAX_VALUE));

        showAndHidden(whiteboardDef, mRealUid == Integer.MAX_VALUE);
    }

    private void showAndHidden(View view, boolean isShow){
        if (view == null){
            return;
        }
        if (isShow && view.getVisibility() != View.VISIBLE){
            view.setVisibility(View.VISIBLE);
        }else if (!isShow && view.getVisibility() == View.VISIBLE){
            view.setVisibility(View.GONE);
        }
    }

    public void updateVoiceIcon(){
        if (mIconTextView != null){
            if (mIsOpenVoice){
                mIconTextView.setText(sIconOpen);
                mIconTextView.setTextColor(Color.parseColor(sIconOpenColor));
            }else {
                mIconTextView.setText(sIconClose);
                mIconTextView.setTextColor(Color.parseColor(sIconCloseColor));
            }
            showAndHidden(mIconTextView, !(mRealUid == Integer.MAX_VALUE));
        }
        showAndHidden(whiteboardDef, mRealUid == Integer.MAX_VALUE);
    }

    public void updateCameraView() {
        if (mCameraView != null){
            showAndHidden(mCameraView, !mIsOpenCamera);
        }
    }

    /*public void updateFlat(int flatUid){
        if (mRealUid == flatUid){
            if (mCameraView != null){
                showAndHidden(mCameraView, false);
            }
        }

    }*/

    public String getName() {
        return mName;
    }

    public View getFlatView(){
        return flatView;
    }

    public void setFlatView(View flatView) {
        this.flatView = flatView;
    }

    /*public SurfaceView getSurfaceView() {
        return surfaceView;
    }*/

    public TextureView getSurfaceView() {
        return surfaceView;
    }

    public void setSurfaceView(TextureView surfaceView) {
        this.surfaceView = surfaceView;
    }

    public void setRemoteView(FrameLayout remoteView) {
        mRemoteView = remoteView;
    }

    public FrameLayout getRemoteView() {
        return mRemoteView;
    }

    public int getUid() {
        return uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }


    public void setWhiteboardDef(View whiteboardDef){
        this.whiteboardDef = whiteboardDef;
    }

    public View getWhiteboardDef(){
        return whiteboardDef;
    }

    @Override
    public String toString() {
        return "AgoraStreamItem{" +
                "surfaceView=" + surfaceView +
                ", uid=" + uid +
                '}';
    }

    public void onDestroy(){
        surfaceView = null;
        mRemoteView = null;
        mTextViewName = null;
        mIconTextView = null;
        mCameraView = null;
    }

}
