package com.hyphenate.agora;


import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class ZuoXiSendRequestObj implements Parcelable {

    private String nickName;

    private int callId;
    private int uid;

    private int threeUid;
    private int threeCallId;

    private String threeNiceName;
    private String threeTrueName;

    private String token;
    private String appId;
    private String channel;

    private String niceName;
    private String trueName;

    private String appIdentifier;
    private String roomToken;
    private String roomUUID;

    private String to;
    private String from;

    private boolean isAddThreeUser;

    private boolean isNewVec;

    public ZuoXiSendRequestObj(){

    }


    protected ZuoXiSendRequestObj(Parcel in) {
        to = in.readString();
        from = in.readString();
        nickName = in.readString();
        callId = in.readInt();
        uid = in.readInt();
        threeUid = in.readInt();
        threeCallId = in.readInt();
        threeNiceName = in.readString();
        threeTrueName = in.readString();
        token = in.readString();
        appId = in.readString();
        channel = in.readString();
        niceName = in.readString();
        trueName = in.readString();
        isAddThreeUser = in.readByte() != 0;
        isNewVec = in.readByte() != 0;
    }

    public static final Creator<ZuoXiSendRequestObj> CREATOR = new Creator<ZuoXiSendRequestObj>() {
        @Override
        public ZuoXiSendRequestObj createFromParcel(Parcel in) {
            return new ZuoXiSendRequestObj(in);
        }

        @Override
        public ZuoXiSendRequestObj[] newArray(int size) {
            return new ZuoXiSendRequestObj[size];
        }
    };

    public void setAppIdentifier(String appIdentifier) {
        this.appIdentifier = appIdentifier;
    }

    public void setRoomToken(String roomToken) {
        this.roomToken = roomToken;
    }

    public void setRoomUUID(String roomUUID) {
        this.roomUUID = roomUUID;
    }

    public String getAppIdentifier() {
        return appIdentifier;
    }

    public String getRoomToken() {
        return roomToken;
    }

    public String getRoomUUID() {
        return roomUUID;
    }

    public void setIsAddThreeUser(boolean isAddThreeUser){
        this.isAddThreeUser = isAddThreeUser;
    }

    public boolean isAddThreeUser(){
        return isAddThreeUser;
    }

    public void setNewVec(boolean newVec) {
        isNewVec = newVec;
    }

    public boolean isNewVec() {
        return isNewVec;
    }

    public int getCallId() {
        return callId;
    }

    public void setCallId(int callId) {
        this.callId = callId;
    }

    public int getThreeCallId() {
        return callId;
    }

    public void setThreeCallId(int callId) {
        this.threeCallId = callId;
    }

    public int getUid() {
        return uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }


    public String getNiceName() {
        return niceName;
    }

    public void setNiceName(String niceName) {
        this.niceName = niceName;
    }
    public String getThreeNiceName() {
        return threeNiceName;
    }

    public String getThreeTrueName() {
        return threeTrueName;
    }
    public void setThreeNiceName(String niceName) {
        if (!TextUtils.isEmpty(niceName)){
            this.threeNiceName = niceName;
        }
    }

    public void setThreeTrueName(String threeTrueName) {
        this.threeTrueName = threeTrueName;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return channel;
    }

    public int getThreeUid() {
        return threeUid;
    }

    public void setThreeUid(int selfUid) {
        this.threeUid = selfUid;
    }

    public String getTrueName() {
        return trueName;
    }

    public void setTrueName(String trueName) {
        this.trueName = trueName;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return from;
    }

    public String getTo() {
        return to;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeString(to);
        dest.writeString(from);
        dest.writeString(nickName);
        dest.writeInt(callId);
        dest.writeInt(uid);
        dest.writeInt(threeUid);
        dest.writeInt(threeCallId);
        dest.writeString(threeNiceName);
        dest.writeString(threeTrueName);
        dest.writeString(token);
        dest.writeString(appId);
        dest.writeString(channel);
        dest.writeString(niceName);
        dest.writeString(trueName);
        dest.writeByte((byte) (isAddThreeUser ? 1 : 0));
        dest.writeByte((byte) (isNewVec ? 1 : 0));
    }

    @Override
    public String toString() {
        return "ZuoXiSendRequestObj{" +
                "nickName='" + nickName + '\'' +
                ", callId=" + callId +
                ", uid=" + uid +
                ", threeUid=" + threeUid +
                ", threeCallId=" + threeCallId +
                ", threeNiceName='" + threeNiceName + '\'' +
                ", threeTrueName='" + threeTrueName + '\'' +
                ", token='" + token + '\'' +
                ", appId='" + appId + '\'' +
                ", channel='" + channel + '\'' +
                ", niceName='" + niceName + '\'' +
                ", trueName='" + trueName + '\'' +
                ", appIdentifier='" + appIdentifier + '\'' +
                ", roomToken='" + roomToken + '\'' +
                ", roomUUID='" + roomUUID + '\'' +
                ", to='" + to + '\'' +
                ", from='" + from + '\'' +
                ", isAddThreeUser=" + isAddThreeUser +'\'' +
                ", isNewVec=" + isNewVec +
                '}';
    }
}
