package com.hyphenate.chat;

import android.content.Intent;

import com.hyphenate.agora.FunctionIconItem;
import com.hyphenate.agora.IAgoraMessageNotify;
import com.hyphenate.agora.IEndCallback;
import com.hyphenate.agora.IPushMessage;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AgoraMessage {
    private static final String TAG = AgoraMessage.class.getSimpleName();
    private static AgoraMessage sAgoraMessage = new AgoraMessage();;
    private static final Map<String, IAgoraMessageNotify> mMap = new HashMap<>();
    private static final Map<String, IEndCallback> mMapIEnd = new HashMap<>();
    private static final Map<String, IPushMessage> mPushMessage = new HashMap<>();
    private String mCurrentChatUsername;

    // 标识业务处理类型：LinkMessagePush 信息推送
    public static String TYPE_LINK_MESSAGE_PUSH = "infopush";
    // 卡证识别
    public static String TYPE_CARD_OCR = "cardocr";
    // 电子签名
    public static String TYPE_ELECSIGN = "elecsign";
    // 身份认证
    public static String TYPE_IDENTITYAUTH = "identityauth";
    // 满意度评价
    public static String TYPE_ENQUIRYINVITE = "enquiryInvite";
    // 开关麦克风
    public static String TYPE_MICROPHONE = "microphone";
    // 开关摄像头
    public static String TYPE_CAMERA = "camera";
    // 开关手电筒
    public static String TYPE_FLASH_LIGHT = "flashlight";
    // 聚焦
    public static String TYPE_FOCUS_CAMERA = "focusCamera";
    // 开关闪光灯
    public static String TYPE_CAMERA_TORCH_ON = "cameraTorchOn";
    // 切换摄像头
    public static String TYPE_CAMERA_CHANGE_ON = "cameraChange";

    private AgoraMessage(){

    }

    static void pushVecMessage(String content, String type){
        for (String key : mPushMessage.keySet()){
            mPushMessage.get(key).pushMessage(content, type);
        }
    }


    /**
     * 注册通知
     * @param classKey 当前类名。当调用unRegisterAgoraMessageNotify方法释放时传入相同类名
     * @param message IAgoraMessageNotify接口，通知回调：
     *                zuoXiToBreakOff()当座席端挂断时，回调此方法
     *                zuoXiSendThreeUserRequest(ZuoXiSendRequestObj obj)当座席端邀请第三方用户加入时，回调此方法
     */
    public synchronized void registerAgoraMessageNotify(String classKey, IAgoraMessageNotify message){
        mMap.put(classKey, message);
    }

    /**
     * 注销通知
     * @param classKey 当前类名。registerAgoraMessageNotify方法传入相同类名
     */
    public synchronized void unRegisterAgoraMessageNotify(String classKey){
        mMap.remove(classKey);
    }

    public synchronized void registerIEndCallback(String classKey, IEndCallback callback){
        if (mMapIEnd.containsKey(classKey)) {
            return;
        }
        mMapIEnd.put(classKey, callback);
    }

    public synchronized void unRegisterIEndCallback(String classKey){
        mMapIEnd.remove(classKey);
    }

    public synchronized void registerVecPushMessage(String classKey, IPushMessage callback){
        if (mPushMessage.containsKey(classKey)) {
            return;
        }
        mPushMessage.put(classKey, callback);
    }

    public synchronized void unRegisterVecPushMessage(String classKey){
        mPushMessage.remove(classKey);
    }

    public static AgoraMessage newAgoraMessage(){
        return sAgoraMessage;
    }

    // 座席端断开连接视频
    static synchronized void zuoXiToBreakOff(){
        for (String key : mMap.keySet()){
            mMap.get(key).zuoXiToBreakOff();
        }
    }

    // 座席端断开连接视频
    static synchronized void waitResponse(int callType, String rtcSessionId, String tenantId){
        for (String key : mMapIEnd.keySet()){
            mMapIEnd.get(key).onInitWaitPage(callType, rtcSessionId, tenantId);
        }
    }

    static synchronized void vecBreakOff(){
        for (String key : mMapIEnd.keySet()){
            mMapIEnd.get(key).onVecZuoXiToBreakOff();
        }
    }

    // 座席端响应超时
    /*public static void zuoXiTimeOut(){
        for (String key : mMap.keySet()){
            mMap.get(key).zuoXiTimeOut();
        }
    }*/



    static void createFlatRoom(ZuoXiSendRequestObj obj){
        for (String key : mMap.keySet()){
            mMap.get(key).createFlatRoom(obj);
        }
    }

    static void zuoXiActiveRequest(String msg, String to, String from){
        try {
            VecConfig.newVecConfig().setVecVideo(true);
            // TODO 座席主动发过来视频邀请
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.putExtra("zuo_xi_active",1);
            intent.putExtra("msg",msg);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.putExtra("type", "video");
            intent.putExtra("to", to);
            intent.putExtra("from", from);
            if (!VecConfig.newVecConfig().isEnableVideo()){
                return;
            }
            ChatClient.getInstance().getContext().sendBroadcast(intent);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // 获取当前用户
    // 座席端发送请求视频
    static void zuoXiSendRequest(ZuoXiSendRequestObj obj){
        // 解析数据，座席端请求添加三方人员
        if (obj.isAddThreeUser()){
            for (String key : mMap.keySet()){
                mMap.get(key).zuoXiSendThreeUserRequest(obj);
            }
            return;
        }
        /*if (obj.isNewVec()){
            for (String key : mMap.keySet()){
                mMap.get(key).zuoXiSendThreeUserRequest(obj);
            }
        }else {
            if (obj.isAddThreeUser()){
                for (String key : mMap.keySet()){
                    mMap.get(key).zuoXiSendThreeUserRequest(obj);
                }
                return;
            }
        }*/


        /*for (String key : mMap.keySet()){
            mMap.get(key).zuoXiSendRequest(obj);
        }*/

        /*if (VecConfig.newVecConfig().isOnLine()){
            Log.e("ppppppppp","正在通话中...不进行发送广播");
            return;
        }*/

        try {

            // TODO 座席端同意接入视频聊天，开始视频通话页面广播
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.putExtra("type", "video");
            intent.putExtra("appid", obj.getAppId());
            intent.putExtra("zuoXiSendRequestObj", obj);
            intent.putExtra("to", obj.getTo());
            intent.putExtra("from", obj.getFrom());
            //intent.putExtra("currentChatUsername", newAgoraMessage().getCurrentChatUsername());
            ChatClient.getInstance().getContext().sendBroadcast(intent);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // 满意度评价
    public static void sendEnouiryinvite(JSONObject enquiryInvite) {
        Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        // 满意度评价
        intent.putExtra("type", AgoraMessage.TYPE_ENQUIRYINVITE);
        intent.putExtra("content", enquiryInvite.toString());
        ChatClient.getInstance().getContext().sendBroadcast(intent);
    }



    public String getCurrentChatUsername() {
        return mCurrentChatUsername;
    }

    public void onDestroy(){
        mMap.clear();
    }

    // 设置IM 服务号
    public void setCurrentChatUsername(String currentChatUsername) {
        this.mCurrentChatUsername = currentChatUsername;
    }

    private String mTenantId;
    void setTenantId(String tenantId) {
        //this.mTenantId = tenantId;
    }

    public String getTenantId() {
        return ChatClient.getInstance().tenantId();
    }


    /**
     * 获取功能按键
     * @param tenantId 租户Id
     * @param callBack 回调函数
     */
    public static void asyncGetTenantIdFunctionIcons(String tenantId, final ValueCallBack<List<FunctionIconItem>> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        VecConfig.newVecConfig().setVideoSwitch(false);
        VecConfig.newVecConfig().setOldVideo(false);
        MarketingHttpClient.asyncGetTenantIdFunctionIcons(tenantId, new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                try {
                    List<FunctionIconItem> list = new ArrayList<>();
                    JSONObject object = new JSONObject(value);
                    if (!object.isNull("status")){
                        String status = object.getString("status");
                        if ("ok".equalsIgnoreCase(status)){
                            if (!object.isNull("entities")){
                                JSONArray entities = object.getJSONArray("entities");
                                for (int i = 0; i < entities.length(); i++){
                                    JSONObject jsonObject = entities.getJSONObject(i);
                                    if (jsonObject == null){
                                        continue;
                                    }
                                    // whiteBoard  白板
                                    //shareDesktop  屏幕共享
                                    // 功能名称
                                    if (jsonObject.has("grayName")){
                                        String grayName = jsonObject.getString("grayName");
                                        if ("whiteBoard".equalsIgnoreCase(grayName)
                                                || "shareDesktop".equalsIgnoreCase(grayName)){
                                            FunctionIconItem iconItem = new FunctionIconItem(grayName);
                                            // 功能是否可用
                                            if (!jsonObject.isNull("status")){
                                                iconItem.setStatus(jsonObject.getString("status"));
                                            }

                                            // 对灰度的描述，便于理解
                                            if (!jsonObject.isNull("description")){
                                                iconItem.setDescription(jsonObject.getString("description"));
                                            }

                                            if (iconItem.isEnable()){
                                                list.add(iconItem);
                                            }
                                        }else {
                                            // 在线里的视频灰度
                                            if ("agoraVideo".equalsIgnoreCase(grayName)){
                                                if (jsonObject.has("status")){
                                                    VecConfig.newVecConfig().setOldVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                                }
                                            }

                                            // vec 视频灰度
                                            if ("vecIndependentVideo".equalsIgnoreCase(grayName)){
                                                if (jsonObject.has("status")){
                                                    VecConfig.newVecConfig().setVideoSwitch("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                                }
                                            }
                                        }
                                    }

                                }
                            }
                            callBack.onSuccess(list);
                        }else {
                            VecConfig.newVecConfig().setVideoSwitch(false);
                            EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> status = "+status);
                        }
                    }else {
                        VecConfig.newVecConfig().setVideoSwitch(false);
                        callBack.onError(-1,value);
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                    VecConfig.newVecConfig().setVideoSwitch(false);
                    callBack.onError(-1,e.toString());
                    EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> JSONException e = "+e.toString());
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                Log.e("ttttttttttttt","errorMsg = "+errorMsg);
                EMLog.e(TAG, "asyncGetTenantIdFunctionIcons --> error = "+error+", errorMsg = "+errorMsg);
                callBack.onError(error,errorMsg);
            }
        });
    }

    // 文档转换
    /*public static void asyncWhiteboardFileConversion(String token, String tenantId, String sessionId, ValueCallBack<String> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        // MarketingHttpClient.asyncGetWhiteboardRoomId(token, tenantId, sessionId, callBack);
        MarketingHttpClient.asyncWhiteboardFileConversion(token, tenantId, sessionId, callBack);
    }*/

    /**
     * 上传文件到服务器
     * @param file 文件路径
     * @param token token
     * @param callId callId
     * @param tenantId tenantId
     * @param callBack 回调
     */
    public static void asyncUploadFile(String file, String token, final int callId, String tenantId, ValueCallBack<String> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        MarketingHttpClient.asyncUploadFile(file, token, callId, tenantId, callBack);
    }

    public static String getToken(){
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            throw new RuntimeException();
        }
        return ChatClient.getInstance().imAccessToken();
    }

    // 文件转换
    public static void asyncFileConverted(String file, String token, final int callId, String tenantId, String type, ValueCallBack<String> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        MarketingHttpClient.asyncFileConverted(file, token, callId, tenantId, type, callBack);
    }

    // 文件进度查询
    public static void asyncFileConvertedProgress(final String tenantId, final String token, final int callId, String type,
                                                  String taskId,  ValueCallBack<String> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        MarketingHttpClient.asyncFileConvertedProgress(tenantId, token, callId, type, taskId, callBack);
    }

    // 文件签名
    /*public static void asyncFileSignName(final String tenantId, final String token, final int callId, String filePath,
                                         ValueCallBack<String> callBack){
        // AgoraMessage.newAgoraMessage().getTenantId()
        MarketingHttpClient.asyncFileSignName(tenantId, token, callId, filePath, callBack);
    }*/

    /**
     * 初始化访客语种
     * @param tenantId 租户id
     * @param language 语言，参考文档 http://docs.easemob.com/cs/100agentmode/10conversation#智能翻译
     * @param appKey appKey
     * @param visitorUserName 访客登录用户名
     * @param callBack 回调
     */
    public static void asyncInitLanguage(String tenantId, String language, String appKey, String visitorUserName, ValueCallBack<String> callBack){
        MarketingHttpClient.asyncInitLanguage(tenantId, language, appKey, visitorUserName, callBack);
    }

    // 获取样式
    public static void asyncInitStyle(String tenantId, String configId, ValueCallBack<String> callBack){
        MarketingHttpClient.asyncInitStyle(tenantId, configId, callBack);
    }

    public static void asyncCloseVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncCloseVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void closeVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.closeVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void getAsyncVisitorIdAndVecSessionId(String toUser, ValueCallBack<String> callBack){
        MarketingHttpClient.asyncVisitorId(toUser,callBack);
    }

    public static void getVisitorIdAndVecSessionId(String toUser, ValueCallBack<String> callBack){
        MarketingHttpClient.getVisitorIdAndVecSessionId(toUser,callBack);
    }

    public static void asyncResultReporting(String tenantId, String visitorId, String type, JSONObject resultObj,  ValueCallBack<String> callBack){
        // 访客端业务处理结果上报接口
        MarketingHttpClient.asyncResultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    public static void resultReporting(String tenantId, String visitorId, String type, JSONObject resultObj,  ValueCallBack<String> callBack){
        // 访客端业务处理结果上报接口
        MarketingHttpClient.resultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    // 无空闲坐席提示语
    /*public static void getNoIdlePrompt(String toUser, ValueCallBack<String> callBack){
        MarketingHttpClient.asyncVisitorId(toUser,callBack);
    }*/

    /**
     * tenantId 租户id
     * visitorUserName 登录用户名
     * callBack 回调函数
     */
    public static void getSkillGroupMenuWithVisitorUserName(String tenantId, String visitorUserName, ValueCallBack<String> callBack){
        MarketingHttpClient.getSkillGroupMenuWithVisitorUserName(tenantId, visitorUserName, callBack);
    }

    public static void asyncUploadSignatureImage(File file, String token, String tenantId, String flowId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncUploadSignatureImage(file, token, tenantId, flowId, callBack);
    }

    /**
     * vec发起视频请求后，获取排队人数
     * @param tenantId 租户Id
     * @param rtcSessionId 会话Id
     * @param callBack 回调函数
     */
    public static void getWaitNumber(String tenantId, String rtcSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.getWaitNumber(tenantId, rtcSessionId, callBack);
    }

    // 提交满意度

    /**
     * vec视频通话结束后， 提交满意度
     * @param tenantId 租户id
     * @param jsonData 数据
     * @param callBack 回调函数
     */
    public static void asyncSubmitEvaluate(String tenantId, String jsonData, ValueCallBack<String> callBack){
        /*POST    /v1/kefurtc/tenant/{tenantId}/enquiry/visitor/submit
        请求参数：
        String rtcSessionId  通话id (必传)
        String visitorUserId 访客id(必传)
        Integer score 满意度分值(必传)
        String comment 评价备注
        List<RtcEnquiryTagData> tagData 满意度标签*/

        MarketingHttpClient.asyncSubmitEvaluate(tenantId, jsonData, callBack);
    }

    public static void asyncGetInfo(String tenantId, final ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncGetInfo(tenantId, callBack);
    }

    // 问题解决评价 通过页面设置，满意度评价 --> APP，微信，网页，通过如下接口返回勾选的名称
    public static void asyncProblemSolvingOnServiceSessionResolved(String tenantId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncProblemSolvingOnServiceSessionResolved(tenantId, callBack);
    }

    // 问题解决评价引导语 通过页面设置
    public static void asyncEvalSolveWord(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncEvalSolveWord(tenantId, serviceSessionId, callBack);
    }

    // 问题解决评价，通过页面设置，通过如下接口获取设置值，例如：已解决，未解决
    public static void asyncResolutionParams(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncResolutionParams(tenantId, serviceSessionId, callBack);
    }

    // 满意度评分引导语，通过页面设置，通过如下接口获取设置值
    public static void asyncGreetingMsgEnquiryInvite(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncGreetingMsgEnquiryInvite(tenantId, serviceSessionId, callBack);
    }

    /**
     * 获取指定消息的会话ID（sessionId）
     * @param message 消息
     * @return sessionId 会话id
     */
    public static String getSessionIdFromMessage(Message message) {
        String sessionId = null;
        try {
            String weichat = message.getStringAttribute("weichat");
            JSONObject wc = new JSONObject(weichat);
            if (wc.has("service_session")){
                JSONObject service_session = wc.getJSONObject("service_session");
                if (service_session.has("serviceSessionId")){
                    sessionId = service_session.getString("serviceSessionId");
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return sessionId;
    }

    /**
     * 在线聊天，通知坐席，消息标记已读
     * @param tenantId 租户id
     * @param sessionId 会话id
     * @param callBack 回调
     */
    public static void asyncMarkAllMessagesAsRead(String tenantId, String sessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncMarkAllMessagesAsRead(tenantId, sessionId, callBack);
    }
}
