package com.hyphenate.chat;


import android.text.TextUtils;

import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 音视频管理类
 */
public final class CallManager {

	static final String TAG = "callcore";
	private static CallManager sInstance;
	private String callNickName;
	private ConcurrentLinkedQueue<TicketEntity> ticketQueue = new ConcurrentLinkedQueue<>();
	private String currentMemberName;
	private CallOption callOption = new CallOption();


	synchronized static CallManager getInstance(){
		if (sInstance == null){
			sInstance = new CallManager();
		}
		return sInstance;
	}


	private static final String IncomingCallAction = ".action.incomingcall";

	/**
	 * 获取来电广播Action
	 * @return 广播字符串
	 */
	public String getIncomingCallBroadcastAction(){
		return ChatClient.getInstance().getContext().getPackageName() + IncomingCallAction;
	}

	void putZuoXiSend(Message message, String ticket, String callNickName, String to, String from){
		try {
			ZuoXiSendRequestObj obj = get(message, ticket, callNickName);
			obj.setTo(to);
			obj.setFrom(from);
			AgoraMessage.zuoXiSendRequest(obj);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	void putTicket(Message message, String ticket, String callNickName, String to, String from){
		try {
			ZuoXiSendRequestObj obj = get(message, ticket, callNickName);
			obj.setTo(to);
			obj.setFrom(from);
			AgoraMessage.zuoXiSendRequest(obj);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private ZuoXiSendRequestObj get(Message message, String ticket, String nickName) throws JSONException, HyphenateException {

		ZuoXiSendRequestObj obj = new ZuoXiSendRequestObj();
		JSONObject ticketObj = new JSONObject(ticket);

		if (!ticketObj.isNull("isThirdAgent")){
			// 老板本没有isThirdAgent字段
			boolean isThirdAgent = ticketObj.getBoolean("isThirdAgent");
			obj.setIsAddThreeUser(isThirdAgent);

			if (ticketObj.has("agentTicket")){
				JSONObject agentTicket = ticketObj.getJSONObject("agentTicket");
				if (agentTicket.has("trueName")){
					obj.setThreeTrueName(agentTicket.getString("trueName"));
					obj.setThreeNiceName(agentTicket.getString("niceName"));
					obj.setThreeUid(agentTicket.getInt("uid"));
					obj.setThreeCallId(agentTicket.getInt("callId"));
				}
			}
		}

		// nickname
		obj.setNiceName(ticketObj.getString("niceName"));
		// trueName
		obj.setTrueName(ticketObj.getString("trueName"));
		// callId
		obj.setCallId(ticketObj.getInt("callId"));
		// uid
		obj.setUid(ticketObj.getInt("uid"));
		// token
		obj.setToken(ticketObj.getString("token"));
		// appId
		obj.setAppId(ticketObj.getString("appId"));
		// channel
		obj.setChannel(ticketObj.getString("channel"));

		// 座席端名
		if(TextUtils.isEmpty(nickName) || "null".equalsIgnoreCase(nickName)){
			obj.setNickName(TextUtils.isEmpty(obj.getThreeTrueName()) ? obj.getThreeNiceName() : obj.getThreeTrueName());
		}else {
			obj.setNickName(nickName);
		}

		return obj;
	}


	/**
	 * 挂断视频
	 * @param callId callId
	 * @param isConnected 是否已经接通
	 */
	public void endCall(int callId, boolean isConnected) {
		String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
		Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
		ChatManager.getInstance().sendMessage(message);

		exit(null);
	}

	public void endVecCall(int callId, boolean isConnected) {
		// 发送关闭
		String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
		Message message = isConnected ? Message.createVecCancelVideoMessage(callId, to) : Message.createVecHangUpVideoMessage(callId, to);
		ChatManager.getInstance().sendMessage(message);

		exit(null);
	}

	public void createFlatRoom(int callId) {
		String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
		Message message = Message.createFlatRoomMessage(callId, to);
		ChatManager.getInstance().sendMessage(message);

	}

	public void endCall(int callId, boolean isConnected, Callback callback) {
		String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
		Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
		ChatManager.getInstance().sendMessage(message, callback);

		exit(null);
	}

	/**
	 * 发起视频通话
	 * @param chatInviteShoe
	 * @param toChatUsername
	 */
	public void callVideo(String chatInviteShoe, String toChatUsername){
		Message message = Message.createVideoInviteSendMessage(chatInviteShoe, toChatUsername);
		ChatClient.getInstance().chatManager().sendMessage(message);
	}

	public void callVecVideo(String chatInviteShoe, String toChatUsername){
		Message message = Message.createVecVideoInviteSendMessage(chatInviteShoe, toChatUsername);
		ChatClient.getInstance().chatManager().sendMessage(message);
	}


	static class TicketEntity{
		String ticket;
		String nickname;
		JSONObject extendJson;
		TicketEntity(String ticket, String nick, JSONObject extend){
			this.ticket = ticket;
			this.nickname = nick;
			this.extendJson = extend;
		}
	}


	/**
	 * 获取对方的昵称
	 * @return 昵称
	 */
	public String getCallNickName(){
		return callNickName;
	}

	private void exit(final Callback callback){
		callNickName = null;
		callOption.isVideoOff = false;
		callOption.isMute = false;
	}
}
