package com.hyphenate.chat;


import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMError;
import com.hyphenate.helpdesk.Error;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.manager.EmojiconManager;
import com.hyphenate.helpdesk.manager.TicketManager;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ChatClient {
    public final static String TAG = "ChatClient";
    private static ChatClient instance = new ChatClient();
    private EMClient _client = null;
    private ChatManager chatManager = null;
    private CallManager callManager = null;
    private TicketManager leaveMsgManager = null;
    private EmojiconManager emojiconManager = null;
    private final List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private String userName = null;
    private boolean isInitialized = false;
    private String tenantId = null;
    private String configId = null;
    public static boolean multiChannel = false;
    private static final String DEFAULT_KEFU_HOST = "https://kefu.easemob.com";
    private String kefuHost;
    boolean hasSecondChannel = true;
    private Context mContext;
    private boolean isDebugMode;
    private final static String sdkVersion = "1.3.2.9";
    boolean isShowAgentInputState;
    boolean isShowVisitorWaitCount;
    boolean isShowMessagePredict;
    private Options mOptions = null;

    /**
     * 是否同时使用im
     */
    private boolean useIm;

    /**
     * 如果是同时使用im 请一定要设置im服务号
     */
    private String imServiceUser;

    public String getImServiceUser() {
        return imServiceUser;
    }

    public boolean isUseIm() {
        return useIm;
    }

    private ChatClient() {

    }

    boolean isCountDownDisconnect(){
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        return dnsConfig != null && dnsConfig.keepAliveTime > 0;
    }

    long getKeepAliveTime(){
        ChatConfig.DnsConfig dnsConfig = ChatConfig.getInstance().getDnsConfig();
        if (dnsConfig != null){
            return dnsConfig.keepAliveTime;
        }
        return -1;
    }


    public static ChatClient getInstance() {
        return instance;
    }

    public Options getOptions() { return  mOptions; }


    Context getContext(){
        if (mContext != null){
            return mContext;
        }

        mContext = _client.getContext();
        return mContext;
    }


    /**
     * 获取服务器地址
     * @return 服务器地址
     * @see #kefuRestServer()
     */
    @Deprecated
    public String getKefuServerAddress(){
        return kefuRestServer();
    }

    /**
     * 获取服务器地址
     * @return 服务器地址
     */
    public String kefuRestServer() {
        if (TextUtils.isEmpty(kefuHost)){
            kefuHost = DEFAULT_KEFU_HOST;
        }
        return kefuHost;
    }

    /**
     * 初始化
     * @param context appContext
     * @param options 初始化选项
     * @param runProcessName 在指定的进程内初始化
     * @return 是否成功
     */
    public synchronized boolean init(final Context context,final Options options, String runProcessName) {
        if (isInitialized) {
            android.util.Log.e(TAG, "sdk already initialized");
            return false;
        }
        if (context == null) {
            android.util.Log.e(TAG, "init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e(TAG, "init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty(options.appkey)) {
            android.util.Log.e(TAG, "init fail, appkey is null");
            return false;
        }
        mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        // String processAppName = getAppName(context.getApplicationContext());
        String processAppName = ProcessUtils.getCurrentProcessName();

        kefuHost = options.kefuHost;
        android.util.Log.d(TAG, "process app name : " + processAppName);

        // 如果app启用了远程的service，此application:onCreate会被调用2次
        // 为了防止环信SDK被初始化2次，加此判断会保证SDK被初始化1次
        // 默认的app会在以包名为默认的process name下运行，如果查到的process name不是app的process name就立即返回
        if (processAppName == null || !processAppName.endsWith(runProcessName)) {
            android.util.Log.e(TAG, "enter the service process!");
            // 则此application::onCreate 是被service 调用的，直接返回
            return false;
        }
        /*if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e(TAG, "enter the service process!");
            // 则此application::onCreate 是被service 调用的，直接返回
            return false;
        }*/
        _client = com.hyphenate.chat.EMClient.getInstance();
        final com.hyphenate.chat.EMOptions emoptions = new com.hyphenate.chat.EMOptions();
//        emoptions.setRequireAck(false);
        emoptions.setAppKey(options.appkey);
        // emoptions.setUseHttps(options.getUseHttps());
        emoptions.setUsingHttpsOnly(options.getUseHttps());

        emoptions.setAutoLogin(options.isAutoLogin);
        if (!TextUtils.isEmpty(options.mipushAppid) && !TextUtils.isEmpty(options.mipushAppKey)){
            emoptions.setMipushConfig(options.mipushAppid, options.mipushAppKey);
            android.util.Log.d(TAG, "mipush appid:" + options.mipushAppid + ",appkey:" + options.mipushAppKey);
        }

        if (!TextUtils.isEmpty(options.fcmNumber)){
            emoptions.setFCMNumber(options.fcmNumber);
            android.util.Log.d(TAG, "fcm number:" + options.fcmNumber);
        }

        if(!TextUtils.isEmpty(options.restHost)){
            emoptions.setRestServer(options.restHost);
        }

        if(!TextUtils.isEmpty(options.imHost)){
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0){
            emoptions.setImPort(options.imPort);
        }
        tenantId = options.tenantId;
        configId = options.configId;
        isShowAgentInputState = options.showAgentInputState;
        isShowVisitorWaitCount = options.showVisitorWaitCount;
        isShowMessagePredict = options.showMessagePredict;
        isDebugMode = options.consoleLogEnable;
        if(options.isUseFcm){
            emoptions.setUseFCM(options.isUseFcm);
        }
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        _client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        chatManager = ChatManager.getInstance();
        try{
            if (Class.forName("com.hyphenate.chat.CallManager") != null){
                callManager = CallManager.getInstance();
            }
        }catch (ClassNotFoundException e){
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString(e));
        }catch (Exception ignored){}
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        // isLoggedIn
        if (isLoggedInBefore()){
            if (options.isAutoLogin) {
                final String lastLoginUser = currentUserName();
//            EMLog.d(TAG, "lastLoginUser:" + lastLoginUser);
                if (!TextUtils.isEmpty(lastLoginUser)) {
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                String token = PreferenceUtil.getInstance().getToken();
                                String imToken = imAccessToken();
                                if (token == null) {
                                    if (imToken != null) {
                                        PreferenceUtil.getInstance().setToken(imToken);
                                    } else {
                                        String password = PreferenceUtil.getInstance().getPassword();
                                        if (!TextUtils.isEmpty(password)) {
                                            EMLog.d(TAG, "load lastLoginUser");
                                            login(lastLoginUser, password, null);
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                EMLog.e(TAG, android.util.Log.getStackTraceString(e));
                            }
                        }
                    }).start();

                    initUserData(context, options, lastLoginUser);
                    chatManager().registerCountDown();
                    long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                    if (triggerEventTime > 0) {
                        CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                    } else {
                        CountDownUtils.getInstance().sendBroadcast();
                    }

                    getEmojiconManager();
                }
            } else {
                EMLog.d(TAG, "autoLogin is not enabled");
                cleanCache();
            }

        }

        ChatConfig.getInstance().loadDnsConfigFromRemote(false);

        com.hyphenate.chat.EMChatManager _emChatManager = _client.chatManager();
        _client.addConnectionListener(new EMConnectionListener() {

            @Override
            public void onConnected() {
                synchronized (connectionListeners){
                    for (ConnectionListener listener : connectionListeners){
                        if (listener != null){
                            listener.onConnected();
                        }
                    }
                    // make sure token will be cached when auto login
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = Error.GENERAL_ERROR;
                switch (errorCode) {
                    case EMError.USER_REMOVED:
                        code = Error.USER_REMOVED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_ALREADY_LOGIN:
                        code = Error.USER_ALREADY_LOGIN;
                        break;
                    case EMError.USER_LOGIN_ANOTHER_DEVICE:
                        code = Error.USER_LOGIN_ANOTHER_DEVICE;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_AUTHENTICATION_FAILED:
                        code = Error.USER_AUTHENTICATION_FAILED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_NOT_FOUND:
                        code = Error.USER_NOT_FOUND;
                        chatManager().kefuLogout();
                        break;
                    default:
                        break;
                }
                notifyOnDisconnected(code);
            }

        });

        leaveMsgManager = TicketManager.getInstance();

        isInitialized = true;
        com.hyphenate.chat.EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    /**
     * 初始化
     * @param context appContext
     * @param options 初始化选项
     * @return 是否成功
     */
    public synchronized boolean init(final Context context,final Options options) {
        if (isInitialized) {
            android.util.Log.e(TAG, "sdk already initialized");
            return false;
        }
        if (context == null) {
            android.util.Log.e(TAG, "init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e(TAG, "init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty(options.appkey)) {
            android.util.Log.e(TAG, "init fail, appkey is null");
            return false;
        }
        mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        // String processAppName = getAppName(context.getApplicationContext());
        String processAppName = ProcessUtils.getCurrentProcessName();

        kefuHost = options.kefuHost;
        android.util.Log.d(TAG, "process app name : " + processAppName);


        // 如果app启用了远程的service，此application:onCreate会被调用2次
        // 为了防止环信SDK被初始化2次，加此判断会保证SDK被初始化1次
        // 默认的app会在以包名为默认的process name下运行，如果查到的process name不是app的process name就立即返回
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e(TAG, "enter the service process!");
            // 则此application::onCreate 是被service 调用的，直接返回
            return false;
        }
        _client = com.hyphenate.chat.EMClient.getInstance();
        final com.hyphenate.chat.EMOptions emoptions = new com.hyphenate.chat.EMOptions();
//        emoptions.setRequireAck(false);
        emoptions.setAppKey(options.appkey);
        // emoptions.setUseHttps(options.isUseHttps);
        emoptions.setUsingHttpsOnly(options.isUseHttps);

        emoptions.setAutoLogin(options.isAutoLogin);
        if (!TextUtils.isEmpty(options.mipushAppid) && !TextUtils.isEmpty(options.mipushAppKey)){
            emoptions.setMipushConfig(options.mipushAppid, options.mipushAppKey);
            android.util.Log.d(TAG, "mipush appid:" + options.mipushAppid + ",appkey:" + options.mipushAppKey);
        }

        if (!TextUtils.isEmpty(options.fcmNumber)){
            emoptions.setFCMNumber(options.fcmNumber);
            android.util.Log.d(TAG, "fcm number:" + options.fcmNumber);
        }

        if(!TextUtils.isEmpty(options.restHost)){
            emoptions.setRestServer(options.restHost);
        }

        if(!TextUtils.isEmpty(options.imHost)){
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0){
            emoptions.setImPort(options.imPort);
        }
        tenantId = options.tenantId;
        configId = options.configId;
        isShowAgentInputState = options.showAgentInputState;
        isShowVisitorWaitCount = options.showVisitorWaitCount;
        isShowMessagePredict = options.showMessagePredict;
        isDebugMode = options.consoleLogEnable;
        if(options.isUseFcm){
            emoptions.setUseFCM(options.isUseFcm);
        }
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        _client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        chatManager = ChatManager.getInstance();
        try{
            if (Class.forName("com.hyphenate.chat.CallManager") != null){
                callManager = CallManager.getInstance();
            }
        }catch (ClassNotFoundException e){
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString(e));
        }catch (Exception ignored){}
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        // isLoggedIn
        if (isLoggedInBefore()){
            if (options.isAutoLogin) {
                final String lastLoginUser = currentUserName();
//            EMLog.d(TAG, "lastLoginUser:" + lastLoginUser);
                if (!TextUtils.isEmpty(lastLoginUser)) {
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                String token = PreferenceUtil.getInstance().getToken();
                                String imToken = imAccessToken();
                                if (token == null) {
                                    if (imToken != null) {
                                        PreferenceUtil.getInstance().setToken(imToken);
                                    } else {
                                        String password = PreferenceUtil.getInstance().getPassword();
                                        if (!TextUtils.isEmpty(password)) {
                                            EMLog.d(TAG, "load lastLoginUser");
                                            login(lastLoginUser, password, null);
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                EMLog.e(TAG, android.util.Log.getStackTraceString(e));
                            }
                        }
                    }).start();

                    initUserData(context, options, lastLoginUser);
                    chatManager().registerCountDown();
                    long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                    if (triggerEventTime > 0) {
                        CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                    } else {
                        CountDownUtils.getInstance().sendBroadcast();
                    }

                    getEmojiconManager();
                }
            } else {
                EMLog.d(TAG, "autoLogin is not enabled");
                cleanCache();
            }

        }

        ChatConfig.getInstance().loadDnsConfigFromRemote(false);

        com.hyphenate.chat.EMChatManager _emChatManager = _client.chatManager();
        _client.addConnectionListener(new EMConnectionListener() {

            @Override
            public void onConnected() {
                synchronized (connectionListeners){
                    for (ConnectionListener listener : connectionListeners){
                        if (listener != null){
                            listener.onConnected();
                        }
                    }
                    // make sure token will be cached when auto login
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = Error.GENERAL_ERROR;
                switch (errorCode) {
                    case EMError.USER_REMOVED:
                        code = Error.USER_REMOVED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_ALREADY_LOGIN:
                        code = Error.USER_ALREADY_LOGIN;
                        break;
                    case EMError.USER_LOGIN_ANOTHER_DEVICE:
                        code = Error.USER_LOGIN_ANOTHER_DEVICE;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_AUTHENTICATION_FAILED:
                        code = Error.USER_AUTHENTICATION_FAILED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_NOT_FOUND:
                        code = Error.USER_NOT_FOUND;
                        chatManager().kefuLogout();
                        break;
                    default:
                        break;
                }
                notifyOnDisconnected(code);
            }

        });

        leaveMsgManager = TicketManager.getInstance();

        isInitialized = true;
        com.hyphenate.chat.EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    /**
     * 初始化
     * @param context appContext
     * @param options 初始化选项
     * @param emoptions IM sdk里的EMOptions对象
     * @return 是否成功
     */
    public synchronized boolean init(final Context context,final Options options, com.hyphenate.chat.EMOptions emoptions) {
        if (isInitialized) {
            android.util.Log.e(TAG, "sdk already initialized");
            return false;
        }
        if (context == null) {
            android.util.Log.e(TAG, "init fail, context is null");
            return false;
        }
        if (options == null) {
            android.util.Log.e(TAG, "init fail, options is null");
            return false;
        }
        if (TextUtils.isEmpty(options.appkey)) {
            android.util.Log.e(TAG, "init fail, appkey is null");
            return false;
        }
        mOptions = options;
        this.imServiceUser = options.imServiceUser;
        this.useIm = options.useIm;
        // String processAppName = getAppName(context.getApplicationContext());
        String processAppName = ProcessUtils.getCurrentProcessName();

        kefuHost = options.kefuHost;
        android.util.Log.d(TAG, "process app name : " + processAppName);


        // 如果app启用了远程的service，此application:onCreate会被调用2次
        // 为了防止环信SDK被初始化2次，加此判断会保证SDK被初始化1次
        // 默认的app会在以包名为默认的process name下运行，如果查到的process name不是app的process name就立即返回
        if (processAppName == null || !processAppName.equalsIgnoreCase(context.getPackageName())) {
            android.util.Log.e(TAG, "enter the service process!");
            // 则此application::onCreate 是被service 调用的，直接返回
            return false;
        }
        _client = com.hyphenate.chat.EMClient.getInstance();
        //final com.hyphenate.chat.EMOptions emoptions = new com.hyphenate.chat.EMOptions();
//        emoptions.setRequireAck(false);
        emoptions.setAppKey(options.appkey);
        // emoptions.setUseHttps(false)

        emoptions.setAutoLogin(options.isAutoLogin);
        if (!TextUtils.isEmpty(options.mipushAppid) && !TextUtils.isEmpty(options.mipushAppKey)){
            emoptions.setMipushConfig(options.mipushAppid, options.mipushAppKey);
            android.util.Log.d(TAG, "mipush appid:" + options.mipushAppid + ",appkey:" + options.mipushAppKey);
        }

        if (!TextUtils.isEmpty(options.fcmNumber)){
            emoptions.setFCMNumber(options.fcmNumber);
            android.util.Log.d(TAG, "fcm number:" + options.fcmNumber);
        }

        if(!TextUtils.isEmpty(options.restHost)){
            emoptions.setRestServer(options.restHost);
        }

        if(!TextUtils.isEmpty(options.imHost)){
            emoptions.setIMServer(options.imHost);
        }
        if (options.imPort > 0){
            emoptions.setImPort(options.imPort);
        }
        tenantId = options.tenantId;
        configId = options.configId;
        isShowAgentInputState = options.showAgentInputState;
        isShowVisitorWaitCount = options.showVisitorWaitCount;
        isShowMessagePredict = options.showMessagePredict;
        isDebugMode = options.consoleLogEnable;
        if(options.isUseFcm){
            emoptions.setUseFCM(options.isUseFcm);
        }
        long currentTime = System.currentTimeMillis();
        PreferenceUtil.getInstance().init(context);
        CountDownUtils.getInstance().init(context);
        if (options.pushConfig != null) {
            emoptions.setPushConfig(options.pushConfig);
        }
        _client.init(context, emoptions);
        EMLog.d(TAG, "im init time(ms):" + (System.currentTimeMillis() - currentTime));
        chatManager = ChatManager.getInstance();
        try{
            if (Class.forName("com.hyphenate.chat.CallManager") != null){
                callManager = CallManager.getInstance();
            }
        }catch (ClassNotFoundException e){
            EMLog.d(TAG, "" + android.util.Log.getStackTraceString(e));
        }catch (Exception ignored){}
        ChatConfig.getInstance().loadLocalDnsConfig();
        EMLog.d(TAG, "loadLocalDnsConfig finished");
        // isLoggedIn
        if (isLoggedInBefore()){
            if (options.isAutoLogin) {
                final String lastLoginUser = currentUserName();
//            EMLog.d(TAG, "lastLoginUser:" + lastLoginUser);
                if (!TextUtils.isEmpty(lastLoginUser)) {
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                String token = PreferenceUtil.getInstance().getToken();
                                String imToken = imAccessToken();
                                if (token == null) {
                                    if (imToken != null) {
                                        PreferenceUtil.getInstance().setToken(imToken);
                                    } else {
                                        String password = PreferenceUtil.getInstance().getPassword();
                                        if (!TextUtils.isEmpty(password)) {
                                            EMLog.d(TAG, "load lastLoginUser");
                                            login(lastLoginUser, password, null);
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                EMLog.e(TAG, android.util.Log.getStackTraceString(e));
                            }
                        }
                    }).start();

                    initUserData(context, options, lastLoginUser);
                    chatManager().registerCountDown();
                    long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                    if (triggerEventTime > 0) {
                        CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                    } else {
                        CountDownUtils.getInstance().sendBroadcast();
                    }

                    getEmojiconManager();
                }
            } else {
                EMLog.d(TAG, "autoLogin is not enabled");
                cleanCache();
            }

        }

        ChatConfig.getInstance().loadDnsConfigFromRemote(false);

        com.hyphenate.chat.EMChatManager _emChatManager = _client.chatManager();
        _client.addConnectionListener(new EMConnectionListener() {

            @Override
            public void onConnected() {
                synchronized (connectionListeners){
                    for (ConnectionListener listener : connectionListeners){
                        if (listener != null){
                            listener.onConnected();
                        }
                    }
                    // make sure token will be cached when auto login
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    MarketingHttpClient.asyncRequest();
                }
            }

            @Override
            public void onDisconnected(int errorCode) {
                int code = Error.GENERAL_ERROR;
                switch (errorCode) {
                    case EMError.USER_REMOVED:
                        code = Error.USER_REMOVED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_ALREADY_LOGIN:
                        code = Error.USER_ALREADY_LOGIN;
                        break;
                    case EMError.USER_LOGIN_ANOTHER_DEVICE:
                        code = Error.USER_LOGIN_ANOTHER_DEVICE;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_AUTHENTICATION_FAILED:
                        code = Error.USER_AUTHENTICATION_FAILED;
                        chatManager().kefuLogout();
                        break;
                    case EMError.USER_NOT_FOUND:
                        code = Error.USER_NOT_FOUND;
                        chatManager().kefuLogout();
                        break;
                    default:
                        break;
                }
                notifyOnDisconnected(code);
            }

        });

        leaveMsgManager = TicketManager.getInstance();

        isInitialized = true;
        com.hyphenate.chat.EMClient.getInstance().setDebugMode(options.consoleLogEnable);
        return true;
    }

    private boolean userDataInited = false;
    void initUserData(Context context, Options options, String userName) {
        // load msg db with the last successfully logined user
        PathUtil.getInstance().initDirs(options.appkey, userName, context);
//                EMLog.d(TAG, "start db lastLoginUser:" + lastLoginUser);
        ChatManager.getInstance().initDB(userName);
//                EMLog.d(TAG, "start db finish");
        ChatManager.getInstance().loadDB();
        userDataInited = true;
    }

    void notifyOnDisconnected(int errorCode){
        synchronized (connectionListeners){
            for (ConnectionListener listener : connectionListeners){
                if (listener != null){
                    listener.onDisconnected(errorCode);
                }
            }
        }
    }


    private void getEmojiconManager() {
        if (emojiconManager == null) {
            emojiconManager = EmojiconManager.getInstance();
        }
        emojiconManager.reflesh();
    }

    /**
     * sdk外请勿调用
     */
    public boolean addEmojiconInfo(String tenantId, String iconsJson, String packagesJson) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().addEmojiconInfo(tenantId, iconsJson, packagesJson);
    }
    /**
     * sdk外请勿调用
     */
    public boolean deleteEmojiconInfo(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return false;
        }
        return KefuDBManager.getInstance().deleteEmojiconInfo(tenantId);
    }
    /**
     * sdk外请勿调用
     */
    public String getEmojiconInfoIconsJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoIconsJson(tenantId);
    }
    /**
     * sdk外请勿调用
     */
    public String getEmojiconInfoPackagesJson(String tenantId) {
        if (KefuDBManager.getInstance() == null) {
            return "";
        }
        return KefuDBManager.getInstance().getEmojiconInfoPackagesJson(tenantId);
    }

    /**
     * check the application process name if process name is not qualified, then we think it is a service process and we will not init SDK
     *
     * @param appContext
     * @return
     */
    private String getAppName(Context appContext) {
        try {
            int pid = android.os.Process.myPid();
            String processName = null;
            ActivityManager am = (ActivityManager) appContext.getSystemService(Context.ACTIVITY_SERVICE);
            assert am != null;
            List l = am.getRunningAppProcesses();
            if (l == null){
                android.util.Log.e(TAG, "getRunningAppProcesses is null");
                return null;
            }
            Iterator i = l.iterator();
            PackageManager pm = appContext.getPackageManager();
            while (i.hasNext()) {
                ActivityManager.RunningAppProcessInfo info = (ActivityManager.RunningAppProcessInfo) (i.next());
                try {
                    if (info.pid == pid) {
                        //CharSequence c = pm.getApplicationLabel(pm.getApplicationInfo(info.processName, PackageManager.GET_META_DATA));
                        processName = info.processName;
                        return processName;
                    }
                } catch (Exception ignored) {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 访客登录
     *
     * @param userName 用户名
     * @param password 密码
     * @param callback 回调
     */
    public void login(final String userName, String password,
                      final Callback callback) {
        if (!userDataInited) {
            initUserData(getContext(), mOptions, userName);
        }
        chatManager().login(userName, password, new Callback() {
            @Override
            public void onSuccess() {
                getEmojiconManager();
                if (callback != null){
                    callback.onSuccess();
                }

            }

            @Override
            public void onError(int code, String error) {
                if (callback != null){
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (callback != null){
                    callback.onProgress(progress, status);
                }
            }
        });
    }

    /**
     * 访客token登录
     *
     * @param userName 用户名
     * @param token 令牌
     * @param callback 回调
     */
    public void loginWithToken(final String userName, final String token, final Callback callback) {
        if (!userDataInited) {
            initUserData(getContext(), mOptions, userName);
        }
        chatManager().loginWithToken(userName, token, new Callback() {
            @Override
            public void onSuccess() {
                getEmojiconManager();
                callback.onSuccess();
            }

            @Override
            public void onError(int code, String error) {
                callback.onError(code, error);
            }

            @Override
            public void onProgress(int progress, String status) {
                callback.onProgress(progress, status);
            }
        });
    }

    /**
     * 退出方法
     *
     * 退出后将无法接收客服发来消息
     *
     * @param callback 回调
     */
    public void logout(boolean unbindToken, final Callback callback) {
        chatManager().logout(unbindToken, callback);
    }

    void cleanCache(){
        CountDownUtils.getInstance().cancel();
        emojiconManager().clear();
        this.userName = null;
        userDataInited = false;
        EMLog.d(TAG, "logout and remove all cache");
        PreferenceUtil.getInstance().removeAll();
    }

    /**
     * token登录失败 登出用户
     */
    void loginWithTokenFail() {
        PreferenceUtil.getInstance().removeAll();
        synchronized (connectionListeners){
            for (ConnectionListener listener : connectionListeners){
                if (listener != null){
                    listener.onDisconnected(EMError.USER_AUTHENTICATION_FAILED);
                }
            }
        }
    }

    /**
     * 检测是否账号已经登录
     *
     * 建议在每次登录前都加上,意思是登录过不用再次请求登录.
     *
     * @return 已经登录过 返回true, 未登录 返回false
     */
    public boolean isLoggedInBefore() {
        if (_client == null) {
            EMLog.e(TAG, "please first init");
            return false;
        }

        boolean isLogged = _client.isLoggedInBefore();

        if (isCountDownDisconnect() && !isLogged) {
            String username = PreferenceUtil.getInstance().getUsername();
            String password = PreferenceUtil.getInstance().getPassword();
            String token    = PreferenceUtil.getInstance().getToken();
            boolean isTokenLogin = PreferenceUtil.getInstance().loginWithToken();
            if (!TextUtils.isEmpty(username)) {
                if (isTokenLogin){
                    if (!TextUtils.isEmpty(token)){
                        isLogged = true;
                    }
                }else{
                    if (!TextUtils.isEmpty(password)){
                        isLogged = true;
                    }
                }
            }
        }
        EMLog.d(TAG, "isLoggedIn:" + isLogged);
        return isLogged;
    }

    /**
     * Firebase令牌同步到环信服务器
     * @param token FCM 令牌
     */
    public void sendFCMTokenToServer(String token) {
        EMClient.getInstance().sendFCMTokenToServer(token);
    }

    /**
     * 检测服务器和当前用户是否连通
     *
     * 区别于:方法 isLoggedIn,因为此方法可能已经登录过,只是当前没网,SDK会自动登录不需要再次调用login方法.
     * @see #isLoggedInBefore()
     *
     * @return 服务器和当前账号正常连接返回 true, 当前连接已断开返回false
     */
    @Deprecated
    public boolean isConnected() {
        return _client != null && _client.isConnected();
    }

    /**
     * 为iOS的apns显示昵称而不是ID
     * 同步方法,需要在线程中调用
     *
     * @param userNick 昵称
     */
    public boolean setPushNickname(String userNick) {
        try {
            return EMClient.getInstance().pushManager().updatePushNickname(userNick);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 为iOS的apns显示昵称而不是ID
     * 同步方法,需要在线程中调用
     * @param userNick 昵称
     * @return 是否成功
     * @see #setPushNickname(String)
     */
    @Deprecated
    public boolean updateNickToServer(String userNick) {
        return setPushNickname(userNick);
    }

    /**
     * 注册账号
     * @param userName 用户名
     * @param password 密码
     * @param callback 回调
     */
    public void register(final String userName, final String password,
                         final Callback callback) {
        Thread thread = new Thread(new Runnable() {

            @Override
            public void run() {
                try {
                    _client.createAccount(userName, password);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } catch (com.hyphenate.exceptions.HyphenateException ex) {
                    int errorCode = ex.getErrorCode();
                    EMLog.e(TAG, "error:" + errorCode + ", errorMsg:" + ex.getMessage());
                    if (callback != null) {
                        if (errorCode == EMError.USER_ALREADY_EXIST) {
                            callback.onError(Error.USER_ALREADY_EXIST,
                                    "user already exist");
                        } else if (errorCode == EMError.NETWORK_ERROR) {
                            callback.onError(Error.NETWORK_ERROR,
                                    "network is not available");
                        } else if (errorCode == EMError.USER_AUTHENTICATION_FAILED) {
                            callback.onError(Error.USER_AUTHENTICATION_FAILED,
                                    "register fail without permission");
                        } else if (errorCode == EMError.USER_ILLEGAL_ARGUMENT) {
                            callback.onError(Error.USER_ILLEGAL_ARGUMENT,
                                    "illegal user name");
                        } else {
                            callback.onError(Error.GENERAL_ERROR,
                                    "general error");
                        }
                    }
                }
            }
        });
        thread.start();
    }

    /**
     * 注册账号
     * @param userName 用户名
     * @param password 密码
     * @param callback 回调
     * @see #register(String, String, Callback)
     */
    @Deprecated
    public void createAccount(final String userName, final String password,
                              final Callback callback) {
        register(userName, password, callback);
    }

    /**
     * instead of chatManger
     * @see #chatManager()
     * @return 音视频管理类
     */
    @Deprecated
    public ChatManager getChat() {
        return chatManager();
    }

    /**
     * 获取音视频管理类
     * @return 音视频管理类
     */
    public CallManager callManager(){
        return callManager;
    }

    /**
     * 获取聊天管理类
     * @return 聊天管理类
     */
    public ChatManager chatManager(){
        return chatManager;
    }

    /**
     * 获取留言管理类
     * @return 留言管理类
     */
    public TicketManager leaveMsgManager() {
        return leaveMsgManager;
    }

    /**
     * 获取emojicon管理类
     * @return emojicon管理类
     */
    public EmojiconManager emojiconManager() {
        if (emojiconManager == null) {
            emojiconManager = EmojiconManager.getInstance();
        }
        return emojiconManager;
    }

    /**
     * 获取当前用户名
     * @return 当前用户名
     */
    public String currentUserName() {
        if (TextUtils.isEmpty(userName)){
            if (_client.isLoggedInBefore()){
                userName = _client.getCurrentUser();
            }else{
                if (isCountDownDisconnect()){
                    userName = PreferenceUtil.getInstance().getUsername();
                }
            }
        }
        return userName;
    }

    /**
     * 获取当前用户名
     * @return 当前用户名
     * @see #currentUserName()
     */
    @Deprecated
    public String getCurrentUserName() {
        return currentUserName();
    }

    /**
     * 动态修改appkey,只能未登录状态修改,否则会抛出异常
     * @param appKey 动态修改appkey
     */
    public void changeAppKey(String appKey) throws com.hyphenate.exceptions.HyphenateException {
        com.hyphenate.chat.EMClient.getInstance().changeAppkey(appKey);
    }

    /**
     * 修改租户id
     * @param newTenantId 租户id
     */
    public void changeTenantId(String newTenantId) {
        if (newTenantId == null){
            EMLog.e(TAG, "tenant id is set null");
            return;
        }
        if (!TextUtils.isDigitsOnly(newTenantId)){
            throw new IllegalArgumentException("tenantid is digit");
        }

        if (tenantId == null || !tenantId.equals(newTenantId)){
            this.tenantId = newTenantId;
            ChatConfig.getInstance().loadDnsConfigFromRemote(true);
        }
    }

    public void changeConfigId(String configId){
        this.configId = configId;
    }

    /**
     * 修改租户id
     * @param newTenantId 租户id
     * @see #changeTenantId(String)
     */
    @Deprecated
    public void setTenantId(String newTenantId) {
        changeTenantId(newTenantId);
    }

    /**
     * 获取租户id
     * @return 租户id
     */
    public String tenantId(){
        return tenantId;
    }

    public String getConfigId(){
        return configId;
    }

    /**
     * 获取租户id
     * @return 租户id
     * @see #tenantId()
     */
    @Deprecated
    public String getTenantId(){
        return tenantId();
    }

    /**
     * 获取登录token, 该token为本地token
     * @return token
     */
    public String accessToken() {
        if (_client != null){
            String token = PreferenceUtil.getInstance().getToken();
            return token;
        }
        return null;

    }

    /**
     * 获取登录token, 如果IM token不存在会触发从服务器取，请确保登录后再调用该api
     * @return token
     */
    public String imAccessToken(){
        if(_client.isLoggedInBefore()){
            return _client.getOptions().getAccessToken();
        }
        return null;
    }

    /**
     * 获取登录token
     * @return token
     * @see #accessToken()
     */
    @Deprecated
    public String getAccessToken(){
        return accessToken();
    }

    /**
     * 获取sdk版本号
     * @return sdk版本号
     */
    public String sdkVersion() {
        return sdkVersion;
    }

    /**
     * 获取sdk版本号
     * @return sdk版本号
     * @see #sdkVersion()
     */
    @Deprecated
    public String getSDKVersion() {
        return sdkVersion();
    }

    /**
     * 获取IM sdk版本号
     * @return IM sdk版本号
     */
    public String iMSdkVersion() {
        if (_client != null){
            return _client.getOptions().getVersion();
        }
        return "";
    }

    /**
     * 获取IM sdk 版本号
     * @return IM sdk版本号
     * @see #iMSdkVersion()
     */
    @Deprecated
    public String getIMSDKVersion(){
        return iMSdkVersion();
    }

    /**
     * 获取appkey
     * @return appkey
     */
    public String appKey() {
        if (_client != null){
            return _client.getOptions().getAppKey();
        }
        return null;
    }

    /**
     * 获取appkey
     * @return appkey
     * @see #appKey()
     */
    @Deprecated
    public String getAppKey() {
        return appKey();
    }

    /**
     * 设置debug 模式
     * 过期接口，现已经挪入初始化Option
     * @param paramBoolean 是否开启debug模式
     */
    @Deprecated
    public void setDebugMode(boolean paramBoolean) {
        isDebugMode = paramBoolean;
        com.hyphenate.chat.EMClient.getInstance().setDebugMode(paramBoolean);
    }

    boolean isDebugMode() {
        return isDebugMode;
    }

    /**
     * 增加消息监听
     * @param listener 消息监听
     */
    public void addConnectionListener(ConnectionListener listener) {
        if(listener == null){
            return;
        }
        if (!connectionListeners.contains(listener)){
            connectionListeners.add(listener);
        }
    }

    /**
     * 移除消息监听
     * @param listener 消息监听
     */
    public void removeConnectionListener(ConnectionListener listener) {
        if (listener == null){
            return;
        }
        if (connectionListeners.contains(listener)){
            connectionListeners.remove(listener);
        }
    }


    public interface ConnectionListener {
        void onConnected();

        void onDisconnected(int errorcode);
    }


    /**
     * 传递appid和token到环信服务器
     * @param appid
     * @param token
     */
    public void sendHMSPushTokenToServer(String appid, String token){
        EMClient.getInstance().sendHMSPushTokenToServer(appid, token);
    }

    /**
     * 初始化Option类
     */
    public static class Options {
        private String appkey = "";
        private String configId = "";
        private String tenantId = "";
        private String mipushAppid = "";
        private String mipushAppKey = "";
        private String kefuHost = DEFAULT_KEFU_HOST;
        private String fcmNumber;
        private boolean showAgentInputState;
        private boolean showVisitorWaitCount;
        private boolean showMessagePredict;

        private String restHost;
        private String imHost;
        private int imPort = -1;
        private boolean consoleLogEnable = false;
        private String mediaHost;
        private String mediaSpecilServer;
        private boolean isUseFcm;
        private EMPushConfig pushConfig;
        private boolean isAutoLogin = true;
        private boolean use2channel = false; // only for some special device
        private String appVersion;
        private Boolean isUseHttps = false;

        /**
         * 是否同时使用im
         */
        private boolean useIm;

        /**
         * 如果是同时使用im 请一定要设置im服务号
         */
        private String imServiceUser;

        /**
         *
         * @param imServiceId 如果是同时使用im 请一定要设置 客服后台app关联中对应的 im服务号
         * @return Options
         */
        public Options setImServiceId(String imServiceId){
            this.imServiceUser = imServiceId;
            return this;
        }

        /**
         * 是否同时使用im
         * @param useIm useIm
         * @return Options
         */
        public Options setUseIm(boolean useIm){
            this.useIm = useIm;
            return this;
        }

        public Options setUsingHttpsOnly(boolean isUseHttps){
            this.isUseHttps = isUseHttps;
            return this;
        }

        public Boolean getUseHttps() {
            return isUseHttps;
        }

        public Options setPushConfig(EMPushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        /**
         * 设置appkey
         * @param appkey appkey
         * @return this
         */
        public Options setAppkey(String appkey) {
            this.appkey = appkey;
            return this;
        }

        public Options setConfigId(String configId) {
            this.configId = configId;
            return this;
        }

        /**
         * 设置租户id
         * @param tenantId 租户id
         * @return this
         */
        public Options setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        /**
         * 小米推送设置
         * {see setPushConfig}
         * @param mipushAppid mipush appid
         * @param mipushAppKey mipush appkey
         * @return this
         */
        @Deprecated
        public Options setMipushConfig(String mipushAppid, String mipushAppKey){
            this.mipushAppid = mipushAppid;
            this.mipushAppKey = mipushAppKey;
            return this;
        }

        /**
         * 设置音视频服务器地址
         * @param mediaHost
         * @param mediaSpecilServer
         * @return
         */
        public Options setMediaServer(String mediaHost, String mediaSpecilServer){
            this.mediaHost = mediaHost;
            this.mediaSpecilServer = mediaSpecilServer;
            return this;
        }

        /**
         * 设置FCM 号码 {see setPushConfig}
         * @param fcmNumber fcm号码
         */
        @Deprecated
        public Options setFCMNumber(String fcmNumber){
            this.fcmNumber = fcmNumber;
            return this;
        }

        /**
         * {see setPushConfig}
         * @param isUseFcm
         * @return
         */
        @Deprecated
        public Options setUseFCM(boolean isUseFcm){
            this.isUseFcm = isUseFcm;
            return this;
        }


        /**
         * 坐席输入状态显示功能开关 调用此方法开启
         * @return this
         */
        public Options showAgentInputState(){
            this.showAgentInputState = true;
            return this;
        }

        /**
         * 显示访客等待数功能开关 调用此方法开启
         * @return this
         */
        public Options showVisitorWaitCount(){
            this.showVisitorWaitCount = true;
            return this;
        }

        /**
         * 消息预知功能开关 调用此方法开启
         * @return this
         */
        public Options showMessagePredict() {
            this.showMessagePredict = true;
            return this;
        }

        /**
         * 服务器地址设置
         * @param restServer 服务器地址
         * @return this
         */
        public Options setKefuRestServer(String restServer){
            if(!restServer.contains("http")){
                kefuHost = "http://" + restServer;
            }else{
                kefuHost = restServer;
            }
            EMLog.d(TAG, "set kefu host:" + kefuHost);
            return this;
        }

        /**
         * 服务器地址设置
         * @param restServer 服务器地址
         * @return this
         * @see #setKefuRestServer(String)
         */
        @Deprecated
        public Options setKefuServerAddress(String restServer){
            return setKefuRestServer(restServer);
        }

        public Options setRestServer(String restServer){
            restHost = restServer;
            return this;
        }

        public Options setChatServer(String imServer) {
            imHost = imServer;
            return this;
        }

        @Deprecated
        public Options setIMServer(String imServer){
            return setChatServer(imServer);
        }

        public Options setChatPort(int imPort) {
            this.imPort = imPort;
            return this;
        }

        @Deprecated
        public Options setIMPort(int imPort){
            return setChatPort(imPort);
        }

        /**
         * 设置debug模式
         * @param enable
         * @return this
         */
        public Options setConsoleLog(boolean enable) {
            this.consoleLogEnable = enable;
            return this;
        }

        public boolean isAutoLogin() {
            return isAutoLogin;
        }

        /**
         * 设置是否开启自动登录
         * @param autoLogin, 默认为true
         * @return this
         */
        public Options setAutoLogin(boolean autoLogin) {
            isAutoLogin = autoLogin;
            return this;
        }

        public String getAppVersion() {
            return appVersion;
        }

        /**
         * 设置application 版本号，设置后上报设备信息时会带上该版本号
         * @param appVersion, 应用版本号
         */
        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public boolean isUse2channel() {
            return use2channel;
        }

        public void setUse2channel(boolean use2channel) {
            this.use2channel = use2channel;
        }
    }

}
