package com.hyphenate.chat;

import android.text.TextUtils;

import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.util.EMLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by liyuzhao on 10/01/2017.
 */
class ChatConfig {

    private static final String TAG = "chat_config";
    private volatile DnsConfig dnsConfig;

     DnsConfig getDnsConfig() {
        return dnsConfig;
    }

     void loadLocalDnsConfig() {
        if (dnsConfig == null) {
            String serverJson = PreferenceUtil.getInstance().getServerJson();
            if (serverJson != null) {
                try {
                    JSONObject jsonObject = new JSONObject(serverJson);
                    String fileVersion = jsonObject.optString(Constants.DNS_MAPPING_KEY_FILE_VERSION);
                    long keepAliveTime = jsonObject.optLong(Constants.DNS_MAPPING_KEY_KEEP_ALIVE_TIME);
                    long updateTime = jsonObject.optLong(Constants.DNS_MAPPING_KEY_UPDATE_TIME);
                    long freeRequestTime = Constants.DNS_DEFAULT_FREEZE_REQUEST_TIME;
                    if (jsonObject.has(Constants.DNS_MAPPING_KEY_FREEZE_REQUEST_TIME)){
                        freeRequestTime  = jsonObject.getLong(Constants.DNS_MAPPING_KEY_FREEZE_REQUEST_TIME);
                    }
                    dnsConfig = new DnsConfig(fileVersion, keepAliveTime, freeRequestTime, updateTime);
                    EMLog.d(TAG, "load dns config success:" + fileVersion + ", keepAliveTime:" + keepAliveTime + " ,freeRequestTime:" + freeRequestTime + ",updateTime:" + updateTime);
                    if (ChatClient.getInstance().isLoggedInBefore()){
                        String username = PreferenceUtil.getInstance().getUsername();
                        if (!TextUtils.isEmpty(username)){
                            KefuDBManager.initDB(username);
                        }
                    }
                } catch (JSONException e) {
                    EMLog.d(TAG, "load local dns config cannot parse json");
                }
            }
        }
    }


    /**
     * 远程获取dns信息
     */
     void loadDnsConfigFromRemote(boolean isforce) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (tenantId == null) {
            return;
        }
        if (!isforce){
            try {
                long currentTime = System.currentTimeMillis();
                if (dnsConfig != null){
                    android.util.Log.d(TAG, "dnsConfig-keepAliveTime:" + dnsConfig.keepAliveTime  + ", freezeRequestTime:" + dnsConfig.freezeRequestTime+ "，dnsConfig.updateTime:" + dnsConfig.updateTime+ ", currentTime:" + currentTime);
                }
                if (dnsConfig != null && dnsConfig.updateTime > 0 && (currentTime - dnsConfig.updateTime) < dnsConfig.freezeRequestTime) {
                    return;
                }
            } catch (Exception ignored) {
            }
        }

        KefuHttpClient.asyncLoadServerDns(tenantId, new ValueCallBack<String>() {
            @Override
            public void onSuccess(String serverJson) {
                try {
                    JSONObject jsonObject = new JSONObject(serverJson);
                    JSONObject jsonEntity = jsonObject.getJSONObject("entity");
                    String fileVersion = jsonEntity.getString(Constants.DNS_MAPPING_KEY_FILE_VERSION);
                    String strConnectKeepTime = jsonEntity.getString(Constants.DNS_MAPPING_KEY_KEEP_ALIVE_TIME);
                    long freezeRequestTime = Constants.DNS_DEFAULT_FREEZE_REQUEST_TIME;
                    if (jsonEntity.has(Constants.DNS_MAPPING_KEY_FREEZE_REQUEST_TIME)){
                        String strFreezeRequestTime = jsonEntity.getString(Constants.DNS_MAPPING_KEY_FREEZE_REQUEST_TIME);
                        try {
                            freezeRequestTime = Long.parseLong(strFreezeRequestTime) * Constants.DNS_DEFAULT_ONE_MINUTE;
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }

                    long keepAliveTime = Long.parseLong(strConnectKeepTime);
                    DnsConfig dnsConfig = new DnsConfig(fileVersion, keepAliveTime, freezeRequestTime);
                    saveDnsConfig(dnsConfig);
                    EMLog.d(TAG, "dns load success: keepAliveTime:" + keepAliveTime + ", freezeRequestTime:" + freezeRequestTime);
                    //再次检测
                    long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                    if (triggerEventTime > 0) {
                        CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                    } else {
                        CountDownUtils.getInstance().sendBroadcast();
                    }
                } catch (JSONException e) {
                    EMLog.d(TAG, "load local dns config cannot parse json");
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.d(TAG, "load dns from remote fail : " + errorMsg);
            }
        });
    }


    /**
     * 保存获取到的新的dns配置文件
     *
     * @param newDnsConfig
     */
    private void saveDnsConfig(DnsConfig newDnsConfig) {
        if (newDnsConfig == null) {
            return;
        }
        this.dnsConfig = newDnsConfig;
        try {
            JSONObject jsonObject = new JSONObject();
            //{"file_version":"1", "connect_keep_time":60}
            jsonObject.put(Constants.DNS_MAPPING_KEY_FILE_VERSION, newDnsConfig.fileVersion);
            jsonObject.put(Constants.DNS_MAPPING_KEY_KEEP_ALIVE_TIME, newDnsConfig.keepAliveTime);
            jsonObject.put(Constants.DNS_MAPPING_KEY_FREEZE_REQUEST_TIME, newDnsConfig.freezeRequestTime);
            jsonObject.put(Constants.DNS_MAPPING_KEY_UPDATE_TIME, newDnsConfig.updateTime);
            PreferenceUtil.getInstance().setServerJson(jsonObject.toString());
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.e(TAG, "" + e.getMessage());
        }
    }

    public static ChatConfig instance = new ChatConfig();

    public static ChatConfig getInstance() {
        return instance;
    }

    class DnsConfig {
        // 文件版本号
        String fileVersion;
        // 保持长链时间(单位：分钟)
        long keepAliveTime;
        // 冻结请求时间(单位：分钟)
        long freezeRequestTime;
        long updateTime;

        DnsConfig(String fileVersion, long keepAliveTime, long freezeRequestTime) {
            this.fileVersion = fileVersion;
            this.keepAliveTime = keepAliveTime;
            this.freezeRequestTime = freezeRequestTime;
            this.updateTime = System.currentTimeMillis();
        }

        DnsConfig(String fileVersion, long keepAliveTime, long freezeRequestTime, long updateTime) {
            this.fileVersion = fileVersion;
            this.keepAliveTime = keepAliveTime;
            this.freezeRequestTime = freezeRequestTime;
            this.updateTime = updateTime;
        }
    }


}
