package com.hyphenate.chat;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMError;
import com.hyphenate.EMMessageListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.Error;
import com.hyphenate.helpdesk.callback.Callback;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.httpclient.ProgressListener;
import com.hyphenate.helpdesk.model.MessageHelper;
import com.hyphenate.helpdesk.util.CopyDirectoryUtil;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.helpdesk.util.ZipUtil;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.UriUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;

/**
 * 聊天功能管理类
 */
public class ChatManager {
    private static final String TAG = "ChatManager";

    private final List<MessageListener> messageListeners = Collections.synchronizedList(new ArrayList<MessageListener>());
    private final List<AgentInputListener> agentInputListeners = Collections.synchronizedList(new ArrayList<AgentInputListener>());
    private final List<VisitorWaitListener> visitorWaitCountListeners = Collections.synchronizedList(new ArrayList<VisitorWaitListener>());
    private ScheduledExecutorService agentInputThread;
    private ScheduledExecutorService visitorWaitThread;
    private static ChatManager instance = new ChatManager();
    private ExecutorService sendMsgThread = Executors.newCachedThreadPool();
    private ExecutorService downloadThreadPool = Executors.newCachedThreadPool();
    private Hashtable<String, Object> sendLocks;
    private static final int WAIT_TIME_OUT = 20; // send message and wait ack 20s timeout
    private static final int WAIT_TIME_ATTACHMENT_MIN = 20;
    private static final int WAIT_TIME_ATTACHEMENT_MAX = 60;
    private static final int WAIT_TIME_OUT_TYPE_TXT = 10; // send message txt and wait ack 10s timeout
    private final String SEND_EXT_MSG_ID_FOR_ACK = "msg_id_for_ack";
    private final String ACK_FOR_MSG_ID = "ack_for_msg_id";
    volatile static String currentChatUsername;
    private ExecutorService loginSingleExecutor = Executors.newSingleThreadExecutor();
    private JSONObject latestSendWeichat;
    private Map<String, String> sessionStates = new HashMap<String, String>();

    String currentChatUsername() {
        return currentChatUsername;
    }


    private synchronized void notifySendLock(String messageId){
        if(sendLocks == null){
            return;
        }
        Object lock = sendLocks.remove(messageId);
        if(lock != null){
            synchronized(lock){
                lock.notifyAll();
            }
        }
    }


    /**
     * 获取最近一条发送的消息的weichat扩展
     * @return
     */
    JSONObject getLatestSendWeichat(){
        return latestSendWeichat;
    }


    private synchronized void addSendLock(String messageId, Object lock){
        if(sendLocks == null){
            sendLocks = new Hashtable<String, Object>();
        }
        sendLocks.put(messageId, lock);
    }



    private List<Message>  convertEMMessagesToMessages(List<EMMessage> emMessages){
        List<Message> tempMsgs = new ArrayList<Message>();
        for (final EMMessage msg : emMessages){
            final Message tempMsg = convertToMessage(msg);
            String taskId = tempMsg.getMarketingTaskId();
            MarketingHttpClient.asyncDelivered(taskId, tempMsg.from());
            tempMsgs.add(tempMsg);
        }
        return tempMsgs;
    }

    private List<Message> siftKefuMessages(List<Message> messages){
        List<Message> tempMsgs = new ArrayList<Message>();
        for (Message tempMsg: messages){
            String ackForMsgId = checkKefuMessageAck(tempMsg);
            if (ackForMsgId != null){
                notifySendLock(ackForMsgId);
            }else{
                Message message = checkIsExistMessage(tempMsg);
                if (message != null){
                    tempMsgs.add(message);
                }
            }
        }
        return tempMsgs;
    }

    synchronized Message checkIsExistMessage(Message message){
        String kefuExtMsgId = getKefuExtMsgId(message);
        if(kefuExtMsgId != null){
            boolean isExists = true;
            if (KefuDBManager.getInstance() == null) {
                return null;
            }
            isExists = KefuDBManager.getInstance().isMessageExistedByExtMsgId(kefuExtMsgId);
            EMLog.d(TAG, "im-msgid:" + message.getIMMsgId() + ", kefuExtMsgId:" + kefuExtMsgId + ",isExists:" + isExists);
            if(!isExists){
                message.setUnread(true);
                if(!MessageHelper.isNotificationMessage(message)){
                    message.setStatus(Message.Status.SUCCESS);
                    KefuConversationManager.getInstance().saveMessage(message);
                    return message;
                }
            }
        }else{
            message.setUnread(true);
            if(!MessageHelper.isNotificationMessage(message)){
                message.setStatus(Message.Status.SUCCESS);
                KefuConversationManager.getInstance().saveMessage(message);
                return message;
            } else if (MessageHelper.isTicketStatusChangedMessage(message)) {
                message.setStatus(Message.Status.SUCCESS);
                return message;
            }
        }

        return null;
    }





    private ChatManager(){
        EMClient.getInstance().chatManager()
                .addMessageListener(new EMMessageListener() {

                    @Override
                    public void onMessageReceived(List<EMMessage> messages) {
                        List<Message> tempMsgs = convertEMMessagesToMessages(messages);
                        publishNewMessage(siftKefuMessages(tempMsgs));
                    }

                    @Override
                    public void onMessageRead(
                            List<EMMessage> messages) {
                        CountDownUtils.getInstance().sendBroadcast();
                        synchronized (messageListeners) {
                            for (MessageListener listener : messageListeners) {
                                listener.onMessageStatusUpdate();
                            }
                        }
                    }

                    @Override
                    public void onMessageDelivered(
                            List<EMMessage> messages) {
                        CountDownUtils.getInstance().sendBroadcast();
                        synchronized (messageListeners) {
                            for (MessageListener listener : messageListeners) {
                                listener.onMessageStatusUpdate();
                            }
                        }

                    }

                    // 消息撤回
                    @Override
                    public void onMessageRecalled(List<EMMessage> list) {
                        CountDownUtils.getInstance().sendBroadcast();
                        synchronized (messageListeners) {
                            for (MessageListener listener : messageListeners) {
                                listener.onMessageStatusUpdate();
                            }
                        }
                    }

                    @Override
                    public void onMessageChanged(EMMessage message,
                                                 Object change) {
                        CountDownUtils.getInstance().sendBroadcast();
                        if(message.getBody() instanceof EMFileMessageBody){
                            Message kefuMessage = convertToMessage(message);
                            updateMessageState(kefuMessage);
                        }

                        synchronized (messageListeners) {
                            for (MessageListener listener : messageListeners) {
                                listener.onMessageStatusUpdate();
                            }
                        }
                    }

                    @Override
                    public void onCmdMessageReceived(List<EMMessage> messages) {
                        List<Message> tempMsgs = new ArrayList<Message>();
                        for (EMMessage msg : messages){
                            Message tempMsg = convertToMessage(msg);
                            if (KefuDBManager.getInstance() == null) {
                                continue;
                            }
                            if (KefuDBManager.getInstance().isExistCmdMessage(tempMsg.messageId())){
                                continue;
                            }
                            boolean isInserted = KefuDBManager.getInstance().insertCmdMessage(tempMsg);
                            if (!isInserted){
                                Log.e(TAG, "message insert failed:" + tempMsg.toString());
                                continue;
                            }
                            String ackForMsgId = checkKefuMessageAck(tempMsg);
                            if(ackForMsgId != null){
                                notifySendLock(ackForMsgId);
                            }else{
                                //是否为消息撤回的命令消息
                                if (isReCallCmdMessage(tempMsg)){
                                    notifyReCallMessage(tempMsg);
                                } else{
                                    EMCmdMessageBody cmdBody = (EMCmdMessageBody) tempMsg.body();
                                    String action = cmdBody.action();
                                    EMLog.d(TAG, "session event: " + action);
                                    if (!TextUtils.isEmpty(action)){
                                        sessionStates.put(currentChatUsername, action);

                                        if (action.equals("ServiceSessionOpenedEvent")){
                                            sendDeviceInfo(tempMsg.from());
                                            if (!TextUtils.isEmpty(currentChatUsername)){
                                                showVisitorWaitCountAndAgentInputState(currentChatUsername);
                                            }
                                        }else if (action.equals("ServiceSessionClosedEvent")){
                                            // pass
                                            shutdownWaitAndInput();
                                            if (!TextUtils.isEmpty(currentChatUsername) && !currentChatUsername.contains(OfficialAccount.SEPARATOR)){
                                                getConversation(currentChatUsername).clearOfficialAccount();
                                            }
                                        }else if (action.equalsIgnoreCase("ServiceSessionCreatedEvent")){
                                            if (!TextUtils.isEmpty(currentChatUsername)){
                                                showVisitorWaitCountAndAgentInputState(currentChatUsername);
                                            }
                                        }else if (action.equalsIgnoreCase("ServiceSessionTransferedEvent")){
                                            if (!TextUtils.isEmpty(currentChatUsername)){
                                                showVisitorWaitCountAndAgentInputState(currentChatUsername);
                                            }
                                        }else if (action.equalsIgnoreCase("ServiceSessionAbortedEvent")){
                                            shutdownWaitAndInput();
                                            if (!TextUtils.isEmpty(currentChatUsername) && !currentChatUsername.contains(OfficialAccount.SEPARATOR)){
                                                getConversation(currentChatUsername).clearOfficialAccount();
                                            }
                                        }else if (action.equalsIgnoreCase("ServiceSessionTransferedToAgentQueueEvent")){
                                            if (!TextUtils.isEmpty(currentChatUsername)){
                                                showVisitorWaitCountAndAgentInputState(currentChatUsername);
                                            }
                                        }
                                    }
                                    tempMsgs.add(tempMsg);
                                }
                            }
                        }
                        publishCmdMessage(tempMsgs);
                    }
                });
    }

    private JSONObject getVideoInviteTicket(Message message){
        try {
//            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("sendVisitorTicket").getString("ticket");
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("sendVisitorTicket");
        } catch (Exception ignored) {
        }
        return null;
    }

    private JSONObject getKefuRtcCallbackRinging(Message message) {
        try {
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("KefuRtcCallbackRinging");
        } catch (Exception ignored) {
        }
        return null;
    }

    private JSONObject getSendVisitorCallbackTicket(Message message) {
        try {
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("sendVisitorCallbackTicket");
        } catch (Exception ignored) {
        }
        return null;
    }

    private JSONObject getAgentCancelCallback(Message message) {
        try {
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("agentCancelCallback");
        } catch (Exception ignored) {
        }
        return null;
    }

    private JSONObject getVisitorCancelInvitation(Message message) {
        try {
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("visitorCancelInvitation");
        } catch (Exception ignored) {
        }
        return null;
    }

    private JSONObject getVisitorRejectInvitation(Message message) {
        try {
            return message.getJSONObjectAttribute(Message.KEY_MSGTYPE).getJSONObject("visitorRejectInvitation");
        } catch (Exception ignored) {
        }
        return null;
    }

    boolean isReCallCmdMessage(Message message) {
        if (message.getType() == Message.Type.CMD) {
            EMCmdMessageBody body = ((EMCmdMessageBody) message.body());
            String action = body.action();
            if (!TextUtils.isEmpty(action) && action.equals("KEFU_MESSAGE_RECALL")) {
                return true;
            }
        }
        return false;
    }

    void notifyReCallMessage(Message message) {
        if (message.getType() == Message.Type.CMD) {
            try {
                JSONObject jsonObj = message.getJSONObjectAttribute(Message.KEY_WEICHAT);
                if (jsonObj != null && jsonObj.has("recall_msg_id")) {
                    String recallMsgId = jsonObj.getString("recall_msg_id");
                    String msgId = KefuConversationManager.getInstance().getMessageByExtMsgId(recallMsgId);
                    if (!TextUtils.isEmpty(msgId)) {
                        ChatClient.getInstance().chatManager().getConversation(message.from).removeMessage(msgId, false);
                        KefuDBManager.getInstance().recallMessage(msgId);
                    }
                    notifyMessageSent();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    public static synchronized ChatManager getInstance(){
        return instance;
    }

    void loginWithToken(final String username, String token, final EMCallBack callback) {
        if (TextUtils.isEmpty(token)) {
            ChatClient.getInstance().loginWithTokenFail();
            callback.onError(Error.GENERAL_ERROR, "token is null");
            return;
        }

        if(!TextUtils.isEmpty(username)){
            initDB(username);
        } else {
            ChatClient.getInstance().loginWithTokenFail();
            callback.onError(Error.GENERAL_ERROR, "username is null");
            return;
        }

        EMClient.getInstance().loginWithToken(username, token, new EMCallBack() {
            public void onSuccess() {
                loadDB();
                PreferenceUtil.getInstance().setUsername(username);
                PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                PreferenceUtil.getInstance().saveLoginWithToken(true);
                registerCountDown();
                CountDownUtils.getInstance().sendBroadcast();
                ChatConfig.getInstance().loadDnsConfigFromRemote(false);
                if(callback != null){
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String error) {
                ChatClient.getInstance().loginWithTokenFail();
                if(callback != null){
                    callback.onError(code, error);
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if(callback != null){
                    callback.onProgress(progress, status);
                }
            }
        });
    }


    void login(final String username, final String password, final EMCallBack callback){
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty(tenantId)){
            if (callback != null){
                callback.onError(-1, "tenantid is null");
                EMLog.e(TAG, "tenantid is null, please set in option");
            }
            return;
        }
        if (!TextUtils.isDigitsOnly(tenantId)){
            if (callback != null){
                callback.onError(-1, "tenantid must be digits");
            }
            EMLog.e(TAG, "current tenantid is :" + tenantId + ", tenantid must is digits");
            return;
        }
        if(!TextUtils.isEmpty(username)){
            initDB(username);
        }
        EMClient.getInstance().login(username, password, new EMCallBack() {

            @Override
            public void onSuccess() {
                loadDB();
                if (KefuDBManager.getInstance() != null) {
                    KefuDBManager.getInstance().deleteCmdMessages(7);
                }
                PreferenceUtil.getInstance().setUsernameAndPassword(username, password);
                PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                PreferenceUtil.getInstance().saveLoginWithToken(false);
                if (TextUtils.isEmpty(PreferenceUtil.getInstance().getUniqueId())){
                    PreferenceUtil.getInstance().setUniqueId(getDeviceId());
                }
                registerCountDown();
                CountDownUtils.getInstance().sendBroadcast();
                ChatConfig.getInstance().loadDnsConfigFromRemote(false);
                if(callback != null){
                    callback.onSuccess();
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if(callback != null){
                    callback.onProgress(progress, status);
                }
            }

            @Override
            public void onError(int code, String error) {
                if(callback != null){
                    callback.onError(code, error);
                }
            }
        });
    }

    @SuppressLint("MissingPermission")
    private String getDeviceId() {
        String deviceId = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager) ChatClient.getInstance().getContext().getSystemService(Context.TELEPHONY_SERVICE);
	        deviceId = telephonyManager.getDeviceId();
        } catch (Exception ignored) {}
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = UUID.randomUUID().toString();
        }
        return deviceId;
    }



    private int logout(boolean unbindToken){
        int error = EMClient.getInstance().logout(unbindToken);
        if(error != EMError.EM_NO_ERROR){
            return error;
        }
        KefuDBManager.closeDatabase();
        if (sendLocks != null){
            sendLocks.clear();
        }
        KefuConversationManager.getInstance().clear();
        unbindChat();
        ChatClient.getInstance().cleanCache();
        unregisterCountDown();
        return EMError.EM_NO_ERROR;
    }

    void logout(final boolean unbindToken, final EMCallBack callback) {
        new Thread(){
            @Override
            public void run(){
                int error = logout(unbindToken);

                if(error != EMError.EM_NO_ERROR){
                    if(callback != null){
                        callback.onError(error, "faild to unbind device token");
                    }
                }else{
                    unregisterCountDown();
                    kefuLogout();
                    if(callback != null){
                        callback.onSuccess();
                    }
                }
            }
        }.start();
    }


    private CountDownBroadCast broadCastReceiver;

    private void unregisterCountDown(){
        try{
            if (broadCastReceiver != null){
                EMClient.getInstance().getContext().unregisterReceiver(broadCastReceiver);
                broadCastReceiver = null;
            }
        }catch (Exception ignored){}
    }

    void registerCountDown(){
        if (broadCastReceiver == null){
            broadCastReceiver = new CountDownBroadCast();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(CountDownBroadCast.ACTION);
        EMClient.getInstance().getContext().registerReceiver(broadCastReceiver, intentFilter);
    }



    void kefuLogout(){
        KefuDBManager.closeDatabase();
        if (sendLocks != null){
            sendLocks.clear();
        }
        KefuConversationManager.getInstance().clear();
        unbindChat();
        ChatClient.getInstance().cleanCache();
        EMClient.getInstance().logout(false);
        unregisterCountDown();
    }

    void publishNewMessage(List<Message> messages){
        imDataIntercepted(messages);
        if (messages.size() == 0){
            return;
        }

        CountDownUtils.getInstance().sendBroadcast();
        if (messages != null && messages.size() > 0){
            synchronized (messageListeners){
                parseAgora(messages);
                for (MessageListener messageListener : messageListeners){
                    messageListener.onMessage(messages);
                }
            }
        }
    }

    void imDataIntercepted(List<Message> messages){
        if (TextUtils.isEmpty(ChatClient.getInstance().getImServiceUser())){
            return;
        }
        if (messages != null && messages.size() > 0){
            synchronized (messageListeners){
                List<Message> list = new ArrayList<>();
                Iterator<Message> iterator = messages.iterator();
                while (iterator.hasNext()){
                    Message message = iterator.next();
                    if (ChatClient.getInstance().getImServiceUser().equals(message.from)){
                        list.add(message);
                        iterator.remove();
                    }
                }
                // 返回值
                for (MessageListener messageListener : messageListeners){
                    if (messageListener instanceof IMMessageListener){
                        ((IMMessageListener) messageListener).messagesDidIMReceive(list);
                    }
                }
            }
        }
    }

    private void parseAgora(List<Message> messages) {
        for (Message item : messages) {
            try {
                JSONObject msgtype = item.getJSONObjectAttribute("msgtype");
                // 座席端断开视频，// 不使用这个判断座席端发送请求视频
                if (!msgtype.isNull("videoPlayback")){
                    AgoraMessage.zuoXiToBreakOff();
                }

            } catch (HyphenateException e) {
                try {
                    JSONObject weichat = item.getJSONObjectAttribute("weichat");
                    if (!weichat.isNull("html_safe_body")){
                        try {
                            JSONObject html_safe_body = weichat.getJSONObject("html_safe_body");
                            if (!html_safe_body.isNull("msg")){
                                String msg = html_safe_body.getString("msg");
                                if (msg.contains("超时")){
                                    // AgoraMessage.zuoXiTimeOut();
                                }
                            }
                        } catch (JSONException jsonException) {
                            jsonException.printStackTrace();
                        }
                    }
                } catch (HyphenateException hyphenateException) {
                    hyphenateException.printStackTrace();
                }
            }
        }
    }

    void publishCmdMessage(List<Message> allMessages){
        CountDownUtils.getInstance().sendBroadcast();
        for (Message message : allMessages){
            EMCmdMessageBody body = (EMCmdMessageBody) message.body();
            String action = body.action();
            if ("AgentRejectKefuRtcRingingCall".equalsIgnoreCase(action)){
                AgoraMessage.vecBreakOff();
                return;
            }
        }
        List<Message> messages = filterNonofifyCmdMessage(allMessages);
        if (messages != null && messages.size() > 0){
            synchronized (messageListeners) {
                for (MessageListener listener : messageListeners) {
                    listener.onCmdMessage(messages);
                }
            }
        }
    }

    private boolean preLogMode;

    private List<Message> filterNonofifyCmdMessage(List<Message> allMessages) {
        if (!TextUtils.isEmpty(currentChatUsername)){
            AgoraMessage.newAgoraMessage().setCurrentChatUsername(currentChatUsername);
        }
        List<Message> tempMessages = new ArrayList<>();
        for (Message item : allMessages) {
            EMCmdMessageBody body = (EMCmdMessageBody) item.body();
            String action = body.action();
            if (getRoomId(item)){
                continue;
            }

            try {
                String weichat = item.getStringAttribute("weichat");
                JSONObject wc = new JSONObject(weichat);
                if (!wc.isNull("service_session")){
                    JSONObject service_session = wc.getJSONObject("service_session");
                    if (!service_session.isNull("serviceSessionId")){
                        String serviceSessionId = service_session.getString("serviceSessionId");
                        VecConfig.newVecConfig().setSessionId(serviceSessionId);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }


            if (!TextUtils.isEmpty(action)){
                if (AgoraMessage.TYPE_LINK_MESSAGE_PUSH.equalsIgnoreCase(action)){
                    // 标识业务处理类型：LinkMessagePush 信息推送
                    linkMessagePush(item, AgoraMessage.TYPE_LINK_MESSAGE_PUSH);
                    continue;
                }else if (AgoraMessage.TYPE_CARD_OCR.equalsIgnoreCase(action)){
                    // 卡证识别
                    linkMessagePush(item, AgoraMessage.TYPE_CARD_OCR);
                    continue;
                }else if (AgoraMessage.TYPE_ELECSIGN.equalsIgnoreCase(action)){
                    // 电子签名
                    linkMessagePush(item, AgoraMessage.TYPE_ELECSIGN);
                    continue;
                }else if (AgoraMessage.TYPE_IDENTITYAUTH.equalsIgnoreCase(action)){
                    // 身份认证
                    linkMessagePush(item, AgoraMessage.TYPE_IDENTITYAUTH);
                    continue;
                }else if (AgoraMessage.TYPE_ENQUIRYINVITE.equalsIgnoreCase(action)){
                    // 满意度评价，转到CallVideoActivity页面处理
                    // linkMessagePush(item, AgoraMessage.TYPE_ENQUIRYINVITE);
                    try {
                        String msgtype = item.getStringAttribute("msgtype");
                        JSONObject jsonObject = new JSONObject(msgtype);
                        JSONObject enquiryInvite = jsonObject.getJSONObject("enquiryInvite");
                        AgoraMessage.sendEnouiryinvite(enquiryInvite);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                    continue;
                }else if ("RtcSessionCreateEvent".equalsIgnoreCase(action)){
                    // 获取会话rtcSession
                    try{
                        // {"rtcSession":{"callType":0,"rtcSessionId":"eba4a371-588c-493f-b5e1-76daa1971b52","tenantId":77561,"visitorUserId":"afa65674-086c-48f1-83f6-c2b5e3278112"}}
                        String msgType = item.getStringAttribute(Message.KEY_MSGTYPE);
                        JSONObject jsonObject = new JSONObject(msgType);
                        JSONObject rtcSession = jsonObject.getJSONObject("rtcSession");
                        int callType = rtcSession.getInt("callType");
                        String rtcSessionId = rtcSession.getString("rtcSessionId");
                        String tenantId = rtcSession.getString("tenantId");
                        String visitorUserId = rtcSession.getString("visitorUserId");
                        if (callType == 0){
                            VecConfig.newVecConfig().setWaitSessionId(rtcSessionId);
                            VecConfig.newVecConfig().setWaitTenantId(tenantId);

                        }
                        SystemClock.sleep(1000);
                        AgoraMessage.waitResponse(callType, rtcSessionId, tenantId);

                    }catch (Exception e){
                        e.printStackTrace();
                    }
                    continue;
                }else if (AgoraMessage.TYPE_MICROPHONE.equalsIgnoreCase(action)){
                    // 开关麦克风
                    linkMessagePush(item, AgoraMessage.TYPE_MICROPHONE);
                    continue;
                }else if (AgoraMessage.TYPE_CAMERA.equalsIgnoreCase(action)){
                    // 开关摄像头
                    linkMessagePush(item, AgoraMessage.TYPE_CAMERA);
                    continue;
                }else if (AgoraMessage.TYPE_FLASH_LIGHT.equalsIgnoreCase(action)){
                    // 开关手电筒
                    linkMessagePush(item, AgoraMessage.TYPE_FLASH_LIGHT);
                    continue;
                }else if (AgoraMessage.TYPE_FOCUS_CAMERA.equalsIgnoreCase(action)){
                    // 聚焦
                    linkMessagePush(item, AgoraMessage.TYPE_FOCUS_CAMERA);
                    continue;
                } else if (AgoraMessage.TYPE_CAMERA_TORCH_ON.equalsIgnoreCase(action)){
                    // 开关闪光灯
                    linkMessagePush(item, AgoraMessage.TYPE_CAMERA_TORCH_ON);
                    continue;
                }else if (AgoraMessage.TYPE_CAMERA_CHANGE_ON.equalsIgnoreCase(action)){
                    // 切换摄像头
                    linkMessagePush(item, AgoraMessage.TYPE_CAMERA_CHANGE_ON);
                    continue;
                }
            }

            /*JSONObject visitorCancelInvitation = getVisitorCancelInvitation(item);
            Log.e("rrrrrrrr","visitorCancelInvitation = "+visitorCancelInvitation);
            if (visitorCancelInvitation != null){
                try {
                    String callId = visitorCancelInvitation.getString("callId");
                    Log.e("uuuuuuuuuuuu","visitorCancelInvitation callId = "+callId);
                }catch (Exception e){
                    e.printStackTrace();
                }
                continue;
            }

            JSONObject visitorRejectInvitation = getVisitorRejectInvitation(item);
            if (visitorRejectInvitation != null){
                try {
                    String callId = visitorRejectInvitation.getString("callId");
                    Log.e("uuuuuuuuuuuu","visitorRejectInvitation callId = "+callId);
                }catch (Exception e){
                    e.printStackTrace();
                }
                continue;
            }*/

            JSONObject agentCancelCallback = getAgentCancelCallback(item);
            if (agentCancelCallback != null){
                AgoraMessage.vecBreakOff();
                continue;
            }


            JSONObject sendVisitorCallbackTicket = getSendVisitorCallbackTicket(item);
            if (sendVisitorCallbackTicket != null){
                try {
                    if (ChatClient.getInstance().callManager() != null){
                        if (TextUtils.isEmpty(currentChatUsername)){
                            AgoraMessage.newAgoraMessage().setCurrentChatUsername(item.from());
                        }
                        String ticket = sendVisitorCallbackTicket.optString("ticket");
                        String callNickName = sendVisitorCallbackTicket.optString("nickname");
                        ChatClient.getInstance().callManager().putZuoXiSend(item, ticket, callNickName, item.to(), item.from());
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
                continue;
            }

            JSONObject kefuRtcCallbackRinging =  getKefuRtcCallbackRinging(item);
            if (kefuRtcCallbackRinging != null){
                EMLog.d(TAG, "kefuRtcCallbackRinging:" + kefuRtcCallbackRinging.toString());
                try {
                    if (ChatClient.getInstance().callManager() != null){
                        if (TextUtils.isEmpty(currentChatUsername)){
                            AgoraMessage.newAgoraMessage().setCurrentChatUsername(item.from());
                        }
                        String ticket = kefuRtcCallbackRinging.optString("ticket");
                        String callNickName = kefuRtcCallbackRinging.optString("nickname");
                        ChatClient.getInstance().callManager().putZuoXiSend(item, ticket, callNickName, item.to(), item.from());
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
                continue;
            }


            JSONObject inviteVideoJson = getVideoInviteTicket(item);
            if (inviteVideoJson != null){
                EMLog.d(TAG, "inviteVideoJson:" + inviteVideoJson.toString());
                String ticket = inviteVideoJson.optString("ticket");
                String callNickName = inviteVideoJson.optString("nickname");

                try{
                    if (ChatClient.getInstance().callManager() != null){
                        if (TextUtils.isEmpty(currentChatUsername)){
                            AgoraMessage.newAgoraMessage().setCurrentChatUsername(item.from());
                        }
                        // ChatClient.getInstance().callManager().putTicket(new CallManager.TicketEntity(ticket, callNickName, extendJson));
                        ChatClient.getInstance().callManager().putTicket(item, ticket, callNickName, item.to(), item.from());
                    }
                }catch (Exception e){
                    EMLog.e(TAG, "e->" + android.util.Log.getStackTraceString(e));
                }
                continue;
            }

            // 坐席主动邀请
            try {
                JSONObject zuoXiToFangKe = getZuoXiToFangKe(item);
                String msg = zuoXiToFangKe.getString("msg");
                AgoraMessage.zuoXiActiveRequest(msg, item.to(), item.from());
                continue;
            }catch (Exception e){
                e.printStackTrace();
            }


            if (!TextUtils.isEmpty(action)) {
                if (action.equals("easemob_exit")){
                    int code = Error.USER_REMOVED;
                    PreferenceUtil.getInstance().removeAll();
                    ChatClient.getInstance().notifyOnDisconnected(code);
                    continue;
                }else if (action.equals("easemob_startlog")){
                    preLogMode = ChatClient.getInstance().isDebugMode();
                    ChatClient.getInstance().setDebugMode(true);
                    continue;
                }else if (action.equals("easemob_stoplog")){
                    ChatClient.getInstance().setDebugMode(preLogMode);
                    continue;
                }else if (action.equals("easemob_uploadlog")){
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try{
                                Log.e("oooooooooooo","easemob_uploadlog");
                                String tempLogDir = "/sdcard/easemoblog/";
                                String packageName = ChatClient.getInstance().getContext().getPackageName();
                                String appkey = EMClient.getInstance().getOptions().getAppKey();
                                final File tempZipFile = new File("/sdcard/easemoblog.zip");
                                CopyDirectoryUtil.copyDirectory("/sdcard/Android/data/" + packageName + "/" + appkey + "/core_log", tempLogDir);
                                CopyDirectoryUtil.copyDirectory("/data/data/" + packageName + "/databases/", tempLogDir);
                                ZipUtil.zipFolder(tempLogDir, tempZipFile.getPath());
                                ZipUtil.deleteDirectory(new File(tempLogDir));

                                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                                HttpRequestBuilder requestBuilder = httpClient.post("https://kefu-sdk-log.easemob.com/upload?token=f2dfcdf86fc51be02a6fcb8fef9c703e");
                                requestBuilder.contentFromFile(tempZipFile.getPath());
                                requestBuilder.to(new HttpResponseHandler(){
                                    @Override
                                    public void onResponse(HttpResponse response, long contentLength) throws Exception {
                                        try {
                                            Log.e("oooooooooooo","onResponse");
                                            String result = response.getResponseBody();
                                            EMLog.d(TAG, "upload log zip :" + result);
                                            JSONObject jsonObject = new JSONObject(result);
                                            String urlMessage = jsonObject.getString("message");
                                            JSONObject jsonBody = new JSONObject();
                                            String username = PreferenceUtil.getInstance().getUsername();
                                            String appkey = EMClient.getInstance().getOptions().getAppKey();
                                            String logUsername = appkey.replace("#", "_") + "_" + username;
                                            EMLog.d(TAG, "logUsername:" + logUsername);
                                            jsonBody.put("username", logUsername);
                                            jsonBody.put("url", urlMessage);
                                            tempZipFile.delete();
                                            uploadLogToServer(jsonBody.toString());
                                        }catch (Exception ignored){
                                            ignored.printStackTrace();
                                        }

                                    }
                                });
                                requestBuilder.execute();
                            }catch (Exception ignored){
                                Log.e("oooooooooooo","error = "+ignored.toString());
                                ignored.printStackTrace();
                            }
                        }
                    }).start();
                    continue;
                }
            }
            tempMessages.add(item);
        }
        return tempMessages;
    }

    private JSONObject getZuoXiToFangKe(Message item) throws Exception {
        String msgtype = item.getStringAttribute("msgtype");
        // {"sendVisitorCallback":{"msg":"坐席邀请视频通话"}}
        JSONObject jsonObject = new JSONObject(msgtype);
        return jsonObject.getJSONObject("sendVisitorCallback");
    }

    private void linkMessagePush(Message item, String type) {
        try {
            // http://c1.private.easemob.com/pages/viewpage.action?pageId=20808276
            String msgtype = item.getStringAttribute("msgtype");
            if (!TextUtils.isEmpty(msgtype)){
                AgoraMessage.pushVecMessage(msgtype, type);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean getRoomId(Message item) {
        boolean isResult = false;
        try {
            // {"roomData":{"appIdentifier":"cU8B8JXnEeyLkOdaPIfpCg/rl0behAO05Ua5g","roomToken":"NETLESSROOM_YWs9ZUktd2RsQmk3eENrU3M3VCZleHBpcmVBdD0xNjUwMjg2NDQ0MTc3Jm5vbmNlPTFlZWVhZWEwLWEwYmEtNGFjNy04OTNiLTI2NGRlMDJiZTFkZCZyb2xlPTEmc2lnPTM1NDAzOGYxMzEzZGNiYjVlZmE3YjAyZTIyMDU1ZDNhNWY1ZGJkNGUwZDc0ODZhMWFiNTg0N2NkZmViZjQ0ZjMmdXVpZD0zZTU1YTNkMGJmMGUxMWVjOTUzOThkODk3NjgxMjQxYQ","roomUUID":"3e55a3d0bf0e11ec95398d897681241a"}}
            //2022-04-18 19:54:03.899 16767-17072/com.easemob.helpdeskdemo E/wwwwwwwww: body = cmd:""
            String msgtype = item.getStringAttribute("msgtype");
            if (!TextUtils.isEmpty(msgtype)){
                JSONObject msg = new JSONObject(msgtype);
                if (!msg.isNull("roomData")){
                    JSONObject roomData = msg.getJSONObject("roomData");
                    ZuoXiSendRequestObj zuoXiSendRequestObj = new ZuoXiSendRequestObj();
                    if (!roomData.isNull("appIdentifier")){
                        zuoXiSendRequestObj.setAppIdentifier(roomData.getString("appIdentifier"));
                    }

                    if (!roomData.isNull("roomToken")){
                        zuoXiSendRequestObj.setRoomToken(roomData.getString("roomToken"));
                    }

                    if (!roomData.isNull("roomUUID")){
                        zuoXiSendRequestObj.setRoomUUID(roomData.getString("roomUUID"));
                    }
                    AgoraMessage.createFlatRoom(zuoXiSendRequestObj);
                    isResult = true;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return isResult;
    }

    private void uploadLogToServer(String jsonBody){
        try {
            HttpClient httpClient1 = new HttpClient(EMClient.getInstance().getContext());
            HttpRequestBuilder requestBuilder1 = httpClient1.post("https://kefu-sdk-log.easemob.com/applog/api/v1.0?token=f2dfcdf86fc51be02a6fcb8fef9c703e");
            requestBuilder1.content(jsonBody.getBytes(), "application/json");
            HttpResponse msgHttpResponse = requestBuilder1.execute();
            assert msgHttpResponse != null;
            int statusCode = msgHttpResponse.getStatusCode();
            if (statusCode/100 == 2){
                EMLog.d(TAG, "upload log success");
                Log.e("oooooooooooo","upload log success");
            }else{
                EMLog.d(TAG, "upload log failed");
                Log.e("oooooooooooo","upload log failed");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    void sendMessageWithoutRecord(final Message msg) {
        sendMessage(msg, false, null);
    }

    /**
     * 发送消息
     * @param msg 消息
     */
    public void sendMessage(final Message msg){
        sendMessage(msg, true, new Callback() {
            @Override
            public void onSuccess() {
                Log.e("sendMessage","onSuccess");
                Log.e("qqqqqqqqqqqq","onSuccess");
            }

            @Override
            public void onError(int code, String error) {
                Log.e("sendMessage","code = "+error);
                Log.e("qqqqqqqqqqqq","onError = "+error);
            }

            @Override
            public void onProgress(int progress, String status) {

            }
        });
    }

    /**
     * 发送消息
     * @param message 消息
     * @param callback 回调
     */
    public void sendMessage(Message message, final Callback callback) {
        sendMessage(message, true, callback);
    }

    private void sendMessage(Message message, boolean isRecord, final Callback callback){
        if (TextUtils.isEmpty(currentChatUsername)){
            EMLog.e(TAG, "please invoke ChatClient.getInstance().chatManager().bindChat({imServiceNum}) method in your chat activity!");
        }

        if(message.messageId() == null){
            message.setMsgId(UUID.randomUUID().toString());
        }
        JSONObject jsonWeichat = null;
        try{
            jsonWeichat = message.getJSONObjectAttribute(Message.KEY_WEICHAT);
        }catch(Exception ignored){}
        if(jsonWeichat == null){
            jsonWeichat = new JSONObject();
        }
        latestSendWeichat = jsonWeichat;
        try {
            if (ChatClient.getInstance().hasSecondChannel) {
                jsonWeichat.put(SEND_EXT_MSG_ID_FOR_ACK, message.messageId());
            }
            // 检测添加 服务号信息
            if (message.to.contains(OfficialAccount.SEPARATOR)) {
                String officialAccountId = message.to.substring(message.to.indexOf(OfficialAccount.SEPARATOR) + 2);
                EMLog.d(TAG, "officialAccount:" + officialAccountId);
                JSONObject jsonOffAccount = new JSONObject();
                jsonOffAccount.put(OfficialAccount.KEY_ID, officialAccountId);
                jsonWeichat.put(OfficialAccount.KEY_OFFICIAL_ACCOUNT, jsonOffAccount);
                MarketingHttpClient.asyncReplied(message.to);

                Conversation conversation = getConversation(message.to);
                if (conversation != null && conversation.getMarketings() != null) {
                    JSONObject jsonMarketings = new JSONObject(conversation.getMarketings());
                    try {
                        JSONObject jsonScheduleInfo = jsonMarketings.getJSONObject("schedule_info");
                        if (jsonScheduleInfo.has("skillgroup_name")) {
                            String skillGroupName = jsonScheduleInfo.getString("skillgroup_name");
                            jsonWeichat.put("queueName", skillGroupName);
                        }
                        if (jsonScheduleInfo.has("agent_username")) {
                            String agentName = jsonScheduleInfo.getString("agent_username");
                            jsonWeichat.put("agentUsername", agentName);
                        }
                    } catch (Exception ignored) {
                    }
                }
            }
        } catch (JSONException ignored) {
        }
        message.setAttribute(Message.KEY_WEICHAT, jsonWeichat);
        EMMessageBody messageBody = message.body();
        if(messageBody == null){
            EMLog.e(TAG, "messagebody is nulll");
            if (callback != null){
                callback.onError(Error.GENERAL_ERROR, "body is null");
            }
            if (message.messageStatusCallBack != null){
                message.messageStatusCallBack.onError(Error.GENERAL_ERROR, "body is null");
            }
            return;
        }
        String currentUser = ChatClient.getInstance().currentUserName();
        if (TextUtils.isEmpty(currentUser)){
            EMLog.e(TAG, "currentUserName is empty");
            if (callback != null){
                callback.onError(Error.GENERAL_ERROR, "please login before");
            }

            if (message.messageStatusCallBack != null){
                message.messageStatusCallBack.onError(Error.GENERAL_ERROR, "please login before");
            }
            return;
        }

        message.setFrom(currentUser);


        if (message.getType() == Message.Type.TXT){
            EMTextMessageBody txtBody = (EMTextMessageBody) messageBody;
            if (txtBody.getMessage() != null && txtBody.getMessage().length() > 1500){
                if (callback != null){
                    callback.onError(Error.MESSAGE_SEND_TRAFFIC_LIMIT, "text message length could not more than 1500");
                }

                if (message.messageStatusCallBack != null){
                    message.messageStatusCallBack.onError(Error.MESSAGE_SEND_TRAFFIC_LIMIT, "text message length could not more than 1500");
                }
                return;
            }
        }

        if(isRecord && message.getType() != Message.Type.CMD){
            KefuConversationManager.getInstance().saveMessage(message);
        }

        String originPath = null;
        // If message body is image, check scale request, set size, and file name
        if(message.getType() == Message.Type.IMAGE){
            EMImageMessageBody body = (EMImageMessageBody)message.body();
            if(body == null){
                message.setStatus(Message.Status.FAIL);
                if(callback != null){
                    callback.onError(EMError.GENERAL_ERROR, "Message body cannot be null");
                }
                return;
            }

            Uri fileUri = body.getLocalUri();

            if(!UriUtils.isFileExistByUri(EMClient.getInstance().getContext(), fileUri)) {
                message.setStatus(Message.Status.FAIL);
                if(callback != null){
                    callback.onError(EMError.FILE_INVALID, "File not exists or can not be read");
                }
                return;
            }

            String localUri = fileUri.toString();
            if(!body.isSendOriginalImage()){
                String scaledImagePath = ImageUtils.getScaledImageByUri(EMClient.getInstance().getContext(), localUri);
                if(!scaledImagePath.equals(localUri)){
                    originPath = localUri;
                    long originalSize = ImageUtils.getFileLength(EMClient.getInstance().getContext(), localUri);
                    long scaledSize = ImageUtils.getFileLength(EMClient.getInstance().getContext(), scaledImagePath);

                    if(originalSize == 0){
                        EMLog.d(TAG, "original image size:" + originalSize);
                        message.setStatus(Message.Status.FAIL);
                        if(callback != null){
                            callback.onError(EMError.FILE_INVALID, "original image size is 0");
                        }
                        return;
                    }
                    localUri = scaledImagePath;
                    body.setLocalUrl(UriUtils.getLocalUriFromString(localUri));
                }
            }

            // get video width and height
            String thumbPath = UriUtils.getFilePath(EMClient.getInstance().getContext(), body.getThumbnailUrl());
            if(!TextUtils.isEmpty(thumbPath)) {
                BitmapFactory.Options options = ImageUtils.getBitmapOptions(thumbPath);
                int width = options.outWidth;
                int height = options.outHeight;
                body.setThumbnailSize(width, height);
            }
            body.setFileName(ImageUtils.getFilename(EMClient.getInstance().getContext(), localUri));
        }

        message.setStatus(Message.Status.INPROGRESS);

        if (!EMClient.getInstance().isLoggedInBefore() && ChatClient.getInstance().isLoggedInBefore()){
            sendRESTMessage(message, callback);
            sendMsgThread.execute(new Runnable() {
                @Override
                public void run() {
                    asyncLoginIM();
                }
            });

        }else{
            sendIMEMMessage(message, callback);
        }
        notifyMessageSent();
        CountDownUtils.getInstance().sendBroadcast();

    }

    private final Object asyncLoginImMutex = new Object();
    private void asyncRealLoginIM(){
        if (EMClient.getInstance().isLoggedInBefore()){
            EMLog.d(TAG, "im isLoggedIn");
            notifyAsyncLoginMutex();
            return;
        }

        String uName = PreferenceUtil.getInstance().getUsername();
        String uPwd = PreferenceUtil.getInstance().getPassword();
        String uToken = PreferenceUtil.getInstance().getToken();

        if (TextUtils.isEmpty(uName)) {
            EMLog.d(TAG, "asyncLoginIM: userName is empty");
            notifyAsyncLoginMutex();
            return;
        }


        if (!TextUtils.isEmpty(uPwd)) {
            EMClient.getInstance().login(uName, uPwd, new EMCallBack() {
                @Override
                public void onSuccess() {
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    registerCountDown();
                    CountDownUtils.getInstance().sendBroadcast();
                    notifyAsyncLoginMutex();
                }

                @Override
                public void onError(int i, String s) {
                    notifyAsyncLoginMutex();
                }

                @Override
                public void onProgress(int i, String s) {
                }
            });
        } else if (!TextUtils.isEmpty(uToken)) {
            EMClient.getInstance().loginWithToken(uName, uToken, new EMCallBack() {
                @Override
                public void onSuccess() {
                    PreferenceUtil.getInstance().setToken(EMClient.getInstance().getAccessToken());
                    registerCountDown();
                    CountDownUtils.getInstance().sendBroadcast();
                    notifyAsyncLoginMutex();
                }

                @Override
                public void onError(int i, String s) {
                    ChatClient.getInstance().loginWithTokenFail();
                    notifyAsyncLoginMutex();
                }

                @Override
                public void onProgress(int i, String s) {
                }
            });

        }else{
            notifyAsyncLoginMutex();
        }

    }
    private void notifyAsyncLoginMutex(){
        synchronized (asyncLoginImMutex){
            asyncLoginImMutex.notifyAll();
        }
    }


    private void asyncLoginIM(){
        loginSingleExecutor.execute(new Runnable() {
            @Override
            public void run() {
                synchronized (asyncLoginImMutex){
                    asyncRealLoginIM();
                    try {
                        asyncLoginImMutex.wait(10000);
                    } catch (InterruptedException ignored) {
                        EMLog.e(TAG, "asyncLoginImMutex wait InterruptedException");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }



    private void notifyMessageSent(){
        synchronized (messageListeners){
            for (MessageListener listener : messageListeners){
                listener.onMessageSent();
            }
        }
    }




    //一般用于发送消息
    private EMMessage convertToEMMessage(Message message){
        String from = message.from();
        String to = message.to();
        EMMessageBody messageBody = message.body();
        EMMessage imMessage;
        if (message.direct() == Message.Direct.SEND) {
            imMessage = EMMessage.createSendMessage(EMMessage.Type
                    .valueOf(message.getType().name()));
            if (to.contains(OfficialAccount.SEPARATOR)){
                to = to.substring(0, to.indexOf(OfficialAccount.SEPARATOR));
            }
        } else {
            imMessage = EMMessage.createReceiveMessage(EMMessage.Type
                    .valueOf(message.getType().name()));
            if (from.contains(OfficialAccount.SEPARATOR)){
                from = from.substring(0, from.indexOf(OfficialAccount.SEPARATOR));
            }
        }
        imMessage.addBody(messageBody);
        imMessage.setFrom(from);
        imMessage.setTo(to);
//        imMessage.setMsgId(message.getIMMsgId());
        imMessage.setMsgTime(message.messageTime());
        Map<String, Object> extAttrs = message.ext();
        synchronized (extAttrs) {
            for(Map.Entry<String, Object> item : extAttrs.entrySet()){
                String key = item.getKey();
                Object value = item.getValue();
                if(value instanceof Boolean){
                    imMessage.setAttribute(key, (Boolean) value);
                }else if(value instanceof Integer){
                    imMessage.setAttribute(key, (Integer) value);
                }else if(value instanceof Long){
                    imMessage.setAttribute(key, (Long) value);
                }else if(value instanceof JSONObject){
                    imMessage.setAttribute(key, (JSONObject)value);
                }else if(value instanceof JSONArray){
                    imMessage.setAttribute(key, (JSONArray)value);
                }else if(value instanceof String){
                    imMessage.setAttribute(key, (String)value);
                }
            }
        }



        return imMessage;
    }

    // 一般用于接收消息
    private Message convertToMessage(EMMessage message) {
        String from = message.getFrom();
        String to = message.getTo();
        EMMessageBody messageBody = message.getBody();
        Message msg;
        if (message.direct() == EMMessage.Direct.SEND) {
            msg = Message.createSendMessage(Message.Type.valueOf(message.getType().name()));
        } else {
            msg = Message.createReceiveMessage(Message.Type.valueOf(message.getType().name()));
        }
        msg.setBody(messageBody);
        msg.setFrom(from);
        msg.setTo(to);
        msg.setIMMsgId(message.getMsgId());
        msg.setMessageTime(message.getMsgTime());
        Map<String, Object> extAttrs = message.ext();
        synchronized (extAttrs) {
            for (Map.Entry<String, Object> item : extAttrs.entrySet()) {
                String key = item.getKey();
                Object value = item.getValue();
                if (value instanceof Boolean) {
                    msg.setAttribute(key, (Boolean) value);
                } else if (value instanceof Integer) {
                    msg.setAttribute(key, (Integer) value);
                } else if (value instanceof Long) {
                    msg.setAttribute(key, (Long) value);
                } else if (value instanceof JSONObject) {
                    msg.setAttribute(key, (JSONObject) value);
                } else if (value instanceof JSONArray) {
                    msg.setAttribute(key, (JSONArray) value);
                } else if (value instanceof String) {
                    msg.setAttribute(key, (String) value);
                }
            }
        }
        String extMsgId = getKefuExtMsgId(msg);
        if (extMsgId != null) {
            msg.setMsgId(extMsgId);
        } else {
            msg.setMsgId(message.getMsgId());
        }

        if (msg.direct() == Message.Direct.RECEIVE){
            if (msg.from() != null && !msg.from().contains(OfficialAccount.SEPARATOR)){
                OfficialAccount officialAccount = msg.getOfficialAccount();
                if (officialAccount != null && officialAccount.getId() != null && !officialAccount.getType().equals("SYSTEM")){
                    msg.setFrom(msg.from() + OfficialAccount.SEPARATOR + officialAccount.getId());
                }
            }
        }else{
            if (msg.to() != null && !msg.to().contains(OfficialAccount.SEPARATOR)){
                OfficialAccount officialAccount = msg.getOfficialAccount();
                if (officialAccount != null && officialAccount.getId() != null && !officialAccount.getType().equals("SYSTEM")){
                    msg.setTo(msg.to() + OfficialAccount.SEPARATOR + officialAccount.getId());
                }
            }
        }


        return msg;
    }



    private void sendIMEMMessage(final Message message, final EMCallBack callback){
        sendMsgThread.submit(new Runnable() {
            @Override
            public void run() {
                Log.e("qqqqqqqqqqqq", "vvvv after");
                final EMMessage imMessage = convertToEMMessage(message);
                imMessage.setMessageStatusCallback(new EMCallBack() {
                    @Override
                    public void onSuccess() {
                        Log.e("qqqqqqqqqqqq", "vvvv onSuccess");
                        if (!ChatClient.getInstance().hasSecondChannel){
                            message.setIMMsgId(imMessage.getMsgId());
                            message.setStatus(Message.Status.SUCCESS);
                            message.setMessageTime(imMessage.getMsgTime());
                            updateMessageStatusAndMsgId(message);

                            if (callback != null){
                                callback.onSuccess();
                            }
                            if (message.messageStatusCallBack != null){
                                message.messageStatusCallBack.onSuccess();
                            }
                        }

                    }

                    @Override
                    public void onError(int i, String s) {
                        Log.e("qqqqqqqqqqqq", "vvvv error = "+s);
                    }

                    @Override
                    public void onProgress(int i, String s) {
                        if(message.status() == Message.Status.INPROGRESS){
                            if(message.messageStatusCallBack != null){
                                message.messageStatusCallBack.onProgress(i, s);
                            }
                            if(callback != null){
                                callback.onProgress(i, s);
                            }
                        }
                    }
                });
                long fileLength = 0;
                if (imMessage.getType() == EMMessage.Type.FILE){
                    EMNormalFileMessageBody fileBody = (EMNormalFileMessageBody) imMessage.getBody();
                    fileLength = fileBody.getFileSize();
                }

                if (imMessage.getType() == EMMessage.Type.VIDEO){
                    EMVideoMessageBody fileBody = (EMVideoMessageBody) imMessage.getBody();
                    fileLength = fileBody.getVideoFileLength();
                }

                EMClient.getInstance().chatManager().sendMessage(imMessage);

                if (ChatClient.getInstance().hasSecondChannel){
                    Object mutex = new Object();
                    String msgId = message.messageId();
                    addSendLock(msgId, mutex);
                    synchronized (mutex) {
                        if(sendLocks.containsKey(msgId)){
                            try {
                                if (message.getType() == Message.Type.TXT || message.getType() == Message.Type.CMD || message.getType() == Message.Type.LOCATION){
                                    mutex.wait(WAIT_TIME_OUT_TYPE_TXT * 1000L);
                                }else if (message.getType() == Message.Type.IMAGE || message.getType() == Message.Type.VOICE){
                                    mutex.wait(WAIT_TIME_OUT * 1000L);
                                }else if(message.getType() == Message.Type.FILE || message.getType() == Message.Type.VIDEO){
                                    long tempWaitTime = fileLength/1024/1024 * 3 + WAIT_TIME_OUT;
                                    long waitTime = Math.min(tempWaitTime, WAIT_TIME_ATTACHEMENT_MAX);
                                    waitTime = Math.max(waitTime, WAIT_TIME_ATTACHMENT_MIN);
                                    mutex.wait(waitTime * 1000);
                                }else{
                                    mutex.wait(WAIT_TIME_OUT * 1000L);
                                }
                            } catch (InterruptedException ignored) {
                                EMLog.e(TAG, "mutex wait InterruptedException");
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    EMLog.d(TAG, "exit from wait msgid:" + message.messageId());
                    if(sendLocks.remove(msgId) != null){
                        sendRESTMessage(message, callback);
                    }else{
                        message.setIMMsgId(imMessage.getMsgId());
                        message.setStatus(Message.Status.SUCCESS);
                        message.setMessageTime(imMessage.getMsgTime());
                        updateMessageStatusAndMsgId(message);
                        if(message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onSuccess();
                        }
                        if(callback != null){
                            callback.onSuccess();
                        }
                    }
                }

            }
        });
    }

    private void sendRESTMessage(final Message mesage, final EMCallBack callback){
        Log.e("qqqqqqqqqqqq", "sendRESTMessage after");
        KefuHttpClient.sendMessageByKefuRest(mesage, new EMCallBack() {
            @Override
            public void onSuccess() {
                Log.e("qqqqqqqqqqqq", "sendRESTMessage onSuccess");
                mesage.setStatus(Message.Status.SUCCESS);
                updateMessageState(mesage);
                if(mesage.messageStatusCallBack != null){
                    mesage.messageStatusCallBack.onSuccess();
                }
                if (callback != null){
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                Log.e("qqqqqqqqqqqq", "sendRESTMessage errorMsg = "+errorMsg);
                KefuHttpClient.sendMessageByKefuRest(mesage, new EMCallBack() {
                    @Override
                    public void onSuccess() {
                        EMLog.d(TAG, "send kefu message by rest msgid:" + mesage.messageId());
                        mesage.setStatus(Message.Status.SUCCESS);
                        updateMessageState(mesage);
                        if(mesage.messageStatusCallBack != null){
                            mesage.messageStatusCallBack.onSuccess();
                        }
                        if (callback != null){
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int error, String errorMsg) {
                        EMLog.d(TAG, "send kefu message:" + errorMsg);
                        mesage.setStatus(Message.Status.FAIL);
                        updateMessageState(mesage);
                        if(mesage.messageStatusCallBack != null){
                            mesage.messageStatusCallBack.onError(error, errorMsg);
                        }
                        if (callback != null) {
                            callback.onError(error, errorMsg);
                        }

                    }

                    @Override
                    public void onProgress(int i, String s) {

                    }
                });


            }

            @Override
            public void onProgress(int i, String s) {

            }
        });

    }

    void initDB(String userName){
        EMLog.d(TAG, "initDB - userName:"  + userName);
        Context context = EMClient.getInstance().getContext();
        if(context == null){
            return;
        }
        KefuDBManager.initDB(userName);
    }

    void loadDB(){
        KefuConversationManager.getInstance().clear();
        Thread thread = new Thread(new Runnable() {

            @Override
            public void run() {
                loadAllConversations();
            }
        });
        thread.setPriority(Thread.MAX_PRIORITY - 1);
        thread.start();
    }


    /**
     * 判断是否是silent消息
     * silent消息不需要通知前台
     * @param message 消息
     * @return 是否是silent消息状态
     */
    public boolean isSilentMessage(Message message){
        return message.getBooleanAttribute("em_ignore_notification", false);
    }

    /**
     * 下载方法 已过期
     * @param remoteUrl 远端url
     * @param localFilePath 本地url
     * @param headers 请求header
     * @param callback 回调
     */
    @Deprecated
    public void downloadFile(String remoteUrl, String localFilePath, final Map<String, String> headers, final EMCallBack callback){
        EMClient.getInstance().chatManager().downloadFile(remoteUrl, localFilePath, headers, callback);
    }

    private void shutdownVisitorWaitThread(){
        if(ChatClient.getInstance().isShowVisitorWaitCount){
            if (visitorWaitThread != null && !visitorWaitThread.isShutdown()){
                visitorWaitThread.shutdownNow();
                visitorWaitThread = null;
                if (!visitorWaitCountListeners.isEmpty()){
                    synchronized (visitorWaitCountListeners){
                        for (VisitorWaitListener listener : visitorWaitCountListeners){
                            if (listener != null){
                                listener.waitCount(0);
                            }
                        }
                    }
                }
            }
        }
    }

    private void shutdownAgentInputThread(){
        if (ChatClient.getInstance().isShowAgentInputState){
            if (agentInputThread != null && !agentInputThread.isShutdown()){
                agentInputThread.shutdownNow();
                agentInputThread = null;
                if (!agentInputListeners.isEmpty()){
                    synchronized (agentInputListeners) {
                        for (AgentInputListener listener : agentInputListeners) {
                            if (listener != null) {
                                listener.onInputState(null);
                            }
                        }
                    }
                }

            }
        }

    }

    private final Object visitorLock = new Object();
    private final Object agentInputLock = new Object();

    private void showVisitorWaitCountAndAgentInputState(final String toChatUsername){
        final Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                synchronized (visitorLock){
                    if (ChatClient.getInstance().isShowVisitorWaitCount){
                        shutdownVisitorWaitThread();
                        if (visitorWaitCountListeners.isEmpty()){
                            return;
                        }
                        OfficialAccount officialAccount = getConversation(toChatUsername).officialAccount();
                        if (officialAccount == null){
                            officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                        }
                        if (officialAccount != null && officialAccount.getId() != null){
                            final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                            if (info == null || info.session_id == null) {
                                EMLog.d(TAG, "sessionid is null");
                            }else if(info.state == null || !info.state.equalsIgnoreCase("wait")){
                                EMLog.d(TAG, "session is not wait state");
                            }else{
                                visitorWaitThread = Executors.newSingleThreadScheduledExecutor();
                                visitorWaitThread.scheduleAtFixedRate(new Runnable() {
                                    @Override
                                    public void run() {
                                        MarketingHttpClient.asyncGetWaitCount(info, new ValueCallBack<String>() {
                                            @Override
                                            public void onSuccess(String value) {
                                                try {
                                                    JSONObject jsonObj = new JSONObject(value);
                                                    JSONObject jsonEntty = jsonObj.getJSONObject("entity");
                                                    String number = jsonEntty.getString("visitorUserWaitingNumber");
                                                    if (!TextUtils.isEmpty(number) && TextUtils.isDigitsOnly(number)){
                                                        synchronized (visitorWaitCountListeners){
                                                            for (VisitorWaitListener listener : visitorWaitCountListeners){
                                                                if (listener != null){
                                                                    listener.waitCount(Integer.parseInt(number));
                                                                }
                                                            }
                                                        }
                                                    }else{
                                                        shutdownVisitorWaitThread();
                                                    }
                                                } catch (JSONException e) {
                                                    shutdownVisitorWaitThread();
                                                }
                                            }

                                            @Override
                                            public void onError(int error, String errorMsg) {
                                                EMLog.i(TAG, "visitor wait error -> " + errorMsg);
                                            }
                                        });
                                    }
                                }, 1000, 5000, TimeUnit.MILLISECONDS);
                            }

                        }
                    }
                }
            }
        });
        thread.start();

        Thread agentThread = new Thread(new Runnable() {
            @Override
            public void run() {
                synchronized (agentInputLock){
                    if (ChatClient.getInstance().isShowAgentInputState){
                        shutdownAgentInputThread();
                        if (agentInputListeners.isEmpty()){
                            return;
                        }
                        OfficialAccount officialAccount = getConversation(toChatUsername).officialAccount();
                        if (officialAccount == null){
                            officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                        }
                        if (officialAccount != null && officialAccount.getId() != null){
                            final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                            if (info == null || info.session_id == null) {
                                EMLog.i(TAG, "sessionid is null");
                            }else{
                                agentInputThread = Executors.newScheduledThreadPool(1);
                                agentInputThread.scheduleAtFixedRate(new Runnable() {
                                    @Override
                                    public void run() {
                                        MarketingHttpClient.asyncGetAgentState(info, new ValueCallBack<String>() {
                                            @Override
                                            public void onSuccess(String value) {
                                                if (!TextUtils.isEmpty(value) && !value.equals("null")){
                                                    synchronized (agentInputListeners){
                                                        for (AgentInputListener listener : agentInputListeners){
                                                            if (listener != null){
                                                                listener.onInputState(value);
                                                            }
                                                        }
                                                    }
                                                }else{
                                                    synchronized (agentInputListeners) {
                                                        for (AgentInputListener listener : agentInputListeners) {
                                                            if (listener != null) {
                                                                listener.onInputState(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            }

                                            @Override
                                            public void onError(int error, String errorMsg) {
                                                EMLog.i(TAG, "get agent state error->" + errorMsg);
                                            }
                                        });

                                    }
                                }, 3000, 3000, TimeUnit.MILLISECONDS);
                            }

                        }

                    }
                }
            }
        });
        agentThread.start();
    }

    /**
     * 消息预知功能发送消息内容
     * @param content 内容
     */
    public void postMessagePredict(final String content) {
        postMessagePredict(content, currentChatUsername);
    }

    /**
     * 消息预知功能发送消息内容
     * @param content 内容
     * @param toChatUsername 聊天对象UserName
     */
    public void postMessagePredict(final String content, final String toChatUsername) {
        if (!ChatClient.getInstance().isShowMessagePredict || TextUtils.isEmpty(content) || TextUtils.isEmpty(toChatUsername)) {
            return;
        }

        new Thread(new Runnable() {
            @Override
            public void run() {
                OfficialAccount officialAccount = getConversation(toChatUsername).officialAccount();
                if (officialAccount == null){
                    officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                }
                if (officialAccount != null && officialAccount.getId() != null) {
                    final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                    if (info == null || info.session_id == null) {
                        EMLog.i(TAG, "sessionid is null");
                    } else {
                        MarketingHttpClient.postMessagePredict(content, info, new ValueCallBack<String>() {
                            @Override
                            public void onSuccess(String value) {

                            }

                            @Override
                            public void onError(int error, String errorMsg) {

                            }
                        });
                    }
                }
            }
        }).start();
    }

    /**
     * 进入聊天页面需要bind联系人
     * @param toChatUsername 聊天对象UserName
     */
    public void bindChat(final String toChatUsername) {
        if (TextUtils.isEmpty(toChatUsername)){
            return;
        }
        currentChatUsername = toChatUsername;
        AgoraMessage.newAgoraMessage().setCurrentChatUsername(currentChatUsername);
        KefuPolling.startPolling(toChatUsername);
        showVisitorWaitCountAndAgentInputState(toChatUsername);
    }

    /**
     * 进入聊天页面需要bind联系人
     * @param toChatUsername 聊天对象UserName
     * @see #bindChat(String)
     */
    @Deprecated
    public void bindChatUI(final String toChatUsername){
        bindChat(toChatUsername);
    }

    private void sendDeviceInfo(String target){
        if (ChatClient.getInstance().tenantId() != null){
            KefuHttpClient.asyncSendDeviceInfo(ChatClient.getInstance().tenantId(), target, new ValueCallBack<String>() {
                @Override
                public void onSuccess(String value) {
                    Log.d(TAG, "value:" + value);
                }

                @Override
                public void onError(int error, String errorMsg) {
                    EMLog.e(TAG, "asyncSendDeviceInfo error:" + errorMsg);
                }
            });
        }
    }

    /**
     * 离开聊天页面调用此方法
     */
    public void unbindChat() {
        KefuPolling.stopPolling();
        shutdownWaitAndInput();
        if (!TextUtils.isEmpty(MarketingHttpClient.currentConversationId)){
            getConversation(MarketingHttpClient.currentConversationId).setConversationInfo(null);
        }
        currentChatUsername = null;
    }

    /**
     * 离开聊天页面调用此方法
     * @see #unbindChat()
     */
    @Deprecated
    public void unBind(){
        unbindChat();
    }

    private void shutdownWaitAndInput(){

        shutdownVisitorWaitThread();
        shutdownAgentInputThread();



    }


    /**
     * 增加消息监听
     * @param listener 监听
     */
    public void addMessageListener(MessageListener listener) {
        if(listener == null){
            return;
        }

        if(!messageListeners.contains(listener)){
            messageListeners.add(listener);
        }
    }

    /**
     * 移除消息监听
     * @param listener 要移除的监听
     */
    public void removeMessageListener(MessageListener listener) {
        if(listener == null){
            return;
        }
        if (messageListeners.contains(listener)){
            messageListeners.remove(listener);
        }
    }

    /**
     * 管理员输入状态监听 聊天界面初始化时调用
     * @param listener 监听
     */
    public void addAgentInputListener(AgentInputListener listener){
        if (listener == null){
            return;
        }
        if (!agentInputListeners.contains(listener)){
            agentInputListeners.add(listener);
        }
    }

    /**
     * 移除管理员输入状态监听 聊天界面销毁时调用
     * @param listener 监听
     */
    public void removeAgentInputListener(AgentInputListener listener){
        if (listener == null){
            return;
        }
        if (agentInputListeners.contains(listener)){
            agentInputListeners.remove(listener);
        }
    }

    /**
     * 访客等待数监听 聊天界面初始化时调用
     * @param listener 监听
     */
    public void addVisitorWaitListener(VisitorWaitListener listener){
        if (listener == null){
            return;
        }
        if (!visitorWaitCountListeners.contains(listener)){
            visitorWaitCountListeners.add(listener);
        }
    }

    /**
     * 移除访客等待数监听 聊天界面销毁时调用
     * @param listener 监听
     */
    public void removeVisitorWaitListener(VisitorWaitListener listener){
        if (listener == null){
            return;
        }
        if (visitorWaitCountListeners.contains(listener)){
            visitorWaitCountListeners.remove(listener);
        }
    }

    private String checkKefuMessageAck(Message message){
        try {
            JSONObject jsonExt = message.getJSONObjectAttribute(Message.KEY_WEICHAT);
            if (jsonExt != null) {
                String msgIdForAck = jsonExt.getString(ACK_FOR_MSG_ID);// ACK_FOR_MSG_ID
                if (!TextUtils.isEmpty(msgIdForAck)
                        && !msgIdForAck.equals("null")) {
                    return msgIdForAck;
                }
            }
        } catch (Exception ignored) {
        }
        return null;
    }

    /**
     * 第二通道收到的消息的msgid
     * @param message 消息
     * @return 第二通道消息msgid
     */
    String getKefuExtMsgId(Message message){
        try {
            JSONObject jsonExt = message.getJSONObjectAttribute(Message.KEY_WEICHAT);
            if (jsonExt != null) {
                String msgIdForAck = jsonExt.getString("msgId");
                if (!TextUtils.isEmpty(msgIdForAck)
                        && !msgIdForAck.equals("null")) {
                    return msgIdForAck;
                }
            }
        } catch (Exception ignored) {
        }
        return null;
    }

    /**
     * 消息重发
     * @param msg 消息
     */
    public void resendMessage(Message msg) {
        msg.setStatus(Message.Status.CREATE);
        sendMessage(msg);
    }

    /**
     * 消息重发
     * @param msg 消息
     * @see #resendMessage(Message)
     */
    @Deprecated
    public void reSendMessage(Message msg) {
        resendMessage(msg);
    }

    /**
     * 设置语音消息已读状态
     * @param message  消息
     */
    public void setMessageListened(Message message){
        message.setListened(true);
        KefuDBManager.getInstance().updateMessageListened(message.messageId(), true);
    }

    /**
     * 通过消息id获取消息
     * @param messageId 消息id
     * @return 消息
     */
    public Message getMessage(String messageId){
        return KefuConversationManager.getInstance().getMessage(messageId);
    }

    void addMessage(Message msg){
        KefuConversationManager.getInstance().addMessage(msg);
    }

    void addMessage(Message msg, boolean unreadCountIncrease){
        KefuConversationManager.getInstance().addMessage(msg, unreadCountIncrease);
    }

    /**
     * 通过会话id获取会话
     * @param conversationId 会话id
     * @return 会话
     */
    public Conversation getConversation(final String conversationId){
        return KefuConversationManager.getInstance().getConversation(conversationId);
    }

    /**
     * 删除会话
     * @param username ToUserName
     * @param deleteMessages 是否删除消息
     * @return 成功或失败
     */
    public boolean deleteConversation(String username, boolean deleteMessages){
        EMClient.getInstance().chatManager().deleteConversation(username, deleteMessages);
        return KefuConversationManager.getInstance().removeConversation(username, deleteMessages);
    }

    /**
     * 标记所有会话消息为已读
     */
    public void markAllConversationsAsRead(){
        KefuConversationManager.getInstance().resetAllUnreadMsgCount();
    }

    private void loadAllConversations(){
        KefuConversationManager.getInstance().loadAllConversations();
    }

    /**
     * 获取所有会话
     * @return 会话列表
     */
    public Hashtable<String, Conversation> getAllConversations(){
        return KefuConversationManager.getInstance().getAllConversations();
    }

    /**
     * 获取未读消息数
     * @return 未读消息数
     */
    public int getUnreadMsgsCount(){
        return KefuConversationManager.getInstance().getUnreadMsgsCount();
    }

    /**
     * 保持信息进入数据库
     * @param message 消息
     */
    public void saveMessage(Message message){
        KefuConversationManager.getInstance().saveMessage(message);
    }

    /**
     * 更新消息体
     * @param message
     * @return
     */
    public boolean updateMessageBody(Message message){
        return KefuDBManager.getInstance().updateMessageBody(message);
    }

    private void updateMessageState(Message message){
        ContentValues cvs = new ContentValues();
        cvs.put(KefuDBManager.COLUMN_MSG_STATUS, message.status().ordinal() + "");
        KefuDBManager.getInstance().updateMessage(message.messageId(), cvs);
    }

    private void updateMessageStatusAndMsgId(Message message){
        ContentValues cvs = new ContentValues();
        cvs.put(KefuDBManager.COLUMN_MSG_STATUS, message.status().ordinal() + "");
        cvs.put(KefuDBManager.COLUMN_IM_MSG_ID, message.getIMMsgId());
        cvs.put(KefuDBManager.COLUMN_MSG_TIME, message.messageTime());
        KefuDBManager.getInstance().updateMessage(message.messageId(), cvs);

    }

//    public void downloadAttachment(final Message message){
//        EMMessage imMessage = convertToEMMessage(message);
//        if (message.messageStatusCallBack != null){
//            imMessage.setMessageStatusCallback(message.messageStatusCallBack);
//        }
//        EMClient.getInstance().chatManager().downloadAttachment(imMessage);
//    }

    /**
     * 下载消息中包含的附件
     * @param message 消息
     */
    public void downloadAttachment(final Message message){
        if (!(message.body() instanceof EMFileMessageBody)) {
            EMLog.d(TAG, "download file msg body is not FileMessageBody");
            return;
        }
        EMFileMessageBody msgBody = (EMFileMessageBody) message.body();
        final String remoteUrl = msgBody.getRemoteUrl();
        final String localPath = msgBody.getLocalUrl();
        if (TextUtils.isEmpty(remoteUrl) || TextUtils.isEmpty(localPath)){
            EMLog.d(TAG, "download file remoteUrl or localPath is empty");
            return;
        }

        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, false);
        downloadThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                try {
                    requestBuilder.to(tempLocalFile, new ProgressListener() {
                        @Override
                        public void loadProgress(long progress) {
                            if (message.messageStatusCallBack != null){
                                if (progress < 100){
                                    message.messageStatusCallBack.onProgress((int) progress, "progress");
                                }
                            }

                        }
                    });
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "rfile download failed");
                        }
                        return;
                    }
                    int status = httpResponse.getStatusCode();
                    if (status / 100 == 2){
                        tempLocalFile.renameTo(localFile);
                        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, false);
                        updateMessageBody(message);
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onSuccess();
                        }
                    }else{
                        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                        updateMessageBody(message);
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "file download failed");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, false);
                    updateMessageBody(message);
                    if (message.messageStatusCallBack != null){
                        message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "file download failed");
                    }
                }

            }
        });

    }

    void downloadAttachments(final Message message,final boolean isThumbnail){
        if (isThumbnail){
            downloadThumbnail(message);
        }else{
            downloadAttachment(message);
        }
    }

    /**
     * 下载微缩图
     * @param message 消息
     */
    public void downloadThumbnail(final Message message){
        final String remoteUrl;
        final String localPath;

        if (message.body() instanceof EMImageMessageBody) {
            EMImageMessageBody msgBody = (EMImageMessageBody) message.body();
            remoteUrl = msgBody.getRemoteUrl();
            localPath = msgBody.thumbnailLocalPath();
        } else if (message.body() instanceof EMVideoMessageBody){
            EMVideoMessageBody msgBody = (EMVideoMessageBody) message.body();
            remoteUrl = msgBody.getThumbnailUrl();
            localPath = msgBody.getLocalThumb();
        } else {
            EMLog.d(TAG, "download file msg body is not ImageMessageBody or EMVideoMessageBody");
            return;
        }
        if (TextUtils.isEmpty(remoteUrl) || TextUtils.isEmpty(localPath)){
            EMLog.d(TAG, "download file remoteUrl or localPath is empty");
            return;
        }
        final File localFile = new File(localPath);
        final File tempLocalFile = new File(localFile.getParent(), "tmp_" + localFile.getName());
        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.DOWNLOADING, true);
        downloadThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                requestBuilder.param("thumbnail", "true");
                try {
                    requestBuilder.to(tempLocalFile);
                    HttpResponse httpResponse = requestBuilder.execute();
                    if (httpResponse == null){
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "rfile download failed");
                        }
                        return;
                    }
                    int status = httpResponse.getStatusCode();
                    if (status / 100 == 2){
                        tempLocalFile.renameTo(localFile);
                        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.SUCCESSED, true);
                        updateMessageBody(message);
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onSuccess();
                        }
                    }else{
                        updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                        updateMessageBody(message);
                        if (message.messageStatusCallBack != null){
                            message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "file download failed");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    updateMessageBodyDownloadStatus(message, EMFileMessageBody.EMDownloadStatus.FAILED, true);
                    updateMessageBody(message);
                    if (message.messageStatusCallBack != null){
                        message.messageStatusCallBack.onError(Error.FILE_DOWNLOAD_FAILED, "file download failed");
                    }
                }

            }
        });
    }


    private void updateMessageBodyDownloadStatus(final Message message, EMFileMessageBody.EMDownloadStatus status, boolean isThumbnail){
        switch (message.getType()){
            case FILE:
            case VOICE:
                EMFileMessageBody fileBody = (EMFileMessageBody) message.body();
                fileBody.setDownloadStatus(status);
                break;
            case IMAGE:
                EMImageMessageBody imgBody = (EMImageMessageBody) message.body();
                if (isThumbnail){
                    imgBody.setThumbnailDownloadStatus(status);
                }else{
                    imgBody.setDownloadStatus(status);
                }
                break;
            default:
                break;
        }
    }

//    public void downloadThumbnail(Message message){
//        EMMessage imMessage = convertToEMMessage(message);
//        if (message.messageStatusCallBack != null){
//            imMessage.setMessageStatusCallback(message.messageStatusCallBack);
//        }
//        EMClient.getInstance().chatManager().downloadThumbnail(imMessage);
//    }


    /**
     * 主动发起满意度评价
     * @param toUser IM服务号
     * @param callback
     */
    public void asyncSendInviteEvaluationMessage(final String toUser, final Callback callback) {
        KefuHttpClient.asyncGetInviteEvaluation(toUser, "", new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                try {
                    JSONObject jsonObject = new JSONObject(value);
                    String status = jsonObject.getString("status");
                    if (!"OK".equalsIgnoreCase(status)) {
                        if (callback != null) {
                            callback.onError(-1, "server is error");
                        }
                        return;
                    }
                    JSONArray jsonEntites = jsonObject.getJSONArray("entities");
                    Message message = Message.createReceiveMessage(Message.Type.TXT);
                    message.addBody(new EMTextMessageBody(""));
                    JSONObject weichatJson = new JSONObject();
                    weichatJson.put("ctrlType", "inviteEnquiry");
                    JSONObject ctrlArgsJson = new JSONObject();
                    ctrlArgsJson.put("inviteId", 0);
                    ConversationInfo conversationInfo = getConversation(toUser).getConversationInfo();
                    if (conversationInfo != null){
                        ctrlArgsJson.put("serviceSessionId", conversationInfo.session_id);
                    }
                    ctrlArgsJson.put("evaluationDegree", jsonEntites);
                    weichatJson.put("ctrlArgs", ctrlArgsJson);
                    JSONObject officialAccountJson = new JSONObject();
                    OfficialAccount officialAccount = getConversation(toUser).officialAccount();
                    if (officialAccount != null && officialAccount.getId() != null) {
                        officialAccountJson.put("official_account_id", officialAccount.getId());
                    }
                    weichatJson.put("official_account", officialAccountJson);
                    message.setAttribute("weichat", weichatJson);
                    message.setMessageTime(System.currentTimeMillis());
                    message.setMsgId(UUID.randomUUID().toString());
                    message.setFrom(toUser);
                    saveMessage(message);
                    notifyMessageSent();
                    if (callback != null){
                        callback.onSuccess();
                    }
                } catch (Exception e) {
                    if (callback != null) {
                        callback.onError(-1, "invite evaluation message error:" + e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    public void asyncSendInviteEvaluationMessage(final String toUser, String serviceSessionId, final Callback callback) {
        KefuHttpClient.asyncGetInviteEvaluation(toUser, serviceSessionId, new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                try {
                    JSONObject jsonObject = new JSONObject(value);
                    String status = jsonObject.getString("status");
                    if (!"OK".equalsIgnoreCase(status)) {
                        if (callback != null) {
                            callback.onError(-1, "server is error");
                        }
                        return;
                    }
                    JSONArray jsonEntites = jsonObject.getJSONArray("entities");
                    Message message = Message.createReceiveMessage(Message.Type.TXT);
                    message.addBody(new EMTextMessageBody(""));
                    JSONObject weichatJson = new JSONObject();
                    weichatJson.put("ctrlType", "inviteEnquiry");
                    JSONObject ctrlArgsJson = new JSONObject();
                    ctrlArgsJson.put("inviteId", 0);
                    ConversationInfo conversationInfo = getConversation(toUser).getConversationInfo();
                    if (conversationInfo != null){
                        ctrlArgsJson.put("serviceSessionId", conversationInfo.session_id);
                    }
                    ctrlArgsJson.put("evaluationDegree", jsonEntites);
                    weichatJson.put("ctrlArgs", ctrlArgsJson);
                    JSONObject officialAccountJson = new JSONObject();
                    OfficialAccount officialAccount = getConversation(toUser).officialAccount();
                    if (officialAccount != null && officialAccount.getId() != null) {
                        officialAccountJson.put("official_account_id", officialAccount.getId());
                    }
                    weichatJson.put("official_account", officialAccountJson);
                    message.setAttribute("weichat", weichatJson);
                    message.setMessageTime(System.currentTimeMillis());
                    message.setMsgId(UUID.randomUUID().toString());
                    message.setFrom(toUser);
                    saveMessage(message);
                    notifyMessageSent();
                    if (callback != null){
                        callback.onSuccess();
                    }
                } catch (Exception e) {
                    if (callback != null) {
                        callback.onError(-1, "invite evaluation message error:" + e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null) {
                    callback.onError(error, errorMsg);
                }
            }
        });
    }



    /**
     * 清空会话
     * @param username ToUserName
     */
    public void clearConversation(String username){
        KefuConversationManager.getInstance().clearConversation(username);
    }


    public interface MessageListener {
        void onMessage(List<Message> msgs);
        void onCmdMessage(List<Message> msgs);
        void onMessageStatusUpdate();
        void onMessageSent();
    }

    /**
     * 接收IM消息，客服消息已经被过滤，目前只实现上屏消息，cmd消息未过滤
     */
    public interface IMMessageListener extends MessageListener{
        void messagesDidIMReceive(List<Message> msgs);
    }

    public interface AgentInputListener{
        void onInputState(String input);
    }

    public interface VisitorWaitListener{
        void waitCount(int num);
    }

    /**
     * 获取企业欢迎语
     */
    public void getEnterpriseWelcome(final ValueCallBack<String> callback){
        KefuHttpClient.getEnterpriseWelcome(callback);
    }

    /**
     * 获取企业欢迎语（根据语种自动翻译）
     * 先初始化语种
     * String visitorUserName 访客登录用户名
     */
    public void getEnterpriseWelcome(String visitorUserName, final ValueCallBack<String> callback){
        KefuHttpClient.getEnterpriseWelcome(visitorUserName, callback);
    }

    /**
     * 获取机器人欢迎语
     *
     * @param imServiceNumber imServiceNumber号码，demo的获取方法是  Preferences.getInstance().getCustomerAccount();
     */
    public void getRobotWelcome(final String imServiceNumber, final ValueCallBack<JSONObject> callBack){
        KefuHttpClient.getRobotWelcome(imServiceNumber, callBack);
    }

    /**
     *  提交机器人解决未解决评价
     * @param msg 要评价的消息
     * @param isResolved 是否解决用户问题
     * @param tags 评价的标签
     * @param callBack 回调是否提交成功
     */
    public void postRobotQuality(Message msg, final boolean isResolved, final List<String> tags, final EMCallBack callBack) {
        KefuHttpClient.postRobotQuality(msg,isResolved, tags, callBack);
    }

    /**
     *  获取服务器配置的解决与否的标签
     * @param msg 要评价的消息
     * @param callBack 返回服务器的评价标签
     */
    public void getRobotQualityTags(final Message msg, final EMValueCallBack<List<String>> callBack) {
        KefuHttpClient.getRobotQualityTags(msg,callBack);
    }

    /**
     * 获取询前引导菜单
     */
    public void getTransferGuideMenu(final String conversationId, final ValueCallBack<JSONObject> callBack){
        if (getConversation(conversationId) != null) {
            String sessionState = sessionStates.get(conversationId);

            if ( sessionState == null || sessionState.equals("ServiceSessionClosedEvent") || sessionState.equals("ServiceSessionAbortedEvent")) {
                KefuHttpClient.getTransferGuideMenu(conversationId, callBack);
            } else {
                callBack.onError(-1, "session in progress");
            }
        } else {
            callBack.onError(-1, "no conversation");
        }
    }

    /**
     * 获取当前会话状态
     */
    public void getCurrentSessionId(final String toChatUsername, final ValueCallBack<String> callback){
        KefuHttpClient.getCurrentSessionStatus(toChatUsername, new ValueCallBack<String>() {
            @Override
            public void onSuccess(String value) {
                if (callback != null){
                    try{
                        JSONObject jsonObject = new JSONObject(value);
                        String status = jsonObject.getString("status");
                        if (status != null && status.equalsIgnoreCase("ok")){
                            JSONArray entityArr = jsonObject.getJSONArray("entities");
                            if (entityArr != null && entityArr.length() > 0){
                                callback.onSuccess(entityArr.getString(0));
                            }else{
                                callback.onSuccess("");
                            }
                        }else{
                            String description = jsonObject.getString("errorDescription");
                            callback.onError(-1, description);
                        }
                    }catch (Exception e){
                        callback.onError(-1, "request failed:" + android.util.Log.getStackTraceString(e));
                    }
                }

            }

            @Override
            public void onError(int error, String errorMsg) {
                if (callback != null){
                    callback.onError(error, errorMsg);
                }
            }
        });
    }

    /**
     * 获取当前sessionId
     * @param toChatUsername IMServiceNumber
     * @param tenant 租户Id
     * @param userName 当前用户名
     * @param callback 回调，返回数据比较全面
     */
    public void getCurrentSessionId(String toChatUsername, String tenant, String userName, final ValueCallBack<String> callback){
        // GET https://sandbox.kefu.easemob.com/v1/webimplugin/tenant/77556/visitors/3e4e907d3b904d48bf003d0ae1cd05b98690/CurrentServiceSession?techChannelInfo=1402220224092325%23kefuchannelapp77556%23kefuchannelimid_248171
        /*String appkey = ChatClient.getInstance().appKey();
        String techChannelInfo = appkey + "#" + toChatUsername;
        techChannelInfo = techChannelInfo.replace("#", "%23");*/
        KefuHttpClient.getCurrentSession(toChatUsername, tenant, userName, callback);
    }


    public void cancelVideoConferences(final String toChatUsername, final ValueCallBack<String> callBack){
        new Thread(new Runnable() {
            @Override
            public void run() {
                OfficialAccount officialAccount = getConversation(toChatUsername).officialAccount();
                if (officialAccount == null){
                    officialAccount = MarketingHttpClient.getSystemOfficialAccount(toChatUsername);
                }
                if (officialAccount != null && officialAccount.getId() != null) {
                    final ConversationInfo info = MarketingHttpClient.getLastestSession(officialAccount.getId(), toChatUsername);
                    if (info == null || info.session_id == null) {
                        EMLog.e(TAG, "sessionid is null");
                        if (callBack != null) {
                            callBack.onError(-1, "session is null");
                        }
                    } else {
                        KefuHttpClient.asyncCancelVideoConferences(info.session_id, callBack);
                    }
                }
            }
        }).start();
    }


    // 问题解决评价 通过页面设置，满意度评价 --> APP，微信，网页，通过如下接口返回勾选的名称
    public void asyncProblemSolvingOnServiceSessionResolved(String tenantId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncProblemSolvingOnServiceSessionResolved(tenantId, callBack);
    }

    // 问题解决评价引导语 通过页面设置
    public void asyncEvalSolveWord(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncEvalSolveWord(tenantId, serviceSessionId, callBack);
    }

    // 问题解决评价，通过页面设置，通过如下接口获取设置值，例如：已解决，未解决
    public void asyncResolutionParams(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncResolutionParams(tenantId, serviceSessionId, callBack);
    }

    // 满意度评分引导语，通过页面设置，通过如下接口获取设置值
    public void asyncGreetingMsgEnquiryInvite(String tenantId, String serviceSessionId, final ValueCallBack<String> callBack){
        MarketingHttpClient.asyncGreetingMsgEnquiryInvite(tenantId, serviceSessionId, callBack);
    }

    /**
     * 在线聊天，通知坐席，消息标记已读
     * @param tenantId 租户id
     * @param sessionId 会话id
     * @param callBack 回调
     */
    public void asyncMarkAllMessagesAsRead(String tenantId, String sessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncMarkAllMessagesAsRead(tenantId, sessionId, callBack);
    }

}
