package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 账号工具类（sdk外部请不要调用）
 */

public class OfficialAccount implements Parcelable{
	static final String KEY_ID = "official_account_id";
	static final String KEY_NAME = "name";
	static final String KEY_TYPE = "type";
	static final String KEY_IMG = "img";
	static final String KEY_OFFICIAL_ACCOUNT = "official_account";
	static final String SEPARATOR = "#|";
	static final String KEY_MARKETING_TASK_ID = "marketing_task_id";
	static final String KEY_MARKETING = "marketing";

	private String id;
	private String name;
	private String type;
	private String img;

	 OfficialAccount(){}

	private OfficialAccount(Parcel in) {
		id = in.readString();
		name = in.readString();
		type = in.readString();
		img = in.readString();
	}

	public static final Creator<OfficialAccount> CREATOR = new Creator<OfficialAccount>() {
		@Override
		public OfficialAccount createFromParcel(Parcel in) {
			return new OfficialAccount(in);
		}

		@Override
		public OfficialAccount[] newArray(int size) {
			return new OfficialAccount[size];
		}
	};

	@Override
	public String toString() {
		String content = "";
		JSONObject jsonObject = new JSONObject();
		try {
			jsonObject.put(KEY_ID, id);
			jsonObject.put(KEY_NAME, name);
			jsonObject.put(KEY_TYPE, type);
			jsonObject.put(KEY_IMG, img);
			content = jsonObject.toString();
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return content;
	}



	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getImg() {
		return img;
	}

	void setImg(String img) {
		this.img = img;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(id);
		dest.writeString(name);
		dest.writeString(type);
		dest.writeString(img);
	}
}
