package com.hyphenate.chat;

import android.app.Application;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import java.io.FileInputStream;
import java.lang.reflect.Method;


public class ProcessUtils {
    private static String mCurrentProcessName;

    public static String getCurrentProcessName() {
        if (TextUtils.isEmpty(mCurrentProcessName)) {
            mCurrentProcessName = getProcessNameFromSdk();
            if (TextUtils.isEmpty(mCurrentProcessName)) {
                mCurrentProcessName = getProcessNameFromActivityThread();
                if (TextUtils.isEmpty(mCurrentProcessName)) {
                    mCurrentProcessName = getProcessNameFromCmd();
                    mCurrentProcessName = !TextUtils.isEmpty(mCurrentProcessName) ? mCurrentProcessName : "";
                }
            }
        }
        return mCurrentProcessName;
    }

    private static String getProcessNameFromSdk() {
        return Build.VERSION.SDK_INT >= 28 ? Application.getProcessName() : null;
    }

    private static String getProcessNameFromActivityThread() {
        String var0 = null;
        try {
            Method var1 = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", (Class[])(new Class[0]));
            var1.setAccessible(true);
            Object var2 = var1.invoke((Object)null);
            if (var2 instanceof String) {
                var0 = (String)var2;
            }
        } catch (Throwable var3) {
            Log.e("ProcessUtil", "getCurrentProcessNameByActivityThread failed, " + var3.getMessage());
        }

        return var0;
    }

    private static String getProcessNameFromCmd() {
        FileInputStream var0 = null;
        String var5;
        try {
            String var1 = "/proc/self/cmdline";
            var0 = new FileInputStream(var1);
            byte[] var2 = new byte[256];

            int var3;
            int var4;
            for(var3 = 0; (var4 = var0.read()) > 0 && var3 < var2.length; var2[var3++] = (byte)var4) {}
            if (var3 <= 0) {
                return "";
            }

            var5 = new String(var2, 0, var3, "UTF-8");
        } catch (Throwable var16) {
            return "";
        } finally {
            try {
                if (var0 != null) {
                    var0.close();
                }
            } catch (Throwable var15) {
                var15.printStackTrace();
            }

        }
        return var5;
    }
}