package com.hyphenate.chat;

import com.hyphenate.util.EMLog;

public class VecConfig {
    private static final String TAG = "VecConfig";
    private static VecConfig sVecConfig;
    private boolean visitorCameraOff;
    private String mUserName = "";
    private String mVisitorId;
    private String mSessionId;
    private volatile boolean mIsVecVideo;

    private boolean mIsOnLine;
    private String mCallTimer;
    private String mRtcSessionId;
    private String mTenantId;
    private String mTenantName;
    private String mAvatarImage;

    private volatile boolean mIsOldVideo;

    // 是否开会度
    private volatile boolean mIsEnable;

    public  boolean isOnLine(){
        return mIsOnLine;
    }

    public void setIsOnLine(boolean isOnLine){
        this.mIsOnLine = isOnLine;
    }

    public static VecConfig newVecConfig(){
        if (sVecConfig == null){
            synchronized (VecConfig.class){
                if (sVecConfig == null){
                    sVecConfig = new VecConfig();
                }
            }
        }
        return sVecConfig;
    }

    // 区分新版旧版vec
    public boolean isVecVideo(){
        EMLog.e(TAG,"区分新版旧版vec isVecVideo = "+mIsVecVideo);
        return mIsVecVideo;
    }

    public void setVecVideo(boolean isVecVideo){
        EMLog.e(TAG,"区分新版旧版vec setVecVideo = "+isVecVideo);
        this.mIsVecVideo = isVecVideo;
    }

    public boolean isOpenCamera(){
        return visitorCameraOff;
    }

    public void setCameraState(boolean visitorCameraOff){
        this.visitorCameraOff = !visitorCameraOff;
    }

    public void setUserName(String userName){
        this.mUserName = userName;
    }

    public String getUserName(){
        return mUserName;
    }

    public void setTenantName(String tenantName) {
        mTenantName = tenantName;
    }

    public String getTenantName(){
        return mTenantName;
    }

    public void setAvatarImage(String avatarImage) {
        mAvatarImage = avatarImage;
    }

    public String getAvatarImage(){
        return mAvatarImage;
    }

    public void setVisitorId(String visitorId) {
        mVisitorId = visitorId;
    }

    public void setSessionId(String sessionId) {
        mSessionId = sessionId;
    }

    public String getSessionId() {
        return mSessionId;
    }

    public String getVisitorId() {
        return mVisitorId;
    }

    public void setVideoCallTimer(String callTimer) {
        this.mCallTimer = callTimer;
    }

    public String getCallTimer() {
        return mCallTimer;
    }

    public void setWaitSessionId(String rtcSessionId) {
        this.mRtcSessionId = rtcSessionId;
    }
    public String getWaitSessionId(){
        return mRtcSessionId;
    }

    public void setWaitTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public String getWaitTenantId() {
        return mTenantId;
    }



    // 设置vec是否开灰度
    public void setVideoSwitch(boolean isEnable) {
        this.mIsEnable = isEnable;
    }

    public boolean isEnableVideo() {
        return mIsEnable;
    }

    // 旧版视频在线灰度
    public void setOldVideo(boolean isOldVideo){
        this.mIsOldVideo = isOldVideo;
    }

    public boolean isOldVideo() {
        return mIsOldVideo;
    }
}
