package com.hyphenate.helpdesk.model;


import com.hyphenate.helpdesk.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

public class ControlMessage extends CompositeContent {

    private static final String TAG = "ControlMessage";
    static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
    static public final String TYPE_EVAL_REQUEST = "inviteEnquiry";
    static public final String TYPE_EVAL_RESPONSE = "enquiry";
    private ControlType type = null;
    private ControlArguments arguments = null;

    ControlMessage() {
        type = ContentFactory.createControlType(null);
        arguments = ContentFactory.createControlArguments(null);
        fillContents();
    }

    ControlMessage(JSONObject jsonObj) {
        String key;
        try {
            key = ContentFactory.createControlType(null).getName();
            if (jsonObj.has(key)) {
                type = ContentFactory.createControlType(jsonObj.getString(key));
            }
            key = ContentFactory.createControlArguments(null).getName();
            if (jsonObj.isNull(key)) {
                arguments = ContentFactory.createControlArguments(null);
            } else {
                arguments = ContentFactory.createControlArguments(jsonObj.getJSONObject(key));
            }
        } catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        fillContents();
    }


    public String getControlType() {
        if (type != null && !"null".equals(type.toString()))
            return type.getString();
        else
            return null;
    }

    public void setControlType(String ctrlType) {
        if (type == null) {
            type = ContentFactory.createControlType(null);
        }
        type.setString(ctrlType);
    }

    public String getId() {
        return getArgumentsValue("id");
    }

    public String getServiceSessionId() {
        return getArgumentsValue("serviceSessionId");
    }

    public String getLabel() {
        return getArgumentsValue("label");
    }

    public String getInviteId() {
        return getArgumentsValue("inviteId");
    }

    public String getDetail() {
        return getArgumentsValue("detail");
    }

    public void setDetail(String detail) {
        arguments.set("detail", detail);
    }

    public String getSummary() {
        return getArgumentsValue("summary");
    }

    public void setSummary(Object summary) {
        arguments.set("summary", summary);
    }

    private String getArgumentsValue(String key) {
        if (arguments != null)
            return arguments.get(key);
        else
            return null;
    }

    public void setArgumentsValue(String key, Object value){
        if (arguments != null){
            arguments.set(key, value);
        }
    }


    public String getParentName() {
        return PARENT_NAME;
    }

    @Override
    protected void fillContents() {
        if (type != null)
            contents.add(type);
        if (arguments != null)
            contents.add(arguments);
    }

}

class ControlType extends Content {

    static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
    static public final String NAME = "ctrlType";

    ControlType() {
        super();
    }

    ControlType(String value) {
        super(value);
    }


    public String getName() {
        return NAME;
    }

    public String getParentName() {
        return PARENT_NAME;
    }


}

class ControlArguments extends Content {

    static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
    static public final String NAME = "ctrlArgs";

    ControlArguments() {
        super();
    }

    ControlArguments(JSONObject jsonObj) {
        super(jsonObj);
    }


    public String getName() {
        return NAME;
    }

    public String getParentName() {
        return PARENT_NAME;
    }


}