package com.hyphenate.helpdesk.model;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 满意度
 */

public class EvaluationInfo extends Content {

	private static final String TAG = EvaluationInfo.class.getSimpleName();

	static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
	static public final String NAME = "ctrlType";
	static public final String VALUE = "inviteEnquiry";
	static public final String ARGS = "ctrlArgs";

	public EvaluationInfo() {
		super();
	}

	public EvaluationInfo(String value) {
		super(value);
	}

	public EvaluationInfo(JSONObject argObj){
		if (argObj != null ){
			try {
				if (argObj.has("inviteId")){
					inviteId = argObj.getString("inviteId");
				}
				if (argObj.has("serviceSessionId")){
					sessionId = argObj.getString("serviceSessionId");
				}
				parseResolutionParam(argObj);
				if (argObj.has("evaluationDegree") && !argObj.isNull("evaluationDegree")){
					JSONArray jsonArr = argObj.optJSONArray("evaluationDegree");
					if (jsonArr != null){
						degreeList = new ArrayList<>();
						for (int i = 0; i < jsonArr.length(); i++){
							JSONObject degreeJsonObj = jsonArr.getJSONObject(i);
							if (degreeJsonObj != null){
								Degree degree = new Degree();
								degree.id = degreeJsonObj.getInt("id");
								if (degreeJsonObj.has("name")){
									degree.name = degreeJsonObj.getString("name");
								}
								if (degreeJsonObj.has("score")){
									degree.score = degreeJsonObj.getInt("score");
								}
								if (degreeJsonObj.has("level")){
									degree.level = degreeJsonObj.getInt("level");
								}
								if (degreeJsonObj.has("status")){
									degree.status = degreeJsonObj.getString("status");
								}
								if (degreeJsonObj.has("appraiseTags") && !degreeJsonObj.isNull("appraiseTags")){
									JSONArray tagJsonArr = degreeJsonObj.getJSONArray("appraiseTags");
									degree.appraiseTag = new ArrayList<>();
									for (int j = 0; j < tagJsonArr.length(); j++){
										JSONObject tagJsonObj = tagJsonArr.getJSONObject(j);
										TagInfo tagInfo = new TagInfo();
										tagInfo.id = tagJsonObj.getInt("id");
										if (tagJsonObj.has("name")){
											tagInfo.name = tagJsonObj.getString("name");
										}
										if (tagJsonObj.has("tenantId")){
											tagInfo.tenantId = tagJsonObj.getString("tenantId");
										}
										if (tagJsonObj.has("tagSeqId")){
											tagInfo.tagSeqId = tagJsonObj.getString("tagSeqId");
										}
										if (tagJsonObj.has("evaluationDegreeId")){
											tagInfo.degreeId = tagJsonObj.getString("evaluationDegreeId");
										}
										degree.appraiseTag.add(tagInfo);
									}
								}
								degreeList.add(degree);
							}
						}
					}
				}


			} catch (JSONException e) {
				e.printStackTrace();
			}
		}

	}

	private void parseResolutionParam(JSONObject argObj) throws JSONException{
		if (argObj.has("resolutionEnable")){
			mResolutionEnable = argObj.getBoolean("resolutionEnable");
		}
		if (argObj.has("resolutionParam")){
			JSONArray resolutionParam = argObj.getJSONArray("resolutionParam");
			mResolutionParams = new ArrayList<>();
			for (int i = 0; i < resolutionParam.length(); i++){
				ResolutionParam param = new ResolutionParam();
				JSONObject jsonObject = resolutionParam.getJSONObject(i);

				if (jsonObject.has("id")){
					param.setId(jsonObject.getString("id"));
				}

				if (jsonObject.has("name")){
					param.setName(jsonObject.getString("name"));
				}

				if (jsonObject.has("score")){
					param.setScore(jsonObject.getString("score"));
				}

				if (jsonObject.has("resolutionParamTags")){
					param.setResolutionParamTags(jsonObject.getJSONArray("resolutionParamTags"));
				}

				mResolutionParams.add(param);
			}
		}
	}


	private String inviteId;
	private String sessionId;
	private List<Degree> degreeList;

	// evaluateWay 评价方式：由前端传入，visitor访客主动评价，agent坐席邀请，system强制邀请访客点击关闭窗口或会话结束
	private String evaluateWay = "visitor";

	private List<ResolutionParam> mResolutionParams;
	private boolean mResolutionEnable;

	public void setEvaluateWay(String evaluateWay) {
		this.evaluateWay = evaluateWay;
	}

	public String getEvaluateWay() {
		return evaluateWay;
	}

	public boolean isResolutionEnable() {
		return mResolutionEnable;
	}

	public void setResolutionParams(List<ResolutionParam> resolutionParams, String evaluateWay) {
		mResolutionParams = resolutionParams;
		this.evaluateWay = evaluateWay;
	}

	public List<ResolutionParam> getResolutionParams() {
		return mResolutionParams;
	}

	public String getInviteId() {
		return inviteId;
	}

	public List<Degree> getDegreeList() {
		return degreeList;
	}

	public String getSessionId() {
		return sessionId;
	}

	public Degree getDegree(int level){
		if (degreeList != null && !degreeList.isEmpty()){
			for (Degree d : degreeList){
				if (d.level == level){
					return d;
				}
			}
		}
		return null;
	}



	@Override
	public String getName() {
		return NAME;
	}

	@Override
	public String getParentName() {
		return PARENT_NAME;
	}

	private String getCtrlType() {
		return get("ctrlType");
	}

	public boolean isEvaluationMessage(){
		if (content.has(NAME) && !content.isNull(NAME)) {
			String ctrlType = getCtrlType();
			return ctrlType != null && ctrlType.equals(VALUE);
		}
		return false;
	}

	public static class Degree{
		private int id;
		private String name;
		private int score;
		private int level;
		private String status;
		private List<TagInfo> appraiseTag;

		public int getId() {
			return id;
		}

		public List<TagInfo> getAppraiseTag() {
			return appraiseTag;
		}

		public int getLevel() {
			return level;
		}

		public String getName() {
			return name;
		}

		public int getScore() {
			return score;
		}

		public String getStatus() {
			return status;
		}

		public void setLevel(int level) {
			this.level = level;
		}
	}

	public static class TagInfo{
		private int id;
		private String name;
		private String tenantId;
		private String tagSeqId;
		private String degreeId;

		public String getDegreeId() {
			return degreeId;
		}

		public int getId() {
			return id;
		}

		public String getName() {
			return name;
		}

		public String getTagSeqId() {
			return tagSeqId;
		}

		public String getTenantId() {
			return tenantId;
		}
	}

	public static class ResolutionParamTags{

	}

	public static class ResolutionParam{
		/* "id":"2",
				 "name":"未解决",
				 "score":"2",
				 "resolutionParamTags":[

				 ]*/
		private String id;
		private String name;
		private String score;
		//private List<ResolutionParamTags> resolutionParamTags;
		private JSONArray resolutionParamTags;

		public void setId(String id) {
			this.id = id;
		}

		public String getId() {
			return id;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getName() {
			return name;
		}

		public void setScore(String score) {
			this.score = score;
		}

		public String getScore() {
			return score;
		}

		public void setResolutionParamTags(JSONArray resolutionParamTags) {
			this.resolutionParamTags = resolutionParamTags;
		}

		public JSONArray getResolutionParamTags() {
			return resolutionParamTags;
		}
	}


}
