package com.hyphenate.helpdesk.model;

import android.text.TextUtils;

import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.Message;

import org.json.JSONObject;

/**
 * 转人工消息
 */
public class ToCustomServiceInfo extends Content {

    static public final String PARENT_NAME = MessageHelper.TAG_WEICHAT;
    static public final String NAME = "ctrlArgs";
    static public final String TYPE = "ctrlType";
    static final String TYPE_VALUE = "TransferToKfHint";
    static final String TRANSFER_KF_INFO = "transferToHumanButtonInfo";
    static final String TRANSFER_KF_ID = "transferToHumanId";
    static final String TRANSFER_KF_LABEL = "suggestionTransferToHumanLabel";
    /*transferToHumanButtonInfo =         {
        suggestionTransferToHumanLabel = "\U8f6c\U4eba\U5de5";
        transferToHumanId = "MenuBtn-TransferToHuman-";
    };*/

    public ToCustomServiceInfo() {
        super();
    }

    public ToCustomServiceInfo(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String getName() {
        return NAME;
    }

    public String getParentName() {
        return PARENT_NAME;
    }

    public String getId() {
        return get("id");
    }

    public String getServiceSessionId() {
        return get("serviceSessionId");
    }

    public String getLable() {
        if (hasTransferGroupInfo()) {
            return getCustomTransferLabel();
        }
        return get("label");
    }

    public String getCtrlType() {
        return get("ctrlType");
    }

    public String getCustomTransferLabel() { return get(TRANSFER_KF_LABEL); }

    public String getTransferKFID() { return get(TRANSFER_KF_ID); }

    public boolean hasTransferGroupInfo() {
        if (content.has(TRANSFER_KF_ID) && !content.isNull(TRANSFER_KF_ID)) {
            return true;
        }
        return false;
    }

    public boolean isToCustomServiceMessage() {
        if (content.has("ctrlType") && !content.isNull("ctrlType")) {
            String ctrlType = getCtrlType();
            return ctrlType != null && ctrlType.equals("TransferToKfHint");
        }
        return false;
    }

    // 转人工
    public void sendToCustomServiceMessage(Message message){
        if (TextUtils.isEmpty(getTransferKFID())
                &&  (TextUtils.isEmpty(getId()) || TextUtils.isEmpty(getServiceSessionId()))){
            return;
        }

        ChatClient.getInstance().chatManager().sendMessage(Message.createTranferToKefuMessage(message.from(), this));
    }
}
