package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;

public class TransferGuideMenuInfo extends Content {
    private static final String TAG = "TransferGuideMenuInfo";

    static public final String PARENT_NAME = MessageHelper.TAG_MSGTYPE;
    static public final String NAME = "choice";
    static public final String TRANSFER_GUIDE = "transferManualGuide";
    static public final String MODE = "mode";
    static final String NAME_ITEMS = "items";
    static final String NAME_LIST = "list";
    static final String ITEM_TRANSFER_NOTE = "hasTransferNote";

    public TransferGuideMenuInfo() {
        super();
    }

    public TransferGuideMenuInfo(JSONObject jsonObj) {
        super(jsonObj);
    }


    public String getName() {
        return NAME;
    }

    public String getParentName() {
        return PARENT_NAME;
    }

    public String getTitle() {
        String title = get("title");
        return title; // use different key with robot menu
    }

    public String getMode() { return get(MODE); }

    public Collection<TransferGuideMenuInfo.Item> getItems() {
        Collection<JSONObject> objArray = getObjectArray(NAME_ITEMS);
        if (objArray == null){
            return null;
        }
        Collection<TransferGuideMenuInfo.Item> items = new ArrayList<TransferGuideMenuInfo.Item>();
        TransferGuideMenuInfo.Item item;
        for (JSONObject obj : objArray) {
            item = createItem(obj);
            if (item != null) {
                items.add(item);
            }
        }
        return items;
    }

    public Collection<String> getList(){
        return getStringArray(NAME_LIST);
    }

    private TransferGuideMenuInfo.Item createItem(JSONObject obj) {
        TransferGuideMenuInfo.Item item = null;
        String id = null;
        String menuId = null;
        String queueType = null;
        String queueName = null;

        try {
            queueType = obj.getString("queueType");
        }catch (JSONException ex) {
//            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }

        try {
            queueName = obj.getString("queueName");
        } catch (JSONException ex) {
//            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }

        try {
            menuId = obj.getString("id");
        } catch (JSONException ex) {
//            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }

        try {
            id = obj.getString("queueId");
        } catch (JSONException ex) {
//            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }

        if (id == null) {
            try {
                id = obj.getString("id");
            } catch (JSONException ex) {
//                ex.printStackTrace();
                Log.e(TAG, ex.getMessage());
            }
        }

        try {
            item = new TransferGuideMenuInfo.Item(id, obj.getString("name"), queueType);
            item.setContent(obj);
            item.setMenuId(menuId);
            if (queueName != null) {
                item.setQueueName(queueName);
            }
        } catch (JSONException ex) {
//            ex.printStackTrace();
            Log.e(TAG, ex.getMessage());
        }

        return item;
    }

    public class Item {
        private String queueId;
        private String menuId;
        private String name;
        private String queueType;
        private String queueName;
        private JSONObject jsonObj;

        Item(String id, String name, String queueType) {
            this.queueId = id;
            this.name = name;
            this.queueType = queueType;
        }

        public void setContent(JSONObject jsonObj) {
            this.jsonObj = jsonObj;
        }

        public String getQueueId() {
            return queueId;
        }

        public String getMenuId() {
            return menuId;
        }

        public void setMenuId(String menuId) {
            this.menuId = menuId;
        }

        public String getName() {
            return name;
        }

        public String getQueueType() {
            return queueType;
        }

        public void setQueueType(String queueType) {
            this.queueType = queueType;
        }

        public String getQueueName() { return queueName; }

        public void setQueueName(String name) { this.queueName = name; }

        public String toString() {
            return jsonObj.toString();
        }

        public boolean isLeaveMessage() {return queueId.equals(ITEM_TRANSFER_NOTE); }

    }
}
