package com.hyphenate.helpdesk.model;

import android.text.TextUtils;

import org.json.JSONObject;

public class TransferGuideQueneInfo extends Content {
    private static final String TAG = "TransferGuideQueneInfo";

    static public final String PARENT_NAME = MessageHelper.TAG_MSGTYPE;
    static public final String NAME = "choice";

    public TransferGuideQueneInfo() {
        super();
    }

    public TransferGuideQueneInfo(JSONObject jsonObj) {
        super(jsonObj);
    }


    public String getName() {
        return NAME;
    }

    public String getParentName() {
        return PARENT_NAME;
    }


    public TransferGuideQueneInfo setMenuId(String id){
        if (!TextUtils.isEmpty(id)){
            set("menuid", id);
        }
        return this;
    }


    public TransferGuideQueneInfo setQueueId(String id){
        if (!TextUtils.isEmpty(id)){
            set("queueId", id);
        }
        return this;
    }

    public TransferGuideQueneInfo setQueueType(String type) {
        if (!TextUtils.isEmpty(type)) {
            set("queueType", type);
        }
        return this;
    }
}
