/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.agora;

import android.graphics.Color;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

public class AgoraStreamItem {
    private int uid;
    private TextureView surfaceView;
    private View flatView;
    private FrameLayout mRemoteView;
    private View mCameraView;
    private int mRealUid;
    private TextView mTextViewName;
    private TextView mIconTextView;
    private String mName;
    private View whiteboardDef;
    private boolean mIsOpenVoice = true;
    private boolean mIsOpenCamera = true;
    private static final String sIconOpen = "\uecb1";
    private static final String sIconClose = "\ue6eb";
    private static final String sIconOpenColor = "#3B84F7";
    private static final String sIconCloseColor = "#ff4400";

    public void init() {
        this.mIsOpenVoice = true;
        this.mTextViewName = null;
        this.mIconTextView = null;
        this.mRemoteView = null;
        this.mCameraView = null;
    }

    public int getRealUid() {
        return this.mRealUid;
    }

    public void setRealUid(int realUid) {
        this.mRealUid = realUid;
    }

    public void setIconTextView(TextView iconTextView) {
        this.mIconTextView = iconTextView;
    }

    public TextView getIconTextView() {
        return this.mIconTextView;
    }

    public void setOpenVoice(boolean openVoice) {
        this.mIsOpenVoice = openVoice;
        this.updateVoiceIcon();
    }

    public void setCameraView(View cameraView) {
        this.mCameraView = cameraView;
    }

    public View getCameraView() {
        return this.mCameraView;
    }

    public void setOpenCamera(boolean isOpenCamera) {
        this.mIsOpenCamera = isOpenCamera;
        this.updateCameraView();
    }

    public boolean isOpenCamera() {
        return this.mIsOpenCamera;
    }

    public boolean isOpenVoice() {
        return this.mIsOpenVoice;
    }

    public void setTextViewName(TextView textViewName) {
        this.mTextViewName = textViewName;
    }

    public TextView getTextViewName() {
        return this.mTextViewName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void updateName() {
        this.updateCameraView();
        if (this.mTextViewName != null) {
            this.mTextViewName.setText((CharSequence)this.mName);
        }
        if (this.mIconTextView != null) {
            if (this.mIsOpenVoice) {
                this.mIconTextView.setText((CharSequence)sIconOpen);
                this.mIconTextView.setTextColor(Color.parseColor((String)sIconOpenColor));
            } else {
                this.mIconTextView.setText((CharSequence)sIconClose);
                this.mIconTextView.setTextColor(Color.parseColor((String)sIconCloseColor));
            }
            this.showAndHidden((View)this.mIconTextView, this.mRealUid != Integer.MAX_VALUE);
        }
        this.showAndHidden((View)this.mIconTextView, this.mRealUid != Integer.MAX_VALUE);
        this.showAndHidden(this.whiteboardDef, this.mRealUid == Integer.MAX_VALUE);
    }

    private void showAndHidden(View view, boolean isShow) {
        if (view == null) {
            return;
        }
        if (isShow && view.getVisibility() != 0) {
            view.setVisibility(0);
        } else if (!isShow && view.getVisibility() == 0) {
            view.setVisibility(8);
        }
    }

    public void updateVoiceIcon() {
        if (this.mIconTextView != null) {
            if (this.mIsOpenVoice) {
                this.mIconTextView.setText((CharSequence)sIconOpen);
                this.mIconTextView.setTextColor(Color.parseColor((String)sIconOpenColor));
            } else {
                this.mIconTextView.setText((CharSequence)sIconClose);
                this.mIconTextView.setTextColor(Color.parseColor((String)sIconCloseColor));
            }
            this.showAndHidden((View)this.mIconTextView, this.mRealUid != Integer.MAX_VALUE);
        }
        this.showAndHidden(this.whiteboardDef, this.mRealUid == Integer.MAX_VALUE);
    }

    public void updateCameraView() {
        if (this.mCameraView != null) {
            this.showAndHidden(this.mCameraView, !this.mIsOpenCamera);
        }
    }

    public String getName() {
        return this.mName;
    }

    public View getFlatView() {
        return this.flatView;
    }

    public void setFlatView(View flatView) {
        this.flatView = flatView;
    }

    public TextureView getSurfaceView() {
        return this.surfaceView;
    }

    public void setSurfaceView(TextureView surfaceView) {
        this.surfaceView = surfaceView;
    }

    public void setRemoteView(FrameLayout remoteView) {
        this.mRemoteView = remoteView;
    }

    public FrameLayout getRemoteView() {
        return this.mRemoteView;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public void setWhiteboardDef(View whiteboardDef) {
        this.whiteboardDef = whiteboardDef;
    }

    public View getWhiteboardDef() {
        return this.whiteboardDef;
    }

    public String toString() {
        return "AgoraStreamItem{surfaceView=" + this.surfaceView + ", uid=" + this.uid + '}';
    }

    public void onDestroy() {
        this.surfaceView = null;
        this.mRemoteView = null;
        this.mTextViewName = null;
        this.mIconTextView = null;
        this.mCameraView = null;
    }
}

