/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Intent;
import android.os.Parcelable;
import com.hyphenate.agora.FunctionIconItem;
import com.hyphenate.agora.IAgoraMessageNotify;
import com.hyphenate.agora.IEndCallback;
import com.hyphenate.agora.IPushMessage;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.MarketingHttpClient;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.VecConfig;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgoraMessage {
    private static final String TAG = AgoraMessage.class.getSimpleName();
    private static AgoraMessage sAgoraMessage = new AgoraMessage();
    private static final Map<String, IAgoraMessageNotify> mMap = new HashMap<String, IAgoraMessageNotify>();
    private static final Map<String, IEndCallback> mMapIEnd = new HashMap<String, IEndCallback>();
    private static final Map<String, IPushMessage> mPushMessage = new HashMap<String, IPushMessage>();
    private String mCurrentChatUsername;
    public static String TYPE_LINK_MESSAGE_PUSH = "infopush";
    public static String TYPE_CARD_OCR = "cardocr";
    public static String TYPE_ELECSIGN = "elecsign";
    public static String TYPE_IDENTITYAUTH = "identityauth";
    public static String TYPE_ENQUIRYINVITE = "enquiryInvite";
    public static String TYPE_MICROPHONE = "microphone";
    public static String TYPE_CAMERA = "camera";
    public static String TYPE_FLASH_LIGHT = "flashlight";
    public static String TYPE_FOCUS_CAMERA = "focusCamera";
    public static String TYPE_CAMERA_TORCH_ON = "cameraTorchOn";
    public static String TYPE_CAMERA_CHANGE_ON = "cameraChange";
    private String mTenantId;

    private AgoraMessage() {
    }

    static void pushVecMessage(String content, String type) {
        for (String key : mPushMessage.keySet()) {
            mPushMessage.get(key).pushMessage(content, type);
        }
    }

    public synchronized void registerAgoraMessageNotify(String classKey, IAgoraMessageNotify message) {
        mMap.put(classKey, message);
    }

    public synchronized void unRegisterAgoraMessageNotify(String classKey) {
        mMap.remove(classKey);
    }

    public synchronized void registerIEndCallback(String classKey, IEndCallback callback) {
        if (mMapIEnd.containsKey(classKey)) {
            return;
        }
        mMapIEnd.put(classKey, callback);
    }

    public synchronized void unRegisterIEndCallback(String classKey) {
        mMapIEnd.remove(classKey);
    }

    public synchronized void registerVecPushMessage(String classKey, IPushMessage callback) {
        if (mPushMessage.containsKey(classKey)) {
            return;
        }
        mPushMessage.put(classKey, callback);
    }

    public synchronized void unRegisterVecPushMessage(String classKey) {
        mPushMessage.remove(classKey);
    }

    public static AgoraMessage newAgoraMessage() {
        return sAgoraMessage;
    }

    static synchronized void zuoXiToBreakOff() {
        for (String key : mMap.keySet()) {
            mMap.get(key).zuoXiToBreakOff();
        }
    }

    static synchronized void waitResponse(int callType, String rtcSessionId, String tenantId) {
        for (String key : mMapIEnd.keySet()) {
            mMapIEnd.get(key).onInitWaitPage(callType, rtcSessionId, tenantId);
        }
    }

    static synchronized void vecBreakOff() {
        for (String key : mMapIEnd.keySet()) {
            mMapIEnd.get(key).onVecZuoXiToBreakOff();
        }
    }

    static void createFlatRoom(ZuoXiSendRequestObj obj) {
        for (String key : mMap.keySet()) {
            mMap.get(key).createFlatRoom(obj);
        }
    }

    static void zuoXiActiveRequest(String msg, String to, String from) {
        try {
            VecConfig.newVecConfig().setVecVideo(true);
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.putExtra("zuo_xi_active", 1);
            intent.putExtra("msg", msg);
            intent.addFlags(0x10000000);
            intent.putExtra("type", "video");
            intent.putExtra("to", to);
            intent.putExtra("from", from);
            if (!VecConfig.newVecConfig().isEnableVideo()) {
                return;
            }
            ChatClient.getInstance().getContext().sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void zuoXiSendRequest(ZuoXiSendRequestObj obj) {
        if (obj.isAddThreeUser()) {
            for (String key : mMap.keySet()) {
                mMap.get(key).zuoXiSendThreeUserRequest(obj);
            }
            return;
        }
        try {
            Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
            intent.addFlags(0x10000000);
            intent.putExtra("type", "video");
            intent.putExtra("appid", obj.getAppId());
            intent.putExtra("zuoXiSendRequestObj", (Parcelable)obj);
            intent.putExtra("to", obj.getTo());
            intent.putExtra("from", obj.getFrom());
            ChatClient.getInstance().getContext().sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendEnouiryinvite(JSONObject enquiryInvite) {
        Intent intent = new Intent(ChatClient.getInstance().callManager().getIncomingCallBroadcastAction());
        intent.addFlags(0x10000000);
        intent.putExtra("type", TYPE_ENQUIRYINVITE);
        intent.putExtra("content", enquiryInvite.toString());
        ChatClient.getInstance().getContext().sendBroadcast(intent);
    }

    public String getCurrentChatUsername() {
        return this.mCurrentChatUsername;
    }

    public void onDestroy() {
        mMap.clear();
    }

    public void setCurrentChatUsername(String currentChatUsername) {
        this.mCurrentChatUsername = currentChatUsername;
    }

    void setTenantId(String tenantId) {
    }

    public String getTenantId() {
        return ChatClient.getInstance().tenantId();
    }

    public static void asyncGetTenantIdFunctionIcons(String tenantId, final ValueCallBack<List<FunctionIconItem>> callBack) {
        VecConfig.newVecConfig().setVideoSwitch(false);
        VecConfig.newVecConfig().setOldVideo(false);
        MarketingHttpClient.asyncGetTenantIdFunctionIcons(tenantId, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String value) {
                try {
                    ArrayList<FunctionIconItem> list = new ArrayList<FunctionIconItem>();
                    JSONObject object = new JSONObject(value);
                    if (!object.isNull("status")) {
                        String status = object.getString("status");
                        if ("ok".equalsIgnoreCase(status)) {
                            if (!object.isNull("entities")) {
                                JSONArray entities = object.getJSONArray("entities");
                                for (int i = 0; i < entities.length(); ++i) {
                                    JSONObject jsonObject = entities.getJSONObject(i);
                                    if (jsonObject == null || !jsonObject.has("grayName")) continue;
                                    String grayName = jsonObject.getString("grayName");
                                    if ("whiteBoard".equalsIgnoreCase(grayName) || "shareDesktop".equalsIgnoreCase(grayName)) {
                                        FunctionIconItem iconItem = new FunctionIconItem(grayName);
                                        if (!jsonObject.isNull("status")) {
                                            iconItem.setStatus(jsonObject.getString("status"));
                                        }
                                        if (!jsonObject.isNull("description")) {
                                            iconItem.setDescription(jsonObject.getString("description"));
                                        }
                                        if (!iconItem.isEnable()) continue;
                                        list.add(iconItem);
                                        continue;
                                    }
                                    if ("agoraVideo".equalsIgnoreCase(grayName) && jsonObject.has("status")) {
                                        VecConfig.newVecConfig().setOldVideo("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                    }
                                    if (!"vecIndependentVideo".equalsIgnoreCase(grayName) || !jsonObject.has("status")) continue;
                                    VecConfig.newVecConfig().setVideoSwitch("enable".equalsIgnoreCase(jsonObject.getString("status")));
                                }
                            }
                            callBack.onSuccess(list);
                        } else {
                            VecConfig.newVecConfig().setVideoSwitch(false);
                            EMLog.e((String)TAG, (String)("asyncGetTenantIdFunctionIcons --> status = " + status));
                        }
                    } else {
                        VecConfig.newVecConfig().setVideoSwitch(false);
                        callBack.onError(-1, value);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    VecConfig.newVecConfig().setVideoSwitch(false);
                    callBack.onError(-1, e.toString());
                    EMLog.e((String)TAG, (String)("asyncGetTenantIdFunctionIcons --> JSONException e = " + e.toString()));
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                Log.e("ttttttttttttt", "errorMsg = " + errorMsg);
                EMLog.e((String)TAG, (String)("asyncGetTenantIdFunctionIcons --> error = " + error + ", errorMsg = " + errorMsg));
                callBack.onError(error, errorMsg);
            }
        });
    }

    public static void asyncUploadFile(String file, String token, int callId, String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncUploadFile(file, token, callId, tenantId, callBack);
    }

    public static String getToken() {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            throw new RuntimeException();
        }
        return ChatClient.getInstance().imAccessToken();
    }

    public static void asyncFileConverted(String file, String token, int callId, String tenantId, String type, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncFileConverted(file, token, callId, tenantId, type, callBack);
    }

    public static void asyncFileConvertedProgress(String tenantId, String token, int callId, String type, String taskId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncFileConvertedProgress(tenantId, token, callId, type, taskId, callBack);
    }

    public static void asyncInitLanguage(String tenantId, String language, String appKey, String visitorUserName, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncInitLanguage(tenantId, language, appKey, visitorUserName, callBack);
    }

    public static void asyncInitStyle(String tenantId, String configId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncInitStyle(tenantId, configId, callBack);
    }

    public static void asyncCloseVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncCloseVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void closeVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        MarketingHttpClient.closeVec(tenantId, rtcSessionId, visitorId, callBack);
    }

    public static void getAsyncVisitorIdAndVecSessionId(String toUser, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncVisitorId(toUser, callBack);
    }

    public static void getVisitorIdAndVecSessionId(String toUser, ValueCallBack<String> callBack) {
        MarketingHttpClient.getVisitorIdAndVecSessionId(toUser, callBack);
    }

    public static void asyncResultReporting(String tenantId, String visitorId, String type, JSONObject resultObj, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncResultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    public static void resultReporting(String tenantId, String visitorId, String type, JSONObject resultObj, ValueCallBack<String> callBack) {
        MarketingHttpClient.resultReporting(tenantId, visitorId, type, resultObj, callBack);
    }

    public static void getSkillGroupMenuWithVisitorUserName(String tenantId, String visitorUserName, ValueCallBack<String> callBack) {
        MarketingHttpClient.getSkillGroupMenuWithVisitorUserName(tenantId, visitorUserName, callBack);
    }

    public static void asyncUploadSignatureImage(File file, String token, String tenantId, String flowId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncUploadSignatureImage(file, token, tenantId, flowId, callBack);
    }

    public static void getWaitNumber(String tenantId, String rtcSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.getWaitNumber(tenantId, rtcSessionId, callBack);
    }

    public static void asyncSubmitEvaluate(String tenantId, String jsonData, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncSubmitEvaluate(tenantId, jsonData, callBack);
    }

    public static void asyncGetInfo(String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncGetInfo(tenantId, callBack);
    }

    public static void asyncProblemSolvingOnServiceSessionResolved(String tenantId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncProblemSolvingOnServiceSessionResolved(tenantId, callBack);
    }

    public static void asyncEvalSolveWord(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncEvalSolveWord(tenantId, serviceSessionId, callBack);
    }

    public static void asyncResolutionParams(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncResolutionParams(tenantId, serviceSessionId, callBack);
    }

    public static void asyncGreetingMsgEnquiryInvite(String tenantId, String serviceSessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncGreetingMsgEnquiryInvite(tenantId, serviceSessionId, callBack);
    }

    public static String getSessionIdFromMessage(Message message) {
        String sessionId = null;
        try {
            JSONObject service_session;
            String weichat = message.getStringAttribute("weichat");
            JSONObject wc = new JSONObject(weichat);
            if (wc.has("service_session") && (service_session = wc.getJSONObject("service_session")).has("serviceSessionId")) {
                sessionId = service_session.getString("serviceSessionId");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sessionId;
    }

    public static void asyncMarkAllMessagesAsRead(String tenantId, String sessionId, ValueCallBack<String> callBack) {
        MarketingHttpClient.asyncMarkAllMessagesAsRead(tenantId, sessionId, callBack);
    }
}

