/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.agora.ZuoXiSendRequestObj;
import com.hyphenate.chat.AgoraMessage;
import com.hyphenate.chat.CallOption;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.Message;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.helpdesk.callback.Callback;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

public final class CallManager {
    static final String TAG = "callcore";
    private static CallManager sInstance;
    private String callNickName;
    private ConcurrentLinkedQueue<TicketEntity> ticketQueue = new ConcurrentLinkedQueue();
    private String currentMemberName;
    private CallOption callOption = new CallOption();
    private static final String IncomingCallAction = ".action.incomingcall";

    static synchronized CallManager getInstance() {
        if (sInstance == null) {
            sInstance = new CallManager();
        }
        return sInstance;
    }

    public String getIncomingCallBroadcastAction() {
        return ChatClient.getInstance().getContext().getPackageName() + IncomingCallAction;
    }

    void putZuoXiSend(Message message, String ticket, String callNickName, String to, String from) {
        try {
            ZuoXiSendRequestObj obj = this.get(message, ticket, callNickName);
            obj.setTo(to);
            obj.setFrom(from);
            AgoraMessage.zuoXiSendRequest(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void putTicket(Message message, String ticket, String callNickName, String to, String from) {
        try {
            ZuoXiSendRequestObj obj = this.get(message, ticket, callNickName);
            obj.setTo(to);
            obj.setFrom(from);
            AgoraMessage.zuoXiSendRequest(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ZuoXiSendRequestObj get(Message message, String ticket, String nickName) throws JSONException, HyphenateException {
        ZuoXiSendRequestObj obj = new ZuoXiSendRequestObj();
        JSONObject ticketObj = new JSONObject(ticket);
        if (!ticketObj.isNull("isThirdAgent")) {
            JSONObject agentTicket;
            boolean isThirdAgent = ticketObj.getBoolean("isThirdAgent");
            obj.setIsAddThreeUser(isThirdAgent);
            if (ticketObj.has("agentTicket") && (agentTicket = ticketObj.getJSONObject("agentTicket")).has("trueName")) {
                obj.setThreeTrueName(agentTicket.getString("trueName"));
                obj.setThreeNiceName(agentTicket.getString("niceName"));
                obj.setThreeUid(agentTicket.getInt("uid"));
                obj.setThreeCallId(agentTicket.getInt("callId"));
            }
        }
        obj.setNiceName(ticketObj.getString("niceName"));
        obj.setTrueName(ticketObj.getString("trueName"));
        obj.setCallId(ticketObj.getInt("callId"));
        obj.setUid(ticketObj.getInt("uid"));
        obj.setToken(ticketObj.getString("token"));
        obj.setAppId(ticketObj.getString("appId"));
        obj.setChannel(ticketObj.getString("channel"));
        if (TextUtils.isEmpty((CharSequence)nickName) || "null".equalsIgnoreCase(nickName)) {
            obj.setNickName(TextUtils.isEmpty((CharSequence)obj.getThreeTrueName()) ? obj.getThreeNiceName() : obj.getThreeTrueName());
        } else {
            obj.setNickName(nickName);
        }
        return obj;
    }

    public void endCall(int callId, boolean isConnected) {
        String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
        Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
        ChatManager.getInstance().sendMessage(message);
        this.exit(null);
    }

    public void endVecCall(int callId, boolean isConnected) {
        String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
        Message message = isConnected ? Message.createVecCancelVideoMessage(callId, to) : Message.createVecHangUpVideoMessage(callId, to);
        ChatManager.getInstance().sendMessage(message);
        this.exit(null);
    }

    public void createFlatRoom(int callId) {
        String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
        Message message = Message.createFlatRoomMessage(callId, to);
        ChatManager.getInstance().sendMessage(message);
    }

    public void endCall(int callId, boolean isConnected, Callback callback) {
        String to = AgoraMessage.newAgoraMessage().getCurrentChatUsername();
        Message message = isConnected ? Message.createCancelVideoMessage(callId, to) : Message.createHangUpVideoMessage(callId, to);
        ChatManager.getInstance().sendMessage(message, callback);
        this.exit(null);
    }

    public void callVideo(String chatInviteShoe, String toChatUsername) {
        Message message = Message.createVideoInviteSendMessage(chatInviteShoe, toChatUsername);
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    public void callVecVideo(String chatInviteShoe, String toChatUsername) {
        Message message = Message.createVecVideoInviteSendMessage(chatInviteShoe, toChatUsername);
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    public String getCallNickName() {
        return this.callNickName;
    }

    private void exit(Callback callback) {
        this.callNickName = null;
        this.callOption.isVideoOff = false;
        this.callOption.isMute = false;
    }

    static class TicketEntity {
        String ticket;
        String nickname;
        JSONObject extendJson;

        TicketEntity(String ticket, String nick, JSONObject extend) {
            this.ticket = ticket;
            this.nickname = nick;
            this.extendJson = extend;
        }
    }
}

