/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.CountDownUtils;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.KefuHttpClient;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.util.EMLog;
import org.json.JSONException;
import org.json.JSONObject;

class ChatConfig {
    private static final String TAG = "chat_config";
    private volatile DnsConfig dnsConfig;
    public static ChatConfig instance = new ChatConfig();

    ChatConfig() {
    }

    DnsConfig getDnsConfig() {
        return this.dnsConfig;
    }

    void loadLocalDnsConfig() {
        String serverJson;
        if (this.dnsConfig == null && (serverJson = PreferenceUtil.getInstance().getServerJson()) != null) {
            try {
                String username;
                JSONObject jsonObject = new JSONObject(serverJson);
                String fileVersion = jsonObject.optString("file_version");
                long keepAliveTime = jsonObject.optLong("connect_keep_time");
                long updateTime = jsonObject.optLong("update_time");
                long freeRequestTime = 240000L;
                if (jsonObject.has("freeze_request_time")) {
                    freeRequestTime = jsonObject.getLong("freeze_request_time");
                }
                this.dnsConfig = new DnsConfig(fileVersion, keepAliveTime, freeRequestTime, updateTime);
                EMLog.d((String)TAG, (String)("load dns config success:" + fileVersion + ", keepAliveTime:" + keepAliveTime + " ,freeRequestTime:" + freeRequestTime + ",updateTime:" + updateTime));
                if (ChatClient.getInstance().isLoggedInBefore() && !TextUtils.isEmpty((CharSequence)(username = PreferenceUtil.getInstance().getUsername()))) {
                    KefuDBManager.initDB(username);
                }
            }
            catch (JSONException e) {
                EMLog.d((String)TAG, (String)"load local dns config cannot parse json");
            }
        }
    }

    void loadDnsConfigFromRemote(boolean isforce) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (tenantId == null) {
            return;
        }
        if (!isforce) {
            try {
                long currentTime = System.currentTimeMillis();
                if (this.dnsConfig != null) {
                    Log.d((String)TAG, (String)("dnsConfig-keepAliveTime:" + this.dnsConfig.keepAliveTime + ", freezeRequestTime:" + this.dnsConfig.freezeRequestTime + "\uff0cdnsConfig.updateTime:" + this.dnsConfig.updateTime + ", currentTime:" + currentTime));
                }
                if (this.dnsConfig != null && this.dnsConfig.updateTime > 0L && currentTime - this.dnsConfig.updateTime < this.dnsConfig.freezeRequestTime) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KefuHttpClient.asyncLoadServerDns(tenantId, new ValueCallBack<String>(){

            @Override
            public void onSuccess(String serverJson) {
                try {
                    JSONObject jsonObject = new JSONObject(serverJson);
                    JSONObject jsonEntity = jsonObject.getJSONObject("entity");
                    String fileVersion = jsonEntity.getString("file_version");
                    String strConnectKeepTime = jsonEntity.getString("connect_keep_time");
                    long freezeRequestTime = 240000L;
                    if (jsonEntity.has("freeze_request_time")) {
                        String strFreezeRequestTime = jsonEntity.getString("freeze_request_time");
                        try {
                            freezeRequestTime = Long.parseLong(strFreezeRequestTime) * 60000L;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    long keepAliveTime = Long.parseLong(strConnectKeepTime);
                    DnsConfig dnsConfig = new DnsConfig(fileVersion, keepAliveTime, freezeRequestTime);
                    ChatConfig.this.saveDnsConfig(dnsConfig);
                    EMLog.d((String)ChatConfig.TAG, (String)("dns load success: keepAliveTime:" + keepAliveTime + ", freezeRequestTime:" + freezeRequestTime));
                    long triggerEventTime = PreferenceUtil.getInstance().getTriggerEventTime();
                    if (triggerEventTime > 0L) {
                        CountDownUtils.getInstance().sendBroadcast(triggerEventTime);
                    } else {
                        CountDownUtils.getInstance().sendBroadcast();
                    }
                }
                catch (JSONException e) {
                    EMLog.d((String)ChatConfig.TAG, (String)"load local dns config cannot parse json");
                }
            }

            @Override
            public void onError(int error, String errorMsg) {
                EMLog.d((String)ChatConfig.TAG, (String)("load dns from remote fail : " + errorMsg));
            }
        });
    }

    private void saveDnsConfig(DnsConfig newDnsConfig) {
        if (newDnsConfig == null) {
            return;
        }
        this.dnsConfig = newDnsConfig;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("file_version", (Object)newDnsConfig.fileVersion);
            jsonObject.put("connect_keep_time", newDnsConfig.keepAliveTime);
            jsonObject.put("freeze_request_time", newDnsConfig.freezeRequestTime);
            jsonObject.put("update_time", newDnsConfig.updateTime);
            PreferenceUtil.getInstance().setServerJson(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e((String)TAG, (String)("" + e.getMessage()));
        }
    }

    public static ChatConfig getInstance() {
        return instance;
    }

    class DnsConfig {
        String fileVersion;
        long keepAliveTime;
        long freezeRequestTime;
        long updateTime;

        DnsConfig(String fileVersion, long keepAliveTime, long freezeRequestTime) {
            this.fileVersion = fileVersion;
            this.keepAliveTime = keepAliveTime;
            this.freezeRequestTime = freezeRequestTime;
            this.updateTime = System.currentTimeMillis();
        }

        DnsConfig(String fileVersion, long keepAliveTime, long freezeRequestTime, long updateTime) {
            this.fileVersion = fileVersion;
            this.keepAliveTime = keepAliveTime;
            this.freezeRequestTime = freezeRequestTime;
            this.updateTime = updateTime;
        }
    }
}

