/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.PreferenceUtil;

class CountDownUtils {
    private static final String TAG = "CountDownUtils";
    private static CountDownUtils instance = new CountDownUtils();
    private static int REQUEST_CODE = 0;
    private static int KEY_HANDLE_WHAT = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            try {
                if (msg.what == KEY_HANDLE_WHAT) {
                    long triggerAtTime = (Long)msg.obj;
                    PreferenceUtil.getInstance().setTriggerEventTime(triggerAtTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private AlarmManager alarmMgr = null;
    private Context mContext;
    private PendingIntent pendingIntent;

    CountDownUtils() {
    }

    public static CountDownUtils getInstance() {
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
        this.alarmMgr = (AlarmManager)context.getSystemService("alarm");
    }

    public void sendBroadcast() {
        this.sendBroadcast(0L);
    }

    public void sendBroadcast(long willTriggerTime) {
        long keepAliveTime;
        if (this.pendingIntent != null) {
            this.cancel();
        }
        if (!ChatClient.getInstance().isCountDownDisconnect()) {
            return;
        }
        Intent intent = new Intent("com.hyphenate.receive.countdown");
        intent.setPackage(this.mContext.getPackageName());
        intent.putExtra("msg", "countdown");
        this.pendingIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)this.mContext, (int)REQUEST_CODE, (Intent)intent, (int)0xC000000) : PendingIntent.getBroadcast((Context)this.mContext, (int)REQUEST_CODE, (Intent)intent, (int)0x8000000);
        if (this.mHandler.hasMessages(KEY_HANDLE_WHAT)) {
            this.mHandler.removeMessages(KEY_HANDLE_WHAT);
        }
        if ((keepAliveTime = ChatClient.getInstance().getKeepAliveTime()) <= 0L) {
            return;
        }
        long triggerAtTime = SystemClock.elapsedRealtime() + 60000L * keepAliveTime;
        if (willTriggerTime > 0L) {
            if (willTriggerTime < SystemClock.elapsedRealtime()) {
                this.mContext.sendBroadcast(intent);
                return;
            }
            if (willTriggerTime < triggerAtTime) {
                triggerAtTime = willTriggerTime;
            }
        }
        Message message = this.mHandler.obtainMessage();
        message.what = KEY_HANDLE_WHAT;
        message.obj = triggerAtTime;
        this.mHandler.sendMessageDelayed(message, 30000L);
        if (Build.VERSION.SDK_INT >= 23) {
            this.alarmMgr.setExactAndAllowWhileIdle(2, triggerAtTime, this.pendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.alarmMgr.setExact(2, triggerAtTime, this.pendingIntent);
        } else {
            this.alarmMgr.set(2, triggerAtTime, this.pendingIntent);
        }
    }

    public void cancel() {
        if (this.pendingIntent != null) {
            this.alarmMgr.cancel(this.pendingIntent);
        }
    }
}

