/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.ChatManager;
import com.hyphenate.chat.Conversation;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.KefuMessageEncoder;
import com.hyphenate.chat.Message;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.chat.PreferenceUtil;
import com.hyphenate.chat.RequestInfo;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

class KefuDBManager {
    private static final String TAG = "KefuDBManager";
    static final String DATABASE_NAME = "_kefumsg.db";
    private static final int DATABASE_VERSION = 7;
    private static final String COLUMN_ID = "_id";
    private static final String COLUMN_MSG_ID = "msgid";
    static final String COLUMN_IM_MSG_ID = "immsgid";
    static final String COLUMN_MSG_TIME = "msgtime";
    private static final String COLUMN_MSG_DIR = "msgdir";
    private static final String COLUMN_PARTICIPANT = "participant";
    private static final String COLUMN_MSG_BODY = "msgbody";
    private static final String COLUMN_MSG_GROUP = "groupname";
    private static final String COLUMN_MSG_ISACKED = "isacked";
    private static final String COLUMN_MSG_ISDELIVERED = "isdelivered";
    static final String COLUMN_MSG_STATUS = "status";
    private static final String COLUMN_MSG_ISLISTENED = "islistened";
    private static final String COLUMN_MSG_TYPE = "msgtype";
    private static final String COLUMN_MSG_EXT_MSG_ID = "extMsgId";
    private static final String COLUMN_MSG_RECALLED = "recalled";
    private static final String CHAT_TABLE_NAME = "chat";
    private static final String UNREAD_TABLE_NAME = "unreadcount";
    private static final String COLUMN_UNREAD_CONVERSATION_ID = "conversation_id";
    private static final String COLUMN_UNREAD_COUNT = "count";
    private static final String CONVERSATION_LIST_TABLE_NAME = "conversation_list";
    private static final String COLUMN_CONVERSATION_LIST_USERNAME = "username";
    private static final String COLUMN_CONVERSATION_OFFICIAL_ACCOUNT = "official_account";
    private static final String COLUMN_CONVERSATION_MARKETING = "marketing";
    private static final String COLUMN_CONVERSATION_LIST_EXT = "ext";
    private static final String VISITOR_INFO_TABLE_NAME = "visitor_info";
    private static final String COLUMN_VISITOR_INFO_USERNAME = "username";
    private static final String COLUMN_VISITOR_INFO_TO = "im_number";
    private static final String COLUMN_VISITOR_INFO_ID = "id";
    private static final String COLUMN_VISITOR_INFO_EXT = "ext";
    private static final String MARKETING_INFO_TABLE_NAME = "marketing_info";
    private static final String COLUMN_MARKETING_INFO_ID = "id";
    private static final String COLUMN_MARKETING_INFO_CONVERSATIONID = "conversation_id";
    private static final String COLUMN_MARKETING_INFO_STATUS = "status";
    private static final String REQUEST_INFO_TABLE_NAME = "request_info";
    private static final String COLUMN_REQUEST_INFO_ID = "id";
    private static final String COLUMN_REQUEST_INFO_URL = "url";
    private static final String COLUMN_REQUEST_INFO_PARAMS = "params";
    private static final String COLUMN_REQUEST_INFO_KEY = "keyname";
    private static final String EMOJICON_INFO_TABLE_NAME = "emojicon_info";
    private static final String COLUMN_EMOJICON_INFO_TENANTID = "tenantId";
    private static final String COLUMN_EMOJICON_INFO_ICONS_JSON = "icons_json";
    private static final String COLUMN_EMOJICON_INFO_PACKAGES_JSON = "packages_json";
    private static final String CMD_MSG_TABLE_NAME = "cmdMessages";
    private static final String COLUMN_CMD_MSG_ID = "msgid";
    private static final String COLUMN_CMD_MSG_ACTION = "actionname";
    private static final String COLUMN_CMD_MSG_FROM = "msgfrom";
    private static final String COLUMN_CMD_MSG_TO = "msgto";
    private static final String COLUMN_CMD_MSG_EXT = "ext";
    private static final String COLUMN_CMD_MSG_TIMESTAMP = "timestamp";
    private static final String CREATE_CHAT_TABLE = "create table if not exists chat (_id integer primary key autoincrement, msgid text, immsgid text, msgtime integer, msgdir integer, isacked integer, isdelivered integer, status integer,participant text not null, islistened integer, msgbody text not null,msgtype integer, extMsgId text, recalled bit default 0, groupname text);";
    private static final String CREATE_UNREAD_COUNT_TABLE = "create table if not exists unreadcount (conversation_id text primary key, count integer);";
    private static final String CREATE_CONVERSATION_LIST_TABLE = "create table if not exists conversation_list (username text primary key, official_account text, marketing text, ext text);";
    private static final String CREATE_VISITOR_INFO_TABLE = "create table if not exists visitor_info (id text primary key, username text, im_number text, ext text);";
    private static final String CREATE_MARKETING_INFO_TABLE = "create table if not exists marketing_info (id text primary key, conversation_id text, status text);";
    private static final String CREATE_REQUEST_INFO_TABLE = "create table if not exists request_info (id text primary key, url text, params text, keyname text);";
    private static final String CREATE_EMOJIICON_INFO_TABLE = "create table if not exists emojicon_info (tenantId text primary key, icons_json text, packages_json text);";
    private static final String CREATE_CMD_MSG_TABLE = "create table if not exists cmdMessages (msgid text primary key, actionname text, msgfrom text, msgto text, ext text, timestamp integer);";
    private static KefuDBManager instance = null;
    private String currentUserName = null;
    private Context appContext;
    private boolean isDBClosed = true;

    private KefuDBManager() {
    }

    static synchronized void initDB(String username) {
        EMLog.e((String)TAG, (String)("initDB : " + username));
        if (instance != null) {
            if (KefuDBManager.instance.currentUserName != null && KefuDBManager.instance.currentUserName.equals(username)) {
                return;
            }
            KefuDBManager.closeDatabase();
        }
        if (instance == null) {
            instance = new KefuDBManager();
            KefuDBManager.instance.appContext = EMClient.getInstance().getContext();
        }
        KefuDBManager.instance.currentUserName = username;
        KefuDBManager.instance.isDBClosed = false;
    }

    public static synchronized KefuDBManager getInstance() {
        EMLog.d((String)TAG, (String)("getInstance:" + instance));
        if (instance == null) {
            String lastUser = KefuDBManager.getLastLoginUser();
            if (TextUtils.isEmpty((CharSequence)lastUser)) {
                EMLog.e((String)TAG, (String)"Please login first!");
                throw new RuntimeException("Please login first");
            }
            KefuDBManager.initDB(lastUser);
        }
        return instance;
    }

    private static String getLastLoginUser() {
        String username = PreferenceUtil.getInstance().getUsername();
        if (TextUtils.isEmpty((CharSequence)username)) {
            username = EMClient.getInstance().getCurrentUser();
        }
        return username;
    }

    static synchronized void closeDatabase() {
        try {
            EMChatDBOpenHelper.closeDB();
            EMLog.d((String)TAG, (String)"close msg db");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getEMMessageExtMsgId(Message message) {
        try {
            String msgIdForAck;
            JSONObject jsonExt = message.getJSONObjectAttribute("weichat");
            if (jsonExt != null && !TextUtils.isEmpty((CharSequence)(msgIdForAck = jsonExt.getString("msgId"))) && !msgIdForAck.equals("null")) {
                return msgIdForAck;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    boolean saveMessage(Message message) {
        try {
            Message.Status status;
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return false;
            }
            ContentValues values = new ContentValues();
            values.put("msgid", message.messageId());
            values.put(COLUMN_IM_MSG_ID, message.getIMMsgId());
            values.put(COLUMN_MSG_TIME, Long.valueOf(message.messageTime()));
            values.put(COLUMN_MSG_ISACKED, Boolean.valueOf(message.isAcked));
            values.put(COLUMN_MSG_ISDELIVERED, Boolean.valueOf(message.kefuReceived()));
            values.put(COLUMN_MSG_DIR, Integer.valueOf(message.direct().ordinal()));
            values.put(COLUMN_MSG_TYPE, Integer.valueOf(0));
            String extMsgId = this.getEMMessageExtMsgId(message);
            if (extMsgId != null) {
                values.put(COLUMN_MSG_EXT_MSG_ID, extMsgId);
            }
            if ((status = message.status()) == Message.Status.INPROGRESS) {
                status = Message.Status.CREATE;
            }
            values.put("status", Integer.valueOf(status.ordinal()));
            String participant = message.from().equals(this.currentUserName) ? message.to() : message.from();
            String id = participant;
            values.put(COLUMN_PARTICIPANT, participant);
            values.put(COLUMN_MSG_BODY, KefuMessageEncoder.getJSONMsg(message, true));
            values.putNull(COLUMN_MSG_GROUP);
            values.put(COLUMN_MSG_ISLISTENED, Integer.valueOf(message.isListened() ? 1 : 0));
            if (!participant.equals("bot")) {
                db.insert(CHAT_TABLE_NAME, null, values);
            }
            String conversation = participant;
            OfficialAccount officialAccount = message.getOfficialAccount();
            String marketings = message.getMarketings();
            this.addConversation(conversation, officialAccount, marketings, message.direct() == Message.Direct.SEND);
            EMLog.d((String)TAG, (String)"save msg to db");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e((String)TAG, (String)("save msg has error: " + e));
            return false;
        }
    }

    boolean updateMessageBody(Message message) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return false;
            }
            ContentValues values = new ContentValues();
            String msgId = message.messageId();
            String body = KefuMessageEncoder.getJSONMsg(message, true);
            values.put(COLUMN_MSG_BODY, body);
            db.update(CHAT_TABLE_NAME, values, "msgid = ?", new String[]{msgId});
            EMLog.d((String)TAG, (String)("update msg:" + msgId + " messagebody:" + body));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMessage(String msgId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            String username = "";
            cursor = db.rawQuery("select participant, groupname from chat where msgid =? limit 1", new String[]{msgId});
            if (cursor.moveToFirst()) {
                username = cursor.getString(0);
            }
            int ret = db.delete(CHAT_TABLE_NAME, "msgid = ?", new String[]{msgId});
            EMLog.d((String)TAG, (String)("delete msg:" + msgId + " return:" + ret));
            if (!TextUtils.isEmpty((CharSequence)username)) {
                this.deleteConversationIfNoMessages(username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable<String, Conversation> loadAllParticipantsWithMsgs(int LIMIT) {
        Hashtable<String, Conversation> results = new Hashtable<String, Conversation>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                Hashtable<String, Conversation> hashtable = results;
                return hashtable;
            }
            String sqlChat = "select * from chat where recalled=0 and participant in (select username from conversation_list) order by participant, msgtime desc";
            cursor = db.rawQuery(sqlChat, null);
            LinkedList<Message> list = null;
            String prevUserName = null;
            long counter = 0L;
            Message msg = null;
            while (cursor.moveToNext()) {
                String username = cursor.getString(cursor.getColumnIndex(COLUMN_PARTICIPANT));
                if (prevUserName != null && prevUserName.equals(username)) {
                    if (list.size() < LIMIT && (msg = this.loadMsgFromCursor(cursor)) != null) {
                        list.add(msg);
                    }
                    ++counter;
                    continue;
                }
                if (prevUserName != null && prevUserName.equals(username)) continue;
                if (prevUserName != null) {
                    Collections.reverse(list);
                    Conversation conversation = new Conversation(prevUserName, list, counter);
                    this.attachExtToConversation(conversation);
                    results.put(prevUserName, conversation);
                }
                list = new LinkedList<Message>();
                Message temp = this.loadMsgFromCursor(cursor);
                if (temp != null) {
                    list.add(temp);
                }
                prevUserName = username;
                counter = 1L;
            }
            if (prevUserName != null) {
                Collections.reverse(list);
                Conversation conversation = new Conversation(prevUserName, list, counter);
                this.attachExtToConversation(conversation);
                results.put(prevUserName, conversation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachExtToConversation(Conversation conversation) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select * from conversation_list where username=? ", new String[]{conversation.conversationId()});
            if (cursor.moveToFirst()) {
                String strOffAcc = cursor.getString(cursor.getColumnIndex(COLUMN_CONVERSATION_OFFICIAL_ACCOUNT));
                conversation.setOfficialAccount(strOffAcc);
                String strMarketings = cursor.getString(cursor.getColumnIndex(COLUMN_CONVERSATION_MARKETING));
                conversation.setMarketings(strMarketings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getConversationMessageCount(String username, boolean isGroup) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return 0L;
        }
        Cursor cursor = null;
        try {
            String field = !isGroup ? COLUMN_PARTICIPANT : COLUMN_MSG_GROUP;
            cursor = db.rawQuery("select count(*) as msgCount from chat where " + field + " = ?", new String[]{username});
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getMessageIdByExtMsgId(String extMsgId) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return null;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select msgid from chat where extMsgId=?", new String[]{extMsgId});
            if (cursor.moveToFirst()) {
                String string = cursor.getString(0);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.d((String)TAG, (String)("exitMsgId: " + extMsgId + ", error:" + e.getMessage()));
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return null;
    }

    void recallMessage(String msgId) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put(COLUMN_MSG_RECALLED, Integer.valueOf(1));
            db.update(CHAT_TABLE_NAME, values, "msgid = ?", new String[]{msgId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String messageId) {
        Message msg = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            if (!db.isOpen()) {
                Message message = null;
                return message;
            }
            cursor = db.rawQuery("select * from chat where msgid =?", new String[]{messageId});
            if (cursor.moveToFirst()) {
                msg = this.loadMsgFromCursor(cursor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        EMLog.d((String)TAG, (String)("load msg msgId:" + messageId));
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMessageExistedByExtMsgId(String extMsgId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            if (!db.isOpen()) {
                boolean bl = true;
                return bl;
            }
            cursor = db.rawQuery("select * from chat where extMsgId =?", new String[]{extMsgId});
            if (!cursor.moveToFirst()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> loadAllRecalledMessageIds(int limit) {
        ArrayList<String> msgIds = new ArrayList<String>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            if (!db.isOpen()) {
                ArrayList<String> arrayList = msgIds;
                return arrayList;
            }
            cursor = db.rawQuery("select * from chat where recalled=1 order by msgtime limit ?", new String[]{String.valueOf(limit)});
            while (cursor.moveToNext()) {
                String msgId = cursor.getString(cursor.getColumnIndex("msgid"));
                msgIds.add(msgId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return msgIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> findMessages(String username, String startMsgId, int pageSize) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            if (!db.isOpen()) {
                ArrayList<Message> arrayList = msgList;
                return arrayList;
            }
            if (startMsgId != null) {
                Message message = ChatManager.getInstance().getMessage(startMsgId);
                if (message == null) {
                    EMLog.e((String)TAG, (String)"can't find message for startMsgId");
                    ArrayList<Message> arrayList = msgList;
                    return arrayList;
                }
                cursor = db.rawQuery("select * from chat where participant =? and recalled=0 and msgtime <? order by msgtime desc limit ?", new String[]{username, String.valueOf(message.messageTime()), String.valueOf(pageSize)});
            } else {
                cursor = db.rawQuery("select * from chat where participant =? and recalled=0 order by msgtime desc limit ?", new String[]{username, String.valueOf(pageSize)});
            }
            while (cursor.moveToNext()) {
                Message msg = this.loadMsgFromCursor(cursor);
                if (msg == null) continue;
                msgList.add(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        EMLog.d((String)TAG, (String)("load msgs size:" + msgList.size() + " for participate:" + username));
        return msgList;
    }

    private Message loadMsgFromCursor(Cursor cursor) {
        String jsonString = cursor.getString(cursor.getColumnIndex(COLUMN_MSG_BODY));
        Message msg = KefuMessageEncoder.getMsgFromJson(jsonString);
        if (msg == null) {
            return null;
        }
        msg.setMsgId(cursor.getString(cursor.getColumnIndex("msgid")));
        msg.setMessageTime(cursor.getLong(cursor.getColumnIndex(COLUMN_MSG_TIME)));
        msg.setIMMsgId(cursor.getString(cursor.getColumnIndex(COLUMN_IM_MSG_ID)));
        int dir = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_DIR));
        if (dir == Message.Direct.SEND.ordinal()) {
            msg.setDirection(Message.Direct.SEND);
            msg.setTo(cursor.getString(cursor.getColumnIndex(COLUMN_PARTICIPANT)));
            msg.setFrom(this.currentUserName);
        } else {
            msg.setDirection(Message.Direct.RECEIVE);
            msg.setFrom(cursor.getString(cursor.getColumnIndex(COLUMN_PARTICIPANT)));
            msg.setTo(this.currentUserName);
        }
        int status = cursor.getInt(cursor.getColumnIndex("status"));
        if (status == Message.Status.CREATE.ordinal()) {
            msg.setStatus(Message.Status.CREATE);
        } else if (status == Message.Status.INPROGRESS.ordinal()) {
            msg.setStatus(Message.Status.INPROGRESS);
        } else if (status == EMMessage.Status.SUCCESS.ordinal()) {
            msg.setStatus(Message.Status.SUCCESS);
        } else if (status == EMMessage.Status.FAIL.ordinal()) {
            msg.setStatus(Message.Status.FAIL);
        }
        int isAcked = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_ISACKED));
        msg.isAcked = isAcked != 0;
        int isDelivered = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_ISDELIVERED));
        msg.setKefuReceived(isDelivered != 0);
        int isListened = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_ISLISTENED));
        msg.setListened(isListened == 1);
        msg.setUnread(false);
        return msg;
    }

    void deleteChatMsgs(String participate) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            int ret = db.delete(CHAT_TABLE_NAME, "participant = ? and groupname is null", new String[]{participate});
            EMLog.d((String)TAG, (String)("delete chat msgs with:" + participate + " return:" + ret));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean conversationExists(String conversationId) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select username from conversation_list where username=?", new String[]{conversationId});
            if (cursor.moveToFirst()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return false;
    }

    private boolean insertConversation(String conversationId, OfficialAccount officialAccount, String marketings) {
        long row;
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        ContentValues cv = new ContentValues();
        cv.put("username", conversationId);
        if (officialAccount != null) {
            cv.put(COLUMN_CONVERSATION_OFFICIAL_ACCOUNT, officialAccount.toString());
        }
        if (marketings != null) {
            cv.put(COLUMN_CONVERSATION_MARKETING, marketings);
        }
        return (row = db.insertWithOnConflict(CONVERSATION_LIST_TABLE_NAME, null, cv, 4)) > 0L;
    }

    private boolean updateConversation(String conversationId, OfficialAccount officialAccount, String marketings) {
        long row;
        if (conversationId == null) {
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        ContentValues cv = new ContentValues();
        cv.put("username", conversationId);
        if (officialAccount != null) {
            cv.put(COLUMN_CONVERSATION_OFFICIAL_ACCOUNT, officialAccount.toString());
        }
        if (marketings != null) {
            cv.put(COLUMN_CONVERSATION_MARKETING, marketings);
        }
        return (row = (long)db.updateWithOnConflict(CONVERSATION_LIST_TABLE_NAME, cv, "username=? ", new String[]{conversationId}, 4)) > 0L;
    }

    void addConversation(String conversationId, OfficialAccount officialAccount, String marketings, boolean isSend) {
        try {
            if (this.conversationExists(conversationId)) {
                if (!isSend) {
                    boolean boolParam = this.updateConversation(conversationId, officialAccount, marketings);
                    EMLog.d((String)TAG, (String)("update conversation is " + boolParam));
                }
            } else {
                boolean boolParam = this.insertConversation(conversationId, officialAccount, marketings);
                EMLog.d((String)TAG, (String)("insert conversation is " + boolParam));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("addConversation-error:" + e.getMessage()));
        }
    }

    boolean addMarketingInfo(String marketingId, String conversationId, String status) {
        if (TextUtils.isEmpty((CharSequence)marketingId) || TextUtils.isEmpty((CharSequence)conversationId)) {
            EMLog.e((String)TAG, (String)"marketing or conversationId is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", marketingId);
        cv.put("conversation_id", conversationId);
        cv.put("status", status);
        long row = db.insertWithOnConflict(MARKETING_INFO_TABLE_NAME, null, cv, 4);
        return row > 0L;
    }

    boolean addEmojiconInfo(String tenantId, String iconsJson, String packagesJson) {
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            EMLog.e((String)TAG, (String)"tenantId is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_EMOJICON_INFO_TENANTID, tenantId);
        cv.put(COLUMN_EMOJICON_INFO_ICONS_JSON, iconsJson);
        cv.put(COLUMN_EMOJICON_INFO_PACKAGES_JSON, packagesJson);
        long row = db.insertWithOnConflict(EMOJICON_INFO_TABLE_NAME, null, cv, 4);
        return row > 0L;
    }

    boolean deleteEmojiconInfo(String tenantId) {
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            EMLog.e((String)TAG, (String)"tenantId is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        long row = db.delete(EMOJICON_INFO_TABLE_NAME, "tenantId=?", new String[]{tenantId});
        return row > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getEmojiconInfoIconsJson(String tenantId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            cursor = db.rawQuery("select * from emojicon_info", new String[0]);
            while (cursor.moveToNext()) {
                String tempTenantId = cursor.getString(cursor.getColumnIndex(COLUMN_EMOJICON_INFO_TENANTID));
                if (!tempTenantId.equals(tenantId)) continue;
                String string = cursor.getString(cursor.getColumnIndex(COLUMN_EMOJICON_INFO_ICONS_JSON));
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getEmojiconInfoPackagesJson(String tenantId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            cursor = db.rawQuery("select * from emojicon_info", new String[0]);
            while (cursor.moveToNext()) {
                String tempTenantId = cursor.getString(cursor.getColumnIndex(COLUMN_EMOJICON_INFO_TENANTID));
                if (!tempTenantId.equals(tenantId)) continue;
                String string = cursor.getString(cursor.getColumnIndex(COLUMN_EMOJICON_INFO_PACKAGES_JSON));
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return null;
    }

    boolean updateMarketingInfoStatusByConversationId(String conversationId, String fromStatus, String status) {
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            EMLog.e((String)TAG, (String)"conversationId is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> argList = new ArrayList<String>();
        sb.append("conversation_id").append("=? ");
        argList.add(conversationId);
        if (!TextUtils.isEmpty((CharSequence)fromStatus)) {
            sb.append(" and ").append("status").append("=? ");
            argList.add(fromStatus);
        }
        ContentValues cv = new ContentValues();
        cv.put("status", status);
        long row = db.updateWithOnConflict(MARKETING_INFO_TABLE_NAME, cv, sb.toString(), argList.toArray(new String[argList.size()]), 4);
        return row > 0L;
    }

    boolean deleteMarketingInfoByConversationId(String conversationId, String status) {
        long row;
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            EMLog.e((String)TAG, (String)"conversationId is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> argList = new ArrayList<String>();
        sb.append("conversation_id").append("=? ");
        argList.add(conversationId);
        if (!TextUtils.isEmpty((CharSequence)status)) {
            sb.append(" and ").append("status").append("=? ");
            argList.add(status);
        }
        return (row = (long)db.delete(MARKETING_INFO_TABLE_NAME, sb.toString(), argList.toArray(new String[argList.size()]))) > 0L;
    }

    boolean deleteMarketingInfoByConversationId(String conversationId) {
        return this.deleteMarketingInfoByConversationId(conversationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getMarketingIdsByConversationId(String conversationId, String status) {
        ArrayList<String> marketingIds = new ArrayList<String>();
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            EMLog.e((String)TAG, (String)"conversationId is null");
            return marketingIds;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return marketingIds;
        }
        Cursor cursor = null;
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> argList = new ArrayList<String>();
            sb.append("conversation_id").append("=? ");
            argList.add(conversationId);
            if (!TextUtils.isEmpty((CharSequence)status)) {
                sb.append(" and ").append("status").append("=? ");
                argList.add(status);
            }
            cursor = db.rawQuery("select * from marketing_info where " + sb.toString(), argList.toArray(new String[argList.size()]));
            while (cursor.moveToNext()) {
                String marketingId = cursor.getString(cursor.getColumnIndex("id"));
                marketingIds.add(marketingId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return marketingIds;
    }

    boolean addRequestInfo(RequestInfo info) {
        SQLiteDatabase db;
        if (info == null) {
            return false;
        }
        if (info.id == null) {
            info.id = UUID.randomUUID().toString();
        }
        if (!(db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase()).isOpen()) {
            return false;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", info.id);
        cv.put(COLUMN_REQUEST_INFO_URL, info.url);
        cv.put(COLUMN_REQUEST_INFO_PARAMS, info.params);
        cv.put(COLUMN_REQUEST_INFO_KEY, info.key);
        long row = db.insertWithOnConflict(REQUEST_INFO_TABLE_NAME, null, cv, 4);
        return row > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RequestInfo> getRequestInfoByKey(String key) {
        ArrayList<RequestInfo> list = new ArrayList<RequestInfo>();
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return list;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select * from request_info where keyname=? ", new String[]{key});
            while (cursor.moveToNext()) {
                RequestInfo info = new RequestInfo();
                info.id = cursor.getString(cursor.getColumnIndex("id"));
                info.url = cursor.getString(cursor.getColumnIndex(COLUMN_REQUEST_INFO_URL));
                info.params = cursor.getString(cursor.getColumnIndex(COLUMN_REQUEST_INFO_PARAMS));
                info.key = cursor.getString(cursor.getColumnIndex(COLUMN_REQUEST_INFO_KEY));
                list.add(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return list;
    }

    boolean deleteRequestInfoById(String id) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            EMLog.e((String)TAG, (String)"id cannot is null");
            return false;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        long row = db.delete(REQUEST_INFO_TABLE_NAME, "id=?", new String[]{id});
        return row > 0L;
    }

    private void deleteConversationIfNoMessages(String username) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            db.execSQL("delete from conversation_list where username =? and  not exists (select null from chat where participant =? )", (Object[])new String[]{username, username});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void deleteConversation(String username) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            db.execSQL("delete from conversation_list where username =?", (Object[])new String[]{username});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateMessageListened(String msgId, boolean isListened) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put(COLUMN_MSG_ISLISTENED, Boolean.valueOf(isListened));
            db.update(CHAT_TABLE_NAME, values, "msgid = ?", new String[]{msgId});
            EMLog.d((String)TAG, (String)("update msg:" + msgId + " isListened:" + isListened));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMessageId(String oldId, String newId) {
        ContentValues values = new ContentValues();
        values.put("msgid", newId + "");
        KefuDBManager.getInstance().updateMessage(oldId, values);
    }

    void updateMessage(String msgId, ContentValues values) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return;
        }
        db.update(CHAT_TABLE_NAME, values, "msgid = ?", new String[]{msgId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getConversationUnreadCount(String conversationId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            if (!db.isOpen()) {
                int n = 0;
                return n;
            }
            int count = 0;
            cursor = db.rawQuery("select count from unreadcount where conversation_id =? ", new String[]{conversationId});
            if (cursor.moveToFirst()) {
                count = cursor.getInt(cursor.getColumnIndex(COLUMN_UNREAD_COUNT));
            }
            if (count < 0) {
                int n = 0;
                return n;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return 0;
    }

    void saveConversationUnreadCount(String conversationId, int count) {
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put("conversation_id", conversationId);
            values.put(COLUMN_UNREAD_COUNT, Integer.valueOf(count));
            db.replace(UNREAD_TABLE_NAME, null, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void deleteConversationUnreadrecord(String conversationId) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return;
        }
        db.delete(UNREAD_TABLE_NAME, "conversation_id = ?", new String[]{conversationId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getConversationsUnread() {
        ArrayList<String> conversations = new ArrayList<String>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
            cursor = db.rawQuery("select * from unreadcount", new String[0]);
            while (cursor.moveToNext()) {
                String userOrName = cursor.getString(0);
                int count = cursor.getInt(1);
                if (count <= 0) continue;
                conversations.add(userOrName);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return conversations;
    }

    void setExtField(String username, String ext) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return;
        }
        try {
            ContentValues values = new ContentValues();
            values.put("ext", ext == null ? "" : ext);
            db.update(CONVERSATION_LIST_TABLE_NAME, values, "username = ?", new String[]{username});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getExtField(String conversationId) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return "";
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select ext from conversation_list where username =? ", new String[]{conversationId});
            if (cursor.moveToFirst()) {
                String string = cursor.getString(0);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return "";
    }

    boolean saveVisitorInfo(String toUser, String visitorUserId) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        try {
            ContentValues values = new ContentValues();
            values.put("id", visitorUserId);
            values.put("username", ChatClient.getInstance().currentUserName());
            values.put(COLUMN_VISITOR_INFO_TO, toUser);
            long row = db.replace(VISITOR_INFO_TABLE_NAME, null, values);
            if (row > 0L) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getVisitorUserId(String toUser) {
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return "";
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("select id from visitor_info where username=? and im_number=? ", new String[]{ChatClient.getInstance().currentUserName(), toUser});
            if (cursor.moveToFirst()) {
                String string = cursor.getString(cursor.getColumnIndex("id"));
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isExistCmdMessage(String messageId) {
        if (TextUtils.isEmpty((CharSequence)messageId)) {
            return true;
        }
        SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getReadableDatabase();
        if (!db.isOpen()) {
            return false;
        }
        boolean isExist = false;
        String sql = "select msgid from cmdMessages where msgid=? ";
        Cursor cursor = null;
        try {
            cursor = db.rawQuery(sql, new String[]{messageId});
            if (cursor.moveToNext()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return isExist;
    }

    boolean insertCmdMessage(Message message) {
        SQLiteDatabase db;
        if (message == null) {
            return false;
        }
        if (message.getType() != Message.Type.CMD) {
            EMLog.d((String)TAG, (String)("Non-command message,msgid->" + message.messageId()));
            return false;
        }
        EMCmdMessageBody cmdBody = (EMCmdMessageBody)message.body();
        String messageId = message.messageId();
        String ext = KefuMessageEncoder.getJSONMsg(message, false);
        long timestamp = message.messageTime();
        if (timestamp <= 0L) {
            timestamp = System.currentTimeMillis();
        }
        if (!(db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase()).isOpen()) {
            return false;
        }
        ContentValues cvs = new ContentValues();
        cvs.put("msgid", messageId);
        cvs.put(COLUMN_CMD_MSG_ACTION, cmdBody.action());
        cvs.put(COLUMN_CMD_MSG_FROM, message.from());
        cvs.put(COLUMN_CMD_MSG_TO, message.to());
        cvs.put("ext", ext);
        cvs.put(COLUMN_CMD_MSG_TIMESTAMP, Long.valueOf(timestamp));
        long row = db.insertWithOnConflict(CMD_MSG_TABLE_NAME, null, cvs, 4);
        if (row <= 0L) {
            EMLog.e((String)TAG, (String)("cmd Message insert failed:msgid:" + messageId));
            return false;
        }
        return true;
    }

    void deleteCmdMessages(int numberDayBefore) {
        if (numberDayBefore <= 0) {
            return;
        }
        try {
            long currentTime = System.currentTimeMillis();
            int oneDay = 86400;
            long theDateTime = currentTime - (long)(oneDay * numberDayBefore);
            SQLiteDatabase db = EMChatDBOpenHelper.getInstance(this.appContext, this.currentUserName).getWritableDatabase();
            if (!db.isOpen()) {
                return;
            }
            long l = db.delete(CMD_MSG_TABLE_NAME, "timestamp<? ", new String[]{String.valueOf(theDateTime)});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class EMChatDBOpenHelper
    extends SQLiteOpenHelper {
        private static EMChatDBOpenHelper instance = null;
        private String username;

        private EMChatDBOpenHelper(Context context, String username) {
            super(context, username + KefuDBManager.DATABASE_NAME, null, 7);
            this.username = username;
            EMLog.e((String)KefuDBManager.TAG, (String)("create kefu chatdb for:" + username));
        }

        public static synchronized EMChatDBOpenHelper getInstance(Context context, String username) {
            if (instance == null) {
                instance = new EMChatDBOpenHelper(context, username);
            }
            return instance;
        }

        static synchronized void closeDB() {
            if (instance != null) {
                try {
                    SQLiteDatabase db = instance.getWritableDatabase();
                    db.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                instance = null;
            }
        }

        private void dropTableDB(SQLiteDatabase db) {
            db.execSQL("drop table if exists unreadcount");
            db.execSQL("drop table if exists conversation_list");
            db.execSQL("drop table if exists visitor_info");
            db.execSQL("drop table if exists marketing_info");
            db.execSQL("drop table if exists request_info");
            db.execSQL("drop table if exists emojicon_info");
        }

        private void dropAllTableDB(SQLiteDatabase db) {
            db.execSQL("drop table if exists chat");
            db.execSQL("drop table if exists unreadcount");
            db.execSQL("drop table if exists conversation_list");
            db.execSQL("drop table if exists visitor_info");
            db.execSQL("drop table if exists marketing_info");
            db.execSQL("drop table if exists request_info");
            db.execSQL("drop table if exists emojicon_info");
            db.execSQL("drop table if exists cmdMessages");
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(KefuDBManager.CREATE_CHAT_TABLE);
            db.execSQL(KefuDBManager.CREATE_UNREAD_COUNT_TABLE);
            db.execSQL(KefuDBManager.CREATE_CONVERSATION_LIST_TABLE);
            db.execSQL(KefuDBManager.CREATE_VISITOR_INFO_TABLE);
            db.execSQL(KefuDBManager.CREATE_MARKETING_INFO_TABLE);
            db.execSQL(KefuDBManager.CREATE_REQUEST_INFO_TABLE);
            db.execSQL(KefuDBManager.CREATE_EMOJIICON_INFO_TABLE);
            db.execSQL(KefuDBManager.CREATE_CMD_MSG_TABLE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w((String)KefuDBManager.TAG, (String)("Upgrading from version " + oldVersion + " to " + newVersion));
            if (oldVersion < 5) {
                this.dropTableDB(db);
                this.onCreate(db);
            } else if (oldVersion < 7) {
                db.execSQL("drop table if exists request_info");
                db.execSQL("drop table if exists cmdMessages");
                db.execSQL(KefuDBManager.CREATE_CMD_MSG_TABLE);
                db.execSQL(KefuDBManager.CREATE_REQUEST_INFO_TABLE);
            }
        }
    }
}

