/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.CommonUtils;
import com.hyphenate.chat.ConversationInfo;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.KefuDBManager;
import com.hyphenate.chat.OfficialAccount;
import com.hyphenate.chat.RequestInfo;
import com.hyphenate.chat.VecConfig;
import com.hyphenate.helpdesk.callback.ValueCallBack;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpRequestBuilder;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.util.Log;
import com.hyphenate.util.EMLog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONObject;

final class MarketingHttpClient {
    private static final String TAG = "MarketingHttpClient";
    public static int DEFAULT_CONNECTION_TIMEOUT = 20000;
    public static int DEFAULT_READ_TIMEOUT = 120000;
    private static ExecutorService sendThreadPool = Executors.newFixedThreadPool(10);
    private static final Object lock = new Object();
    public static String currentConversationId;
    private static String lineEnd;
    private static String twoHyphens;
    private static String boundary;

    private MarketingHttpClient() {
        throw new IllegalAccessError("not support constructor new object");
    }

    private static void sendMarketingDelivered(String marketingTaskId, String toUser, ValueCallBack<String> callBack) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid isnot nullable");
            }
            return;
        }
        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/delivered", ChatClient.getInstance().kefuRestServer(), tenantId, marketingTaskId);
        MarketingHttpClient.sendMarketingStatusChanged(remoteUrl, toUser, callBack);
    }

    private static void sendMarketingOpened(String marketingTaskId, String toUser, ValueCallBack<String> callBack) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid isnot nullable");
            }
            return;
        }
        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/opened", ChatClient.getInstance().kefuRestServer(), tenantId, marketingTaskId);
        MarketingHttpClient.sendMarketingStatusChanged(remoteUrl, toUser, callBack);
    }

    private static void sendMarketingReplied(String marketingTaskId, String toUser, ValueCallBack<String> callBack) {
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            if (callBack != null) {
                callBack.onError(-1, "tenantid isnot nullable");
            }
            return;
        }
        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/replied", ChatClient.getInstance().kefuRestServer(), tenantId, marketingTaskId);
        MarketingHttpClient.sendMarketingStatusChanged(remoteUrl, toUser, callBack);
    }

    private static void sendMarketingStatusChanged(final String remoteUrl, final String toUser, final ValueCallBack<String> callBack) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            if (callBack != null) {
                callBack.onError(-1, "please login first");
            }
            return;
        }
        sendThreadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        String visitorId;
                        Object object = lock;
                        synchronized (object) {
                            visitorId = KefuDBManager.getInstance().getVisitorUserId(toUser);
                            if (TextUtils.isEmpty((CharSequence)visitorId)) {
                                visitorId = MarketingHttpClient.getVisitorIdFromRemote(toUser);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)visitorId)) {
                            if (callBack != null) {
                                callBack.onError(-1, "visitorid is null");
                            }
                            return;
                        }
                        String currentUser = ChatClient.getInstance().currentUserName();
                        String token = ChatClient.getInstance().accessToken();
                        String appkey = ChatClient.getInstance().appKey();
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("visitor_id", (Object)visitorId);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.put(remoteUrl);
                        assert (appkey != null);
                        requestBuilder.param("orgName", appkey.split("#")[0]);
                        requestBuilder.param("appName", appkey.split("#")[1]);
                        requestBuilder.param("userName", currentUser);
                        requestBuilder.param("token", token);
                        requestBuilder.content(jsonObject.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("marketing status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        } else if (callBack != null) {
                            callBack.onError(-1, "send marketing status fail");
                        }
                    }
                    catch (Exception e) {
                        if (callBack == null) break block14;
                        callBack.onError(-1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    private static synchronized String getVisitorIdFromRemote(String toUser) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            EMLog.e((String)TAG, (String)"get visitor but not login");
            return "";
        }
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            return "";
        }
        try {
            String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors", ChatClient.getInstance().kefuRestServer(), tenantId);
            String appkey = ChatClient.getInstance().appKey();
            String token = ChatClient.getInstance().accessToken();
            String currentUser = ChatClient.getInstance().currentUserName();
            String techChannelinfo = appkey + "#" + toUser;
            HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
            httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
            httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
            HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
            assert (appkey != null);
            requestBuilder.param("orgName", appkey.split("#")[0]);
            requestBuilder.param("appName", appkey.split("#")[1]);
            requestBuilder.param("userName", currentUser);
            requestBuilder.param("token", token);
            requestBuilder.param("techChannelInfo", techChannelinfo);
            HttpResponse httpResponse = requestBuilder.execute();
            if (httpResponse == null) {
                return "";
            }
            int status_code = httpResponse.getStatusCode();
            EMLog.d((String)TAG, (String)("getVisitorIdFromRemote status_code:" + status_code));
            if (status_code >= 200 && status_code < 300) {
                StringBuffer buffer = new StringBuffer();
                httpResponse.read(buffer);
                String result = buffer.toString();
                JSONObject resultJson = new JSONObject(result);
                if (resultJson.has("entity")) {
                    JSONObject entitiesJson = resultJson.getJSONObject("entity");
                    String userId = entitiesJson.getString("userId");
                    KefuDBManager.getInstance().saveVisitorInfo(toUser, userId);
                    return userId;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    static void asyncGetAgentState(final ConversationInfo info, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        String remoteUrl = String.format("%1$s/v1/webimplugin/sessions/%2$s/agent-input-state", ChatClient.getInstance().kefuRestServer(), info.session_id);
                        String appkey = ChatClient.getInstance().appKey();
                        String token = ChatClient.getInstance().accessToken();
                        String currentUser = ChatClient.getInstance().currentUserName();
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        assert (appkey != null);
                        requestBuilder.param("orgName", appkey.split("#")[0]);
                        requestBuilder.param("appName", appkey.split("#")[1]);
                        requestBuilder.param("userName", currentUser);
                        requestBuilder.param("token", token);
                        requestBuilder.param("tenantId", ChatClient.getInstance().tenantId());
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "error: response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetAgentState status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            JSONObject resultJson = new JSONObject(result);
                            JSONObject entitiesJson = resultJson.getJSONObject("entity");
                            String input_state_tips = entitiesJson.optString("input_state_tips");
                            if (callBack != null) {
                                callBack.onSuccess(input_state_tips);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block7;
                        callBack.onError(-1, "error:" + e.getMessage());
                    }
                }
            }
        });
    }

    static void postMessagePredict(final String content, final ConversationInfo info, final ValueCallBack<String> callback) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block11: {
                    if (!ChatClient.getInstance().isLoggedInBefore()) {
                        if (callback != null) {
                            callback.onError(-1, "no login");
                        }
                        return;
                    }
                    String tenantId = ChatClient.getInstance().tenantId();
                    if (TextUtils.isEmpty((CharSequence)tenantId)) {
                        if (callback != null) {
                            callback.onError(-1, "tenantId is null");
                        }
                        return;
                    }
                    try {
                        String remoteUrl = String.format("%1$s/v1/webimplugin/servicesessions/%2$s/messagePredict", ChatClient.getInstance().kefuRestServer(), info.session_id);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Authorization", "Easemob IM " + ChatClient.getInstance().accessToken());
                        requestBuilder.header("Content-Type", "application/json");
                        JSONObject postContent = new JSONObject();
                        postContent.put("visitor_user_id", (Object)info.visitor_id);
                        postContent.put("content", (Object)content);
                        postContent.put("timestamp", System.currentTimeMillis());
                        requestBuilder.content(postContent.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        assert (httpResponse != null);
                        int statusCode = httpResponse.getStatusCode();
                        if (statusCode == 200) {
                            StringBuffer sb = new StringBuffer();
                            httpResponse.read(sb);
                            if (callback != null) {
                                callback.onSuccess(sb.toString());
                            }
                        } else if (callback != null) {
                            callback.onError(-1, "statusCode:" + statusCode);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block11;
                        callback.onError(-1, e.getMessage());
                    }
                }
            }
        });
    }

    static void asyncGetWaitCount(final ConversationInfo info, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String remoteUrl = String.format("%1$s/v1/visitors/waitings/data", ChatClient.getInstance().kefuRestServer());
                        String tenantId = ChatClient.getInstance().tenantId();
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.param("tenantId", tenantId);
                        requestBuilder.param("queueId", String.valueOf(info.skill_group_id));
                        requestBuilder.param("serviceSessionId", info.session_id);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetWaitCount status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OfficialAccount getSystemOfficialAccount(String conversationId) {
        String visitorId;
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        Object object = lock;
        synchronized (object) {
            visitorId = KefuDBManager.getInstance().getVisitorUserId(conversationId);
            if (TextUtils.isEmpty((CharSequence)visitorId)) {
                visitorId = MarketingHttpClient.getVisitorIdFromRemote(toUser);
            }
        }
        if (TextUtils.isEmpty((CharSequence)visitorId)) {
            return null;
        }
        try {
            String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors/%3$s/official-accounts", ChatClient.getInstance().kefuRestServer(), ChatClient.getInstance().tenantId(), visitorId);
            String appkey = ChatClient.getInstance().appKey();
            String token = ChatClient.getInstance().accessToken();
            String currentUser = ChatClient.getInstance().currentUserName();
            HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
            httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
            httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
            HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
            assert (appkey != null);
            requestBuilder.param("orgName", appkey.split("#")[0]);
            requestBuilder.param("appName", appkey.split("#")[1]);
            requestBuilder.param("userName", currentUser);
            requestBuilder.param("token", token);
            HttpResponse httpResponse = requestBuilder.execute();
            if (httpResponse == null) {
                return null;
            }
            int status_code = httpResponse.getStatusCode();
            EMLog.d((String)TAG, (String)("getSystemOfficialAccount status_code:" + status_code));
            if (status_code >= 200 && status_code < 300) {
                StringBuffer buffer = new StringBuffer();
                httpResponse.read(buffer);
                String result = buffer.toString();
                JSONObject resultJson = new JSONObject(result);
                if (resultJson.has("entities") && !resultJson.isNull("entities")) {
                    JSONArray entitiesJson = resultJson.getJSONArray("entities");
                    for (int j = 0; j < entitiesJson.length(); ++j) {
                        JSONObject itemJson = entitiesJson.getJSONObject(j);
                        String type = itemJson.getString("type");
                        if (type == null || !type.equals("SYSTEM")) continue;
                        OfficialAccount officialAccount = new OfficialAccount();
                        officialAccount.setId(itemJson.getString("official_account_id"));
                        if (itemJson.has("img")) {
                            officialAccount.setImg(itemJson.getString("img"));
                        }
                        if (itemJson.has("name")) {
                            officialAccount.setName(itemJson.getString("name"));
                        }
                        officialAccount.setType("SYSTEM");
                        ChatClient.getInstance().chatManager().getConversation(conversationId).setOfficialAccount(officialAccount);
                        return officialAccount;
                    }
                }
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized ConversationInfo getLastestSession(String officialAccountId, String conversationId) {
        String visitorId;
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        Object object = lock;
        synchronized (object) {
            visitorId = KefuDBManager.getInstance().getVisitorUserId(conversationId);
            if (TextUtils.isEmpty((CharSequence)visitorId)) {
                visitorId = MarketingHttpClient.getVisitorIdFromRemote(toUser);
            }
        }
        if (TextUtils.isEmpty((CharSequence)visitorId)) {
            return null;
        }
        try {
            String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors/%3$s/official-accounts/%4$s/latest-session", ChatClient.getInstance().kefuRestServer(), ChatClient.getInstance().tenantId(), visitorId, officialAccountId);
            String appkey = ChatClient.getInstance().appKey();
            String token = ChatClient.getInstance().accessToken();
            String currentUser = ChatClient.getInstance().currentUserName();
            HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
            httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
            httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
            HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
            assert (appkey != null);
            requestBuilder.param("orgName", appkey.split("#")[0]);
            requestBuilder.param("appName", appkey.split("#")[1]);
            requestBuilder.param("userName", currentUser);
            requestBuilder.param("token", token);
            HttpResponse httpResponse = requestBuilder.execute();
            if (httpResponse == null) {
                return null;
            }
            int status_code = httpResponse.getStatusCode();
            EMLog.d((String)TAG, (String)("getLastestSession status_code:" + status_code));
            if (status_code >= 200 && status_code < 300) {
                StringBuffer buffer = new StringBuffer();
                httpResponse.read(buffer);
                String result = buffer.toString();
                JSONObject resultJson = new JSONObject(result);
                if (resultJson.has("entity") && !resultJson.isNull("entity")) {
                    JSONObject entitiesJson = resultJson.getJSONObject("entity");
                    ConversationInfo info = new ConversationInfo();
                    if (entitiesJson.has("session_id")) {
                        info.session_id = entitiesJson.getString("session_id");
                    }
                    if (entitiesJson.has("visitor_id")) {
                        info.visitor_id = entitiesJson.getString("visitor_id");
                    }
                    if (entitiesJson.has("skill_group_id")) {
                        info.skill_group_id = entitiesJson.getLong("skill_group_id");
                    }
                    if (entitiesJson.has("state")) {
                        info.state = entitiesJson.getString("state");
                    }
                    if (info.session_id != null) {
                        ChatClient.getInstance().chatManager().getConversation(conversationId).setConversationInfo(info);
                        currentConversationId = conversationId;
                    }
                    return info;
                }
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return null;
    }

    static void asyncOpened(String conversationId) {
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            return;
        }
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        final String tempToUser = toUser;
        List<String> marketingIds = KefuDBManager.getInstance().getMarketingIdsByConversationId(conversationId, "delivered");
        if (marketingIds != null && !marketingIds.isEmpty()) {
            KefuDBManager.getInstance().updateMarketingInfoStatusByConversationId(conversationId, "delivered", "opened");
            for (final String marketingId : marketingIds) {
                sendThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        MarketingHttpClient.sendMarketingOpened(marketingId, tempToUser, new ValueCallBack<String>(){

                            @Override
                            public void onSuccess(String value) {
                            }

                            @Override
                            public void onError(int error, String errorMsg) {
                                String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/opened", ChatClient.getInstance().kefuRestServer(), ChatClient.getInstance().tenantId(), marketingId);
                                RequestInfo info = new RequestInfo();
                                info.key = "marketing";
                                info.url = remoteUrl;
                                info.params = tempToUser;
                                KefuDBManager.getInstance().addRequestInfo(info);
                            }
                        });
                    }
                });
            }
        }
    }

    static void asyncDelivered(final String taskId, String conversationId) {
        if (TextUtils.isEmpty((CharSequence)taskId) || TextUtils.isEmpty((CharSequence)conversationId)) {
            return;
        }
        KefuDBManager.getInstance().addMarketingInfo(taskId, conversationId, "delivered");
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        final String tempToUser = toUser;
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MarketingHttpClient.sendMarketingDelivered(taskId, tempToUser, new ValueCallBack<String>(){

                    @Override
                    public void onSuccess(String value) {
                    }

                    @Override
                    public void onError(int error, String errorMsg) {
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/delivered", ChatClient.getInstance().kefuRestServer(), ChatClient.getInstance().tenantId(), taskId);
                        RequestInfo info = new RequestInfo();
                        info.key = "marketing";
                        info.url = remoteUrl;
                        info.params = tempToUser;
                        KefuDBManager.getInstance().addRequestInfo(info);
                    }
                });
            }
        });
    }

    static void asyncReplied(String conversationId) {
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            return;
        }
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        final String tempToUser = toUser;
        List<String> marketingIds = KefuDBManager.getInstance().getMarketingIdsByConversationId(conversationId, "opened");
        if (marketingIds != null && !marketingIds.isEmpty()) {
            KefuDBManager.getInstance().deleteMarketingInfoByConversationId(conversationId, "opened");
            for (final String marketingId : marketingIds) {
                sendThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        MarketingHttpClient.sendMarketingReplied(marketingId, tempToUser, new ValueCallBack<String>(){

                            @Override
                            public void onSuccess(String value) {
                            }

                            @Override
                            public void onError(int error, String errorMsg) {
                                String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/marketing-tasks/%3$s/replied", ChatClient.getInstance().kefuRestServer(), ChatClient.getInstance().tenantId(), marketingId);
                                RequestInfo info = new RequestInfo();
                                info.key = "marketing";
                                info.url = remoteUrl;
                                info.params = tempToUser;
                                KefuDBManager.getInstance().addRequestInfo(info);
                            }
                        });
                    }
                });
            }
        }
    }

    static void asyncRequest() {
        try {
            List<RequestInfo> requestInfos = KefuDBManager.getInstance().getRequestInfoByKey("marketing");
            if (requestInfos != null && !requestInfos.isEmpty()) {
                for (final RequestInfo info : requestInfos) {
                    MarketingHttpClient.sendMarketingStatusChanged(info.url, info.params, new ValueCallBack<String>(){

                        @Override
                        public void onSuccess(String value) {
                            KefuDBManager.getInstance().deleteRequestInfoById(info.id);
                        }

                        @Override
                        public void onError(int error, String errorMsg) {
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void asyncGetTenantIdFunctionIcons(final String tenantId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String remoteUrl = String.format("%1$s/v1/grayscale/tenants/" + tenantId, ChatClient.getInstance().kefuRestServer());
                        String tenantId2 = ChatClient.getInstance().tenantId();
                        if (tenantId2 == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetTenantIdFunctionIcons status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    static void asyncWhiteboardFileConversion(final String token, final String tenantId, final String callId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String content = "{}";
                        String remoteUrl = String.format("%1$s/v1/agorartc/tenant/%2$s/whiteboard/call/%3$s/conversion", ChatClient.getInstance().kefuRestServer(), tenantId, callId);
                        String tenantId2 = ChatClient.getInstance().tenantId();
                        if (tenantId2 == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.header("Authorization", token);
                        requestBuilder.content(content.getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetWhiteboardRoomId status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    static void asyncUploadFile(final String filePath, final String token, final int callId, final String tenantId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/agorartc/tenant/%2$s/whiteboard/call/%3$d/conversion/upload", urlRoot, tenantId, callId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncUploadFile request url:" + remoteUrl));
                        File file = new File(filePath);
                        URL url = new URL(remoteUrl);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        conn.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        conn.setUseCaches(false);
                        conn.setRequestProperty("Connection", "Keep-Alive");
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Authorization", token);
                        conn.setRequestProperty("Charset", "utf-8");
                        conn.setDoInput(true);
                        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                        conn.setRequestProperty("file", file.getAbsolutePath());
                        DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
                        ((OutputStream)outputStream).write((twoHyphens + boundary + lineEnd).getBytes());
                        ((OutputStream)outputStream).write(("Content-Disposition: form-data; name=\"file\";filename=\"" + file.getName() + "\"" + lineEnd).getBytes());
                        ((OutputStream)outputStream).write(("Content-Type: " + CommonUtils.getMIMEType(file) + lineEnd + lineEnd).getBytes());
                        DataInputStream in = new DataInputStream(new FileInputStream(file));
                        int length = -1;
                        byte[] bufferOut = new byte[1024];
                        while ((length = in.read(bufferOut)) != -1) {
                            ((OutputStream)outputStream).write(bufferOut, 0, length);
                        }
                        byte[] endData = (lineEnd + twoHyphens + boundary + twoHyphens + lineEnd).getBytes();
                        ((OutputStream)outputStream).write(endData);
                        ((OutputStream)outputStream).flush();
                        ((OutputStream)outputStream).close();
                        in.close();
                        InputStream inputStream = conn.getInputStream();
                        conn.connect();
                        int responseCode = conn.getResponseCode();
                        StringBuilder stringBuilder = new StringBuilder();
                        BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                        String line = null;
                        while ((line = bf.readLine()) != null) {
                            stringBuilder.append(line);
                        }
                        bf.close();
                        inputStream.close();
                        if (callBack != null) {
                            callBack.onSuccess(stringBuilder.toString());
                            Log.e("", "");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block5;
                        callBack.onError(-1, "error->" + e.toString());
                    }
                }
            }
        });
    }

    static void asyncFileConverted(final String filePath, final String token, final int callId, final String tenantId, final String type, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/agorartc/tenant/%2$s/whiteboard/call/%3$d/conversion", urlRoot, tenantId, callId);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.header("Authorization", token);
                        JSONObject postContent = new JSONObject();
                        postContent.put("resource", (Object)filePath);
                        postContent.put("type", (Object)type);
                        requestBuilder.content(postContent.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetWhiteboardRoomId status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block6;
                        callBack.onError(-1, "error->" + e.toString());
                    }
                }
            }
        });
    }

    static void asyncFileConvertedProgress(String tenantId, String token, int callId, String type, String taskId, ValueCallBack<String> callBack) {
        block6: {
            try {
                String urlRoot = ChatClient.getInstance().kefuRestServer();
                String remoteUrl = String.format("%1$s/v1/agorartc/tenant/%2$s/whiteboard/call/%3$d/conversion/%4$s?type=%5$s", urlRoot, tenantId, callId, taskId, type);
                EMLog.d((String)TAG, (String)("asyncFileConvertedProgress request url:" + remoteUrl));
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                httpClient.setReadTimeout(180000);
                HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                requestBuilder.header("Authorization", token);
                HttpResponse httpResponse = requestBuilder.execute();
                if (httpResponse == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "response is null");
                    }
                    return;
                }
                int status_code = httpResponse.getStatusCode();
                if (status_code >= 200 && status_code < 300) {
                    StringBuffer buffer = new StringBuffer();
                    httpResponse.read(buffer);
                    String result = buffer.toString();
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                if (callBack == null) break block6;
                callBack.onError(-1, "error->" + ignored);
            }
        }
    }

    static void asyncFileSignName(String tenantId, final String token, final int callId, final String filePath, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        String tenantId = ChatClient.getInstance().tenantId();
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/agorartc/tenant/%2$s/whiteboard/call/%3$d/conversion/sign", urlRoot, tenantId, callId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncFileSignName request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.header("Authorization", token);
                        JSONObject postContent = new JSONObject();
                        postContent.put("urls", (Object)filePath);
                        requestBuilder.content(postContent.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static String getFileTypeByFilePath(File file) {
        String fileName = file.getName();
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String type = "application/octet-stream";
        try {
            type = "png".equals(prefix) ? "png" : ("jpg".equals(prefix) ? "jpg" : ("mp4".equals(prefix) ? "mp4" : ("mp3".equals(prefix) ? "mp3" : ("pptx".equals(prefix) ? "pptx" : ("ppt".equals(prefix) ? "ppt" : ("pdf".equals(prefix) ? "pdf" : ("doc".equals(prefix) ? "doc" : ("docx".equals(prefix) ? "docx" : ("xlsx".equals(prefix) ? "xlsx" : ("txt".equals(prefix) ? "txt" : ("webp".equals(prefix) ? "webp" : "")))))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSubmitBody(String url, Map<String, String> map, String filePath, byte[] body_data, String charset) {
        String NEWLINE = "\r\n";
        String PREFIX = "--";
        String BOUNDARY = "#";
        HttpURLConnection httpConn = null;
        BufferedInputStream bis = null;
        FilterOutputStream dos = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            URL urlObj = new URL(url);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setUseCaches(false);
            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("Accept", "*/*");
            httpConn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            httpConn.setRequestProperty("Cache-Control", "no-cache");
            httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=#");
            httpConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30)");
            httpConn.connect();
            dos = new DataOutputStream(httpConn.getOutputStream());
            if (map != null && !map.isEmpty()) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = map.get(key);
                    ((DataOutputStream)dos).writeBytes("--#\r\n");
                    ((DataOutputStream)dos).writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + "\r\n");
                    ((DataOutputStream)dos).writeBytes("\r\n");
                    ((DataOutputStream)dos).writeBytes(URLEncoder.encode(value.toString(), charset));
                    ((DataOutputStream)dos).writeBytes("\r\n");
                }
            }
            if (body_data != null && body_data.length > 0) {
                ((DataOutputStream)dos).writeBytes("--#\r\n");
                String fileName = filePath.substring(filePath.lastIndexOf(File.separatorChar));
                ((DataOutputStream)dos).writeBytes("Content-Disposition: form-data; name=\"uploadFile\"; filename=\"" + fileName + "\"" + "\r\n");
                ((DataOutputStream)dos).writeBytes("\r\n");
                dos.write(body_data);
                ((DataOutputStream)dos).writeBytes("\r\n");
            }
            ((DataOutputStream)dos).writeBytes("--#--\r\n");
            ((DataOutputStream)dos).flush();
            byte[] buffer = new byte[8192];
            int c = 0;
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                while ((c = bis.read(buffer)) != -1) {
                    baos.write(buffer, 0, c);
                    baos.flush();
                }
            }
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dos.close();
                bis.close();
                baos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(path);
        }
        catch (Exception e) {
            return "application/octet-stream";
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    public static void asyncInitLanguage(final String tenantId, final String language, final String appKey, final String visitorUserName, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors/init-language/set", urlRoot, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncInitLanguage request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        JSONObject postContent = new JSONObject();
                        postContent.put("language", (Object)language);
                        postContent.put("appkey", (Object)appKey);
                        postContent.put("visitorUserName", (Object)visitorUserName);
                        requestBuilder.content(postContent.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncInitLanguage status_code:" + status_code));
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block6;
                        callBack.onError(-1, "error->" + e.toString());
                    }
                }
            }
        });
    }

    public static void asyncInitStyle(final String tenantId, final String configId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                EMLog.e((String)MarketingHttpClient.TAG, (String)"asyncInitStyle tenantId is null");
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/kefurtc/visitor/plugin/webim/%2$s", urlRoot, configId);
                        EMLog.e((String)MarketingHttpClient.TAG, (String)("asyncInitStyle request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                EMLog.e((String)MarketingHttpClient.TAG, (String)"asyncInitStyle httpResponse: requestBuilder.execute() result is null.");
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                EMLog.e((String)MarketingHttpClient.TAG, (String)("asyncInitStyle result:" + result));
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        EMLog.e((String)MarketingHttpClient.TAG, (String)("asyncInitStyle error:" + ignored.toString()));
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncCloseVec(final String tenantId, final String rtcSessionId, final String visitorId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/close", urlRoot, tenantId, rtcSessionId, visitorId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncCloseVec request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void closeVec(String tenantId, String rtcSessionId, String visitorId, ValueCallBack<String> callBack) {
        block8: {
            try {
                if (tenantId == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "tenantid is null");
                    }
                    return;
                }
                String urlRoot = ChatClient.getInstance().kefuRestServer();
                String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/session/%3$s/visitor/%4$s/close", urlRoot, tenantId, rtcSessionId, visitorId);
                EMLog.d((String)TAG, (String)("asyncCloseVec request url:" + remoteUrl));
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                httpClient.setConnectTimeout(8000);
                httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                HttpResponse httpResponse = requestBuilder.execute();
                if (httpResponse == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "response is null");
                    }
                    return;
                }
                int status_code = httpResponse.getStatusCode();
                if (status_code >= 200 && status_code < 300) {
                    StringBuffer buffer = new StringBuffer();
                    httpResponse.read(buffer);
                    String result = buffer.toString();
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                if (callBack == null) break block8;
                callBack.onError(-1, "error->" + ignored);
            }
        }
    }

    public static void asyncVisitorId(final String toUser, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MarketingHttpClient.getVisitorIdAndVecSessionId(toUser, callBack);
            }
        });
    }

    public static void getVisitorId(String toUser, ValueCallBack<String> callBack) {
        MarketingHttpClient.getVisitorIdAndVecSessionId(toUser, callBack);
    }

    public static void getVisitorIdAndVecSessionId(String conversationId, ValueCallBack<String> callBack) {
        String visitorId;
        String toUser = conversationId;
        if (toUser.contains("#|")) {
            toUser = toUser.substring(0, toUser.indexOf("#|"));
        }
        if (TextUtils.isEmpty((CharSequence)(visitorId = MarketingHttpClient.getVisitorId(toUser)))) {
            if (callBack != null) {
                callBack.onError(-1, "visitorId = null");
            }
            return;
        }
        if (callBack != null) {
            callBack.onSuccess(visitorId);
        }
    }

    private static String getVisitorId(String toUser) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            EMLog.e((String)TAG, (String)"get visitor but not login");
            return "";
        }
        String tenantId = ChatClient.getInstance().tenantId();
        if (TextUtils.isEmpty((CharSequence)tenantId)) {
            return "";
        }
        try {
            String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/visitors", ChatClient.getInstance().kefuRestServer(), tenantId);
            String appkey = ChatClient.getInstance().appKey();
            String token = ChatClient.getInstance().accessToken();
            String currentUser = ChatClient.getInstance().currentUserName();
            String techChannelinfo = appkey + "#" + toUser;
            HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
            httpClient.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
            httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
            HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
            assert (appkey != null);
            requestBuilder.param("orgName", appkey.split("#")[0]);
            requestBuilder.param("appName", appkey.split("#")[1]);
            requestBuilder.param("userName", currentUser);
            requestBuilder.param("token", token);
            requestBuilder.param("techChannelInfo", techChannelinfo);
            HttpResponse httpResponse = requestBuilder.execute();
            if (httpResponse == null) {
                return "";
            }
            int status_code = httpResponse.getStatusCode();
            EMLog.d((String)TAG, (String)("getVisitorIdFromRemote status_code:" + status_code));
            if (status_code >= 200 && status_code < 300) {
                StringBuffer buffer = new StringBuffer();
                httpResponse.read(buffer);
                String result = buffer.toString();
                JSONObject resultJson = new JSONObject(result);
                if (resultJson.has("entity")) {
                    JSONObject entitiesJson = resultJson.getJSONObject("entity");
                    return entitiesJson.getString("userId");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void getSkillGroupMenuWithVisitorUserName(final String tenantId, final String visitorUserName, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/skillgroup-menu?visitorUserName=%3$s", urlRoot, tenantId, visitorUserName);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncInitStyle request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncResultReporting(final String tenantId, final String visitorId, final String type, final JSONObject resultObj, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/kefurtc/visitor/%2$s/tenant/%3$s/business/report", urlRoot, visitorId, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncResultReporting request url:" + remoteUrl));
                        Log.e("rrrrrrrr", "asyncResultReporting remoteUrl = " + remoteUrl);
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        JSONObject postContent = new JSONObject();
                        postContent.put("type", (Object)type);
                        postContent.put("result", (Object)resultObj);
                        requestBuilder.content(postContent.toString().getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void resultReporting(String tenantId, String visitorId, String type, JSONObject resultObj, ValueCallBack<String> callBack) {
        block8: {
            try {
                if (tenantId == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "tenantid is null");
                    }
                    return;
                }
                String urlRoot = ChatClient.getInstance().kefuRestServer();
                String remoteUrl = String.format("%1$s/v1/kefurtc/visitor/%2$s/tenant/%3$s/business/report", urlRoot, visitorId, tenantId);
                EMLog.d((String)TAG, (String)("resultReporting request url:" + remoteUrl));
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                httpClient.setConnectTimeout(8000);
                httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                requestBuilder.header("Content-Type", "application/json");
                JSONObject postContent = new JSONObject();
                postContent.put("type", (Object)type);
                postContent.put("result", (Object)resultObj);
                requestBuilder.content(postContent.toString().getBytes(), "application/json");
                HttpResponse httpResponse = requestBuilder.execute();
                if (httpResponse == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "response is null");
                    }
                    return;
                }
                int status_code = httpResponse.getStatusCode();
                if (status_code >= 200 && status_code < 300) {
                    StringBuffer buffer = new StringBuffer();
                    httpResponse.read(buffer);
                    String result = buffer.toString();
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callBack == null) break block8;
                callBack.onError(-1, "error->" + e);
            }
        }
    }

    public static void asyncUploadSignatureImage(final File file, final String token, final String tenantId, final String flowId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/Service/vec/visitor/Tenant/%2$s/MediaFiles", urlRoot, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncUploadSignatureImage request url:" + remoteUrl));
                        URL url = new URL(remoteUrl);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
                        conn.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        conn.setUseCaches(false);
                        conn.setRequestProperty("Connection", "Keep-Alive");
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Authorization", token);
                        conn.setRequestProperty("Charset", "utf-8");
                        conn.setDoInput(true);
                        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                        conn.setRequestProperty("file", file.getAbsolutePath());
                        DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
                        ((OutputStream)outputStream).write((twoHyphens + boundary + lineEnd).getBytes());
                        ((OutputStream)outputStream).write(("Content-Disposition: form-data; name=\"file\";filename=\"" + file.getName() + "\"" + lineEnd).getBytes());
                        ((OutputStream)outputStream).write(("Content-Type: " + CommonUtils.getMIMEType(file) + lineEnd + lineEnd).getBytes());
                        DataInputStream in = new DataInputStream(new FileInputStream(file));
                        int length = -1;
                        byte[] bufferOut = new byte[1024];
                        while ((length = in.read(bufferOut)) != -1) {
                            ((OutputStream)outputStream).write(bufferOut, 0, length);
                        }
                        byte[] endData = (lineEnd + twoHyphens + boundary + twoHyphens + lineEnd).getBytes();
                        ((OutputStream)outputStream).write(endData);
                        ((OutputStream)outputStream).flush();
                        ((OutputStream)outputStream).close();
                        in.close();
                        conn.connect();
                        int responseCode = conn.getResponseCode();
                        if (responseCode != 200) {
                            if (callBack != null) {
                                callBack.onError(responseCode, "responseCode = " + responseCode);
                            }
                            return;
                        }
                        InputStream inputStream = conn.getInputStream();
                        StringBuilder stringBuilder = new StringBuilder();
                        BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                        String line = null;
                        while ((line = bf.readLine()) != null) {
                            stringBuilder.append(line);
                        }
                        bf.close();
                        inputStream.close();
                        String content = stringBuilder.toString();
                        JSONObject jsonObject = new JSONObject(content);
                        String uuid = jsonObject.getString("uuid");
                        String contentType = jsonObject.getString("contentType");
                        String imageUrl = jsonObject.getString("url");
                        String fileName = jsonObject.getString("fileName");
                        String visitorId = VecConfig.newVecConfig().getVisitorId();
                        JSONObject object = new JSONObject();
                        object.put("flowId", (Object)flowId);
                        object.put("action", (Object)"elecsign_end");
                        object.put("url", (Object)imageUrl);
                        MarketingHttpClient.resultReporting(ChatClient.getInstance().tenantId(), VecConfig.newVecConfig().getVisitorId(), "elecsign", object, callBack);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block6;
                        callBack.onError(-1, e.toString());
                    }
                }
            }
        });
    }

    public static void getWaitNumber(String tenantId, String rtcSessionId, ValueCallBack<String> callBack) {
        block8: {
            try {
                if (tenantId == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "tenantid is null");
                    }
                    return;
                }
                String urlRoot = ChatClient.getInstance().kefuRestServer();
                String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/webim/session/%3$s/waiting", urlRoot, tenantId, rtcSessionId);
                EMLog.d((String)TAG, (String)("asyncGetWaitNumber request url:" + remoteUrl));
                HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                httpClient.setConnectTimeout(8000);
                httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
                HttpResponse httpResponse = requestBuilder.execute();
                if (httpResponse == null) {
                    if (callBack != null) {
                        callBack.onError(-1, "response is null");
                    }
                    return;
                }
                int status_code = httpResponse.getStatusCode();
                if (status_code >= 200 && status_code < 300) {
                    StringBuffer buffer = new StringBuffer();
                    httpResponse.read(buffer);
                    String result = buffer.toString();
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                if (callBack == null) break block8;
                callBack.onError(-1, "error->" + ignored);
            }
        }
    }

    private static byte[] getSecretKey(String pas, int keySize) {
        try {
            String algorithmName = "AES";
            KeyGenerator instance = KeyGenerator.getInstance(algorithmName);
            if (pas == null) {
                instance.init(keySize);
            } else {
                instance.init(keySize, new SecureRandom(pas.getBytes()));
            }
            SecretKey secretKey = instance.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encrypt(String content, String secretKey) {
        try {
            String algorithmName = "AES";
            SecretKeySpec key = new SecretKeySpec(MarketingHttpClient.getSecretKey(secretKey, 128), algorithmName);
            Cipher cipher = Cipher.getInstance(algorithmName);
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, key);
            return cipher.doFinal(byteContent);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void asyncSubmitEvaluate(final String tenantId, final String jsonData, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/kefurtc/tenant/%2$s/enquiry/visitor/submit", urlRoot, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncSubmitEvaluate request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        requestBuilder.header("Content-Type", "application/json");
                        requestBuilder.content(jsonData.getBytes(), "application/json");
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + e);
                    }
                }
            }
        });
    }

    public static void asyncGetInfo(final String tenantId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/info", urlRoot, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncGetInfo request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncProblemSolvingOnServiceSessionResolved(final String tenantId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/options/problemSolvingOnServiceSessionResolved", urlRoot, tenantId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncProblemSolvingOnServiceSessionResolved request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncEvalSolveWord(final String tenantId, final String serviceSessionId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/options/evaluteSolveWord?serviceSessionId=%3$s", urlRoot, tenantId, serviceSessionId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncProblemSolvingOnServiceSessionResolved request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncResolutionParams(final String tenantId, final String serviceSessionId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block10: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String appKey = ChatClient.getInstance().appKey();
                        if (appKey == null) {
                            EMLog.e((String)MarketingHttpClient.TAG, (String)"appkey is not set");
                            if (callBack != null) {
                                callBack.onError(100, "appkey is not set");
                            }
                            return;
                        }
                        String orgName = appKey.split("#")[0];
                        String appName = appKey.split("#")[1];
                        String currentUserName = ChatClient.getInstance().currentUserName();
                        String token = ChatClient.getInstance().accessToken();
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/resolutionparams?serviceSessionId=%3$s&orgName=%4$s&appName=%5$s&userName=%6$s&token=%7$s", urlRoot, tenantId, serviceSessionId, orgName, appName, currentUserName, token);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncResolutionParams request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block10;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncGreetingMsgEnquiryInvite(final String tenantId, final String serviceSessionId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/options/GreetingMsgEnquiryInvite?serviceSessionId=%3$s", urlRoot, tenantId, serviceSessionId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncProblemSolvingOnServiceSessionResolved request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.get(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + ignored);
                    }
                }
            }
        });
    }

    public static void asyncMarkAllMessagesAsRead(final String tenantId, final String sessionId, final ValueCallBack<String> callBack) {
        sendThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (tenantId == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "tenantid is null");
                            }
                            return;
                        }
                        String urlRoot = ChatClient.getInstance().kefuRestServer();
                        String remoteUrl = String.format("%1$s/v1/webimplugin/tenants/%2$s/servicesessions/%3$s/read", urlRoot, tenantId, sessionId);
                        EMLog.d((String)MarketingHttpClient.TAG, (String)("asyncMarkAllMessagesAsRead request url:" + remoteUrl));
                        HttpClient httpClient = new HttpClient(EMClient.getInstance().getContext());
                        httpClient.setConnectTimeout(8000);
                        httpClient.setReadTimeout(DEFAULT_READ_TIMEOUT);
                        HttpRequestBuilder requestBuilder = httpClient.post(remoteUrl);
                        HttpResponse httpResponse = requestBuilder.execute();
                        if (httpResponse == null) {
                            if (callBack != null) {
                                callBack.onError(-1, "response is null");
                            }
                            return;
                        }
                        int status_code = httpResponse.getStatusCode();
                        if (status_code >= 200 && status_code < 300) {
                            StringBuffer buffer = new StringBuffer();
                            httpResponse.read(buffer);
                            String result = buffer.toString();
                            if (callBack != null) {
                                callBack.onSuccess(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callBack == null) break block8;
                        callBack.onError(-1, "error->" + e);
                    }
                }
            }
        });
    }

    static {
        lineEnd = "\r\n";
        twoHyphens = "--";
        boundary = "*****";
    }
}

