/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.Application;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileInputStream;
import java.lang.reflect.Method;

public class ProcessUtils {
    private static String mCurrentProcessName;

    public static String getCurrentProcessName() {
        if (TextUtils.isEmpty((CharSequence)mCurrentProcessName) && TextUtils.isEmpty((CharSequence)(mCurrentProcessName = ProcessUtils.getProcessNameFromSdk())) && TextUtils.isEmpty((CharSequence)(mCurrentProcessName = ProcessUtils.getProcessNameFromActivityThread()))) {
            mCurrentProcessName = ProcessUtils.getProcessNameFromCmd();
            mCurrentProcessName = !TextUtils.isEmpty((CharSequence)mCurrentProcessName) ? mCurrentProcessName : "";
        }
        return mCurrentProcessName;
    }

    private static String getProcessNameFromSdk() {
        return Build.VERSION.SDK_INT >= 28 ? Application.getProcessName() : null;
    }

    private static String getProcessNameFromActivityThread() {
        String var0 = null;
        try {
            Method var1 = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            var1.setAccessible(true);
            Object var2 = var1.invoke(null, new Object[0]);
            if (var2 instanceof String) {
                var0 = (String)var2;
            }
        }
        catch (Throwable var3) {
            Log.e((String)"ProcessUtil", (String)("getCurrentProcessNameByActivityThread failed, " + var3.getMessage()));
        }
        return var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameFromCmd() {
        String var5;
        FileInputStream var0 = null;
        try {
            int var4;
            String var1 = "/proc/self/cmdline";
            var0 = new FileInputStream(var1);
            byte[] var2 = new byte[256];
            int var3 = 0;
            while ((var4 = var0.read()) > 0 && var3 < var2.length) {
                var2[var3++] = (byte)var4;
            }
            if (var3 <= 0) {
                String string = "";
                return string;
            }
            var5 = new String(var2, 0, var3, "UTF-8");
        }
        catch (Throwable var16) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (var0 != null) {
                    var0.close();
                }
            }
            catch (Throwable var15) {
                var15.printStackTrace();
            }
        }
        return var5;
    }
}

