/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import android.content.Context;
import android.os.Build;
import com.hyphenate.helpdesk.httpclient.HttpClient;
import com.hyphenate.helpdesk.httpclient.HttpClientException;
import com.hyphenate.helpdesk.httpclient.HttpRequestHandler;
import com.hyphenate.helpdesk.httpclient.HttpResponse;
import com.hyphenate.helpdesk.httpclient.HttpResponseHandler;
import com.hyphenate.helpdesk.httpclient.ProgressListener;
import com.hyphenate.helpdesk.httpclient.UncloseableInputStream;
import com.hyphenate.helpdesk.httpclient.WriteToOutputStreamAndProgressHandler;
import com.hyphenate.helpdesk.httpclient.WriteToOutputStreamHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.FileNameMap;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;

public final class HttpRequestBuilder {
    private static final String CONTENT_CHARSET = "UTF-8";
    private static final Map<String, List<String>> NO_HEADERS = new HashMap<String, List<String>>(0);
    private static TrustManager[] trustManagers;
    private final byte[] buffer = new byte[1024];
    private final HttpClient hc;
    private final List<HttpRequestHandler> reqHandlers = new ArrayList<HttpRequestHandler>(2);
    private String uri;
    private String method;
    private Set<Integer> expectedStatusCodes = new HashSet<Integer>(2);
    private Map<String, String> cookies;
    private Map<String, List<String>> headers;
    private Map<String, String> parameters;
    private byte[] content;
    private String contentFilePath;
    private boolean contentSet;
    private String contentType;
    private HttpResponseHandler handler;
    private String lineEnd = "\r\n";
    private String twoHyphens = "--";
    private String boundary = "*****";

    HttpRequestBuilder(HttpClient hc, String uri, String method) {
        this.hc = hc;
        this.uri = uri;
        this.method = method;
    }

    private HttpRequestBuilder with(HttpRequestHandler handler) {
        if (handler != null) {
            this.reqHandlers.add(handler);
        }
        return this;
    }

    public HttpRequestBuilder expect(int ... statusCodes) {
        if (statusCodes != null) {
            for (int statusCode : statusCodes) {
                if (statusCode < 1) {
                    throw new IllegalArgumentException("Invalid status code:" + statusCode);
                }
                this.expectedStatusCodes.add(statusCode);
            }
        }
        return this;
    }

    public HttpRequestBuilder contentFromFile(String filePath) {
        this.contentFilePath = filePath;
        if (this.contentFilePath != null) {
            this.contentSet = true;
        }
        return this;
    }

    public HttpRequestBuilder content(byte[] content, String contentType) {
        this.content = content;
        this.contentType = contentType;
        if (content != null) {
            this.contentSet = true;
        }
        return this;
    }

    public HttpRequestBuilder cookies(Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    public HttpRequestBuilder headers(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder header(String name, String value) {
        List<String> values;
        if (name == null) {
            throw new IllegalArgumentException("Header name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>(2);
        }
        if ((values = this.headers.get(name)) == null) {
            values = new ArrayList<String>(1);
            this.headers.put(name, values);
        }
        values.add(value);
        return this;
    }

    public HttpRequestBuilder params(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public HttpRequestBuilder param(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value cannot be null");
        }
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>(4);
        }
        this.parameters.put(name, value);
        return this;
    }

    public HttpRequestBuilder cookie(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cookie name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cookie value cannot be null");
        }
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>(2);
        }
        this.cookies.put(name, value);
        return this;
    }

    public HttpRequestBuilder to(HttpResponseHandler handler) {
        this.handler = handler;
        return this;
    }

    public HttpRequestBuilder to(File file) throws IOException {
        this.to(new WriteToOutputStreamHandler(new FileOutputStream(file)));
        return this;
    }

    public HttpRequestBuilder to(File file, ProgressListener progressListener) throws IOException {
        this.to(new WriteToOutputStreamAndProgressHandler(new FileOutputStream(file), progressListener));
        return this;
    }

    public HttpRequestBuilder to(OutputStream output) {
        this.to(new WriteToOutputStreamHandler(output));
        return this;
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(path);
        }
        catch (Exception e) {
            return "application/octet-stream";
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse execute() throws HttpClientException {
        HttpURLConnection conn = null;
        UncloseableInputStream payloadStream = null;
        try {
            List<String> newCookies;
            String userAgent;
            if (this.parameters != null && !this.parameters.isEmpty()) {
                StringBuffer buf = new StringBuffer(256);
                if ("GET".equals(this.method) || "HEAD".equals(this.method) || "PUT".equals(this.method)) {
                    buf.append('?');
                }
                boolean bl = false;
                for (Map.Entry<String, String> e : this.parameters.entrySet()) {
                    void var4_7;
                    if (var4_7 != false) {
                        buf.append("&");
                    }
                    String name = e.getKey();
                    String value = e.getValue();
                    buf.append(URLEncoder.encode(name, CONTENT_CHARSET)).append("=").append(URLEncoder.encode(value, CONTENT_CHARSET));
                    ++var4_7;
                }
                if (!this.contentSet && ("POST".equals(this.method) || "DELETE".equals(this.method) || "PUT".equals(this.method))) {
                    try {
                        this.content = buf.toString().getBytes(CONTENT_CHARSET);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new HttpClientException("Encoding error", e);
                    }
                } else {
                    this.uri = this.uri + buf;
                }
            }
            conn = (HttpURLConnection)new URL(this.uri).openConnection();
            conn.setConnectTimeout(this.hc.getConnectTimeout());
            conn.setReadTimeout(this.hc.getReadTimeout());
            conn.setAllowUserInteraction(false);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod(this.method);
            conn.setUseCaches(false);
            conn.setDoInput(true);
            if (this.headers != null && !this.headers.isEmpty()) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    List values = (List)entry.getValue();
                    if (values == null) continue;
                    String name = (String)entry.getKey();
                    for (String value : values) {
                        conn.addRequestProperty(name, value);
                    }
                }
            }
            if (this.cookies != null && !this.cookies.isEmpty() || this.hc.getInMemoryCookies() != null && !this.hc.getInMemoryCookies().isEmpty()) {
                StringBuilder cookieHeaderValue = new StringBuilder(256);
                HttpRequestBuilder.prepareCookieHeader(this.cookies, cookieHeaderValue);
                HttpRequestBuilder.prepareCookieHeader(this.hc.getInMemoryCookies(), cookieHeaderValue);
                conn.setRequestProperty("Cookie", cookieHeaderValue.toString());
            }
            if ((userAgent = this.hc.getUserAgent()) != null) {
                conn.setRequestProperty("User-Agent", userAgent);
            }
            conn.setRequestProperty("Connection", "close");
            conn.setRequestProperty("Location", this.uri);
            conn.setRequestProperty("Referrer", this.uri);
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            conn.setRequestProperty("Accept-Charset", CONTENT_CHARSET);
            if (conn instanceof HttpsURLConnection) {
                HttpRequestBuilder.setupSecureConnection(this.hc.getContext(), (HttpsURLConnection)conn);
            }
            if ("POST".equals(this.method) || "DELETE".equals(this.method) || "PUT".equals(this.method)) {
                if (this.content != null) {
                    conn.setDoOutput(true);
                    if (!this.contentSet) {
                        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    } else if (this.contentType != null) {
                        conn.setRequestProperty("Content-Type", this.contentType);
                    }
                    conn.setFixedLengthStreamingMode(this.content.length);
                    OutputStream outputStream = conn.getOutputStream();
                    outputStream.write(this.content);
                    outputStream.flush();
                } else if (this.contentFilePath != null) {
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + this.boundary);
                    conn.setRequestProperty("file", this.contentFilePath);
                    File file = new File(this.contentFilePath);
                    DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
                    ((OutputStream)outputStream).write((this.twoHyphens + this.boundary + this.lineEnd).getBytes());
                    ((OutputStream)outputStream).write(("Content-Disposition: form-data; name=\"file\";filename=\"" + file.getName() + "\"" + this.lineEnd).getBytes());
                    ((OutputStream)outputStream).write(("Content-Type: " + this.guessMimeType(file.getPath()) + this.lineEnd + this.lineEnd).getBytes());
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    int length = -1;
                    Object bufferOut = new byte[1024];
                    while ((length = in.read((byte[])bufferOut)) != -1) {
                        ((OutputStream)outputStream).write((byte[])bufferOut, 0, length);
                    }
                    in.close();
                    byte[] endData = (this.lineEnd + this.twoHyphens + this.boundary + this.twoHyphens + this.lineEnd).getBytes();
                    ((OutputStream)outputStream).write(endData);
                    ((OutputStream)outputStream).flush();
                    ((OutputStream)outputStream).close();
                } else {
                    conn.setFixedLengthStreamingMode(0);
                }
            }
            for (HttpRequestHandler connHandler : this.reqHandlers) {
                try {
                    connHandler.onRequest(conn);
                }
                catch (HttpClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new HttpClientException("Failed to prepare request to " + this.uri, e);
                }
            }
            conn.connect();
            int n = conn.getResponseCode();
            if (n == -1) {
                throw new HttpClientException("Invalid response from " + this.uri);
            }
            if (!this.expectedStatusCodes.isEmpty() && !this.expectedStatusCodes.contains(n)) {
                throw new HttpClientException("Expected status code " + this.expectedStatusCodes + ", got " + n);
            }
            if (this.expectedStatusCodes.isEmpty() && n / 100 != 2) {
                throw new HttpClientException("Expected status code 2xx, got " + n);
            }
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            Map<String, String> inMemoryCookies = this.hc.getInMemoryCookies();
            if (headerFields != null && (newCookies = headerFields.get("Set-Cookie")) != null) {
                for (String newCookie : newCookies) {
                    String rawCookie = newCookie.split(";", 2)[0];
                    int i = rawCookie.indexOf(61);
                    String name = rawCookie.substring(0, i);
                    String value = rawCookie.substring(i + 1);
                    inMemoryCookies.put(name, value);
                }
            }
            payloadStream = HttpRequestBuilder.isStatusCodeError(n) ? new UncloseableInputStream(HttpRequestBuilder.getErrorStream(conn)) : new UncloseableInputStream(HttpRequestBuilder.getInputStream(conn));
            HttpResponse resp = new HttpResponse(n, payloadStream, headerFields == null ? NO_HEADERS : headerFields, inMemoryCookies);
            if (this.handler != null) {
                try {
                    this.handler.onResponse(resp, conn.getContentLength());
                }
                catch (HttpClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new HttpClientException("Error in response handler", e);
                }
            } else {
                File temp = File.createTempFile("httpclient-req-", ".cache", this.hc.getContext().getCacheDir());
                resp.preload(temp);
                temp.delete();
            }
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
        catch (SocketTimeoutException e) {
            if (this.handler != null) {
                try {
                    this.handler.onTimeout();
                    HttpResponse httpResponse = null;
                    return httpResponse;
                }
                catch (HttpClientException httpClientException) {
                    throw httpClientException;
                }
                catch (Exception exception) {
                    throw new HttpClientException("Error in response handler", exception);
                }
            }
            throw new HttpClientException("Response timeout from " + this.uri, e);
        }
        catch (IOException e) {
            throw new HttpClientException("Connection failed to " + this.uri, e);
        }
        finally {
            if (conn != null) {
                if (payloadStream != null) {
                    try {
                        while (payloadStream.read(this.buffer) != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                    payloadStream.forceClose();
                }
                conn.disconnect();
            }
        }
    }

    private static boolean isStatusCodeError(int sc) {
        int i = sc / 100;
        return i == 4 || i == 5;
    }

    private static void prepareCookieHeader(Map<String, String> cookies, StringBuilder headerValue) {
        if (cookies != null) {
            for (Map.Entry<String, String> e : cookies.entrySet()) {
                if (headerValue.length() != 0) {
                    headerValue.append("; ");
                }
                headerValue.append(e.getKey()).append("=").append(e.getValue());
            }
        }
    }

    private static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        List<String> contentEncodingValues = conn.getHeaderFields().get("Content-Encoding");
        if (contentEncodingValues != null) {
            for (String contentEncoding : contentEncodingValues) {
                if (contentEncoding == null) continue;
                if (contentEncoding.contains("gzip")) {
                    return new GZIPInputStream(conn.getInputStream());
                }
                if (!contentEncoding.contains("deflate")) continue;
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
        }
        return conn.getInputStream();
    }

    private static InputStream getErrorStream(HttpURLConnection conn) throws IOException {
        List<String> contentEncodingValues = conn.getHeaderFields().get("Content-Encoding");
        if (contentEncodingValues != null) {
            for (String contentEncoding : contentEncodingValues) {
                if (contentEncoding == null) continue;
                if (contentEncoding.contains("gzip")) {
                    return new GZIPInputStream(conn.getErrorStream());
                }
                if (!contentEncoding.contains("deflate")) continue;
                return new InflaterInputStream(conn.getErrorStream(), new Inflater(true));
            }
        }
        return conn.getErrorStream();
    }

    private static void setupSecureConnection(Context context, HttpsURLConnection conn) throws IOException {
        SSLContext sslContext;
        try {
            if (trustManagers == null) {
                // empty if block
            }
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            IOException ioe = new IOException("Failed to initialize SSL engine");
            ioe.initCause(e);
            throw ioe;
        }
        if (Build.VERSION.SDK_INT < 14) {
            final SSLSocketFactory delegate = sslContext.getSocketFactory();
            SSLSocketFactory socketFactory = new SSLSocketFactory(){

                @Override
                public String[] getDefaultCipherSuites() {
                    return delegate.getDefaultCipherSuites();
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    return delegate.getSupportedCipherSuites();
                }

                @Override
                public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                    this.injectHostname(s.getInetAddress(), host);
                    return delegate.createSocket(s, host, port, autoClose);
                }

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    InetAddress addr = InetAddress.getByName(host);
                    this.injectHostname(addr, host);
                    return delegate.createSocket(addr, port);
                }

                @Override
                public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
                    return delegate.createSocket(host, port, localHost, localPort);
                }

                @Override
                public Socket createSocket(InetAddress host, int port) throws IOException {
                    return delegate.createSocket(host, port);
                }

                @Override
                public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                    return delegate.createSocket(address, port, localAddress, localPort);
                }

                private void injectHostname(InetAddress address, String host) {
                    try {
                        Field field = InetAddress.class.getDeclaredField("hostName");
                        field.setAccessible(true);
                        field.set(address, host);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            conn.setSSLSocketFactory(socketFactory);
        } else {
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
        }
        conn.setHostnameVerifier((HostnameVerifier)new BrowserCompatHostnameVerifier());
    }
}

