/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.httpclient;

import android.os.Build;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HttpResponse {
    private final int statusCode;
    private final Map<String, String> cookies;
    private final Map<String, List<String>> headers;
    private InputStream payload;

    HttpResponse(int statusCode, InputStream payload, Map<String, List<String>> rawHeaders, Map<String, String> cookies) {
        this.statusCode = statusCode;
        this.payload = payload;
        this.cookies = Collections.unmodifiableMap(cookies);
        if (Build.VERSION.SDK_INT < 9) {
            HashMap<String, List<String>> newHeaders = new HashMap<String, List<String>>(rawHeaders.size());
            for (Map.Entry<String, List<String>> e : rawHeaders.entrySet()) {
                String key = e.getKey();
                if (key == null) continue;
                int keyLen = key.length();
                StringBuilder newKey = new StringBuilder(keyLen);
                for (int i = 0; i < keyLen; ++i) {
                    char c = key.charAt(i);
                    char c2 = i == 0 || key.charAt(i - 1) == '-' ? Character.toUpperCase(c) : c;
                    newKey.append(c2);
                }
                newHeaders.put(newKey.toString(), e.getValue());
            }
            this.headers = Collections.unmodifiableMap(newHeaders);
        } else {
            this.headers = Collections.unmodifiableMap(rawHeaders);
        }
    }

    public String getContentType() {
        String contentType = this.getFirstHeaderValue("Content-Type");
        if (contentType == null) {
            return null;
        }
        int i = contentType.indexOf(59);
        return i == -1 ? contentType : contentType.substring(0, i).trim();
    }

    public String getContentCharset() {
        String contentType = this.getFirstHeaderValue("Content-Type");
        if (contentType == null) {
            return null;
        }
        int i = contentType.indexOf(61);
        return i == -1 ? null : contentType.substring(i + 1).trim();
    }

    public InputStream getPayload() {
        return this.payload;
    }

    void preload(File temp) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(temp);
            byte[] inBuf = new byte[1024];
            InputStream in = this.getPayload();
            int bytesRead = 0;
            while ((bytesRead = in.read(inBuf)) != -1) {
                out.write(inBuf, 0, bytesRead);
            }
            this.payload = new FileInputStream(temp);
        }
    }

    public String getResponseBody() throws IOException {
        String enc = this.getContentCharset();
        if (enc == null) {
            enc = "UTF-8";
        }
        InputStream input = this.getPayload();
        InputStreamReader inputStreamReader = new InputStreamReader(input, enc);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        String bufferedStrChunk = null;
        while ((bufferedStrChunk = bufferedReader.readLine()) != null) {
            stringBuilder.append(bufferedStrChunk);
        }
        bufferedReader.close();
        inputStreamReader.close();
        return stringBuilder.toString();
    }

    public void read(StringBuffer buffer) throws IOException {
        int charsRead;
        String enc = this.getContentCharset();
        if (enc == null) {
            enc = "UTF-8";
        }
        InputStream input = this.getPayload();
        InputStreamReader reader = new InputStreamReader(input, enc);
        char[] inBuf = new char[64];
        while ((charsRead = reader.read(inBuf)) != -1) {
            buffer.append(inBuf, 0, charsRead);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getFirstHeaderValue(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }
}

