/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Content {
    private static final String TAG = "Content";
    protected JSONObject content = null;
    protected String stringContent = null;

    Content() {
        this.content = new JSONObject();
    }

    Content(JSONObject jsonObject) {
        this.content = jsonObject;
    }

    Content(String value) {
        this.stringContent = value;
    }

    Content set(String name, Object value) {
        try {
            if (this.content != null) {
                this.content.put(name, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        return this;
    }

    Content set(String name, Collection<String> values) {
        try {
            if (this.content != null) {
                this.content.put(name, (Object)new JSONArray(values));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        return this;
    }

    String get(String name) {
        if (this.content == null || !this.content.has(name) || this.content.isNull(name)) {
            return null;
        }
        try {
            return this.content.getString(name);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
            return null;
        }
    }

    boolean has(String name) {
        return this.content != null && this.content.has(name);
    }

    boolean isNull(String name) {
        return this.content == null || this.content.isNull(name);
    }

    Collection<JSONObject> getObjectArray(String name) {
        try {
            if (this.content.has(name) && !this.content.isNull(name)) {
                JSONArray jsonArray = this.content.getJSONArray(name);
                ArrayList<JSONObject> objArray = new ArrayList<JSONObject>();
                for (int index = 0; index < jsonArray.length(); ++index) {
                    objArray.add(jsonArray.getJSONObject(index));
                }
                return objArray;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        return null;
    }

    Collection<String> getStringArray(String name) {
        try {
            if (this.content.has(name) && !this.content.isNull(name)) {
                JSONArray jsonArray = this.content.getJSONArray(name);
                ArrayList<String> strArray = new ArrayList<String>();
                for (int index = 0; index < jsonArray.length(); ++index) {
                    strArray.add(jsonArray.getString(index));
                }
                return strArray;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        return null;
    }

    public void setString(String value) {
        this.stringContent = value;
    }

    public String getString() {
        return this.stringContent;
    }

    public JSONObject getContent() {
        return this.content;
    }

    public abstract String getName();

    public abstract String getParentName();
}

