/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import android.text.TextUtils;
import com.hyphenate.helpdesk.model.AgentIdentityInfo;
import com.hyphenate.helpdesk.model.AgentInfo;
import com.hyphenate.helpdesk.model.ArticlesInfo;
import com.hyphenate.helpdesk.model.ControlArguments;
import com.hyphenate.helpdesk.model.ControlMessage;
import com.hyphenate.helpdesk.model.ControlType;
import com.hyphenate.helpdesk.model.EvaluationInfo;
import com.hyphenate.helpdesk.model.Event;
import com.hyphenate.helpdesk.model.FormInfo;
import com.hyphenate.helpdesk.model.OrderInfo;
import com.hyphenate.helpdesk.model.QueueIdentityInfo;
import com.hyphenate.helpdesk.model.RobotMenuIdInfo;
import com.hyphenate.helpdesk.model.RobotMenuInfo;
import com.hyphenate.helpdesk.model.ToCustomServiceInfo;
import com.hyphenate.helpdesk.model.TransferGuideMenuInfo;
import com.hyphenate.helpdesk.model.TransferGuideQueneInfo;
import com.hyphenate.helpdesk.model.TransferIndication;
import com.hyphenate.helpdesk.model.VisitorInfo;
import com.hyphenate.helpdesk.model.VisitorTrack;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentFactory {
    public static VisitorInfo createVisitorInfo(JSONObject obj) {
        if (obj == null) {
            return new VisitorInfo();
        }
        return new VisitorInfo(obj);
    }

    public static VisitorTrack createVisitorTrack(JSONObject obj) {
        if (obj == null) {
            return new VisitorTrack();
        }
        return new VisitorTrack(obj);
    }

    public static RobotMenuInfo createRobotMenuInfo(JSONObject obj) {
        if (obj == null) {
            return new RobotMenuInfo();
        }
        return new RobotMenuInfo(obj);
    }

    public static TransferGuideMenuInfo createTransferGuideMenuInfo(JSONObject obj) {
        if (obj == null) {
            return new TransferGuideMenuInfo();
        }
        return new TransferGuideMenuInfo(obj);
    }

    public static OrderInfo createOrderInfo(JSONObject obj) {
        if (obj == null) {
            return new OrderInfo();
        }
        return new OrderInfo(obj);
    }

    public static AgentInfo createAgentInfo(JSONObject obj) {
        if (obj == null) {
            return new AgentInfo();
        }
        return new AgentInfo(obj);
    }

    public static TransferIndication createTransferIndication(JSONObject obj) {
        if (obj == null) {
            return new TransferIndication();
        }
        return new TransferIndication(obj);
    }

    static Event createEvent(JSONObject obj) {
        if (obj == null) {
            return new Event();
        }
        return new Event(obj);
    }

    public static ControlMessage createControlMessage(JSONObject obj) {
        if (obj == null) {
            return new ControlMessage();
        }
        return new ControlMessage(obj);
    }

    static ControlType createControlType(String value) {
        if (value == null) {
            return new ControlType();
        }
        return new ControlType(value);
    }

    static ControlArguments createControlArguments(JSONObject obj) {
        if (obj == null) {
            return new ControlArguments();
        }
        return new ControlArguments(obj);
    }

    public static QueueIdentityInfo createQueueIdentityInfo(String value) {
        if (value == null) {
            return new QueueIdentityInfo();
        }
        return new QueueIdentityInfo(value);
    }

    public static AgentIdentityInfo createAgentIdentityInfo(String value) {
        if (value == null) {
            return new AgentIdentityInfo();
        }
        return new AgentIdentityInfo(value);
    }

    static ToCustomServiceInfo createToCustomeServiceInfo(JSONObject obj) {
        if (obj == null) {
            return new ToCustomServiceInfo();
        }
        return new ToCustomServiceInfo(obj);
    }

    public static RobotMenuIdInfo createRobotMenuIdInfo(JSONObject obj) {
        if (obj == null) {
            return new RobotMenuIdInfo();
        }
        return new RobotMenuIdInfo(obj);
    }

    public static TransferGuideQueneInfo createTransferGuideQueueInfo(JSONObject obj) {
        if (obj == null) {
            return new TransferGuideQueneInfo();
        }
        return new TransferGuideQueneInfo(obj);
    }

    static EvaluationInfo createEvaluationInfo(JSONObject obj) {
        if (obj == null) {
            return new EvaluationInfo();
        }
        return new EvaluationInfo(obj);
    }

    static ArticlesInfo createArticlesInfo(JSONObject obj) {
        if (obj == null) {
            return new ArticlesInfo();
        }
        return new ArticlesInfo(obj);
    }

    static FormInfo createFormInfo(JSONObject content) {
        if (content == null) {
            return new FormInfo();
        }
        return new FormInfo(content);
    }

    public static ControlMessage createEvaluationResponse(EvaluationInfo evaluationInfo, String detail, int summary, int degreeId, List<EvaluationInfo.TagInfo> appraiseTags) {
        List<EvaluationInfo.ResolutionParam> resolutionParams;
        ControlMessage controlMessage = new ControlMessage();
        controlMessage.setControlType("enquiry");
        controlMessage.setArgumentsValue("detail", detail);
        controlMessage.setSummary(summary);
        if (degreeId > 0) {
            controlMessage.setArgumentsValue("evaluationDegreeId", degreeId);
        }
        if (evaluationInfo != null) {
            controlMessage.setArgumentsValue("inviteId", evaluationInfo.getInviteId());
            controlMessage.setArgumentsValue("serviceSessionId", evaluationInfo.getSessionId());
        }
        if (appraiseTags != null && !appraiseTags.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            for (EvaluationInfo.TagInfo info : appraiseTags) {
                JSONObject jsonItem = new JSONObject();
                try {
                    jsonItem.put("id", info.getId());
                    jsonItem.put("name", (Object)info.getName());
                    jsonArray.put((Object)jsonItem);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            controlMessage.setArgumentsValue("appraiseTags", jsonArray);
        }
        if (evaluationInfo != null && (resolutionParams = evaluationInfo.getResolutionParams()) != null && !resolutionParams.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            for (EvaluationInfo.ResolutionParam info : resolutionParams) {
                JSONObject jsonItem = new JSONObject();
                try {
                    jsonItem.put("id", (Object)info.getId());
                    jsonItem.put("name", (Object)info.getName());
                    jsonItem.put("score", (Object)info.getScore());
                    JSONArray resolutionParamTags = info.getResolutionParamTags();
                    if (resolutionParamTags != null) {
                        jsonItem.put("resolutionParamTags", (Object)resolutionParamTags);
                    }
                    jsonArray.put((Object)jsonItem);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            controlMessage.setArgumentsValue("resolutionParam", jsonArray);
            if (!TextUtils.isEmpty((CharSequence)evaluationInfo.getEvaluateWay())) {
                controlMessage.setArgumentsValue("evaluateWay", evaluationInfo.getEvaluateWay());
            }
        }
        return controlMessage;
    }
}

