/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.model.CompositeContent;
import com.hyphenate.helpdesk.model.ContentFactory;
import com.hyphenate.helpdesk.model.ControlArguments;
import com.hyphenate.helpdesk.model.ControlType;
import com.hyphenate.helpdesk.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class ControlMessage
extends CompositeContent {
    private static final String TAG = "ControlMessage";
    public static final String PARENT_NAME = "weichat";
    public static final String TYPE_EVAL_REQUEST = "inviteEnquiry";
    public static final String TYPE_EVAL_RESPONSE = "enquiry";
    private ControlType type = null;
    private ControlArguments arguments = null;

    ControlMessage() {
        this.type = ContentFactory.createControlType(null);
        this.arguments = ContentFactory.createControlArguments(null);
        this.fillContents();
    }

    ControlMessage(JSONObject jsonObj) {
        try {
            String key = ContentFactory.createControlType(null).getName();
            if (jsonObj.has(key)) {
                this.type = ContentFactory.createControlType(jsonObj.getString(key));
            }
            this.arguments = jsonObj.isNull(key = ContentFactory.createControlArguments(null).getName()) ? ContentFactory.createControlArguments(null) : ContentFactory.createControlArguments(jsonObj.getJSONObject(key));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage());
        }
        this.fillContents();
    }

    public String getControlType() {
        if (this.type != null && !"null".equals(this.type.toString())) {
            return this.type.getString();
        }
        return null;
    }

    public void setControlType(String ctrlType) {
        if (this.type == null) {
            this.type = ContentFactory.createControlType(null);
        }
        this.type.setString(ctrlType);
    }

    public String getId() {
        return this.getArgumentsValue("id");
    }

    public String getServiceSessionId() {
        return this.getArgumentsValue("serviceSessionId");
    }

    public String getLabel() {
        return this.getArgumentsValue("label");
    }

    public String getInviteId() {
        return this.getArgumentsValue("inviteId");
    }

    public String getDetail() {
        return this.getArgumentsValue("detail");
    }

    public void setDetail(String detail) {
        this.arguments.set("detail", detail);
    }

    public String getSummary() {
        return this.getArgumentsValue("summary");
    }

    public void setSummary(Object summary) {
        this.arguments.set("summary", summary);
    }

    private String getArgumentsValue(String key) {
        if (this.arguments != null) {
            return this.arguments.get(key);
        }
        return null;
    }

    public void setArgumentsValue(String key, Object value) {
        if (this.arguments != null) {
            this.arguments.set(key, value);
        }
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    @Override
    protected void fillContents() {
        if (this.type != null) {
            this.contents.add(this.type);
        }
        if (this.arguments != null) {
            this.contents.add(this.arguments);
        }
    }
}

