/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.model.Content;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EvaluationInfo
extends Content {
    private static final String TAG = EvaluationInfo.class.getSimpleName();
    public static final String PARENT_NAME = "weichat";
    public static final String NAME = "ctrlType";
    public static final String VALUE = "inviteEnquiry";
    public static final String ARGS = "ctrlArgs";
    private String inviteId;
    private String sessionId;
    private List<Degree> degreeList;
    private String evaluateWay = "visitor";
    private List<ResolutionParam> mResolutionParams;
    private boolean mResolutionEnable;

    public EvaluationInfo() {
    }

    public EvaluationInfo(String value) {
        super(value);
    }

    public EvaluationInfo(JSONObject argObj) {
        if (argObj != null) {
            try {
                JSONArray jsonArr;
                if (argObj.has("inviteId")) {
                    this.inviteId = argObj.getString("inviteId");
                }
                if (argObj.has("serviceSessionId")) {
                    this.sessionId = argObj.getString("serviceSessionId");
                }
                this.parseResolutionParam(argObj);
                if (argObj.has("evaluationDegree") && !argObj.isNull("evaluationDegree") && (jsonArr = argObj.optJSONArray("evaluationDegree")) != null) {
                    this.degreeList = new ArrayList<Degree>();
                    for (int i = 0; i < jsonArr.length(); ++i) {
                        JSONObject degreeJsonObj = jsonArr.getJSONObject(i);
                        if (degreeJsonObj == null) continue;
                        Degree degree = new Degree();
                        degree.id = degreeJsonObj.getInt("id");
                        if (degreeJsonObj.has("name")) {
                            degree.name = degreeJsonObj.getString("name");
                        }
                        if (degreeJsonObj.has("score")) {
                            degree.score = degreeJsonObj.getInt("score");
                        }
                        if (degreeJsonObj.has("level")) {
                            degree.level = degreeJsonObj.getInt("level");
                        }
                        if (degreeJsonObj.has("status")) {
                            degree.status = degreeJsonObj.getString("status");
                        }
                        if (degreeJsonObj.has("appraiseTags") && !degreeJsonObj.isNull("appraiseTags")) {
                            JSONArray tagJsonArr = degreeJsonObj.getJSONArray("appraiseTags");
                            degree.appraiseTag = new ArrayList();
                            for (int j = 0; j < tagJsonArr.length(); ++j) {
                                JSONObject tagJsonObj = tagJsonArr.getJSONObject(j);
                                TagInfo tagInfo = new TagInfo();
                                tagInfo.id = tagJsonObj.getInt("id");
                                if (tagJsonObj.has("name")) {
                                    tagInfo.name = tagJsonObj.getString("name");
                                }
                                if (tagJsonObj.has("tenantId")) {
                                    tagInfo.tenantId = tagJsonObj.getString("tenantId");
                                }
                                if (tagJsonObj.has("tagSeqId")) {
                                    tagInfo.tagSeqId = tagJsonObj.getString("tagSeqId");
                                }
                                if (tagJsonObj.has("evaluationDegreeId")) {
                                    tagInfo.degreeId = tagJsonObj.getString("evaluationDegreeId");
                                }
                                degree.appraiseTag.add(tagInfo);
                            }
                        }
                        this.degreeList.add(degree);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseResolutionParam(JSONObject argObj) throws JSONException {
        if (argObj.has("resolutionEnable")) {
            this.mResolutionEnable = argObj.getBoolean("resolutionEnable");
        }
        if (argObj.has("resolutionParam")) {
            JSONArray resolutionParam = argObj.getJSONArray("resolutionParam");
            this.mResolutionParams = new ArrayList<ResolutionParam>();
            for (int i = 0; i < resolutionParam.length(); ++i) {
                ResolutionParam param = new ResolutionParam();
                JSONObject jsonObject = resolutionParam.getJSONObject(i);
                if (jsonObject.has("id")) {
                    param.setId(jsonObject.getString("id"));
                }
                if (jsonObject.has("name")) {
                    param.setName(jsonObject.getString("name"));
                }
                if (jsonObject.has("score")) {
                    param.setScore(jsonObject.getString("score"));
                }
                if (jsonObject.has("resolutionParamTags")) {
                    param.setResolutionParamTags(jsonObject.getJSONArray("resolutionParamTags"));
                }
                this.mResolutionParams.add(param);
            }
        }
    }

    public void setEvaluateWay(String evaluateWay) {
        this.evaluateWay = evaluateWay;
    }

    public String getEvaluateWay() {
        return this.evaluateWay;
    }

    public boolean isResolutionEnable() {
        return this.mResolutionEnable;
    }

    public void setResolutionParams(List<ResolutionParam> resolutionParams, String evaluateWay) {
        this.mResolutionParams = resolutionParams;
        this.evaluateWay = evaluateWay;
    }

    public List<ResolutionParam> getResolutionParams() {
        return this.mResolutionParams;
    }

    public String getInviteId() {
        return this.inviteId;
    }

    public List<Degree> getDegreeList() {
        return this.degreeList;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Degree getDegree(int level) {
        if (this.degreeList != null && !this.degreeList.isEmpty()) {
            for (Degree d : this.degreeList) {
                if (d.level != level) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    private String getCtrlType() {
        return this.get(NAME);
    }

    public boolean isEvaluationMessage() {
        if (this.content.has(NAME) && !this.content.isNull(NAME)) {
            String ctrlType = this.getCtrlType();
            return ctrlType != null && ctrlType.equals(VALUE);
        }
        return false;
    }

    public static class ResolutionParam {
        private String id;
        private String name;
        private String score;
        private JSONArray resolutionParamTags;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setScore(String score) {
            this.score = score;
        }

        public String getScore() {
            return this.score;
        }

        public void setResolutionParamTags(JSONArray resolutionParamTags) {
            this.resolutionParamTags = resolutionParamTags;
        }

        public JSONArray getResolutionParamTags() {
            return this.resolutionParamTags;
        }
    }

    public static class ResolutionParamTags {
    }

    public static class TagInfo {
        private int id;
        private String name;
        private String tenantId;
        private String tagSeqId;
        private String degreeId;

        public String getDegreeId() {
            return this.degreeId;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTagSeqId() {
            return this.tagSeqId;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }

    public static class Degree {
        private int id;
        private String name;
        private int score;
        private int level;
        private String status;
        private List<TagInfo> appraiseTag;

        public int getId() {
            return this.id;
        }

        public List<TagInfo> getAppraiseTag() {
            return this.appraiseTag;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public int getScore() {
            return this.score;
        }

        public String getStatus() {
            return this.status;
        }

        public void setLevel(int level) {
            this.level = level;
        }
    }
}

