/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import android.text.TextUtils;
import com.hyphenate.chat.ChatClient;
import com.hyphenate.chat.Message;
import com.hyphenate.helpdesk.model.Content;
import org.json.JSONObject;

public class ToCustomServiceInfo
extends Content {
    public static final String PARENT_NAME = "weichat";
    public static final String NAME = "ctrlArgs";
    public static final String TYPE = "ctrlType";
    static final String TYPE_VALUE = "TransferToKfHint";
    static final String TRANSFER_KF_INFO = "transferToHumanButtonInfo";
    static final String TRANSFER_KF_ID = "transferToHumanId";
    static final String TRANSFER_KF_LABEL = "suggestionTransferToHumanLabel";

    public ToCustomServiceInfo() {
    }

    public ToCustomServiceInfo(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    public String getId() {
        return this.get("id");
    }

    public String getServiceSessionId() {
        return this.get("serviceSessionId");
    }

    public String getLable() {
        if (this.hasTransferGroupInfo()) {
            return this.getCustomTransferLabel();
        }
        return this.get("label");
    }

    public String getCtrlType() {
        return this.get(TYPE);
    }

    public String getCustomTransferLabel() {
        return this.get(TRANSFER_KF_LABEL);
    }

    public String getTransferKFID() {
        return this.get(TRANSFER_KF_ID);
    }

    public boolean hasTransferGroupInfo() {
        return this.content.has(TRANSFER_KF_ID) && !this.content.isNull(TRANSFER_KF_ID);
    }

    public boolean isToCustomServiceMessage() {
        if (this.content.has(TYPE) && !this.content.isNull(TYPE)) {
            String ctrlType = this.getCtrlType();
            return ctrlType != null && ctrlType.equals(TYPE_VALUE);
        }
        return false;
    }

    public void sendToCustomServiceMessage(Message message) {
        if (TextUtils.isEmpty((CharSequence)this.getTransferKFID()) && (TextUtils.isEmpty((CharSequence)this.getId()) || TextUtils.isEmpty((CharSequence)this.getServiceSessionId()))) {
            return;
        }
        ChatClient.getInstance().chatManager().sendMessage(Message.createTranferToKefuMessage(message.from(), this));
    }
}

