/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.model;

import com.hyphenate.helpdesk.model.Content;
import com.hyphenate.helpdesk.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class TransferGuideMenuInfo
extends Content {
    private static final String TAG = "TransferGuideMenuInfo";
    public static final String PARENT_NAME = "msgtype";
    public static final String NAME = "choice";
    public static final String TRANSFER_GUIDE = "transferManualGuide";
    public static final String MODE = "mode";
    static final String NAME_ITEMS = "items";
    static final String NAME_LIST = "list";
    static final String ITEM_TRANSFER_NOTE = "hasTransferNote";

    public TransferGuideMenuInfo() {
    }

    public TransferGuideMenuInfo(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getParentName() {
        return PARENT_NAME;
    }

    public String getTitle() {
        String title = this.get("title");
        return title;
    }

    public String getMode() {
        return this.get(MODE);
    }

    public Collection<Item> getItems() {
        Collection<JSONObject> objArray = this.getObjectArray(NAME_ITEMS);
        if (objArray == null) {
            return null;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (JSONObject obj : objArray) {
            Item item = this.createItem(obj);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public Collection<String> getList() {
        return this.getStringArray(NAME_LIST);
    }

    private Item createItem(JSONObject obj) {
        Item item = null;
        String id = null;
        String menuId = null;
        String queueType = null;
        String queueName = null;
        try {
            queueType = obj.getString("queueType");
        }
        catch (JSONException ex) {
            Log.e(TAG, ex.getMessage());
        }
        try {
            queueName = obj.getString("queueName");
        }
        catch (JSONException ex) {
            Log.e(TAG, ex.getMessage());
        }
        try {
            menuId = obj.getString("id");
        }
        catch (JSONException ex) {
            Log.e(TAG, ex.getMessage());
        }
        try {
            id = obj.getString("queueId");
        }
        catch (JSONException ex) {
            Log.e(TAG, ex.getMessage());
        }
        if (id == null) {
            try {
                id = obj.getString("id");
            }
            catch (JSONException ex) {
                Log.e(TAG, ex.getMessage());
            }
        }
        try {
            item = new Item(id, obj.getString("name"), queueType);
            item.setContent(obj);
            item.setMenuId(menuId);
            if (queueName != null) {
                item.setQueueName(queueName);
            }
        }
        catch (JSONException ex) {
            Log.e(TAG, ex.getMessage());
        }
        return item;
    }

    public class Item {
        private String queueId;
        private String menuId;
        private String name;
        private String queueType;
        private String queueName;
        private JSONObject jsonObj;

        Item(String id, String name, String queueType) {
            this.queueId = id;
            this.name = name;
            this.queueType = queueType;
        }

        public void setContent(JSONObject jsonObj) {
            this.jsonObj = jsonObj;
        }

        public String getQueueId() {
            return this.queueId;
        }

        public String getMenuId() {
            return this.menuId;
        }

        public void setMenuId(String menuId) {
            this.menuId = menuId;
        }

        public String getName() {
            return this.name;
        }

        public String getQueueType() {
            return this.queueType;
        }

        public void setQueueType(String queueType) {
            this.queueType = queueType;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public void setQueueName(String name) {
            this.queueName = name;
        }

        public String toString() {
            return this.jsonObj.toString();
        }

        public boolean isLeaveMessage() {
            return this.queueId.equals(TransferGuideMenuInfo.ITEM_TRANSFER_NOTE);
        }
    }
}

