/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.helpdesk.util;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class CopyDirectoryUtil {
    public static void copyFile(File sourceFile, File targetFile) throws Exception {
        FileInputStream input = null;
        BufferedInputStream inBuff = null;
        FileOutputStream output = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            input = new FileInputStream(sourceFile);
            inBuff = new BufferedInputStream(input);
            output = new FileOutputStream(targetFile);
            outBuff = new BufferedOutputStream(output);
            byte[] buffer = new byte[4096];
            while ((len = inBuff.read(buffer)) != -1) {
                ((BufferedOutputStream)outBuff).write(buffer, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyDirectory(String sourceDir, String targetDir) throws Exception {
        File targetDirFile = new File(targetDir);
        if (!targetDirFile.exists() || !targetDirFile.isDirectory()) {
            targetDirFile.mkdirs();
        }
        File sourceDirFile = new File(sourceDir);
        if (!sourceDirFile.exists()) {
            Log.e((String)"copy", (String)("sourceDir:" + sourceDir + " is not found."));
            return;
        }
        File[] files = sourceDirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File sourceFile = files[i];
            if (sourceFile.isFile()) {
                File targetFile = new File(targetDirFile.getAbsolutePath() + File.separator + sourceFile.getName());
                CopyDirectoryUtil.copyFile(sourceFile, targetFile);
            }
            if (!sourceFile.isDirectory()) continue;
            String dir1 = sourceDirFile.getAbsolutePath() + File.separator + sourceFile.getName();
            String dir2 = targetDirFile.getAbsolutePath() + File.separator + sourceFile.getName();
            CopyDirectoryUtil.copyDirectory(dir1, dir2);
        }
    }
}

