/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMPresenceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPresence;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPresence;
import com.hyphenate.chat.adapter.EMAPresenceManager;
import com.hyphenate.chat.adapter.EMAPresenceManagerListener;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EMPresenceManager {
    private final String TAG = this.getClass().getSimpleName();
    EMAPresenceManager emaObject;
    private List<EMPresenceListener> listeners = new CopyOnWriteArrayList<EMPresenceListener>();
    private EMAPresenceManagerListener listenerImpl = new EMAPresenceManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPresenceUpdated(List<EMAPresence> list) {
            List list2 = EMPresenceManager.this.listeners;
            synchronized (list2) {
                for (EMPresenceListener eMPresenceListener : EMPresenceManager.this.listeners) {
                    try {
                        eMPresenceListener.onPresenceUpdated(EMPresenceManager.this.convertToEMPresence(list));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EMLog.e(EMPresenceManager.this.TAG, "EMPresenceManager->listenerImpl:onPresenceUpdated() Error:" + exception.getMessage());
                    }
                }
            }
        }
    };

    public EMPresenceManager(EMAPresenceManager eMAPresenceManager) {
        this.emaObject = eMAPresenceManager;
        this.emaObject.addListener(this.listenerImpl);
    }

    public void publishPresence(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMPresenceManager.this.emaObject.publishPresence(string, eMAError);
                if (eMAError.errCode() == 0) {
                    eMCallBack.onSuccess();
                } else {
                    eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void subscribePresences(final List<String> list, final long l, final EMValueCallBack<List<EMPresence>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list2 = EMPresenceManager.this.emaObject.subscribePresences(list, l, eMAError);
                if (eMAError.errCode() == 0) {
                    eMValueCallBack.onSuccess(EMPresenceManager.this.convertToEMPresence(list2));
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void unsubscribePresences(final List<String> list, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMPresenceManager.this.emaObject.unsubscribePresences(list, eMAError);
                if (eMAError.errCode() == 0) {
                    eMCallBack.onSuccess();
                } else {
                    eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchSubscribedMembers(final int n, final int n2, final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<String> list = EMPresenceManager.this.emaObject.fetchSubscribedMembers(n, n2, eMAError);
                if (eMAError.errCode() == 0) {
                    eMValueCallBack.onSuccess(list);
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchPresenceStatus(final List<String> list, final EMValueCallBack<List<EMPresence>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list2 = EMPresenceManager.this.emaObject.fetchPresenceStatus(list, eMAError);
                if (eMAError.errCode() == 0) {
                    eMValueCallBack.onSuccess(EMPresenceManager.this.convertToEMPresence(list2));
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addListener(EMPresenceListener eMPresenceListener) {
        if (!this.listeners.contains(eMPresenceListener)) {
            this.listeners.add(eMPresenceListener);
        }
    }

    public void removeListener(EMPresenceListener eMPresenceListener) {
        if (eMPresenceListener != null) {
            this.listeners.remove(eMPresenceListener);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    private List<EMPresence> convertToEMPresence(List<EMAPresence> list) {
        ArrayList<EMPresence> arrayList = new ArrayList<EMPresence>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMPresence(list.get(i)));
        }
        return arrayList;
    }
}

