/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMPushConfigs;
import com.hyphenate.chat.EMSilentModeParam;
import com.hyphenate.chat.EMSilentModeResult;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPushConfigs;
import com.hyphenate.chat.adapter.EMAPushManager;
import com.hyphenate.chat.adapter.EMASilentModeItem;
import com.hyphenate.chat.adapter.EMASilentModeParam;
import com.hyphenate.exceptions.HyphenateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EMPushManager {
    private static final String TAG = EMPushManager.class.getSimpleName();
    EMClient mClient;
    EMAPushManager emaObject;

    EMPushManager(EMClient eMClient, EMAPushManager eMAPushManager) {
        this.emaObject = eMAPushManager;
        this.mClient = eMClient;
    }

    @Deprecated
    public void enableOfflinePush() throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.enableOfflineNotification(eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void disableOfflinePush(int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.disableOfflineNotification(n, n2, eMAError);
        this.handleError(eMAError);
    }

    public EMPushConfigs getPushConfigs() {
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigs();
        if (eMAPushConfigs == null) {
            return null;
        }
        return new EMPushConfigs(eMAPushConfigs);
    }

    public EMPushConfigs getPushConfigsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigsFromServer(eMAError);
        this.handleError(eMAError);
        return new EMPushConfigs(eMAPushConfigs);
    }

    @Deprecated
    public void updatePushServiceForGroup(List<String> list, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForGroup(list, bl, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void updatePushServiceForUsers(List<String> list, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForUsers(list, bl, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public List<String> getNoPushGroups() {
        return this.emaObject.getNoPushGroups();
    }

    @Deprecated
    public List<String> getNoPushUsers() {
        return this.emaObject.getNoPushUsers();
    }

    public boolean updatePushNickname(String string) throws IllegalArgumentException, HyphenateException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("nick name is null or empty");
        }
        String string2 = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string3 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushNickname(string, eMAError);
        this.handleError(eMAError);
        return true;
    }

    public void asyncUpdatePushNickname(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushNickname(string);
                    eMCallBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    eMCallBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updatePushDisplayStyle(DisplayStyle displayStyle) throws IllegalArgumentException, HyphenateException {
        String string = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushDisplayStyle(displayStyle.ordinal(), eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdatePushDisplayStyle(final DisplayStyle displayStyle, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushDisplayStyle(displayStyle);
                    eMCallBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    eMCallBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void reportPushAction(String string) throws IllegalArgumentException, HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.reportPushAction(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncReportPushAction(final String string, final String string2, final EMPushAction eMPushAction, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    if (!string.isEmpty()) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("task_id", (Object)string);
                        jSONObject.put("report", (Object)jSONObject2);
                    }
                    jSONObject.put("provider", (Object)string2);
                    jSONObject.put("action", (Object)eMPushAction.name);
                    EMPushManager.this.reportPushAction(jSONObject.toString());
                    eMCallBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    eMCallBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    public void setSilentModeForConversation(final String string, final EMConversation.EMConversationType eMConversationType, final EMSilentModeParam eMSilentModeParam, final EMValueCallBack<EMSilentModeResult> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.setSilentModeForConversation(string, eMConversationType.ordinal(), (EMASilentModeParam)eMSilentModeParam.emaObject, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void clearRemindTypeForConversation(final String string, final EMConversation.EMConversationType eMConversationType, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMPushManager.this.emaObject.clearRemindTypeForConversation(string, eMConversationType.ordinal(), eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversation(final String string, final EMConversation.EMConversationType eMConversationType, final EMValueCallBack<EMSilentModeResult> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.getSilentModeForConversation(string, eMConversationType.ordinal(), eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setSilentModeForAll(final EMSilentModeParam eMSilentModeParam, final EMValueCallBack<EMSilentModeResult> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.setSilentModeForAll((EMASilentModeParam)eMSilentModeParam.emaObject, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForAll(final EMValueCallBack<EMSilentModeResult> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.getSilentModeForAll(eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversations(final List<EMConversation> list, final EMValueCallBack<Map<String, EMSilentModeResult>> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object2;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (Object object2 : list) {
                        if (((EMConversation)object2).getType() == EMConversation.EMConversationType.Chat) {
                            stringBuilder.append(((EMConversation)object2).conversationId());
                            stringBuilder.append(",");
                            continue;
                        }
                        stringBuilder2.append(((EMConversation)object2).conversationId());
                        stringBuilder2.append(",");
                    }
                    HashMap hashMap = new HashMap();
                    hashMap.put("user", stringBuilder.toString());
                    hashMap.put("group", stringBuilder2.toString());
                    object2 = new EMAError();
                    List<EMASilentModeItem> list2 = EMPushManager.this.emaObject.getSilentModeForConversations(hashMap, (EMAError)object2);
                    EMPushManager.this.handleError((EMAError)object2);
                    HashMap<String, EMSilentModeResult> hashMap2 = new HashMap<String, EMSilentModeResult>();
                    for (EMASilentModeItem eMASilentModeItem : list2) {
                        hashMap2.put(eMASilentModeItem.getConversationId(), new EMSilentModeResult(eMASilentModeItem));
                    }
                    eMValueCallBack.onSuccess(hashMap2);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setPreferredNotificationLanguage(final String string, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMPushManager.this.emaObject.setPushPerformLanguage(string, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getPreferredNotificationLanguage(final EMValueCallBack<String> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    String string = EMPushManager.this.emaObject.getPushPerformLanguage(eMAError);
                    EMPushManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(string);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public static enum EMPushRemindType {
        ALL,
        MENTION_ONLY,
        NONE;

    }

    public static enum EMPushAction {
        ARRIVE("arrive"),
        CLICK("click");

        private String name;

        private EMPushAction(String string2) {
            this.name = string2;
        }
    }

    public static enum DisplayStyle {
        SimpleBanner,
        MessageSummary;

    }
}

