/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.AsyncTask;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.CacheManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMLanguage;
import com.hyphenate.chat.EMTranslateParams;
import com.hyphenate.chat.EMTranslationResult;
import com.hyphenate.chat.EMTranslator;
import com.hyphenate.chat.adapter.EMATranslateManager;
import com.hyphenate.chat.adapter.EMATranslateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public class EMTranslationManager {
    private static final String TAG = EMTranslationManager.class.getSimpleName();
    public static final int MaxTranslationTextSize = 5000;
    private static EMTranslationManager instance = null;
    private EMTranslator mTranslator;
    private AtomicBoolean mInitializing = new AtomicBoolean(false);
    private AtomicBoolean mInitialized = new AtomicBoolean(false);
    private List<EMLanguage> mLanguageList;
    EMATranslateManager emaObject;
    static final int MaxCacheSize = 10000;
    private CacheManager mCacheManager;

    EMTranslationManager(EMATranslateManager eMATranslateManager) {
        this.emaObject = eMATranslateManager;
        this.mLanguageList = new ArrayList<EMLanguage>();
        this.mCacheManager = new CacheManager(10000);
    }

    public void init(final EMTranslateParams eMTranslateParams) {
        if (!EMClient.getInstance().isLoggedInBefore()) {
            return;
        }
        if (this.mInitializing.compareAndSet(false, true)) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    EMTranslationManager.this.cleanCache();
                    EMTranslationManager.this.loadIds(eMTranslateParams.LoadCount);
                    EMTranslationManager.this.mInitialized.set(true);
                    EMTranslationManager.this.mTranslator = new EMTranslator(eMTranslateParams);
                    EMTranslationManager.this.mLanguageList = EMTranslationManager.this.mTranslator.getSupportedLanguages();
                }
            });
        }
    }

    public boolean isInitialized() {
        return this.mInitialized.get();
    }

    public List<EMLanguage> getSupportedLanguages() {
        if (!this.mInitialized.get()) {
            return new ArrayList<EMLanguage>();
        }
        return this.mLanguageList;
    }

    public void translate(String string3, String string4, String string5, String string6, EMValueCallBack<EMTranslationResult> eMValueCallBack) {
        EMTranslationResult eMTranslationResult;
        if (!this.mInitializing.get()) {
            eMValueCallBack.onError(905, "EMTranslationManager is not initialized");
            return;
        }
        if (string5.length() > 5000) {
            eMValueCallBack.onError(903, "Text exceeds limit");
            return;
        }
        if (this.isTranslationResultForMessage(string3)) {
            eMTranslationResult = this.getTranslationResult(string3);
        } else {
            eMTranslationResult = new EMTranslationResult(string3);
            eMTranslationResult.setConversationId(string4);
        }
        this.mTranslator.translate(string5, string6, (string, string2) -> {
            if (!string.isEmpty()) {
                eMTranslationResult.setShowTranslation(true);
                eMTranslationResult.setTranslatedText(string);
                eMTranslationResult.setTranslateCount(eMTranslationResult.translateCount() + 1);
                this.updateTranslationResult(eMTranslationResult);
                eMValueCallBack.onSuccess(eMTranslationResult);
            } else {
                eMValueCallBack.onError(904, string2);
            }
        });
    }

    public void removeTranslationResult(String string) {
        this.removeTranslationResults(Arrays.asList(string));
    }

    public void removeTranslationResults(List<String> list) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteTranslationResults(list);
    }

    public void clearTranslations() {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteAll();
    }

    public void removeResultsByConversationId(String string) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.removeTranslationsByConversationId(string);
        this.mCacheManager.removeByConversationId(string);
    }

    public EMTranslationResult getTranslationResult(String string) {
        if (!this.mInitializing.get()) {
            return null;
        }
        if (!this.mCacheManager.check(string)) {
            return null;
        }
        if (this.mCacheManager.get(string) != null) {
            return this.mCacheManager.get(string);
        }
        EMTranslationResult eMTranslationResult = this.getTranslationResultByMsgId(string);
        return eMTranslationResult;
    }

    public boolean isTranslationResultForMessage(String string) {
        if (!this.mInitialized.get()) {
            return false;
        }
        return this.isMessageResult(string);
    }

    public void logout() {
        if (!this.mInitialized.get()) {
            return;
        }
        this.mInitializing.set(false);
        this.mInitialized.set(false);
        this.cleanCache();
        this.mLanguageList.clear();
    }

    private void loadIds(int n) {
        List<EMTranslationResult> list = this.loadTranslateResults(n);
        if (list.size() > 0) {
            for (EMTranslationResult eMTranslationResult : list) {
                this.mCacheManager.add(eMTranslationResult);
            }
        }
    }

    public void updateTranslationResult(EMTranslationResult eMTranslationResult) {
        String string = eMTranslationResult.msgId();
        if (this.mCacheManager.check(string)) {
            this.removeTranslationResult(string);
        }
        this.mCacheManager.add(eMTranslationResult);
        this.updateTranslate(eMTranslationResult);
    }

    private void deleteTranslationResults(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!this.mCacheManager.check(string)) continue;
            arrayList.add(string);
        }
        this.removeTranslationsByMsgId(arrayList);
        this.mCacheManager.removeByMsgIds(arrayList);
    }

    private void deleteAll() {
        this.removeAllTranslations();
        this.mCacheManager.clear();
    }

    private boolean isMessageResult(String string) {
        return this.mCacheManager.check(string);
    }

    private void cleanCache() {
        this.mCacheManager.clear();
    }

    private boolean updateTranslate(EMTranslationResult eMTranslationResult) {
        return this.emaObject.updateTranslation((EMATranslateResult)eMTranslationResult.emaObject);
    }

    private EMTranslationResult getTranslationResultByMsgId(String string) {
        EMATranslateResult eMATranslateResult = this.emaObject.getTranslationResultByMsgId(string);
        if (eMATranslateResult == null) {
            return new EMTranslationResult(string);
        }
        return new EMTranslationResult(eMATranslateResult);
    }

    private List<EMTranslationResult> loadTranslateResults(int n) {
        List<EMATranslateResult> list = this.emaObject.loadTranslateResults(n);
        ArrayList<EMTranslationResult> arrayList = new ArrayList<EMTranslationResult>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EMATranslateResult eMATranslateResult = list.get(i);
                EMTranslationResult eMTranslationResult = new EMTranslationResult(eMATranslateResult);
                arrayList.add(eMTranslationResult);
            }
            return arrayList;
        }
        return arrayList;
    }

    private boolean removeTranslationsByMsgId(List<String> list) {
        return this.emaObject.removeTranslationsByMsgId(list);
    }

    private boolean removeTranslationsByConversationId(String string) {
        return this.emaObject.removeTranslationsByConversationId(string);
    }

    private boolean removeAllTranslations() {
        return this.emaObject.removeAllTranslations();
    }
}

