/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;

public class EMNotificationBuilder {
    private Context appContext;
    private boolean sound;
    private boolean vibrate;
    private String channelId;
    private String channelName;
    private int channelLevel;
    private boolean autoCancel = true;
    private String title;
    private String content;
    private SoftReference<Bitmap> iconBitmapRef;
    private EMNotificationDefaultStyle style = new EMNotificationDefaultStyle();
    private PendingIntent pendingIntent;
    private int smallIcon = 17301651;
    private String ticker;
    private PendingIntent fullScreenIntent;
    private int badgeNum;

    public EMNotificationBuilder(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot is null");
        }
        this.appContext = context.getApplicationContext();
    }

    public EMNotificationBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public EMNotificationBuilder setContent(String string) {
        this.content = string;
        return this;
    }

    public EMNotificationBuilder setIcon(@IdRes int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.appContext.getResources(), (int)n);
        if (bitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(bitmap);
        }
        return this;
    }

    public EMNotificationBuilder setIcon(Bitmap bitmap) {
        if (bitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(bitmap);
        }
        return this;
    }

    public EMNotificationBuilder setSmallIcon(@IdRes int n) {
        this.smallIcon = n;
        return this;
    }

    public EMNotificationBuilder setStyle(EMNotificationDefaultStyle eMNotificationDefaultStyle) {
        this.style = eMNotificationDefaultStyle;
        return this;
    }

    public EMNotificationBuilder setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
        return this;
    }

    public EMNotificationBuilder setFullScreenIntent(PendingIntent pendingIntent) {
        this.fullScreenIntent = pendingIntent;
        return this;
    }

    public EMNotificationBuilder setSound(boolean bl) {
        this.sound = bl;
        return this;
    }

    public EMNotificationBuilder setVibrate(boolean bl) {
        this.vibrate = bl;
        return this;
    }

    public EMNotificationBuilder setLevel(int n) {
        this.channelLevel = n;
        return this;
    }

    public EMNotificationBuilder setTicker(String string) {
        this.ticker = string;
        return this;
    }

    public EMNotificationBuilder setChannelId(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.channelId = string;
        }
        return this;
    }

    public EMNotificationBuilder setChannelName(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.channelName = string;
        }
        return this;
    }

    public EMNotificationBuilder setAutoCancel(boolean bl) {
        this.autoCancel = bl;
        return this;
    }

    public EMNotificationBuilder setBadgeNum(int n) {
        this.badgeNum = n;
        return this;
    }

    public Notification build() {
        Object object;
        if (this.channelId == null) {
            this.channelId = "chat";
        }
        if (this.channelName == null) {
            this.channelName = "\u6d88\u606f";
        }
        this.createNotificationChannel(this.appContext, this.vibrate, this.channelId, this.channelName, this.channelLevel);
        int n = 0;
        if (this.sound) {
            n = 1;
        }
        if (this.vibrate) {
            n = 2;
        }
        if (this.sound && this.vibrate) {
            n = -1;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.appContext);
        try {
            object = NotificationCompat.Builder.class.getDeclaredMethod("setChannelId", String.class);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)builder, this.channelId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.setSmallIcon(this.smallIcon);
        if (!this.sound) {
            builder.setSound(null);
        }
        if (n != 0) {
            builder.setDefaults(n);
        }
        if (this.iconBitmapRef != null && this.iconBitmapRef.get() != null) {
            builder.setLargeIcon(this.iconBitmapRef.get());
        }
        if (this.badgeNum > 0) {
            builder.setNumber(this.badgeNum);
        }
        builder.setTicker((CharSequence)this.ticker).setPriority(this.channelLevel - 3).setVisibility(1).setAutoCancel(this.autoCancel).setContentTitle((CharSequence)this.title).setContentText((CharSequence)this.content).setContentIntent(this.pendingIntent).setWhen(System.currentTimeMillis());
        if (this.style instanceof EMNotificationBigTextStyle) {
            object = ((EMNotificationBigTextStyle)this.style).getBigTxt();
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)object));
        } else if (this.style instanceof EMNotificationBigPicStyle) {
            object = ((EMNotificationBigPicStyle)this.style).getBigPic();
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)object));
        }
        if (this.fullScreenIntent != null) {
            builder.setFullScreenIntent(this.fullScreenIntent, true);
        }
        if (this.vibrate) {
            object = new long[]{100L, 200L, 300L, 400L, 500L};
            builder.setVibrate((long[])object);
        } else {
            builder.setVibrate(null);
        }
        object = builder.build();
        builder.setPublicVersion((Notification)object);
        return object;
    }

    private void createNotificationChannel(Context context, boolean bl, String string, String string2, int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            int n2 = 3;
            if (n >= 0 && n <= 5) {
                n2 = n;
            }
            NotificationChannel notificationChannel = new NotificationChannel(string, (CharSequence)string2, n2);
            if (!this.sound) {
                notificationChannel.setSound(null, null);
            }
            if (bl) {
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L});
            } else {
                notificationChannel.enableVibration(false);
            }
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    public static class EMNotificationBigPicStyle
    extends EMNotificationDefaultStyle {
        private SoftReference<Bitmap> bitmapRef;

        public Bitmap getBigPic() {
            if (this.bitmapRef != null && this.bitmapRef.get() != null) {
                return this.bitmapRef.get();
            }
            return null;
        }

        public EMNotificationBigPicStyle setBigPic(Bitmap bitmap) {
            if (bitmap != null) {
                this.bitmapRef = new SoftReference<Bitmap>(bitmap);
            }
            return this;
        }
    }

    public static class EMNotificationBigTextStyle
    extends EMNotificationDefaultStyle {
        private String bigTxt;

        public String getBigTxt() {
            return this.bigTxt;
        }

        public EMNotificationBigTextStyle setBigTxt(String string) {
            this.bigTxt = string;
            return this;
        }
    }

    public static class EMNotificationDefaultStyle {
    }
}

