/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.UriUtils;
import com.hyphenate.util.VersionUtils;
import java.io.File;

public class EMFileHelper {
    private Context mContext = EMClient.getInstance().getContext();
    private IFilePresenter mHelper = new FilePresenterImpl();

    private EMFileHelper() {
    }

    public static EMFileHelper getInstance() {
        return EMFileHelperInstance.instance;
    }

    public void setFileHelper(IFilePresenter iFilePresenter) {
        this.mHelper = iFilePresenter;
    }

    public boolean isFileExist(Uri uri) {
        return this.mHelper.isFileExist(this.mContext, uri);
    }

    public boolean isFileExist(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return this.isFileExist(Uri.parse((String)string));
    }

    public boolean isFileExist(Context context, Uri uri) {
        return this.mHelper.isFileExist(context, uri);
    }

    public boolean isFileExist(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return this.isFileExist(context, Uri.parse((String)string));
    }

    public String getFilename(Uri uri) {
        return this.mHelper.getFilename(this.mContext, uri);
    }

    public String getFilename(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return this.getFilename(Uri.parse((String)string));
    }

    public String getFilePath(Uri uri) {
        return this.mHelper.getFilePath(this.mContext, uri);
    }

    public String getFilePath(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return this.getFilePath(Uri.parse((String)string));
    }

    public String getFilePath(Context context, Uri uri) {
        return this.mHelper.getFilePath(context, uri);
    }

    public String getFilePath(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return this.getFilePath(context, Uri.parse((String)string));
    }

    public long getFileLength(Uri uri) {
        return this.mHelper.getFileLength(this.mContext, uri);
    }

    public long getFileLength(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0L;
        }
        return this.getFileLength(Uri.parse((String)string));
    }

    public String getFileMimeType(Uri uri) {
        return this.mHelper.getFileMimeType(this.mContext, uri);
    }

    public boolean deletePrivateFile(String string) {
        File file;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (!this.isFileExist(string)) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getFilePath(Uri.parse((String)string)))) && (file = new File(string)).exists()) {
            return file.delete();
        }
        return false;
    }

    public Uri formatInUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        if (VersionUtils.isTargetQ(this.mContext) && UriUtils.uriStartWithContent(uri)) {
            return uri;
        }
        String string = this.getFilePath(uri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            uri = Uri.parse((String)string);
        }
        return uri;
    }

    public Uri formatInUri(File file) {
        if (file == null) {
            return null;
        }
        return Uri.parse((String)file.getAbsolutePath());
    }

    public Uri formatInUri(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.formatInUri(Uri.parse((String)string));
    }

    public String formatInUriToString(Uri uri) {
        if ((uri = this.formatInUri(uri)) == null) {
            return "";
        }
        return uri.toString();
    }

    public String formatInUriToString(File file) {
        Uri uri = this.formatInUri(file);
        if (uri == null) {
            return "";
        }
        return uri.toString();
    }

    public String formatInUriToString(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return this.formatInUriToString(Uri.parse((String)string));
    }

    public String formatOutLocalUrl(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        String string2 = this.getFilePath(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return string;
    }

    public Uri formatOutUri(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Uri uri = Uri.parse((String)string);
        if (VersionUtils.isTargetQ(this.mContext) && UriUtils.uriStartWithContent(uri)) {
            return uri;
        }
        String string2 = this.getFilePath(uri);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            uri = Uri.fromFile((File)new File(string2));
        }
        return uri;
    }

    public String uriToString(Uri uri) {
        if (uri == null) {
            return "";
        }
        return uri.toString();
    }

    public static interface IFilePresenter {
        public boolean isFileExist(Context var1, Uri var2);

        public String getFilename(Context var1, Uri var2);

        public String getFilePath(Context var1, Uri var2);

        public long getFileLength(Context var1, Uri var2);

        public String getFileMimeType(Context var1, Uri var2);
    }

    public static class FilePresenterImpl
    implements IFilePresenter {
        @Override
        public boolean isFileExist(Context context, Uri uri) {
            return UriUtils.isFileExistByUri(context, uri);
        }

        @Override
        public String getFilename(Context context, Uri uri) {
            return UriUtils.getFileNameByUri(context, uri);
        }

        @Override
        public String getFilePath(Context context, Uri uri) {
            return UriUtils.getFilePath(context, uri);
        }

        @Override
        public long getFileLength(Context context, Uri uri) {
            return UriUtils.getFileLength(context, uri);
        }

        @Override
        public String getFileMimeType(Context context, Uri uri) {
            return UriUtils.getMimeType(context, uri);
        }
    }

    private static class EMFileHelperInstance {
        private static final EMFileHelper instance = new EMFileHelper();

        private EMFileHelperInstance() {
        }
    }
}

